/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionalTable;
import org.apache.phoenix.transaction.TephraTransactionContext;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.TxConstants;
import org.apache.tephra.hbase.TransactionAwareHTable;

public class TephraTransactionTable
implements PhoenixTransactionalTable {
    private TransactionAwareHTable transactionAwareHTable;
    private TephraTransactionContext tephraTransactionContext;

    public TephraTransactionTable(PhoenixTransactionContext ctx, HTableInterface hTable) {
        this(ctx, hTable, null);
    }

    public TephraTransactionTable(PhoenixTransactionContext ctx, HTableInterface hTable, PTable pTable) {
        assert (ctx instanceof TephraTransactionContext);
        this.tephraTransactionContext = (TephraTransactionContext)ctx;
        this.transactionAwareHTable = new TransactionAwareHTable(hTable, pTable != null && pTable.isImmutableRows() ? TxConstants.ConflictDetection.NONE : TxConstants.ConflictDetection.ROW);
        this.tephraTransactionContext.addTransactionAware((TransactionAware)this.transactionAwareHTable);
        if (pTable != null && pTable.getType() != PTableType.INDEX) {
            this.tephraTransactionContext.markDMLFence(pTable);
        }
    }

    @Override
    public Result get(Get get) throws IOException {
        return this.transactionAwareHTable.get(get);
    }

    @Override
    public void put(Put put) throws IOException {
        this.transactionAwareHTable.put(put);
    }

    @Override
    public void delete(Delete delete) throws IOException {
        this.transactionAwareHTable.delete(delete);
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        return this.transactionAwareHTable.getScanner(scan);
    }

    @Override
    public byte[] getTableName() {
        return this.transactionAwareHTable.getTableName();
    }

    @Override
    public Configuration getConfiguration() {
        return this.transactionAwareHTable.getConfiguration();
    }

    @Override
    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.transactionAwareHTable.getTableDescriptor();
    }

    @Override
    public boolean exists(Get get) throws IOException {
        return this.transactionAwareHTable.exists(get);
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        return this.transactionAwareHTable.get(gets);
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        return this.transactionAwareHTable.getScanner(family);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        return this.transactionAwareHTable.getScanner(family, qualifier);
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        this.transactionAwareHTable.put(puts);
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        this.transactionAwareHTable.delete(deletes);
    }

    @Override
    public void setAutoFlush(boolean autoFlush) {
        this.transactionAwareHTable.setAutoFlush(autoFlush);
    }

    @Override
    public boolean isAutoFlush() {
        return this.transactionAwareHTable.isAutoFlush();
    }

    @Override
    public long getWriteBufferSize() {
        return this.transactionAwareHTable.getWriteBufferSize();
    }

    @Override
    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.transactionAwareHTable.setWriteBufferSize(writeBufferSize);
    }

    @Override
    public void flushCommits() throws IOException {
        this.transactionAwareHTable.flushCommits();
    }

    @Override
    public void close() throws IOException {
        this.transactionAwareHTable.close();
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.transactionAwareHTable.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        return this.transactionAwareHTable.exists(gets);
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.transactionAwareHTable.setAutoFlush(autoFlush, clearBufferOnFail);
    }

    public void setAutoFlushTo(boolean autoFlush) {
        this.transactionAwareHTable.setAutoFlush(autoFlush);
    }

    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        return this.transactionAwareHTable.getRowOrBefore(row, family);
    }

    public TableName getName() {
        return this.transactionAwareHTable.getName();
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        return this.transactionAwareHTable.existsAll(gets);
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        this.transactionAwareHTable.batch(actions, results);
    }

    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        return this.transactionAwareHTable.batch(actions);
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.transactionAwareHTable.batchCallback(actions, results, callback);
    }

    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        return this.transactionAwareHTable.batchCallback(actions, callback);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.transactionAwareHTable.checkAndPut(row, family, qualifier, value, put);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        return this.transactionAwareHTable.checkAndPut(row, family, qualifier, compareOp, value, put);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.transactionAwareHTable.checkAndDelete(row, family, qualifier, value, delete);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        return this.transactionAwareHTable.checkAndDelete(row, family, qualifier, compareOp, value, delete);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.transactionAwareHTable.mutateRow(rm);
    }

    public Result append(Append append) throws IOException {
        return this.transactionAwareHTable.append(append);
    }

    public Result increment(Increment increment) throws IOException {
        return this.transactionAwareHTable.increment(increment);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.transactionAwareHTable.incrementColumnValue(row, family, qualifier, amount);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        return this.transactionAwareHTable.incrementColumnValue(row, family, qualifier, amount, durability);
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return this.transactionAwareHTable.coprocessorService(row);
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return this.transactionAwareHTable.coprocessorService(service, startKey, endKey, callable);
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.transactionAwareHTable.coprocessorService(service, startKey, endKey, callable, callback);
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        return this.transactionAwareHTable.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype);
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.transactionAwareHTable.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, callback);
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation) throws IOException {
        return this.transactionAwareHTable.checkAndMutate(row, family, qualifier, compareOp, value, mutation);
    }
}

