/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Collections;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.CreateFunctionStatement;
import org.apache.phoenix.schema.MetaDataClient;

public class CreateFunctionCompiler {
    private final PhoenixStatement statement;

    public CreateFunctionCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    public MutationPlan compile(final CreateFunctionStatement create) throws SQLException {
        PhoenixConnection connection;
        PhoenixConnection connectionToBe = connection = this.statement.getConnection();
        final StatementContext context = new StatementContext(this.statement);
        final MetaDataClient client = new MetaDataClient(connectionToBe);
        return new BaseMutationPlan(context, create.getOperation()){

            @Override
            public MutationState execute() throws SQLException {
                try {
                    MutationState mutationState = client.createFunction(create);
                    return mutationState;
                }
                finally {
                    if (client.getConnection() != connection) {
                        client.getConnection().close();
                    }
                }
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("CREATE" + (create.getFunctionInfo().isReplace() ? " OR REPLACE" : "") + " FUNCTION"));
            }

            @Override
            public StatementContext getContext() {
                return context;
            }
        };
    }
}

