/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Collections;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.CreateSchemaStatement;
import org.apache.phoenix.schema.MetaDataClient;

public class CreateSchemaCompiler {
    private final PhoenixStatement statement;

    public CreateSchemaCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    public MutationPlan compile(final CreateSchemaStatement create) throws SQLException {
        final PhoenixConnection connection = this.statement.getConnection();
        final StatementContext context = new StatementContext(this.statement);
        final MetaDataClient client = new MetaDataClient(connection);
        return new BaseMutationPlan(context, create.getOperation()){

            @Override
            public MutationState execute() throws SQLException {
                try {
                    MutationState mutationState = client.createSchema(create);
                    return mutationState;
                }
                finally {
                    if (client.getConnection() != connection) {
                        client.getConnection().close();
                    }
                }
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("CREATE SCHEMA"));
            }

            @Override
            public StatementContext getContext() {
                return context;
            }
        };
    }
}

