/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.schema.tuple.ResultTuple;

public class GetRegionObserver
extends BaseRegionObserver {
    private final ImmutableBytesWritable ptr = new ImmutableBytesWritable();

    public void start(CoprocessorEnvironment e) throws IOException {
        super.start(e);
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        super.stop(e);
    }

    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        Expression expression;
        if (results.isEmpty()) {
            return;
        }
        ResultTuple rsTuple = new ResultTuple(Result.create(results));
        byte[] whereBytes = get.getAttribute("_FilterPbBytes");
        if (!(whereBytes == null || (expression = this.deserializeExpression(whereBytes)).evaluate(rsTuple, this.ptr) && this.ptr.getLength() != 0 && Boolean.TRUE.equals(expression.getDataType().toObject(this.ptr)))) {
            results.clear();
            return;
        }
        boolean useNewValueColumnQualifier = get.getAttribute("_UseNewValueColumnQualifier") != null;
        TupleProjector projector = TupleProjector.deserializeProjectorFromGet(get);
        if (projector != null) {
            TupleProjector.ProjectedValueTuple projectTuple = projector.projectResults(rsTuple, useNewValueColumnQualifier);
            results.clear();
            results.add(projectTuple.getValue(0));
        }
    }

    private Expression deserializeExpression(byte[] b) {
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        try {
            DataInputStream input = new DataInputStream(stream);
            ExpressionType type = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)];
            Expression whereExpression = type.newInstance();
            whereExpression.readFields(input);
            Expression expression = whereExpression;
            return expression;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

