/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.generated.PhoenixFilterProtos;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.filter.FilterFactory;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.apache.phoenix.schema.tuple.PositionBasedResultTuple;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ServerUtil;

public class LookupJoinRegionScanner
implements RegionScanner {
    private static final int MULTI_GET_BATCH_SIZE = 100;
    private final RegionScanner delegate;
    private final TupleProjector projector;
    private final RegionCoprocessorEnvironment env;
    private final int getBatchSize;
    private final boolean useQualifierAsListIndex;
    private final boolean useNewValueColumnQualifier;
    private final HTableInterface htable;
    private final ImmutableBytesWritable ptr;
    private long count;
    private long limit;
    private Queue<Cell> resultQueue;
    private IndexMaintainer indexMaintainer;
    private ColumnReference[] dataColumns;
    private Filter filter;
    private Pair<Integer, Integer> minMaxQualifiers;
    private PTable.QualifierEncodingScheme encodingScheme;
    private boolean useQualifierAsIndex;
    private boolean hasMore = false;

    public LookupJoinRegionScanner(RegionScanner scanner, ColumnReference[] dataColumns, RegionCoprocessorEnvironment env, boolean useQualifierAsIndex, boolean useNewValueColumnQualifier, Scan scan, IndexMaintainer indexMaintainer) throws IOException {
        this.env = env;
        this.delegate = scanner;
        this.dataColumns = IndexUtil.deserializeDataTableColumns(scan, "_DataTableColumnsForLookUpJoin");
        this.resultQueue = new LinkedList<Cell>();
        this.count = 0L;
        this.useQualifierAsListIndex = useQualifierAsIndex;
        this.useNewValueColumnQualifier = useNewValueColumnQualifier;
        this.getBatchSize = 100;
        this.ptr = new ImmutableBytesWritable();
        this.indexMaintainer = indexMaintainer;
        this.htable = env.getTable(TableName.valueOf((byte[])scan.getAttribute("_SemiLeftTableName")));
        this.projector = TupleProjector.deserializeProjectorFromScan(scan, BaseScannerRegionObserver.getSemiAttrName("scanProjector"));
        byte[] limitBytes = scan.getAttribute("_OffsetOnServer");
        this.limit = limitBytes != null ? (long)Bytes.toInt((byte[])limitBytes) : -1L;
        byte[] filterTypeBytes = scan.getAttribute("_FilterType");
        if (filterTypeBytes != null) {
            try {
                PhoenixFilterProtos.FilterType type = PhoenixFilterProtos.FilterType.valueOf(Bytes.toInt((byte[])filterTypeBytes));
                byte[] filterBytes = scan.getAttribute("_FilterPbBytes");
                this.filter = FilterFactory.DeserFilter(type, filterBytes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.minMaxQualifiers = this.getMinMaxQualifiersFromScan(scan);
        this.useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(this.minMaxQualifiers);
        byte[] qualifierEncodingSchema = scan.getAttribute(BaseScannerRegionObserver.getSemiAttrName("_QualifierEncodingScheme"));
        this.encodingScheme = qualifierEncodingSchema == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : PTable.QualifierEncodingScheme.fromSerializedValue(qualifierEncodingSchema[0]);
    }

    private Pair<Integer, Integer> getMinMaxQualifiersFromScan(Scan scan) {
        byte[] maxQualifier;
        Integer minQ = null;
        Integer maxQ = null;
        byte[] minQualifier = scan.getAttribute(BaseScannerRegionObserver.getSemiAttrName("_MinQualifier"));
        if (minQualifier != null) {
            minQ = Bytes.toInt((byte[])minQualifier);
        }
        if ((maxQualifier = scan.getAttribute(BaseScannerRegionObserver.getSemiAttrName("_MaxQualifier"))) != null) {
            maxQ = Bytes.toInt((byte[])maxQualifier);
        }
        if (minQualifier == null) {
            return null;
        }
        return new Pair((Object)minQ, (Object)maxQ);
    }

    public long getMvccReadPoint() {
        return this.delegate.getMvccReadPoint();
    }

    public HRegionInfo getRegionInfo() {
        return this.delegate.getRegionInfo();
    }

    public boolean isFilterDone() throws IOException {
        return this.delegate.isFilterDone() && this.resultQueue.isEmpty();
    }

    private byte[] getRowKey(List<Cell> result) {
        BaseTuple tuple = this.useQualifierAsListIndex ? new PositionBasedResultTuple(result) : new ResultTuple(Result.create(result));
        tuple.getKey(this.ptr);
        return this.indexMaintainer.buildDataRowKey(this.ptr, null);
    }

    public boolean nextRaw(List<Cell> result) throws IOException {
        try {
            if (this.resultQueue.isEmpty()) {
                ArrayList gets = Lists.newArrayListWithExpectedSize((int)this.getBatchSize);
                int c = 0;
                do {
                    this.hasMore = this.delegate.nextRaw(result);
                    if (result.isEmpty()) continue;
                    byte[] key = this.getRowKey(result);
                    Get get = new Get(key);
                    if (this.dataColumns != null) {
                        PTable.ImmutableStorageScheme storageScheme = this.indexMaintainer.getIndexStorageScheme();
                        for (int i = 0; i < this.dataColumns.length; ++i) {
                            if (storageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
                                get.addFamily(this.dataColumns[i].getFamily());
                                continue;
                            }
                            get.addColumn(this.dataColumns[i].getFamily(), this.dataColumns[i].getQualifier());
                        }
                    }
                    if (this.filter != null) {
                        get.setFilter(this.filter);
                    }
                    gets.add(get);
                    result.clear();
                } while (this.hasMore && ++c % this.getBatchSize != 0);
                if (!gets.isEmpty()) {
                    for (Result r : this.htable.get((List)gets)) {
                        if (this.limit != -1L && this.count >= this.limit) {
                            this.hasMore = false;
                            break;
                        }
                        if (r.isEmpty()) continue;
                        List<Cell> rs = this.useQualifierAsIndex ? new EncodedColumnQualiferCellsList(11, (Integer)this.minMaxQualifiers.getSecond(), this.encodingScheme) : new ArrayList();
                        rs.addAll(r.listCells());
                        BaseTuple resultTuple = this.useQualifierAsListIndex ? new PositionBasedResultTuple(rs) : new ResultTuple(Result.create(rs));
                        TupleProjector.ProjectedValueTuple tuple = this.projector.projectResults(resultTuple);
                        this.resultQueue.offer((Cell)tuple.getValue(0));
                        ++this.count;
                    }
                }
            }
            Cell cell = this.resultQueue.poll();
            result.clear();
            if (cell == null && !this.hasMore) {
                this.resultQueue.clear();
                return false;
            }
            if (cell != null) {
                result.add(cell);
            }
            return true;
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(this.env.getRegion().getRegionInfo().getRegionNameAsString(), t);
            return false;
        }
    }

    public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
        throw new IOException("Next with scannerContext should not be called in Phoenix environment");
    }

    public boolean reseek(byte[] row) throws IOException {
        return this.delegate.reseek(row);
    }

    public void close() throws IOException {
        this.htable.close();
        this.delegate.close();
    }

    public boolean next(List<Cell> result) throws IOException {
        throw new IOException("Next should not be used in SemiJoin scanner");
    }

    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        throw new IOException("Next with scanner context should not be used in SemiJoin scanner");
    }

    public long getMaxResultSize() {
        return this.delegate.getMaxResultSize();
    }

    public int getBatch() {
        return this.delegate.getBatch();
    }
}

