/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.execute.DelegateQueryPlan;
import org.apache.phoenix.filter.FilterFactory;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.NumberUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;

public class LookupJoinPlan
extends DelegateQueryPlan {
    private static final Log LOG = LogFactory.getLog(LookupJoinPlan.class);
    private final QueryPlan plan;
    private final Set<TableRef> tableRefs;
    private Long estimatedRows;
    private Long estimatedBytes;
    private Long estimateInfoTs;
    private boolean explainPlanCalled;

    public LookupJoinPlan(QueryPlan plan, QueryPlan delegate) {
        super(delegate);
        this.plan = plan;
        this.tableRefs = Sets.newHashSetWithExpectedSize((int)(delegate.getSourceRefs().size() + plan.getSourceRefs().size()));
        this.tableRefs.addAll(plan.getSourceRefs());
        this.tableRefs.addAll(delegate.getSourceRefs());
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return this.tableRefs;
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        if (scan == null) {
            scan = this.getDelegate().getContext().getScan();
        }
        StatementContext context = this.plan.getContext();
        PTable dataTable = this.plan.getTableRef().getTable();
        ResultIterator scanner = null;
        try {
            boolean isOrdered;
            if (this.plan.getStatement().getWhere() != null) {
                Filter filter = context.getScan().getFilter();
                byte[] filterBytes = filter.toByteArray();
                scan.setAttribute("_FilterPbBytes", filterBytes);
                scan.setAttribute("_FilterType", Bytes.toBytes((int)FilterFactory.getFilterType(filter).getNumber()));
            }
            ArrayList indexes = Lists.newArrayListWithExpectedSize((int)1);
            indexes.add(this.delegate.getTableRef().getTable());
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            IndexMaintainer.serialize(dataTable, ptr, indexes, context.getConnection());
            scan.setAttribute("_IndexBuildProto", ByteUtil.copyKeyBytesIfNecessary(ptr));
            if (dataTable.isTransactional()) {
                scan.setAttribute("_TxState", context.getConnection().getMutationState().encodeTransaction());
            }
            scan.setAttribute("_SemiLeftTableName", SchemaUtil.getPhysicalHBaseTableName(dataTable.getSchemaName(), dataTable.getTableName(), dataTable.isNamespaceMapped()).getBytes());
            FilterableStatement query = this.plan.getStatement();
            boolean bl = isOrdered = !query.getOrderBy().isEmpty() && !this.plan.getOrderBy().getOrderByExpressions().isEmpty();
            if (!(query.isAggregate() || query.isDistinct() || isOrdered || this.plan.getLimit() == null || this.plan.getOffset() == null)) {
                scan.setAttribute("_OffsetOnServer", Bytes.toBytes((int)QueryUtil.getOffsetLimit(this.plan.getLimit(), this.plan.getOffset())));
            }
            Scan dataScan = context.getScan();
            this.plan.iterator(scanGrouper, dataScan);
            for (Map.Entry entry : context.getScan().getAttributesMap().entrySet()) {
                String attrName = BaseScannerRegionObserver.getSemiAttrName((String)entry.getKey());
                scan.setAttribute(attrName, (byte[])entry.getValue());
            }
            LookupJoinPlan.serializeDataTableColumns(scan, dataScan.getFamilyMap());
            scanner = this.delegate.iterator(scanGrouper, scan);
            if (this.plan.getOffset() != null) {
                scanner = new OffsetResultIterator(scanner, this.plan.getOffset());
            }
            if (this.plan.getLimit() != null) {
                scanner = new LimitingResultIterator(scanner, this.plan.getLimit());
            }
            if (context.getSequenceManager().getSequenceCount() > 0) {
                scanner = new SequenceResultIterator(scanner, context.getSequenceManager());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return scanner;
    }

    public static void serializeDataTableColumns(Scan scan, Map<byte[], NavigableSet<byte[]>> familyMap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ArrayList<Pair> familyPairs = new ArrayList<Pair>();
            for (Map.Entry<byte[], NavigableSet<byte[]>> entry : familyMap.entrySet()) {
                if (entry.getValue() != null) {
                    for (byte[] cq : entry.getValue()) {
                        if (cq == null) continue;
                        familyPairs.add(new Pair((Object)entry.getKey(), (Object)cq));
                    }
                    continue;
                }
                familyPairs.add(new Pair((Object)entry.getKey(), null));
            }
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)familyPairs.size());
            for (Pair cfMap : familyPairs) {
                byte[] cf = (byte[])cfMap.getFirst();
                byte[] cq = (byte[])cfMap.getSecond();
                Bytes.writeByteArray((DataOutput)output, (byte[])cf);
                Bytes.writeByteArray((DataOutput)output, (byte[])cq);
            }
            scan.setAttribute("_DataTableColumnsForLookUpJoin", stream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        this.explainPlanCalled = true;
        ArrayList planSteps = Lists.newArrayList(this.delegate.getExplainPlan().getPlanSteps());
        boolean exists = planSteps.remove("CLIENT MERGE SORT");
        planSteps.add("    SERVER MULTI GET " + this.plan.getTableRef().getTable().getTableName().getString());
        if (exists) {
            planSteps.add("CLIENT MERGE SORT");
        }
        if (this.plan.getOffset() != null) {
            planSteps.add("CLIENT OFFSET " + this.plan.getOffset());
        }
        if (this.plan.getLimit() != null) {
            planSteps.add("CLIENT " + this.plan.getLimit() + " ROW LIMIT");
        }
        if (this.delegate.getEstimatedBytesToScan() == null || this.delegate.getEstimatedRowsToScan() == null || this.delegate.getEstimateInfoTimestamp() == null) {
            this.estimatedBytes = null;
            this.estimatedRows = null;
            this.estimateInfoTs = null;
        } else {
            this.estimatedBytes = NumberUtil.add(this.plan.getEstimatedBytesToScan(), this.delegate.getEstimatedBytesToScan());
            this.estimatedRows = NumberUtil.add(this.plan.getEstimatedRowsToScan(), this.delegate.getEstimatedRowsToScan());
            this.estimateInfoTs = NumberUtil.getMin(this.plan.getEstimateInfoTimestamp(), this.delegate.getEstimateInfoTimestamp());
        }
        return new ExplainPlan(planSteps);
    }

    @Override
    public RowProjector getProjector() {
        return this.plan.getProjector();
    }

    @Override
    public FilterableStatement getStatement() {
        return this.plan.getStatement();
    }

    @Override
    public Long getEstimatedRowsToScan() throws SQLException {
        if (!this.explainPlanCalled) {
            this.getExplainPlan();
        }
        return this.estimatedRows;
    }

    @Override
    public Long getEstimatedBytesToScan() throws SQLException {
        if (!this.explainPlanCalled) {
            this.getExplainPlan();
        }
        return this.estimatedBytes;
    }

    @Override
    public Long getEstimateInfoTimestamp() throws SQLException {
        if (!this.explainPlanCalled) {
            this.getExplainPlan();
        }
        return this.estimateInfoTs;
    }
}

