/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.util.ByteUtil;

public abstract class ScalarFunction
extends FunctionExpression {
    public static final int NO_TRAVERSAL = -1;

    public ScalarFunction() {
    }

    public ScalarFunction(List<Expression> children) {
        super(children);
    }

    public ScalarFunction clone(List<Expression> children) {
        try {
            return (ScalarFunction)this.getClass().getConstructor(List.class).newInstance(children);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static byte[] evaluateExpression(Expression rhs) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        rhs.evaluate(null, ptr);
        byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
        return key;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public int getKeyFormationTraversalIndex() {
        return this.preservesOrder() == FunctionExpression.OrderPreserving.NO ? -1 : 0;
    }

    public KeyPart newKeyPart(KeyPart childPart) {
        return null;
    }
}

