/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.phoenix.coprocessor.generated.PhoenixFilterProtos;
import org.apache.phoenix.filter.ColumnProjectionFilter;
import org.apache.phoenix.filter.DistinctPrefixFilter;
import org.apache.phoenix.filter.EncodedQualifiersColumnProjectionFilter;
import org.apache.phoenix.filter.MultiCFCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.MultiCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.MultiEncodedCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.MultiKeyValueComparisonFilter;
import org.apache.phoenix.filter.RowKeyComparisonFilter;
import org.apache.phoenix.filter.SingleCFCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.SingleCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.SingleKeyValueComparisonFilter;
import org.apache.phoenix.filter.SkipScanFilter;

public class FilterFactory {
    public static Filter DeserFilter(PhoenixFilterProtos.FilterType type, byte[] pbBytes) throws DeserializationException {
        switch (type) {
            case SINGLE_CQ_KEY_VALUE_COMPARISON: {
                return SingleCQKeyValueComparisonFilter.parseFrom(pbBytes);
            }
            case SINGLE_CF_CQ_KEY_VALUE_COMPARISON: {
                return SingleCFCQKeyValueComparisonFilter.parseFrom(pbBytes);
            }
            case SINGLE_KEY_VALUE_COMPARISON: {
                return SingleKeyValueComparisonFilter.parseFrom((byte[])pbBytes);
            }
            case SKIP_SCAN: {
                return SkipScanFilter.parseFrom(pbBytes);
            }
            case ROWKEY_COMPARISON: {
                return RowKeyComparisonFilter.parseFrom(pbBytes);
            }
            case MULTI_KEY_VALUE_COMPARISON: {
                return MultiKeyValueComparisonFilter.parseFrom((byte[])pbBytes);
            }
            case MULTI_ENOCDE_CQ_KEY_VALUE_COMPARISON: {
                return MultiEncodedCQKeyValueComparisonFilter.parseFrom(pbBytes);
            }
            case MULTI_CF_CQ_KEY_VALUE_COMPARISON: {
                return MultiCFCQKeyValueComparisonFilter.parseFrom(pbBytes);
            }
            case MULTI_CQ_KEY_VALUE_COMPARISON: {
                return MultiCQKeyValueComparisonFilter.parseFrom(pbBytes);
            }
            case DISTINCT_PREFIX: {
                return DistinctPrefixFilter.parseFrom(pbBytes);
            }
            case COLUMN_PROJECT: {
                return ColumnProjectionFilter.parseFrom(pbBytes);
            }
            case ENCODE_QUALIFIER_COLUMN_PROJECT: {
                return EncodedQualifiersColumnProjectionFilter.parseFrom(pbBytes);
            }
            case FILTER_LIST: {
                return FilterList.parseFrom((byte[])pbBytes);
            }
        }
        throw new IllegalArgumentException("Unsupported filter type");
    }

    public static PhoenixFilterProtos.FilterType getFilterType(Filter filter) {
        if (filter instanceof SingleCQKeyValueComparisonFilter) {
            return PhoenixFilterProtos.FilterType.SINGLE_CQ_KEY_VALUE_COMPARISON;
        }
        if (filter instanceof SingleCFCQKeyValueComparisonFilter) {
            return PhoenixFilterProtos.FilterType.SINGLE_CF_CQ_KEY_VALUE_COMPARISON;
        }
        if (filter instanceof SingleKeyValueComparisonFilter) {
            return PhoenixFilterProtos.FilterType.SINGLE_KEY_VALUE_COMPARISON;
        }
        if (filter instanceof SkipScanFilter) {
            return PhoenixFilterProtos.FilterType.SKIP_SCAN;
        }
        if (filter instanceof RowKeyComparisonFilter) {
            return PhoenixFilterProtos.FilterType.ROWKEY_COMPARISON;
        }
        if (filter instanceof MultiKeyValueComparisonFilter) {
            return PhoenixFilterProtos.FilterType.MULTI_KEY_VALUE_COMPARISON;
        }
        if (filter instanceof MultiEncodedCQKeyValueComparisonFilter) {
            return PhoenixFilterProtos.FilterType.MULTI_ENOCDE_CQ_KEY_VALUE_COMPARISON;
        }
        if (filter instanceof MultiCFCQKeyValueComparisonFilter) {
            return PhoenixFilterProtos.FilterType.MULTI_CF_CQ_KEY_VALUE_COMPARISON;
        }
        if (filter instanceof MultiCQKeyValueComparisonFilter) {
            return PhoenixFilterProtos.FilterType.MULTI_CQ_KEY_VALUE_COMPARISON;
        }
        if (filter instanceof DistinctPrefixFilter) {
            return PhoenixFilterProtos.FilterType.DISTINCT_PREFIX;
        }
        if (filter instanceof ColumnProjectionFilter) {
            return PhoenixFilterProtos.FilterType.COLUMN_PROJECT;
        }
        if (filter instanceof FilterList) {
            return PhoenixFilterProtos.FilterType.FILTER_LIST;
        }
        return PhoenixFilterProtos.FilterType.ENCODE_QUALIFIER_COLUMN_PROJECT;
    }
}

