/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.table;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.CoprocessorHConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class CoprocessorHTableFactory
implements HTableFactory {
    private Connection conn = null;

    public CoprocessorHTableFactory(CoprocessorEnvironment e) {
        try {
            RegionCoprocessorEnvironment rce;
            RegionServerServices services;
            Configuration conf = new Configuration(e.getConfiguration());
            if (e instanceof RegionCoprocessorEnvironment && (services = (rce = (RegionCoprocessorEnvironment)e).getRegionServerServices()) instanceof HRegionServer) {
                this.conn = new CoprocessorHConnection(conf, (HRegionServer)services);
            }
            if (this.conn == null) {
                this.conn = ConnectionFactory.createConnection((Configuration)conf);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed creating inter-RS connection", ioe);
        }
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public HTableInterface getTable(ImmutableBytesPtr tableName) throws IOException {
        return (HTableInterface)this.conn.getTable(TableName.valueOf((byte[])tableName.copyBytesIfNecessary()));
    }

    @Override
    public HTableInterface getTable(ImmutableBytesPtr tableName, ExecutorService pool) throws IOException {
        return (HTableInterface)this.conn.getTable(TableName.valueOf((byte[])tableName.copyBytesIfNecessary()), pool);
    }

    @Override
    public void shutdown() {
    }
}

