/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.CoprocessorHConnection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.phoenix.hbase.index.table.CoprocessorHTableFactory;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;

public class IndexWriterUtils {
    private static final Log LOG = LogFactory.getLog(IndexWriterUtils.class);
    private static final String INDEX_WRITER_PER_TABLE_THREADS_CONF_KEY = "index.writer.threads.pertable.max";
    private static final int DEFAULT_NUM_PER_TABLE_THREADS = Integer.MAX_VALUE;
    public static final String HTABLE_THREAD_KEY = "hbase.htable.threads.max";
    public static final String INDEX_WRITES_THREAD_MAX_PER_REGIONSERVER_KEY = "phoenix.index.writes.threads.max";
    public static final String HTABLE_KEEP_ALIVE_KEY = "hbase.htable.threads.keepalivetime";
    public static final String INDEX_WRITER_RPC_RETRIES_NUMBER = "phoenix.index.writes.rpc.retries.number";
    public static final int DEFAULT_INDEX_WRITER_RPC_RETRIES_NUMBER = 11;
    public static final String INDEX_WRITER_RPC_PAUSE = "phoenix.index.writes.rpc.pause";
    public static final int DEFAULT_INDEX_WRITER_RPC_PAUSE = 100;
    private static HTableFactory TABLE_FACTORY = null;

    private IndexWriterUtils() {
    }

    public static HTableFactory getDefaultDelegateHTableFactory(CoprocessorEnvironment env) {
        if (TABLE_FACTORY == null) {
            Configuration conf = env.getConfiguration();
            int htableThreads = conf.getInt(INDEX_WRITER_PER_TABLE_THREADS_CONF_KEY, Integer.MAX_VALUE);
            LOG.trace((Object)("Creating HTableFactory with " + htableThreads + " threads for each HTable."));
            IndexManagementUtil.setIfNotSet(conf, HTABLE_THREAD_KEY, htableThreads);
            TABLE_FACTORY = new CoprocessorHTableFactory(env);
        }
        return TABLE_FACTORY;
    }

    private static class CoprocessorHConnectionTableFactory
    implements HTableFactory {
        @GuardedBy(value="CoprocessorHConnectionTableFactory.this")
        private HConnection connection;
        private final Configuration conf;
        private final HRegionServer server;

        CoprocessorHConnectionTableFactory(Configuration conf, HRegionServer server) {
            this.conf = conf;
            this.server = server;
        }

        private synchronized HConnection getConnection(Configuration conf) throws IOException {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = new CoprocessorHConnection(conf, this.server);
            }
            return this.connection;
        }

        @Override
        public HTableInterface getTable(ImmutableBytesPtr tablename) throws IOException {
            return this.getConnection(this.conf).getTable(tablename.copyBytesIfNecessary());
        }

        @Override
        public synchronized void shutdown() {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)"Error while trying to close the HConnection used by CoprocessorHConnectionTableFactory", e);
            }
        }

        @Override
        public HTableInterface getTable(ImmutableBytesPtr tablename, ExecutorService pool) throws IOException {
            return this.getConnection(this.conf).getTable(tablename.copyBytesIfNecessary(), pool);
        }

        @Override
        public Connection getConnection() {
            try {
                return this.getConnection(this.conf);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed creating coprocessor connection", e);
            }
        }
    }
}

