/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.generated.ServerCachingProtos;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.SingleCellConstructorExpression;
import org.apache.phoenix.expression.visitor.KeyValueExpressionVisitor;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.ValueGetterTuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.BitSet;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class IndexMaintainer
implements Writable,
Iterable<ColumnReference> {
    private static final int EXPRESSION_NOT_PRESENT = -1;
    private static final int ESTIMATED_EXPRESSION_SIZE = 8;
    private byte[] viewIndexId;
    private boolean isMultiTenant;
    private List<Expression> indexedExpressions;
    private Set<ColumnReference> indexedColumns;
    private Set<ColumnReference> allColumns;
    private List<PDataType> indexedColumnTypes;
    private RowKeyMetaData rowKeyMetaData;
    private byte[] indexTableName;
    private int nIndexSaltBuckets;
    private byte[] dataEmptyKeyValueCF;
    private ImmutableBytesPtr emptyKeyValueCFPtr;
    private int nDataCFs;
    private boolean indexWALDisabled;
    private boolean isLocalIndex;
    private boolean immutableRows;
    private final boolean isDataTableSalted;
    private final RowKeySchema dataRowKeySchema;
    private int estimatedIndexRowKeyBytes;
    private int estimatedExpressionSize;
    private int[] dataPkPosition;
    private int maxTrailingNulls;
    private ColumnReference dataEmptyKeyValueRef;
    private boolean rowKeyOrderOptimizable;
    private PTable.QualifierEncodingScheme encodingScheme;
    private PTable.ImmutableStorageScheme immutableStorageScheme;
    private Set<Pair<String, String>> indexedColumnsInfo;
    private Map<ColumnReference, ColumnReference> coveredColumnsMap;
    private volatile RowKeySchema indexRowKeySchema;
    private static int BYTE_OFFSET = 127;

    public static IndexMaintainer create(PTable dataTable, PTable index, PhoenixConnection connection) {
        if (dataTable.getType() == PTableType.INDEX || index.getType() != PTableType.INDEX || !dataTable.getIndexes().contains(index)) {
            throw new IllegalArgumentException();
        }
        IndexMaintainer maintainer = new IndexMaintainer(dataTable, index, connection);
        return maintainer;
    }

    private static boolean sendIndexMaintainer(PTable index) {
        PIndexState indexState = index.getIndexState();
        return PIndexState.DISABLE != indexState && PIndexState.PENDING_ACTIVE != indexState;
    }

    public static Iterator<PTable> maintainedIndexes(Iterator<PTable> indexes) {
        return Iterators.filter(indexes, (Predicate)new Predicate<PTable>(){

            public boolean apply(PTable index) {
                return IndexMaintainer.sendIndexMaintainer(index);
            }
        });
    }

    public static Iterator<PTable> maintainedGlobalIndexes(Iterator<PTable> indexes) {
        return Iterators.filter(indexes, (Predicate)new Predicate<PTable>(){

            public boolean apply(PTable index) {
                return IndexMaintainer.sendIndexMaintainer(index) && index.getIndexType() == PTable.IndexType.GLOBAL;
            }
        });
    }

    public static Iterator<PTable> maintainedLocalIndexes(Iterator<PTable> indexes) {
        return Iterators.filter(indexes, (Predicate)new Predicate<PTable>(){

            public boolean apply(PTable index) {
                return IndexMaintainer.sendIndexMaintainer(index) && index.getIndexType() == PTable.IndexType.LOCAL;
            }
        });
    }

    public static void serialize(PTable dataTable, ImmutableBytesWritable ptr, PhoenixConnection connection) {
        List<PTable> indexes = dataTable.getIndexes();
        IndexMaintainer.serialize(dataTable, ptr, indexes, connection);
    }

    public static void serialize(PTable dataTable, ImmutableBytesWritable ptr, List<PTable> indexes, PhoenixConnection connection) {
        Iterator<PTable> indexesItr = IndexMaintainer.maintainedIndexes(indexes.iterator());
        if (!(!dataTable.isImmutableRows() && indexesItr.hasNext() || (indexesItr = IndexMaintainer.maintainedLocalIndexes(indexesItr)).hasNext())) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return;
        }
        int nIndexes = 0;
        while (indexesItr.hasNext()) {
            ++nIndexes;
            indexesItr.next();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(stream);
        try {
            WritableUtils.writeVInt((DataOutput)output, (int)(nIndexes * (dataTable.getBucketNum() == null ? 1 : -1)));
            dataTable.getRowKeySchema().write(output);
            Iterator<PTable> iterator = indexesItr = dataTable.isImmutableRows() ? IndexMaintainer.maintainedLocalIndexes(indexes.iterator()) : IndexMaintainer.maintainedIndexes(indexes.iterator());
            while (indexesItr.hasNext()) {
                ServerCachingProtos.IndexMaintainer proto = IndexMaintainer.toProto(indexesItr.next().getIndexMaintainer(dataTable, connection));
                byte[] protoBytes = proto.toByteArray();
                WritableUtils.writeVInt((DataOutput)output, (int)protoBytes.length);
                output.write(protoBytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ptr.set(stream.toByteArray(), 0, stream.size());
    }

    public static void serializeAdditional(PTable table, ImmutableBytesWritable indexMetaDataPtr, List<PTable> keyValueIndexes, PhoenixConnection connection) {
        int nMutableIndexes = indexMetaDataPtr.getLength() == 0 ? 0 : ByteUtil.vintFromBytes(indexMetaDataPtr);
        int nIndexes = nMutableIndexes + keyValueIndexes.size();
        int estimatedSize = indexMetaDataPtr.getLength() + 1;
        if (indexMetaDataPtr.getLength() == 0) {
            estimatedSize += table.getRowKeySchema().getEstimatedByteSize();
        }
        for (PTable index : keyValueIndexes) {
            estimatedSize += index.getIndexMaintainer(table, connection).getEstimatedByteSize();
        }
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(estimatedSize + 1);
        DataOutputStream output = new DataOutputStream(stream);
        try {
            WritableUtils.writeVInt((DataOutput)output, (int)(nIndexes * (table.getBucketNum() == null ? 1 : -1)));
            if (indexMetaDataPtr.getLength() > 0) {
                output.write(indexMetaDataPtr.get(), indexMetaDataPtr.getOffset(), indexMetaDataPtr.getLength() - WritableUtils.getVIntSize((long)nMutableIndexes));
            } else {
                table.getRowKeySchema().write(output);
            }
            for (PTable index : keyValueIndexes) {
                IndexMaintainer maintainer = index.getIndexMaintainer(table, connection);
                byte[] protoBytes = IndexMaintainer.toProto(maintainer).toByteArray();
                WritableUtils.writeVInt((DataOutput)output, (int)protoBytes.length);
                output.write(protoBytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        indexMetaDataPtr.set(stream.getBuffer(), 0, stream.size());
    }

    public static List<IndexMaintainer> deserialize(ImmutableBytesWritable metaDataPtr, KeyValueBuilder builder, boolean useProtoForIndexMaintainer) {
        return IndexMaintainer.deserialize(metaDataPtr.get(), metaDataPtr.getOffset(), metaDataPtr.getLength(), useProtoForIndexMaintainer);
    }

    public static List<IndexMaintainer> deserialize(byte[] buf, boolean useProtoForIndexMaintainer) {
        return IndexMaintainer.deserialize(buf, 0, buf.length, useProtoForIndexMaintainer);
    }

    private static List<IndexMaintainer> deserialize(byte[] buf, int offset, int length, boolean useProtoForIndexMaintainer) {
        ByteArrayInputStream stream = new ByteArrayInputStream(buf, offset, length);
        DataInputStream input = new DataInputStream(stream);
        ArrayList maintainers = Collections.emptyList();
        try {
            int size = WritableUtils.readVInt((DataInput)input);
            boolean isDataTableSalted = size < 0;
            size = Math.abs(size);
            RowKeySchema rowKeySchema = new RowKeySchema();
            rowKeySchema.readFields(input);
            maintainers = Lists.newArrayListWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                if (useProtoForIndexMaintainer) {
                    int protoSize = WritableUtils.readVInt((DataInput)input);
                    byte[] b = new byte[protoSize];
                    input.readFully(b);
                    ServerCachingProtos.IndexMaintainer proto = ServerCachingProtos.IndexMaintainer.parseFrom(b);
                    maintainers.add(IndexMaintainer.fromProto(proto, rowKeySchema, isDataTableSalted));
                    continue;
                }
                IndexMaintainer maintainer = new IndexMaintainer(rowKeySchema, isDataTableSalted);
                maintainer.readFields(input);
                maintainers.add(maintainer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return maintainers;
    }

    private IndexMaintainer(RowKeySchema dataRowKeySchema, boolean isDataTableSalted) {
        this.dataRowKeySchema = dataRowKeySchema;
        this.isDataTableSalted = isDataTableSalted;
    }

    private IndexMaintainer(final PTable dataTable, PTable index, PhoenixConnection connection) {
        this(dataTable.getRowKeySchema(), dataTable.getBucketNum() != null);
        int i;
        assert (dataTable.getType() == PTableType.SYSTEM || dataTable.getType() == PTableType.TABLE || dataTable.getType() == PTableType.VIEW);
        this.rowKeyOrderOptimizable = index.rowKeyOrderOptimizable();
        this.isMultiTenant = dataTable.isMultiTenant();
        this.viewIndexId = index.getViewIndexId() == null ? null : MetaDataUtil.getViewIndexIdDataType().toBytes(index.getViewIndexId());
        this.isLocalIndex = index.getIndexType() == PTable.IndexType.LOCAL;
        this.encodingScheme = index.getEncodingScheme();
        this.encodingScheme = index.getEncodingScheme() == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : index.getEncodingScheme();
        this.immutableStorageScheme = index.getImmutableStorageScheme() == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : index.getImmutableStorageScheme();
        byte[] indexTableName = index.getPhysicalName().getBytes();
        Integer nIndexSaltBuckets = this.isLocalIndex ? dataTable.getBucketNum() : index.getBucketNum();
        boolean indexWALDisabled = index.isWALDisabled();
        int indexPosOffset = (index.getBucketNum() == null ? 0 : 1) + (this.isMultiTenant ? 1 : 0) + (this.viewIndexId == null ? 0 : 1);
        int nIndexColumns = index.getColumns().size() - indexPosOffset;
        int nIndexPKColumns = index.getPKColumns().size() - indexPosOffset;
        int indexedExpressionCount = 0;
        for (int i2 = indexPosOffset; i2 < index.getPKColumns().size(); ++i2) {
            PColumn indexColumn = index.getPKColumns().get(i2);
            String indexColumnName = indexColumn.getName().getString();
            String dataFamilyName = IndexUtil.getDataColumnFamilyName(indexColumnName);
            String dataColumnName = IndexUtil.getDataColumnName(indexColumnName);
            try {
                PColumn dataColumn;
                PColumn pColumn = dataColumn = dataFamilyName.equals("") ? dataTable.getColumnForColumnName(dataColumnName) : dataTable.getColumnFamily(dataFamilyName).getPColumnForColumnName(dataColumnName);
                if (SchemaUtil.isPKColumn(dataColumn)) {
                    continue;
                }
            }
            catch (ColumnNotFoundException dataColumn) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            ++indexedExpressionCount;
        }
        int indexPkColumnCount = this.dataRowKeySchema.getFieldCount() + indexedExpressionCount - (this.isDataTableSalted ? 1 : 0) - (this.isMultiTenant ? 1 : 0);
        this.rowKeyMetaData = this.newRowKeyMetaData(indexPkColumnCount);
        BitSet bitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        int dataPosOffset = (this.isDataTableSalted ? 1 : 0) + (this.isMultiTenant ? 1 : 0);
        int nDataPKColumns = this.dataRowKeySchema.getFieldCount() - dataPosOffset;
        if (dataTable.getType() == PTableType.VIEW) {
            List<PColumn> dataPKColumns = dataTable.getPKColumns();
            for (int i3 = dataPosOffset; i3 < dataPKColumns.size(); ++i3) {
                PColumn dataPKColumn = dataPKColumns.get(i3);
                if (dataPKColumn.getViewConstant() == null) continue;
                bitSet.set(i3);
                --nDataPKColumns;
            }
        }
        this.indexTableName = indexTableName;
        this.indexedColumnTypes = Lists.newArrayListWithExpectedSize((int)(nIndexPKColumns - nDataPKColumns));
        this.indexedExpressions = Lists.newArrayListWithExpectedSize((int)(nIndexPKColumns - nDataPKColumns));
        this.coveredColumnsMap = Maps.newHashMapWithExpectedSize((int)(nIndexColumns - nIndexPKColumns));
        this.nIndexSaltBuckets = nIndexSaltBuckets == null ? 0 : nIndexSaltBuckets;
        this.dataEmptyKeyValueCF = SchemaUtil.getEmptyColumnFamily(dataTable);
        this.emptyKeyValueCFPtr = SchemaUtil.getEmptyColumnFamilyPtr(index);
        this.nDataCFs = dataTable.getColumnFamilies().size();
        this.indexWALDisabled = indexWALDisabled;
        this.immutableRows = dataTable.isImmutableRows();
        int indexColByteSize = 0;
        ColumnResolver resolver = null;
        ArrayList<ParseNode> parseNodes = new ArrayList<ParseNode>(1);
        UDFParseNodeVisitor visitor = new UDFParseNodeVisitor();
        for (int i4 = indexPosOffset; i4 < index.getPKColumns().size(); ++i4) {
            PColumn indexColumn = index.getPKColumns().get(i4);
            String expressionStr = IndexUtil.getIndexColumnExpressionStr(indexColumn);
            try {
                ParseNode parseNode = SQLParser.parseCondition(expressionStr);
                parseNode.accept(visitor);
                parseNodes.add(parseNode);
                continue;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            resolver = FromCompiler.getResolver(connection, new TableRef(dataTable), visitor.getUdfParseNodes());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        StatementContext context = new StatementContext(new PhoenixStatement(connection), resolver);
        this.indexedColumnsInfo = Sets.newHashSetWithExpectedSize((int)(nIndexColumns - nIndexPKColumns));
        IndexExpressionCompiler expressionIndexCompiler = new IndexExpressionCompiler(context);
        for (i = indexPosOffset; i < index.getPKColumns().size(); ++i) {
            PColumn indexColumn = index.getPKColumns().get(i);
            int indexPos = i - indexPosOffset;
            Expression expression = null;
            try {
                expressionIndexCompiler.reset();
                expression = ((ParseNode)parseNodes.get(indexPos)).accept(expressionIndexCompiler);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (expressionIndexCompiler.getColumnRef() != null) {
                PColumn column = IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString());
                boolean isPKColumn = SchemaUtil.isPKColumn(column);
                if (isPKColumn) {
                    int dataPkPos = dataTable.getPKColumns().indexOf(column) - (dataTable.getBucketNum() == null ? 0 : 1) - (this.isMultiTenant ? 1 : 0);
                    this.rowKeyMetaData.setIndexPkPosition(dataPkPos, indexPos);
                    this.indexedColumnsInfo.add((Pair<String, String>)new Pair((Object)null, (Object)column.getName().getString()));
                } else {
                    indexColByteSize += column.getDataType().isFixedWidth() ? SchemaUtil.getFixedByteSize(column) : 10;
                    try {
                        if (column.isNullable() && ExpressionUtil.isConstant(expression)) {
                            expression = CoerceExpression.create(expression, indexColumn.getDataType());
                        }
                        this.indexedExpressions.add(expression);
                        this.indexedColumnsInfo.add((Pair<String, String>)new Pair((Object)column.getFamilyName().getString(), (Object)column.getName().getString()));
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                indexColByteSize += expression.getDataType().isFixedWidth() ? SchemaUtil.getFixedByteSize(expression) : 10;
                this.indexedExpressions.add(expression);
                KeyValueExpressionVisitor kvVisitor = new KeyValueExpressionVisitor(){

                    @Override
                    public Void visit(KeyValueColumnExpression colExpression) {
                        return this.addDataColInfo(dataTable, colExpression);
                    }

                    @Override
                    public Void visit(SingleCellColumnExpression expression) {
                        return this.addDataColInfo(dataTable, expression);
                    }

                    private Void addDataColInfo(PTable dataTable2, Expression expression) {
                        Preconditions.checkArgument((expression instanceof SingleCellColumnExpression || expression instanceof KeyValueColumnExpression ? 1 : 0) != 0);
                        KeyValueColumnExpression colExpression = null;
                        colExpression = expression instanceof SingleCellColumnExpression ? ((SingleCellColumnExpression)expression).getKeyValueExpression() : (KeyValueColumnExpression)expression;
                        byte[] cf = colExpression.getColumnFamily();
                        byte[] cq = colExpression.getColumnQualifier();
                        try {
                            PColumn dataColumn = cf == null ? dataTable2.getColumnForColumnQualifier(null, cq) : dataTable2.getColumnFamily(cf).getPColumnForColumnQualifier(cq);
                            IndexMaintainer.this.indexedColumnsInfo.add(new Pair((Object)dataColumn.getFamilyName().getString(), (Object)dataColumn.getName().getString()));
                        }
                        catch (AmbiguousColumnException | ColumnFamilyNotFoundException | ColumnNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                };
                expression.accept(kvVisitor);
            }
            if (indexColumn.getSortOrder() != SortOrder.DESC) continue;
            this.rowKeyMetaData.getDescIndexColumnBitSet().set(indexPos);
        }
        this.estimatedExpressionSize = expressionIndexCompiler.getTotalNodeCount() * 8;
        for (i = 0; i < index.getColumnFamilies().size(); ++i) {
            PColumnFamily family = index.getColumnFamilies().get(i);
            for (PColumn indexColumn : family.getColumns()) {
                PColumn dataColumn = IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString());
                byte[] dataColumnCq = dataColumn.getColumnQualifierBytes();
                byte[] indexColumnCq = indexColumn.getColumnQualifierBytes();
                this.coveredColumnsMap.put(new ColumnReference(dataColumn.getFamilyName().getBytes(), dataColumnCq), new ColumnReference(indexColumn.getFamilyName().getBytes(), indexColumnCq));
            }
        }
        this.estimatedIndexRowKeyBytes = this.estimateIndexRowKeyByteSize(indexColByteSize);
        this.initCachedState();
    }

    public byte[] buildRowKey(ValueGetter valueGetter, ImmutableBytesWritable rowKeyPtr, byte[] regionStartKey, byte[] regionEndKey, long ts) {
        boolean isIndexSalted;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean prependRegionStartKey = this.isLocalIndex && regionStartKey != null;
        boolean bl = isIndexSalted = !this.isLocalIndex && this.nIndexSaltBuckets > 0;
        int prefixKeyLength = prependRegionStartKey ? (regionStartKey.length != 0 ? regionStartKey.length : regionEndKey.length) : 0;
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedIndexRowKeyBytes + (prependRegionStartKey ? prefixKeyLength : 0));
        DataOutputStream output = new DataOutputStream(stream);
        try {
            int length;
            if (prependRegionStartKey) {
                if (regionStartKey.length == 0) {
                    output.write(new byte[prefixKeyLength]);
                } else {
                    output.write(regionStartKey);
                }
            }
            if (isIndexSalted) {
                output.write(0);
            }
            int dataPosOffset = this.isDataTableSalted ? 1 : 0;
            BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
            int nIndexedColumns = this.getIndexPkColumnCount() - this.getNumViewConstants();
            int[][] dataRowKeyLocator = new int[2][nIndexedColumns];
            int maxRowKeyOffset = rowKeyPtr.getOffset() + rowKeyPtr.getLength();
            this.dataRowKeySchema.iterator(rowKeyPtr, ptr, dataPosOffset);
            if (this.viewIndexId != null) {
                output.write(this.viewIndexId);
            }
            if (this.isMultiTenant) {
                this.dataRowKeySchema.next(ptr, dataPosOffset, maxRowKeyOffset);
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                if (!this.dataRowKeySchema.getField(dataPosOffset).getDataType().isFixedWidth()) {
                    output.writeByte(SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable, ptr.getLength() == 0, this.dataRowKeySchema.getField(dataPosOffset)));
                }
                ++dataPosOffset;
            }
            for (int i = dataPosOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
                Boolean hasValue = this.dataRowKeySchema.next(ptr, i, maxRowKeyOffset);
                if (viewConstantColumnBitSet.get(i)) continue;
                int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
                if (Boolean.TRUE.equals(hasValue)) {
                    dataRowKeyLocator[0][pos] = ptr.getOffset();
                    dataRowKeyLocator[1][pos] = ptr.getLength();
                    continue;
                }
                dataRowKeyLocator[0][pos] = 0;
                dataRowKeyLocator[1][pos] = 0;
            }
            BitSet descIndexColumnBitSet = this.rowKeyMetaData.getDescIndexColumnBitSet();
            Iterator<Expression> expressionIterator = this.indexedExpressions.iterator();
            for (int i = 0; i < nIndexedColumns; ++i) {
                boolean isNullable;
                SortOrder dataSortOrder;
                PDataType dataColumnType;
                if (this.dataPkPosition[i] == -1) {
                    Expression expression = expressionIterator.next();
                    dataColumnType = expression.getDataType();
                    dataSortOrder = expression.getSortOrder();
                    isNullable = expression.isNullable();
                    expression.evaluate(new ValueGetterTuple(valueGetter, ts), ptr);
                } else {
                    ValueSchema.Field field = this.dataRowKeySchema.getField(this.dataPkPosition[i]);
                    dataColumnType = field.getDataType();
                    ptr.set(rowKeyPtr.get(), dataRowKeyLocator[0][i], dataRowKeyLocator[1][i]);
                    dataSortOrder = field.getSortOrder();
                    isNullable = field.isNullable();
                }
                boolean isDataColumnInverted = dataSortOrder != SortOrder.ASC;
                PDataType indexColumnType = IndexUtil.getIndexColumnDataType(isNullable, dataColumnType);
                boolean isBytesComparable = dataColumnType.isBytesComparableWith(indexColumnType);
                boolean isIndexColumnDesc = descIndexColumnBitSet.get(i);
                if (isBytesComparable && isDataColumnInverted == isIndexColumnDesc) {
                    output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                } else {
                    if (!isBytesComparable) {
                        indexColumnType.coerceBytes(ptr, dataColumnType, dataSortOrder, SortOrder.getDefault());
                    }
                    if (isDataColumnInverted != isIndexColumnDesc) {
                        IndexMaintainer.writeInverted(ptr.get(), ptr.getOffset(), ptr.getLength(), output);
                    } else {
                        output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                    }
                }
                if (indexColumnType.isFixedWidth()) continue;
                output.writeByte(SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable, ptr.getLength() == 0, isIndexColumnDesc ? SortOrder.DESC : SortOrder.ASC));
            }
            int minLength = length - this.maxTrailingNulls;
            byte[] indexRowKey = stream.getBuffer();
            for (length = stream.size(); length > minLength && indexRowKey[length - 1] == 0; --length) {
            }
            if (isIndexSalted) {
                byte saltByte;
                indexRowKey[0] = saltByte = SaltingUtil.getSaltingByte(indexRowKey, 1, length - 1, this.nIndexSaltBuckets);
            }
            byte[] byArray = indexRowKey.length == length ? indexRowKey : Arrays.copyOf(indexRowKey, length);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] buildDataRowKey(ImmutableBytesWritable indexRowKeyPtr, byte[][] viewConstants) {
        RowKeySchema indexRowKeySchema = this.getIndexRowKeySchema();
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedIndexRowKeyBytes);
        DataOutputStream output = new DataOutputStream(stream);
        int dataPosOffset = 0;
        int viewConstantsIndex = 0;
        try {
            int length;
            int indexPosOffset = !this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0;
            int maxRowKeyOffset = indexRowKeyPtr.getOffset() + indexRowKeyPtr.getLength();
            indexRowKeySchema.iterator(indexRowKeyPtr, ptr, indexPosOffset);
            if (this.isDataTableSalted) {
                ++dataPosOffset;
                output.write(0);
            }
            if (this.viewIndexId != null) {
                indexRowKeySchema.next(ptr, indexPosOffset++, maxRowKeyOffset);
            }
            if (this.isMultiTenant) {
                indexRowKeySchema.next(ptr, indexPosOffset, maxRowKeyOffset);
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                if (!this.dataRowKeySchema.getField(dataPosOffset).getDataType().isFixedWidth()) {
                    output.writeByte(SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable, ptr.getLength() == 0, this.dataRowKeySchema.getField(dataPosOffset)));
                }
                ++indexPosOffset;
                ++dataPosOffset;
            }
            indexPosOffset = (!this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0) + (this.isMultiTenant ? 1 : 0) + (this.viewIndexId == null ? 0 : 1);
            BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
            BitSet descIndexColumnBitSet = this.rowKeyMetaData.getDescIndexColumnBitSet();
            for (int i = dataPosOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
                if (viewConstantColumnBitSet.get(i)) {
                    output.write(viewConstants[viewConstantsIndex++]);
                } else {
                    int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
                    Boolean hasValue = indexRowKeySchema.iterator(indexRowKeyPtr, ptr, pos + indexPosOffset + 1);
                    if (Boolean.TRUE.equals(hasValue)) {
                        ValueSchema.Field dataField = this.dataRowKeySchema.getField(i);
                        ValueSchema.Field indexField = indexRowKeySchema.getField(pos + indexPosOffset);
                        PDataType indexColumnType = indexField.getDataType();
                        PDataType dataColumnType = dataField.getDataType();
                        SortOrder dataSortOrder = dataField.getSortOrder();
                        SortOrder indexSortOrder = indexField.getSortOrder();
                        boolean isDataColumnInverted = dataSortOrder != SortOrder.ASC;
                        boolean isBytesComparable = dataColumnType.isBytesComparableWith(indexColumnType);
                        if (isBytesComparable && isDataColumnInverted == descIndexColumnBitSet.get(pos)) {
                            output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                        } else {
                            if (!isBytesComparable) {
                                dataColumnType.coerceBytes(ptr, indexColumnType, indexSortOrder, SortOrder.getDefault());
                            }
                            if (descIndexColumnBitSet.get(pos) != isDataColumnInverted) {
                                IndexMaintainer.writeInverted(ptr.get(), ptr.getOffset(), ptr.getLength(), output);
                            } else {
                                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                            }
                        }
                    }
                }
                byte sepByte = SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable, ptr.getLength() == 0, this.dataRowKeySchema.getField(i));
                if (this.dataRowKeySchema.getField(i).getDataType().isFixedWidth() || i + 1 == this.dataRowKeySchema.getFieldCount() && sepByte != QueryConstants.DESC_SEPARATOR_BYTE) continue;
                output.writeByte(sepByte);
            }
            int minLength = length - this.maxTrailingNulls;
            byte[] dataRowKey = stream.getBuffer();
            for (length = stream.size(); length > minLength && dataRowKey[length - 1] == 0; --length) {
            }
            if (this.isDataTableSalted) {
                byte saltByte;
                dataRowKey[0] = saltByte = SaltingUtil.getSaltingByte(dataRowKey, 1, length - 1, this.nIndexSaltBuckets);
            }
            byte[] byArray = dataRowKey.length == length ? dataRowKey : Arrays.copyOf(dataRowKey, length);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] getViewIndexIdFromIndexRowKey(ImmutableBytesWritable indexRowKeyPtr) {
        assert (this.isLocalIndex);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr(indexRowKeyPtr.get(), indexRowKeyPtr.getOffset() + (!this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0), this.viewIndexId.length);
        return ptr.copyBytesIfNecessary();
    }

    private RowKeySchema generateIndexRowKeySchema() {
        int dataPosOffset;
        int nIndexedColumns = this.getIndexPkColumnCount() + (this.isMultiTenant ? 1 : 0) + (!this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0) + (this.viewIndexId != null ? 1 : 0) - this.getNumViewConstants();
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(nIndexedColumns);
        builder.rowKeyOrderOptimizable(this.rowKeyOrderOptimizable);
        if (!this.isLocalIndex && this.nIndexSaltBuckets > 0) {
            builder.addField(SaltingUtil.SALTING_COLUMN, false, SortOrder.ASC);
            --nIndexedColumns;
        }
        int n = dataPosOffset = this.isDataTableSalted ? 1 : 0;
        if (this.viewIndexId != null) {
            --nIndexedColumns;
            builder.addField(new PDatum(){

                @Override
                public boolean isNullable() {
                    return false;
                }

                @Override
                public PDataType getDataType() {
                    return MetaDataUtil.getViewIndexIdDataType();
                }

                @Override
                public Integer getMaxLength() {
                    return null;
                }

                @Override
                public Integer getScale() {
                    return null;
                }

                @Override
                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, false, SortOrder.getDefault());
        }
        if (this.isMultiTenant) {
            ValueSchema.Field field = this.dataRowKeySchema.getField(dataPosOffset++);
            builder.addField(field, field.isNullable(), field.getSortOrder());
            --nIndexedColumns;
        }
        ValueSchema.Field[] indexFields = new ValueSchema.Field[nIndexedColumns];
        BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        for (int i = dataPosOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
            if (viewConstantColumnBitSet.get(i)) continue;
            int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
            indexFields[pos] = this.dataRowKeySchema.getField(i);
        }
        BitSet descIndexColumnBitSet = this.rowKeyMetaData.getDescIndexColumnBitSet();
        Iterator<Expression> expressionItr = this.indexedExpressions.iterator();
        for (int i = 0; i < indexFields.length; ++i) {
            Integer scaleToBe;
            Integer maxLengthToBe;
            SortOrder sortOrderToBe;
            PDataType dataTypeToBe;
            boolean isNullableToBe;
            ValueSchema.Field indexField = indexFields[i];
            if (indexField == null) {
                Expression e = expressionItr.next();
                isNullableToBe = e.isNullable();
                dataTypeToBe = IndexUtil.getIndexColumnDataType(isNullableToBe, e.getDataType());
                sortOrderToBe = descIndexColumnBitSet.get(i) ? SortOrder.DESC : SortOrder.ASC;
                maxLengthToBe = e.getMaxLength();
                scaleToBe = e.getScale();
            } else {
                isNullableToBe = indexField.isNullable();
                dataTypeToBe = IndexUtil.getIndexColumnDataType(isNullableToBe, indexField.getDataType());
                sortOrderToBe = descIndexColumnBitSet.get(i) ? SortOrder.DESC : SortOrder.ASC;
                maxLengthToBe = indexField.getMaxLength();
                scaleToBe = indexField.getScale();
            }
            final PDataType dataType = dataTypeToBe;
            final SortOrder sortOrder = sortOrderToBe;
            final boolean isNullable = isNullableToBe;
            final Integer maxLength = maxLengthToBe;
            final Integer scale = scaleToBe;
            builder.addField(new PDatum(){

                @Override
                public boolean isNullable() {
                    return isNullable;
                }

                @Override
                public PDataType getDataType() {
                    return dataType;
                }

                @Override
                public Integer getMaxLength() {
                    return maxLength;
                }

                @Override
                public Integer getScale() {
                    return scale;
                }

                @Override
                public SortOrder getSortOrder() {
                    return sortOrder;
                }
            }, true, sortOrder);
        }
        return builder.build();
    }

    private int getNumViewConstants() {
        BitSet bitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        int num = 0;
        for (int i = 0; i < this.dataRowKeySchema.getFieldCount(); ++i) {
            if (!bitSet.get(i)) continue;
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowKeySchema getIndexRowKeySchema() {
        if (this.indexRowKeySchema != null) {
            return this.indexRowKeySchema;
        }
        IndexMaintainer indexMaintainer = this;
        synchronized (indexMaintainer) {
            if (this.indexRowKeySchema == null) {
                this.indexRowKeySchema = this.generateIndexRowKeySchema();
            }
        }
        return this.indexRowKeySchema;
    }

    public Put buildUpdateMutation(KeyValueBuilder kvBuilder, ValueGetter valueGetter, ImmutableBytesWritable dataRowKeyPtr, long ts, byte[] regionStartKey, byte[] regionEndKey) throws IOException {
        byte[] indexRowKey = this.buildRowKey(valueGetter, dataRowKeyPtr, regionStartKey, regionEndKey, ts);
        Put put = null;
        ImmutableBytesWritable latestValue = null;
        if (valueGetter == null || (latestValue = valueGetter.getLatestValue(this.dataEmptyKeyValueRef, ts)) == null || latestValue == ValueGetter.HIDDEN_BY_DELETE) {
            if (latestValue == ValueGetter.HIDDEN_BY_DELETE) {
                return null;
            }
            put = new Put(indexRowKey);
            put.add((Cell)kvBuilder.buildPut(new ImmutableBytesPtr(indexRowKey), this.getEmptyKeyValueFamily(), this.dataEmptyKeyValueRef.getQualifierWritable(), ts, this.dataEmptyKeyValueRef.getQualifierWritable()));
            put.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
        }
        ImmutableBytesPtr rowKey = new ImmutableBytesPtr(indexRowKey);
        if (this.immutableStorageScheme != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
            HashMap familyToColListMap = Maps.newHashMap();
            for (ColumnReference columnReference : this.getCoveredColumns()) {
                ColumnReference indexColRef = this.coveredColumnsMap.get(columnReference);
                ImmutableBytesPtr cf = new ImmutableBytesPtr(indexColRef.getFamily());
                if (!familyToColListMap.containsKey((Object)cf)) {
                    familyToColListMap.put(cf, Lists.newArrayList());
                }
                ((List)familyToColListMap.get((Object)cf)).add(Pair.newPair((Object)indexColRef, (Object)columnReference));
            }
            for (Map.Entry entry : familyToColListMap.entrySet()) {
                Object colRefPair22;
                byte[] columnFamily = ((ImmutableBytesPtr)((Object)entry.getKey())).copyBytesIfNecessary();
                List colRefPairs = (List)entry.getValue();
                int maxEncodedColumnQualifier = Integer.MIN_VALUE;
                for (Object colRefPair22 : colRefPairs) {
                    maxEncodedColumnQualifier = Math.max(maxEncodedColumnQualifier, this.encodingScheme.decode(((ColumnReference)colRefPair22.getFirst()).getQualifier()));
                }
                Expression[] colValues = EncodedColumnsUtil.createColumnExpressionArray(maxEncodedColumnQualifier);
                colRefPair22 = colRefPairs.iterator();
                while (colRefPair22.hasNext()) {
                    Pair colRefPair3 = (Pair)colRefPair22.next();
                    ColumnReference indexColRef = (ColumnReference)colRefPair3.getFirst();
                    ColumnReference dataColRef = (ColumnReference)colRefPair3.getSecond();
                    SingleCellColumnExpression expression = new SingleCellColumnExpression(new PDatum(){

                        @Override
                        public boolean isNullable() {
                            return false;
                        }

                        @Override
                        public SortOrder getSortOrder() {
                            return null;
                        }

                        @Override
                        public Integer getScale() {
                            return null;
                        }

                        @Override
                        public Integer getMaxLength() {
                            return null;
                        }

                        @Override
                        public PDataType getDataType() {
                            return null;
                        }
                    }, dataColRef.getFamily(), dataColRef.getQualifier(), this.encodingScheme);
                    ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                    expression.evaluate(new ValueGetterTuple(valueGetter, ts), ptr);
                    byte[] value = ptr.copyBytesIfNecessary();
                    if (value == null) continue;
                    int indexArrayPos = this.encodingScheme.decode(indexColRef.getQualifier()) - 11 + 1;
                    colValues[indexArrayPos] = new LiteralExpression(value);
                }
                List<Expression> children = Arrays.asList(colValues);
                SingleCellConstructorExpression singleCellConstructorExpression = new SingleCellConstructorExpression(this.immutableStorageScheme, children);
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                singleCellConstructorExpression.evaluate(new BaseTuple(){}, ptr);
                if (put == null) {
                    put = new Put(indexRowKey);
                    put.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
                }
                ImmutableBytesPtr colFamilyPtr = new ImmutableBytesPtr(columnFamily);
                put.add((Cell)kvBuilder.buildPut(rowKey, colFamilyPtr, QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES_PTR, ts, ptr));
            }
        } else {
            for (ColumnReference ref : this.getCoveredColumns()) {
                ColumnReference columnReference = this.coveredColumnsMap.get(ref);
                ImmutableBytesPtr cq = columnReference.getQualifierWritable();
                ImmutableBytesPtr cf = columnReference.getFamilyWritable();
                ImmutableBytesWritable value = valueGetter.getLatestValue(ref, ts);
                if (value == null || value == ValueGetter.HIDDEN_BY_DELETE) continue;
                if (put == null) {
                    put = new Put(indexRowKey);
                    put.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
                }
                put.add((Cell)kvBuilder.buildPut(rowKey, cf, cq, ts, value));
            }
        }
        return put;
    }

    private DeleteType getDeleteTypeOrNull(Collection<KeyValue> pendingUpdates) {
        int nDeleteCF = 0;
        int nDeleteVersionCF = 0;
        for (KeyValue kv : pendingUpdates) {
            if (kv.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode()) {
                ++nDeleteVersionCF;
                continue;
            }
            if (kv.getTypeByte() != KeyValue.Type.DeleteFamily.getCode() && (!CellUtil.matchingQualifier((Cell)kv, (byte[])TransactionFactory.getTransactionFactory().getTransactionContext().getFamilyDeleteMarker()) || !CellUtil.matchingValue((Cell)kv, (byte[])HConstants.EMPTY_BYTE_ARRAY))) continue;
            ++nDeleteCF;
        }
        DeleteType deleteType = null;
        if (nDeleteVersionCF > 0 && nDeleteVersionCF >= this.nDataCFs) {
            deleteType = DeleteType.SINGLE_VERSION;
        } else {
            int nDelete = nDeleteCF + nDeleteVersionCF;
            if (nDelete > 0 && nDelete >= this.nDataCFs) {
                deleteType = DeleteType.ALL_VERSIONS;
            }
        }
        return deleteType;
    }

    public boolean isRowDeleted(Collection<KeyValue> pendingUpdates) {
        return this.getDeleteTypeOrNull(pendingUpdates) != null;
    }

    private boolean hasIndexedColumnChanged(ValueGetter oldState, Collection<KeyValue> pendingUpdates, long ts) throws IOException {
        if (pendingUpdates.isEmpty()) {
            return false;
        }
        HashMap newState = Maps.newHashMapWithExpectedSize((int)pendingUpdates.size());
        for (Cell cell : pendingUpdates) {
            newState.put(new ColumnReference(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell)), cell);
        }
        for (ColumnReference columnReference : this.indexedColumns) {
            boolean oldValueSetAsNull;
            Cell newValue = (Cell)newState.get(columnReference);
            if (newValue == null) continue;
            ImmutableBytesWritable oldValue = oldState.getLatestValue(columnReference, ts);
            boolean newValueSetAsNull = newValue.getTypeByte() == KeyValue.Type.DeleteColumn.getCode() || newValue.getTypeByte() == KeyValue.Type.Delete.getCode() || CellUtil.matchingValue((Cell)newValue, (byte[])HConstants.EMPTY_BYTE_ARRAY);
            boolean bl = oldValueSetAsNull = oldValue == null || oldValue.getLength() == 0;
            if (newValueSetAsNull && oldValueSetAsNull) continue;
            if (oldValueSetAsNull || newValueSetAsNull) {
                return true;
            }
            if (Bytes.compareTo((byte[])oldValue.get(), (int)oldValue.getOffset(), (int)oldValue.getLength(), (byte[])newValue.getValueArray(), (int)newValue.getValueOffset(), (int)newValue.getValueLength()) == 0) continue;
            return true;
        }
        return false;
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ImmutableBytesWritable dataRowKeyPtr, long ts) throws IOException {
        return this.buildDeleteMutation(kvBuilder, null, dataRowKeyPtr, Collections.emptyList(), ts, null, null);
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ValueGetter oldState, ImmutableBytesWritable dataRowKeyPtr, Collection<KeyValue> pendingUpdates, long ts, byte[] regionStartKey, byte[] regionEndKey) throws IOException {
        byte[] indexRowKey = this.buildRowKey(oldState, dataRowKeyPtr, regionStartKey, regionEndKey, ts);
        DeleteType deleteType = null;
        if (oldState == null || (deleteType = this.getDeleteTypeOrNull(pendingUpdates)) != null || this.hasIndexedColumnChanged(oldState, pendingUpdates, ts)) {
            byte[] emptyCF = this.emptyKeyValueCFPtr.copyBytesIfNecessary();
            Delete delete = new Delete(indexRowKey);
            for (ColumnReference columnReference : this.getCoveredColumns()) {
                ColumnReference indexColumn = this.coveredColumnsMap.get(columnReference);
                if (deleteType == DeleteType.SINGLE_VERSION) {
                    delete.deleteFamilyVersion(indexColumn.getFamily(), ts);
                    continue;
                }
                delete.deleteFamily(indexColumn.getFamily(), ts);
            }
            if (deleteType == DeleteType.SINGLE_VERSION) {
                delete.deleteFamilyVersion(emptyCF, ts);
            } else {
                delete.deleteFamily(emptyCF, ts);
            }
            delete.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            return delete;
        }
        Delete delete = null;
        Set<ColumnReference> dataTableColRefs = this.coveredColumnsMap.keySet();
        for (Cell cell : pendingUpdates) {
            ColumnReference ref;
            if (cell.getTypeByte() == KeyValue.Type.Put.getCode() || !dataTableColRefs.contains(ref = new ColumnReference(cell.getFamily(), cell.getQualifier()))) continue;
            if (delete == null) {
                delete = new Delete(indexRowKey);
                delete.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            }
            ColumnReference indexColumn = this.coveredColumnsMap.get(ref);
            if (cell.getTypeByte() == KeyValue.Type.Delete.getCode()) {
                delete.deleteColumn(indexColumn.getFamily(), indexColumn.getQualifier(), ts);
                continue;
            }
            delete.deleteColumns(indexColumn.getFamily(), indexColumn.getQualifier(), ts);
        }
        return delete;
    }

    public byte[] getIndexTableName() {
        return this.indexTableName;
    }

    public Set<ColumnReference> getCoveredColumns() {
        return this.coveredColumnsMap.keySet();
    }

    public Set<ColumnReference> getAllColumns() {
        return this.allColumns;
    }

    public ImmutableBytesPtr getEmptyKeyValueFamily() {
        return this.emptyKeyValueCFPtr;
    }

    @Deprecated
    public void readFields(DataInput input) throws IOException {
        int i;
        boolean hasViewIndexId;
        int encodedIndexSaltBucketsAndMultiTenant = WritableUtils.readVInt((DataInput)input);
        this.isMultiTenant = encodedIndexSaltBucketsAndMultiTenant < 0;
        this.nIndexSaltBuckets = Math.abs(encodedIndexSaltBucketsAndMultiTenant) - 1;
        int encodedIndexedColumnsAndViewId = WritableUtils.readVInt((DataInput)input);
        boolean bl = hasViewIndexId = encodedIndexedColumnsAndViewId < 0;
        if (hasViewIndexId) {
            this.viewIndexId = new byte[MetaDataUtil.getViewIndexIdDataType().getByteSize().intValue()];
            input.readFully(this.viewIndexId);
        }
        int nIndexedColumns = Math.abs(encodedIndexedColumnsAndViewId) - 1;
        this.indexedColumns = Sets.newLinkedHashSetWithExpectedSize((int)nIndexedColumns);
        for (i = 0; i < nIndexedColumns; ++i) {
            byte[] cf = Bytes.readByteArray((DataInput)input);
            byte[] cq = Bytes.readByteArray((DataInput)input);
            this.indexedColumns.add(new ColumnReference(cf, cq));
        }
        this.indexedColumnTypes = Lists.newArrayListWithExpectedSize((int)nIndexedColumns);
        for (i = 0; i < nIndexedColumns; ++i) {
            PDataType type = PDataType.values()[WritableUtils.readVInt((DataInput)input)];
            this.indexedColumnTypes.add(type);
        }
        int encodedCoveredolumnsAndLocalIndex = WritableUtils.readVInt((DataInput)input);
        this.isLocalIndex = encodedCoveredolumnsAndLocalIndex < 0;
        int nCoveredColumns = Math.abs(encodedCoveredolumnsAndLocalIndex) - 1;
        this.coveredColumnsMap = Maps.newHashMapWithExpectedSize((int)nCoveredColumns);
        for (int i2 = 0; i2 < nCoveredColumns; ++i2) {
            byte[] dataTableCf = Bytes.readByteArray((DataInput)input);
            byte[] dataTableCq = Bytes.readByteArray((DataInput)input);
            ColumnReference dataTableRef = new ColumnReference(dataTableCf, dataTableCq);
            byte[] indexTableCf = this.isLocalIndex ? IndexUtil.getLocalIndexColumnFamily(dataTableCf) : dataTableCf;
            byte[] indexTableCq = IndexUtil.getIndexColumnName(dataTableCf, dataTableCq);
            ColumnReference indexTableRef = new ColumnReference(indexTableCf, indexTableCq);
            this.coveredColumnsMap.put(dataTableRef, indexTableRef);
        }
        int len = WritableUtils.readVInt((DataInput)input);
        if (len < 0) {
            this.rowKeyOrderOptimizable = false;
            len *= -1;
        } else {
            this.rowKeyOrderOptimizable = true;
        }
        this.indexTableName = new byte[len];
        input.readFully(this.indexTableName, 0, len);
        this.dataEmptyKeyValueCF = Bytes.readByteArray((DataInput)input);
        len = WritableUtils.readVInt((DataInput)input);
        boolean isNewClient = false;
        if (len < 0) {
            isNewClient = true;
            len = Math.abs(len);
        }
        byte[] emptyKeyValueCF = new byte[len];
        input.readFully(emptyKeyValueCF, 0, len);
        this.emptyKeyValueCFPtr = new ImmutableBytesPtr(emptyKeyValueCF);
        if (isNewClient) {
            int numIndexedExpressions = WritableUtils.readVInt((DataInput)input);
            this.indexedExpressions = Lists.newArrayListWithExpectedSize((int)numIndexedExpressions);
            for (int i3 = 0; i3 < numIndexedExpressions; ++i3) {
                Expression expression = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
                expression.readFields(input);
                this.indexedExpressions.add(expression);
            }
        } else {
            this.indexedExpressions = Lists.newArrayListWithExpectedSize((int)this.indexedColumns.size());
            Iterator<ColumnReference> colReferenceIter = this.indexedColumns.iterator();
            Iterator<PDataType> dataTypeIter = this.indexedColumnTypes.iterator();
            while (colReferenceIter.hasNext()) {
                ColumnReference colRef = colReferenceIter.next();
                final PDataType dataType = dataTypeIter.next();
                this.indexedExpressions.add(new KeyValueColumnExpression(new PDatum(){

                    @Override
                    public boolean isNullable() {
                        return true;
                    }

                    @Override
                    public SortOrder getSortOrder() {
                        return SortOrder.getDefault();
                    }

                    @Override
                    public Integer getScale() {
                        return null;
                    }

                    @Override
                    public Integer getMaxLength() {
                        return null;
                    }

                    @Override
                    public PDataType getDataType() {
                        return dataType;
                    }
                }, colRef.getFamily(), colRef.getQualifier()));
            }
        }
        this.rowKeyMetaData = this.newRowKeyMetaData();
        this.rowKeyMetaData.readFields(input);
        int nDataCFs = WritableUtils.readVInt((DataInput)input);
        this.indexWALDisabled = nDataCFs < 0;
        this.nDataCFs = Math.abs(nDataCFs) - 1;
        int encodedEstimatedIndexRowKeyBytesAndImmutableRows = WritableUtils.readVInt((DataInput)input);
        this.immutableRows = encodedEstimatedIndexRowKeyBytesAndImmutableRows < 0;
        this.estimatedIndexRowKeyBytes = Math.abs(encodedEstimatedIndexRowKeyBytesAndImmutableRows);
        this.immutableStorageScheme = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
        this.encodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
        this.initCachedState();
    }

    public static IndexMaintainer fromProto(ServerCachingProtos.IndexMaintainer proto, RowKeySchema dataTableRowKeySchema, boolean isDataTableSalted) throws IOException {
        IndexMaintainer maintainer = new IndexMaintainer(dataTableRowKeySchema, isDataTableSalted);
        maintainer.nIndexSaltBuckets = proto.getSaltBuckets();
        maintainer.isMultiTenant = proto.getIsMultiTenant();
        maintainer.viewIndexId = proto.hasViewIndexId() ? proto.getViewIndexId().toByteArray() : null;
        List<ServerCachingProtos.ColumnReference> indexedColumnsList = proto.getIndexedColumnsList();
        maintainer.indexedColumns = new HashSet<ColumnReference>(indexedColumnsList.size());
        for (ServerCachingProtos.ColumnReference columnReference : indexedColumnsList) {
            maintainer.indexedColumns.add(new ColumnReference(columnReference.getFamily().toByteArray(), columnReference.getQualifier().toByteArray()));
        }
        List<Integer> indexedColumnTypes = proto.getIndexedColumnTypeOrdinalList();
        maintainer.indexedColumnTypes = new ArrayList<PDataType>(indexedColumnTypes.size());
        for (Integer typeOrdinal : indexedColumnTypes) {
            maintainer.indexedColumnTypes.add(PDataType.values()[typeOrdinal]);
        }
        maintainer.indexTableName = proto.getIndexTableName().toByteArray();
        maintainer.rowKeyOrderOptimizable = proto.getRowKeyOrderOptimizable();
        maintainer.dataEmptyKeyValueCF = proto.getDataTableEmptyKeyValueColFamily().toByteArray();
        ServerCachingProtos.ImmutableBytesWritable immutableBytesWritable = proto.getEmptyKeyValueColFamily();
        maintainer.emptyKeyValueCFPtr = new ImmutableBytesPtr(immutableBytesWritable.getByteArray().toByteArray(), immutableBytesWritable.getOffset(), immutableBytesWritable.getLength());
        maintainer.indexedExpressions = new ArrayList<Expression>();
        ByteArrayInputStream stream = new ByteArrayInputStream(proto.getIndexedExpressions().toByteArray());
        Object object = null;
        try {
            DataInputStream input2 = new DataInputStream(stream);
            while (stream.available() > 0) {
                int expressionOrdinal = WritableUtils.readVInt((DataInput)input2);
                Expression expression = ExpressionType.values()[expressionOrdinal].newInstance();
                expression.readFields(input2);
                maintainer.indexedExpressions.add(expression);
            }
        }
        catch (Throwable input2) {
            object = input2;
            throw input2;
        }
        finally {
            if (stream != null) {
                if (object != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable input2) {
                        ((Throwable)object).addSuppressed(input2);
                    }
                } else {
                    stream.close();
                }
            }
        }
        maintainer.rowKeyMetaData = IndexMaintainer.newRowKeyMetaData(maintainer, dataTableRowKeySchema, maintainer.indexedExpressions.size(), isDataTableSalted, maintainer.isMultiTenant);
        stream = new ByteArrayInputStream(proto.getRowKeyMetadata().toByteArray());
        object = null;
        try {
            DataInputStream input3 = new DataInputStream(stream);
            maintainer.rowKeyMetaData.readFields(input3);
        }
        catch (Throwable input3) {
            object = input3;
            throw input3;
        }
        finally {
            if (stream != null) {
                if (object != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable input3) {
                        ((Throwable)object).addSuppressed(input3);
                    }
                } else {
                    stream.close();
                }
            }
        }
        maintainer.nDataCFs = proto.getNumDataTableColFamilies();
        maintainer.indexWALDisabled = proto.getIndexWalDisabled();
        maintainer.estimatedIndexRowKeyBytes = proto.getIndexRowKeyByteSize();
        maintainer.immutableRows = proto.getImmutable();
        List<ServerCachingProtos.ColumnInfo> indexedColumnInfoList = proto.getIndexedColumnInfoList();
        maintainer.indexedColumnsInfo = Sets.newHashSet();
        for (ServerCachingProtos.ColumnInfo info : indexedColumnInfoList) {
            maintainer.indexedColumnsInfo.add((Pair<String, String>)new Pair((Object)info.getFamilyName(), (Object)info.getColumnName()));
        }
        maintainer.encodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue((byte)proto.getEncodingScheme());
        maintainer.immutableStorageScheme = PTable.ImmutableStorageScheme.fromSerializedValue((byte)proto.getImmutableStorageScheme());
        maintainer.isLocalIndex = proto.getIsLocalIndex();
        List<ServerCachingProtos.ColumnReference> dataTableColRefsForCoveredColumnsList = proto.getDataTableColRefForCoveredColumnsList();
        List<ServerCachingProtos.ColumnReference> indexTableColRefsForCoveredColumnsList = proto.getIndexTableColRefForCoveredColumnsList();
        maintainer.coveredColumnsMap = Maps.newHashMapWithExpectedSize((int)dataTableColRefsForCoveredColumnsList.size());
        boolean encodedColumnNames = maintainer.encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
        Iterator<ServerCachingProtos.ColumnReference> indexTableColRefItr = indexTableColRefsForCoveredColumnsList.iterator();
        for (ServerCachingProtos.ColumnReference colRefFromProto : dataTableColRefsForCoveredColumnsList) {
            ColumnReference indexTableColRef;
            ColumnReference dataTableColRef = new ColumnReference(colRefFromProto.getFamily().toByteArray(), colRefFromProto.getQualifier().toByteArray());
            if (encodedColumnNames) {
                ServerCachingProtos.ColumnReference fromProto = indexTableColRefItr.next();
                indexTableColRef = new ColumnReference(fromProto.getFamily().toByteArray(), fromProto.getQualifier().toByteArray());
            } else {
                byte[] cq = IndexUtil.getIndexColumnName(dataTableColRef.getFamily(), dataTableColRef.getQualifier());
                byte[] cf = maintainer.isLocalIndex ? IndexUtil.getLocalIndexColumnFamily(dataTableColRef.getFamily()) : dataTableColRef.getFamily();
                indexTableColRef = new ColumnReference(cf, cq);
            }
            maintainer.coveredColumnsMap.put(dataTableColRef, indexTableColRef);
        }
        maintainer.initCachedState();
        return maintainer;
    }

    @Deprecated
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt((DataOutput)output, (int)((this.nIndexSaltBuckets + 1) * (this.isMultiTenant ? -1 : 1)));
        WritableUtils.writeVInt((DataOutput)output, (int)((this.indexedColumns.size() + 1) * (this.viewIndexId != null ? -1 : 1)));
        if (this.viewIndexId != null) {
            output.write(this.viewIndexId);
        }
        for (ColumnReference ref : this.indexedColumns) {
            Bytes.writeByteArray((DataOutput)output, (byte[])ref.getFamily());
            Bytes.writeByteArray((DataOutput)output, (byte[])ref.getQualifier());
        }
        for (int i = 0; i < this.indexedColumnTypes.size(); ++i) {
            PDataType type = this.indexedColumnTypes.get(i);
            WritableUtils.writeVInt((DataOutput)output, (int)type.ordinal());
        }
        WritableUtils.writeVInt((DataOutput)output, (int)((this.coveredColumnsMap.size() + 1) * (this.isLocalIndex ? -1 : 1)));
        for (ColumnReference ref : this.coveredColumnsMap.keySet()) {
            Bytes.writeByteArray((DataOutput)output, (byte[])ref.getFamily());
            Bytes.writeByteArray((DataOutput)output, (byte[])ref.getQualifier());
        }
        WritableUtils.writeVInt((DataOutput)output, (int)(this.indexTableName.length * (this.rowKeyOrderOptimizable ? 1 : -1)));
        output.write(this.indexTableName, 0, this.indexTableName.length);
        Bytes.writeByteArray((DataOutput)output, (byte[])this.dataEmptyKeyValueCF);
        WritableUtils.writeVInt((DataOutput)output, (int)(-this.emptyKeyValueCFPtr.getLength()));
        output.write(this.emptyKeyValueCFPtr.get(), this.emptyKeyValueCFPtr.getOffset(), this.emptyKeyValueCFPtr.getLength());
        WritableUtils.writeVInt((DataOutput)output, (int)this.indexedExpressions.size());
        for (Expression expression : this.indexedExpressions) {
            WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(expression).ordinal());
            expression.write(output);
        }
        this.rowKeyMetaData.write(output);
        WritableUtils.writeVInt((DataOutput)output, (int)((this.nDataCFs + 1) * (this.indexWALDisabled ? -1 : 1)));
        WritableUtils.writeVInt((DataOutput)output, (int)(this.estimatedIndexRowKeyBytes * (this.immutableRows ? -1 : 1)));
    }

    public static ServerCachingProtos.IndexMaintainer toProto(IndexMaintainer maintainer) throws IOException {
        Object cRefBuilder;
        ServerCachingProtos.IndexMaintainer.Builder builder = ServerCachingProtos.IndexMaintainer.newBuilder();
        builder.setSaltBuckets(maintainer.nIndexSaltBuckets);
        builder.setIsMultiTenant(maintainer.isMultiTenant);
        if (maintainer.viewIndexId != null) {
            builder.setViewIndexId(ByteStringer.wrap((byte[])maintainer.viewIndexId));
        }
        for (ColumnReference columnReference : maintainer.indexedColumns) {
            cRefBuilder = ServerCachingProtos.ColumnReference.newBuilder();
            ((ServerCachingProtos.ColumnReference.Builder)cRefBuilder).setFamily(ByteStringer.wrap((byte[])columnReference.getFamily()));
            ((ServerCachingProtos.ColumnReference.Builder)cRefBuilder).setQualifier(ByteStringer.wrap((byte[])columnReference.getQualifier()));
            builder.addIndexedColumns(((ServerCachingProtos.ColumnReference.Builder)cRefBuilder).build());
        }
        for (PDataType pDataType : maintainer.indexedColumnTypes) {
            builder.addIndexedColumnTypeOrdinal(pDataType.ordinal());
        }
        for (Map.Entry entry : maintainer.coveredColumnsMap.entrySet()) {
            cRefBuilder = ServerCachingProtos.ColumnReference.newBuilder();
            ColumnReference dataTableColRef = (ColumnReference)entry.getKey();
            ((ServerCachingProtos.ColumnReference.Builder)cRefBuilder).setFamily(ByteStringer.wrap((byte[])dataTableColRef.getFamily()));
            ((ServerCachingProtos.ColumnReference.Builder)cRefBuilder).setQualifier(ByteStringer.wrap((byte[])dataTableColRef.getQualifier()));
            builder.addDataTableColRefForCoveredColumns(((ServerCachingProtos.ColumnReference.Builder)cRefBuilder).build());
            if (maintainer.encodingScheme == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) continue;
            ColumnReference indexTableColRef = (ColumnReference)entry.getValue();
            cRefBuilder = ServerCachingProtos.ColumnReference.newBuilder();
            ((ServerCachingProtos.ColumnReference.Builder)cRefBuilder).setFamily(ByteStringer.wrap((byte[])indexTableColRef.getFamily()));
            ((ServerCachingProtos.ColumnReference.Builder)cRefBuilder).setQualifier(ByteStringer.wrap((byte[])indexTableColRef.getQualifier()));
            builder.addIndexTableColRefForCoveredColumns(((ServerCachingProtos.ColumnReference.Builder)cRefBuilder).build());
        }
        builder.setIsLocalIndex(maintainer.isLocalIndex);
        builder.setIndexTableName(ByteStringer.wrap((byte[])maintainer.indexTableName));
        builder.setRowKeyOrderOptimizable(maintainer.rowKeyOrderOptimizable);
        builder.setDataTableEmptyKeyValueColFamily(ByteStringer.wrap((byte[])maintainer.dataEmptyKeyValueCF));
        ServerCachingProtos.ImmutableBytesWritable.Builder ibwBuilder = ServerCachingProtos.ImmutableBytesWritable.newBuilder();
        ibwBuilder.setByteArray(ByteStringer.wrap((byte[])maintainer.emptyKeyValueCFPtr.get()));
        ibwBuilder.setLength(maintainer.emptyKeyValueCFPtr.getLength());
        ibwBuilder.setOffset(maintainer.emptyKeyValueCFPtr.getOffset());
        builder.setEmptyKeyValueColFamily(ibwBuilder.build());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        cRefBuilder = null;
        try {
            DataOutputStream output2 = new DataOutputStream(byteArrayOutputStream);
            for (Expression expression : maintainer.indexedExpressions) {
                WritableUtils.writeVInt((DataOutput)output2, (int)ExpressionType.valueOf(expression).ordinal());
                expression.write(output2);
            }
            builder.setIndexedExpressions(ByteStringer.wrap((byte[])byteArrayOutputStream.toByteArray()));
        }
        catch (Throwable output2) {
            cRefBuilder = output2;
            throw output2;
        }
        finally {
            if (byteArrayOutputStream != null) {
                if (cRefBuilder != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Throwable output2) {
                        ((Throwable)cRefBuilder).addSuppressed(output2);
                    }
                } else {
                    byteArrayOutputStream.close();
                }
            }
        }
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        cRefBuilder = null;
        try {
            DataOutputStream output3 = new DataOutputStream(byteArrayOutputStream2);
            maintainer.rowKeyMetaData.write(output3);
            builder.setRowKeyMetadata(ByteStringer.wrap((byte[])byteArrayOutputStream2.toByteArray()));
        }
        catch (Throwable output3) {
            cRefBuilder = output3;
            throw output3;
        }
        finally {
            if (byteArrayOutputStream2 != null) {
                if (cRefBuilder != null) {
                    try {
                        byteArrayOutputStream2.close();
                    }
                    catch (Throwable output3) {
                        ((Throwable)cRefBuilder).addSuppressed(output3);
                    }
                } else {
                    byteArrayOutputStream2.close();
                }
            }
        }
        builder.setNumDataTableColFamilies(maintainer.nDataCFs);
        builder.setIndexWalDisabled(maintainer.indexWALDisabled);
        builder.setIndexRowKeyByteSize(maintainer.estimatedIndexRowKeyBytes);
        builder.setImmutable(maintainer.immutableRows);
        for (Pair<String, String> p : maintainer.indexedColumnsInfo) {
            ServerCachingProtos.ColumnInfo.Builder ciBuilder = ServerCachingProtos.ColumnInfo.newBuilder();
            if (p.getFirst() != null) {
                ciBuilder.setFamilyName((String)p.getFirst());
            }
            ciBuilder.setColumnName((String)p.getSecond());
            builder.addIndexedColumnInfo(ciBuilder.build());
        }
        builder.setEncodingScheme(maintainer.encodingScheme.getSerializedMetadataValue());
        builder.setImmutableStorageScheme(maintainer.immutableStorageScheme.getSerializedMetadataValue());
        return builder.build();
    }

    public int getEstimatedByteSize() {
        int size = WritableUtils.getVIntSize((long)this.nIndexSaltBuckets);
        size += WritableUtils.getVIntSize((long)this.estimatedIndexRowKeyBytes);
        size += WritableUtils.getVIntSize((long)this.indexedColumns.size());
        size += this.viewIndexId == null ? 0 : this.viewIndexId.length;
        for (ColumnReference ref : this.indexedColumns) {
            size += WritableUtils.getVIntSize((long)ref.getFamily().length);
            size += ref.getFamily().length;
            size += WritableUtils.getVIntSize((long)ref.getQualifier().length);
            size += ref.getQualifier().length;
        }
        for (int i = 0; i < this.indexedColumnTypes.size(); ++i) {
            PDataType type = this.indexedColumnTypes.get(i);
            size += WritableUtils.getVIntSize((long)type.ordinal());
        }
        Set<ColumnReference> dataTableColRefs = this.coveredColumnsMap.keySet();
        size += WritableUtils.getVIntSize((long)dataTableColRefs.size());
        for (ColumnReference ref : dataTableColRefs) {
            size += WritableUtils.getVIntSize((long)ref.getFamilyWritable().getSize());
            size += ref.getFamily().length;
            size += WritableUtils.getVIntSize((long)ref.getQualifierWritable().getSize());
            size += ref.getQualifier().length;
        }
        size += this.indexTableName.length + WritableUtils.getVIntSize((long)this.indexTableName.length);
        size += this.rowKeyMetaData.getByteSize();
        size += this.dataEmptyKeyValueCF.length + WritableUtils.getVIntSize((long)this.dataEmptyKeyValueCF.length);
        size += this.emptyKeyValueCFPtr.getLength() + WritableUtils.getVIntSize((long)this.emptyKeyValueCFPtr.getLength());
        size += WritableUtils.getVIntSize((long)(this.nDataCFs + 1));
        size += WritableUtils.getVIntSize((long)this.indexedExpressions.size());
        for (Expression expression : this.indexedExpressions) {
            size += WritableUtils.getVIntSize((long)ExpressionType.valueOf(expression).ordinal());
        }
        return size += this.estimatedExpressionSize;
    }

    private int estimateIndexRowKeyByteSize(int indexColByteSize) {
        int estimatedIndexRowKeyBytes = indexColByteSize + this.dataRowKeySchema.getEstimatedValueLength() + (this.nIndexSaltBuckets == 0 || this.isLocalIndex || this.isDataTableSalted ? 0 : 1);
        return estimatedIndexRowKeyBytes;
    }

    private void initCachedState() {
        int indexPkPos;
        byte[] emptyKvQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(this.encodingScheme).getFirst();
        this.dataEmptyKeyValueRef = new ColumnReference(this.emptyKeyValueCFPtr.copyBytesIfNecessary(), emptyKvQualifier);
        this.allColumns = Sets.newLinkedHashSetWithExpectedSize((int)(this.indexedExpressions.size() + this.coveredColumnsMap.size()));
        this.indexedColumns = Sets.newLinkedHashSetWithExpectedSize((int)this.indexedExpressions.size());
        for (Expression expression : this.indexedExpressions) {
            KeyValueExpressionVisitor visitor = new KeyValueExpressionVisitor(){

                @Override
                public Void visit(KeyValueColumnExpression expression) {
                    if (IndexMaintainer.this.indexedColumns.add(new ColumnReference(expression.getColumnFamily(), expression.getColumnQualifier()))) {
                        IndexMaintainer.this.indexedColumnTypes.add(expression.getDataType());
                    }
                    return null;
                }
            };
            expression.accept(visitor);
        }
        this.allColumns.addAll(this.indexedColumns);
        for (ColumnReference colRef : this.coveredColumnsMap.keySet()) {
            if (this.immutableStorageScheme == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                this.allColumns.add(colRef);
                continue;
            }
            this.allColumns.add(new ColumnReference(colRef.getFamily(), QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES));
        }
        int dataPkOffset = (this.isDataTableSalted ? 1 : 0) + (this.isMultiTenant ? 1 : 0);
        int nIndexPkColumns = this.getIndexPkColumnCount();
        this.dataPkPosition = new int[nIndexPkColumns];
        Arrays.fill(this.dataPkPosition, -1);
        int numViewConstantColumns = 0;
        BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        for (int i = dataPkOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
            if (!viewConstantColumnBitSet.get(i)) {
                int indexPkPosition = this.rowKeyMetaData.getIndexPkPosition(i - dataPkOffset);
                this.dataPkPosition[indexPkPosition] = i;
                continue;
            }
            ++numViewConstantColumns;
        }
        int expressionsPos = this.indexedExpressions.size();
        for (indexPkPos = nIndexPkColumns - numViewConstantColumns - 1; indexPkPos >= 0; --indexPkPos) {
            PDataType dataType;
            boolean isDataNullable;
            int dataPkPos = this.dataPkPosition[indexPkPos];
            if (dataPkPos == -1) {
                isDataNullable = true;
                dataType = this.indexedExpressions.get(--expressionsPos).getDataType();
            } else {
                ValueSchema.Field dataField = this.dataRowKeySchema.getField(dataPkPos);
                dataType = dataField.getDataType();
                isDataNullable = dataField.isNullable();
            }
            PDataType indexDataType = IndexUtil.getIndexColumnDataType(isDataNullable, dataType);
            if (indexDataType.isFixedWidth()) break;
        }
        this.maxTrailingNulls = nIndexPkColumns - indexPkPos - 1;
    }

    private int getIndexPkColumnCount() {
        return IndexMaintainer.getIndexPkColumnCount(this.dataRowKeySchema, this.indexedExpressions.size(), this.isDataTableSalted, this.isMultiTenant);
    }

    private static int getIndexPkColumnCount(RowKeySchema rowKeySchema, int numIndexExpressions, boolean isDataTableSalted, boolean isMultiTenant) {
        return rowKeySchema.getFieldCount() + numIndexExpressions - (isDataTableSalted ? 1 : 0) - (isMultiTenant ? 1 : 0);
    }

    private RowKeyMetaData newRowKeyMetaData() {
        return this.getIndexPkColumnCount() < 255 ? new ByteSizeRowKeyMetaData() : new IntSizedRowKeyMetaData();
    }

    private static RowKeyMetaData newRowKeyMetaData(IndexMaintainer i, RowKeySchema rowKeySchema, int numIndexExpressions, boolean isDataTableSalted, boolean isMultiTenant) {
        RowKeyMetaData rowKeyMetaData;
        int indexPkColumnCount = IndexMaintainer.getIndexPkColumnCount(rowKeySchema, numIndexExpressions, isDataTableSalted, isMultiTenant);
        if (indexPkColumnCount < 255) {
            IndexMaintainer indexMaintainer = i;
            indexMaintainer.getClass();
            rowKeyMetaData = indexMaintainer.new ByteSizeRowKeyMetaData();
        } else {
            IndexMaintainer indexMaintainer = i;
            indexMaintainer.getClass();
            rowKeyMetaData = indexMaintainer.new IntSizedRowKeyMetaData();
        }
        return rowKeyMetaData;
    }

    private RowKeyMetaData newRowKeyMetaData(int capacity) {
        return capacity < 255 ? new ByteSizeRowKeyMetaData(capacity) : new IntSizedRowKeyMetaData(capacity);
    }

    private static void writeInverted(byte[] buf, int offset, int length, DataOutput output) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            byte b = SortOrder.invert(buf[i]);
            output.write(b);
        }
    }

    @Override
    public Iterator<ColumnReference> iterator() {
        return this.allColumns.iterator();
    }

    public ValueGetter createGetterFromKeyValues(final byte[] rowKey, Collection<? extends Cell> pendingUpdates) {
        final HashMap valueMap = Maps.newHashMapWithExpectedSize((int)pendingUpdates.size());
        for (Cell cell : pendingUpdates) {
            ImmutableBytesPtr value = new ImmutableBytesPtr(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            valueMap.put(new ColumnReference(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()), value);
        }
        return new ValueGetter(){

            @Override
            public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) {
                if (ref.equals(IndexMaintainer.this.dataEmptyKeyValueRef)) {
                    return null;
                }
                return (ImmutableBytesWritable)valueMap.get(ref);
            }

            @Override
            public byte[] getRowKey() {
                return rowKey;
            }
        };
    }

    public byte[] getDataEmptyKeyValueCF() {
        return this.dataEmptyKeyValueCF;
    }

    public boolean isLocalIndex() {
        return this.isLocalIndex;
    }

    public boolean isImmutableRows() {
        return this.immutableRows;
    }

    public Set<ColumnReference> getIndexedColumns() {
        return this.indexedColumns;
    }

    public byte[] getEmptyKeyValueQualifier() {
        return this.dataEmptyKeyValueRef.getQualifier();
    }

    public Set<Pair<String, String>> getIndexedColumnInfo() {
        return this.indexedColumnsInfo;
    }

    public PTable.ImmutableStorageScheme getIndexStorageScheme() {
        return this.immutableStorageScheme;
    }

    public static class UDFParseNodeVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

        @Override
        public boolean visitEnter(FunctionParseNode node) throws SQLException {
            if (node instanceof UDFParseNode) {
                this.udfParseNodes.put(node.getName(), (UDFParseNode)node);
            }
            return super.visitEnter(node);
        }

        public Map<String, UDFParseNode> getUdfParseNodes() {
            return this.udfParseNodes;
        }
    }

    private class IntSizedRowKeyMetaData
    extends RowKeyMetaData {
        private int[] indexPkPosition;

        private IntSizedRowKeyMetaData() {
        }

        private IntSizedRowKeyMetaData(int nIndexedColumns) {
            super(nIndexedColumns);
            this.indexPkPosition = new int[nIndexedColumns];
        }

        @Override
        protected int getIndexPkPosition(int dataPkPosition) {
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        protected int setIndexPkPosition(int dataPkPosition, int indexPkPosition) {
            this.indexPkPosition[dataPkPosition] = indexPkPosition;
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        public void write(DataOutput output) throws IOException {
            super.write(output);
            for (int i = 0; i < this.indexPkPosition.length; ++i) {
                output.writeInt(this.indexPkPosition[i]);
            }
        }

        @Override
        protected int getByteSize() {
            return super.getByteSize() + this.indexPkPosition.length * 4;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            super.readFields(input);
            this.indexPkPosition = new int[IndexMaintainer.this.getIndexPkColumnCount()];
            for (int i = 0; i < this.indexPkPosition.length; ++i) {
                this.indexPkPosition[i] = input.readInt();
            }
        }
    }

    private class ByteSizeRowKeyMetaData
    extends RowKeyMetaData {
        private byte[] indexPkPosition;

        private ByteSizeRowKeyMetaData() {
        }

        private ByteSizeRowKeyMetaData(int nIndexedColumns) {
            super(nIndexedColumns);
            this.indexPkPosition = new byte[nIndexedColumns];
        }

        @Override
        protected int getIndexPkPosition(int dataPkPosition) {
            return this.indexPkPosition[dataPkPosition] + BYTE_OFFSET;
        }

        @Override
        protected int setIndexPkPosition(int dataPkPosition, int indexPkPosition) {
            this.indexPkPosition[dataPkPosition] = (byte)(indexPkPosition - BYTE_OFFSET);
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        public void write(DataOutput output) throws IOException {
            super.write(output);
            output.write(this.indexPkPosition);
        }

        @Override
        protected int getByteSize() {
            return super.getByteSize() + this.indexPkPosition.length;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            super.readFields(input);
            this.indexPkPosition = new byte[IndexMaintainer.this.getIndexPkColumnCount()];
            input.readFully(this.indexPkPosition);
        }
    }

    private abstract class RowKeyMetaData
    implements Writable {
        private BitSet descIndexColumnBitSet;
        private BitSet viewConstantColumnBitSet;

        private RowKeyMetaData() {
        }

        private RowKeyMetaData(int nIndexedColumns) {
            this.descIndexColumnBitSet = BitSet.withCapacity(nIndexedColumns);
            this.viewConstantColumnBitSet = BitSet.withCapacity(IndexMaintainer.this.dataRowKeySchema.getMaxFields());
        }

        protected int getByteSize() {
            return BitSet.getByteSize(IndexMaintainer.this.getIndexPkColumnCount()) * 3 + BitSet.getByteSize(IndexMaintainer.this.dataRowKeySchema.getMaxFields());
        }

        protected abstract int getIndexPkPosition(int var1);

        protected abstract int setIndexPkPosition(int var1, int var2);

        public void readFields(DataInput input) throws IOException {
            int length = IndexMaintainer.this.getIndexPkColumnCount();
            this.descIndexColumnBitSet = BitSet.read(input, length);
            int vclength = IndexMaintainer.this.dataRowKeySchema.getMaxFields();
            this.viewConstantColumnBitSet = BitSet.read(input, vclength);
        }

        public void write(DataOutput output) throws IOException {
            int length = IndexMaintainer.this.getIndexPkColumnCount();
            BitSet.write(output, this.descIndexColumnBitSet, length);
            int vclength = IndexMaintainer.this.dataRowKeySchema.getMaxFields();
            BitSet.write(output, this.viewConstantColumnBitSet, vclength);
        }

        private BitSet getDescIndexColumnBitSet() {
            return this.descIndexColumnBitSet;
        }

        private BitSet getViewConstantColumnBitSet() {
            return this.viewConstantColumnBitSet;
        }
    }

    private static enum DeleteType {
        SINGLE_VERSION,
        ALL_VERSIONS;

    }
}

