/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.controller.InterRegionServerIndexRpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.DelegateRegionCoprocessorEnvironment;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.MultiMutation;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.apache.phoenix.hbase.index.covered.update.IndexedColumnGroup;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.LeaveIndexActiveFailurePolicy;
import org.apache.phoenix.hbase.index.write.ParallelWriterIndexCommitter;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.trace.TracingUtils;
import org.apache.phoenix.trace.util.NullSpan;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionalTable;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TransactionUtil;

public class PhoenixTransactionalIndexer
extends BaseRegionObserver {
    private static final Log LOG = LogFactory.getLog(PhoenixTransactionalIndexer.class);
    private ThreadLocal<BatchMutateContext> batchMutateContext = new ThreadLocal();
    private PhoenixIndexCodec codec;
    private IndexWriter writer;
    private boolean stopped;

    public void start(CoprocessorEnvironment e) throws IOException {
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e;
        String serverName = env.getRegionServerServices().getServerName().getServerName();
        this.codec = new PhoenixIndexCodec();
        this.codec.initialize(env);
        Configuration clonedConfig = PropertiesUtil.cloneConfig(e.getConfiguration());
        clonedConfig.setClass("hbase.rpc.controllerfactory.class", InterRegionServerIndexRpcControllerFactory.class, RpcControllerFactory.class);
        clonedConfig.setInt("hbase.client.retries.number", env.getConfiguration().getInt("phoenix.index.writes.rpc.retries.number", 11));
        clonedConfig.setInt("hbase.client.pause", env.getConfiguration().getInt("phoenix.index.writes.rpc.pause", 100));
        DelegateRegionCoprocessorEnvironment indexWriterEnv = new DelegateRegionCoprocessorEnvironment(clonedConfig, env);
        this.writer = new IndexWriter(IndexWriter.getCommitter(indexWriterEnv, ParallelWriterIndexCommitter.class), new LeaveIndexActiveFailurePolicy(), indexWriterEnv, serverName + "-tx-index-writer");
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        String msg = "TxIndexer is being stopped";
        this.writer.stop(msg);
    }

    private static Iterator<Mutation> getMutationIterator(final MiniBatchOperationInProgress<Mutation> miniBatchOp) {
        return new Iterator<Mutation>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < miniBatchOp.size();
            }

            @Override
            public Mutation next() {
                return (Mutation)miniBatchOp.getOperation(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        Mutation m = (Mutation)miniBatchOp.getOperation(0);
        if (!this.codec.isEnabled(m)) {
            super.preBatchMutate(c, miniBatchOp);
            return;
        }
        BatchMutateContext context = new BatchMutateContext();
        this.setBatchMutateContext(c, context);
        Map updateAttributes = m.getAttributesMap();
        PhoenixIndexMetaData indexMetaData = new PhoenixIndexMetaData((RegionCoprocessorEnvironment)c.getEnvironment(), updateAttributes);
        byte[] txRollbackAttribute = m.getAttribute("tephra.tx.rollback");
        Object indexUpdates = null;
        try (TraceScope scope = Trace.startSpan((String)"Starting to build index updates");){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            context.indexUpdates = this.getIndexUpdates((RegionCoprocessorEnvironment)c.getEnvironment(), indexMetaData, PhoenixTransactionalIndexer.getMutationIterator(miniBatchOp), txRollbackAttribute);
            current.addTimelineAnnotation("Built index updates, doing preStep");
            TracingUtils.addAnnotation(current, "index update count", context.indexUpdates.size());
        }
        catch (Throwable t) {
            String msg = "Failed to update index with entries:" + indexUpdates;
            LOG.error((Object)msg, t);
            ServerUtil.throwIOException(msg, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        BatchMutateContext context = this.getBatchMutateContext(c);
        if (context == null || context.indexUpdates == null) {
            return;
        }
        try (TraceScope scope = Trace.startSpan((String)"Starting to write index updates");){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            if (success) {
                if (!context.indexUpdates.isEmpty()) {
                    this.writer.write(context.indexUpdates, true);
                }
                current.addTimelineAnnotation("Wrote index updates");
            }
        }
        catch (Throwable t) {
            String msg = "Failed to write index updates:" + context.indexUpdates;
            LOG.error((Object)msg, t);
            ServerUtil.throwIOException(msg, t);
        }
        finally {
            this.removeBatchMutateContext(c);
        }
    }

    private void setBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) {
        this.batchMutateContext.set(context);
    }

    private BatchMutateContext getBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        return this.batchMutateContext.get();
    }

    private void removeBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.batchMutateContext.remove();
    }

    private static void addMutation(Map<ImmutableBytesPtr, MultiMutation> mutations, ImmutableBytesPtr row, Mutation m) {
        MultiMutation stored = mutations.get((Object)row);
        if (stored == null) {
            stored = new MultiMutation(row);
            mutations.put(row, stored);
        }
        stored.addAll(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Pair<Mutation, byte[]>> getIndexUpdates(RegionCoprocessorEnvironment env, PhoenixIndexMetaData indexMetaData, Iterator<Mutation> mutationIterator, byte[] txRollbackAttribute) throws IOException {
        PhoenixTransactionContext txnContext = indexMetaData.getTransactionContext();
        if (txnContext == null) {
            throw new NullPointerException("Expected to find transaction in metadata for " + env.getRegionInfo().getTable().getNameAsString());
        }
        boolean isRollback = txRollbackAttribute != null;
        boolean isImmutable = indexMetaData.isImmutableRows();
        ResultScanner currentScanner = null;
        PhoenixTransactionalTable txTable = null;
        HashMap<ImmutableBytesPtr, MultiMutation> mutations = new HashMap<ImmutableBytesPtr, MultiMutation>();
        HashMap<ImmutableBytesPtr, MultiMutation> findPriorValueMutations = isImmutable && !isRollback ? new HashMap() : mutations;
        while (mutationIterator.hasNext()) {
            Mutation m = mutationIterator.next();
            ImmutableBytesPtr row = new ImmutableBytesPtr(m.getRow());
            if (mutations != findPriorValueMutations && PhoenixTransactionalIndexer.isDeleteMutation(m)) {
                PhoenixTransactionalIndexer.addMutation(findPriorValueMutations, row, m);
            }
            PhoenixTransactionalIndexer.addMutation(mutations, row, m);
        }
        List<IndexMaintainer> indexMaintainers = indexMetaData.getIndexMaintainers();
        int estimatedSize = indexMaintainers.size() * 10;
        HashSet mutableColumns = Sets.newHashSetWithExpectedSize((int)estimatedSize);
        for (IndexMaintainer indexMaintainer : indexMaintainers) {
            Set<ColumnReference> allColumns = indexMaintainer.getAllColumns();
            mutableColumns.addAll(allColumns);
        }
        ArrayList<Pair<Mutation, byte[]>> indexUpdates = new ArrayList<Pair<Mutation, byte[]>>(mutations.size() * 2 * indexMaintainers.size());
        try {
            if (!findPriorValueMutations.isEmpty()) {
                ArrayList keys = Lists.newArrayListWithExpectedSize((int)mutations.size());
                for (Object ptr : findPriorValueMutations.keySet()) {
                    keys.add(PVarbinary.INSTANCE.getKeyRange(((ImmutableBytesPtr)((Object)ptr)).copyBytesIfNecessary()));
                }
                Scan scan = new Scan();
                for (ColumnReference ref : mutableColumns) {
                    scan.addColumn(ref.getFamily(), ref.getQualifier());
                }
                byte[] emptyKeyValueQualifier = indexMaintainers.get(0).getEmptyKeyValueQualifier();
                scan.addColumn(indexMaintainers.get(0).getDataEmptyKeyValueCF(), emptyKeyValueQualifier);
                ScanRanges scanRanges = ScanRanges.create(SchemaUtil.VAR_BINARY_SCHEMA, Collections.singletonList(keys), ScanUtil.SINGLE_COLUMN_SLOT_SPAN, KeyRange.EVERYTHING_RANGE, null, true, -1);
                scanRanges.initializeScan(scan);
                TableName tableName = env.getRegion().getRegionInfo().getTable();
                HTableInterface htable = env.getTable(tableName);
                txTable = TransactionFactory.getTransactionFactory().getTransactionalTable(txnContext, htable);
                SkipScanFilter filter = scanRanges.getSkipScanFilter();
                if (isRollback) {
                    filter = new SkipScanFilter(filter, true);
                    txnContext.setVisibilityLevel(PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_ALL);
                }
                scan.setFilter((Filter)filter);
                currentScanner = txTable.getScanner(scan);
            }
            if (isRollback) {
                this.processRollback(env, indexMetaData, txRollbackAttribute, currentScanner, txnContext, mutableColumns, indexUpdates, mutations);
            } else {
                this.processMutation(env, indexMetaData, txRollbackAttribute, currentScanner, txnContext, mutableColumns, indexUpdates, mutations, findPriorValueMutations);
            }
        }
        finally {
            if (txTable != null) {
                txTable.close();
            }
        }
        return indexUpdates;
    }

    private static boolean isDeleteMutation(Mutation m) {
        for (Map.Entry cellMap : m.getFamilyCellMap().entrySet()) {
            for (Cell cell : (List)cellMap.getValue()) {
                if (cell.getTypeByte() == KeyValue.Type.Put.getCode() && !TransactionUtil.isDelete(cell)) continue;
                return true;
            }
        }
        return false;
    }

    private void processMutation(RegionCoprocessorEnvironment env, PhoenixIndexMetaData indexMetaData, byte[] txRollbackAttribute, ResultScanner scanner, PhoenixTransactionContext txnContext, Set<ColumnReference> upsertColumns, Collection<Pair<Mutation, byte[]>> indexUpdates, Map<ImmutableBytesPtr, MultiMutation> mutations, Map<ImmutableBytesPtr, MultiMutation> mutationsToFindPreviousValue) throws IOException {
        if (scanner != null) {
            Result result;
            ColumnReference columnReference = new ColumnReference(indexMetaData.getIndexMaintainers().get(0).getDataEmptyKeyValueCF(), indexMetaData.getIndexMaintainers().get(0).getEmptyKeyValueQualifier());
            while ((result = scanner.next()) != null) {
                Mutation m = mutationsToFindPreviousValue.remove((Object)new ImmutableBytesPtr(result.getRow()));
                TxTableState state2 = new TxTableState(env, upsertColumns, indexMetaData.getAttributes(), txnContext.getWritePointer(), m, columnReference, result);
                this.generateDeletes(indexMetaData, indexUpdates, txRollbackAttribute, state2);
                this.generatePuts(indexMetaData, indexUpdates, state2);
            }
        }
        for (Mutation mutation : mutations.values()) {
            TxTableState state3 = new TxTableState(env, upsertColumns, indexMetaData.getAttributes(), txnContext.getWritePointer(), mutation);
            this.generatePuts(indexMetaData, indexUpdates, state3);
        }
    }

    private void processRollback(RegionCoprocessorEnvironment env, PhoenixIndexMetaData indexMetaData, byte[] txRollbackAttribute, ResultScanner scanner, PhoenixTransactionContext tx, Set<ColumnReference> mutableColumns, Collection<Pair<Mutation, byte[]>> indexUpdates, Map<ImmutableBytesPtr, MultiMutation> mutations) throws IOException {
        if (scanner != null) {
            Result result;
            ColumnReference emptyColRef = new ColumnReference(indexMetaData.getIndexMaintainers().get(0).getDataEmptyKeyValueCF(), indexMetaData.getIndexMaintainers().get(0).getEmptyKeyValueQualifier());
            while ((result = scanner.next()) != null) {
                Mutation m = mutations.remove((Object)new ImmutableBytesPtr(result.getRow()));
                List cells = result.listCells();
                Collections.sort(cells, new Comparator<Cell>(){

                    @Override
                    public int compare(Cell o1, Cell o2) {
                        int c = Longs.compare((long)o1.getTimestamp(), (long)o2.getTimestamp());
                        if (c != 0) {
                            return c;
                        }
                        c = o1.getTypeByte() - o2.getTypeByte();
                        if (c != 0) {
                            return c;
                        }
                        c = Bytes.compareTo((byte[])o1.getFamilyArray(), (int)o1.getFamilyOffset(), (int)o1.getFamilyLength(), (byte[])o1.getFamilyArray(), (int)o1.getFamilyOffset(), (int)o1.getFamilyLength());
                        if (c != 0) {
                            return c;
                        }
                        return Bytes.compareTo((byte[])o1.getQualifierArray(), (int)o1.getQualifierOffset(), (int)o1.getQualifierLength(), (byte[])o1.getQualifierArray(), (int)o1.getQualifierOffset(), (int)o1.getQualifierLength());
                    }
                });
                int i = 0;
                int nCells = cells.size();
                Result oldResult = null;
                long readPtr = tx.getReadPointer();
                do {
                    TxTableState state2;
                    long writePtr;
                    boolean hasPuts = false;
                    LinkedList singleTimeCells = Lists.newLinkedList();
                    Cell cell = (Cell)cells.get(i);
                    do {
                        hasPuts |= cell.getTypeByte() == KeyValue.Type.Put.getCode();
                        writePtr = cell.getTimestamp();
                        ListIterator<Cell> it = singleTimeCells.listIterator();
                        do {
                            it.add(cell);
                        } while (++i < nCells && (cell = (Cell)cells.get(i)).getTimestamp() == writePtr);
                    } while (i < nCells && cell.getTimestamp() <= readPtr);
                    if (oldResult != null) {
                        state2 = new TxTableState(env, mutableColumns, indexMetaData.getAttributes(), writePtr, m, emptyColRef, oldResult);
                        this.generateDeletes(indexMetaData, indexUpdates, txRollbackAttribute, state2);
                    }
                    if (hasPuts) {
                        Result newResult = Result.create((List)singleTimeCells);
                        if (writePtr > readPtr) {
                            state2 = new TxTableState(env, mutableColumns, indexMetaData.getAttributes(), writePtr, m, emptyColRef, newResult);
                            this.generateDeletes(indexMetaData, indexUpdates, txRollbackAttribute, state2);
                        }
                        oldResult = newResult;
                        continue;
                    }
                    oldResult = null;
                } while (i < nCells);
            }
        }
    }

    private void generateDeletes(PhoenixIndexMetaData indexMetaData, Collection<Pair<Mutation, byte[]>> indexUpdates, byte[] attribValue, TxTableState state2) throws IOException {
        Iterable<IndexUpdate> deletes = this.codec.getIndexDeletes(state2, indexMetaData);
        for (IndexUpdate delete : deletes) {
            if (!delete.isValid()) continue;
            delete.getUpdate().setAttribute("tephra.tx.rollback", attribValue);
            indexUpdates.add((Pair<Mutation, byte[]>)new Pair((Object)delete.getUpdate(), (Object)delete.getTableName()));
        }
    }

    private boolean generatePuts(PhoenixIndexMetaData indexMetaData, Collection<Pair<Mutation, byte[]>> indexUpdates, TxTableState state2) throws IOException {
        state2.applyMutation();
        Iterable<IndexUpdate> puts = this.codec.getIndexUpserts(state2, indexMetaData);
        boolean validPut = false;
        for (IndexUpdate put : puts) {
            if (!put.isValid()) continue;
            indexUpdates.add((Pair<Mutation, byte[]>)new Pair((Object)put.getUpdate(), (Object)put.getTableName()));
            validPut = true;
        }
        return validPut;
    }

    private static class TxTableState
    implements TableState {
        private final Mutation mutation;
        private final long currentTimestamp;
        private final RegionCoprocessorEnvironment env;
        private final Map<String, byte[]> attributes;
        private final List<KeyValue> pendingUpdates;
        private final Set<ColumnReference> indexedColumns;
        private final Map<ColumnReference, ImmutableBytesWritable> valueMap;

        private TxTableState(RegionCoprocessorEnvironment env, Set<ColumnReference> indexedColumns, Map<String, byte[]> attributes, long currentTimestamp, Mutation mutation) {
            this.env = env;
            this.currentTimestamp = currentTimestamp;
            this.indexedColumns = indexedColumns;
            this.attributes = attributes;
            this.mutation = mutation;
            int estimatedSize = indexedColumns.size();
            this.valueMap = Maps.newHashMapWithExpectedSize((int)estimatedSize);
            this.pendingUpdates = Lists.newArrayListWithExpectedSize((int)estimatedSize);
            try {
                CellScanner scanner = mutation.cellScanner();
                while (scanner.advance()) {
                    Cell cell = scanner.current();
                    this.pendingUpdates.add(KeyValueUtil.ensureKeyValue((Cell)cell));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public TxTableState(RegionCoprocessorEnvironment env, Set<ColumnReference> indexedColumns, Map<String, byte[]> attributes, long currentTimestamp, Mutation m, ColumnReference emptyColRef, Result r) {
            this(env, indexedColumns, attributes, currentTimestamp, m);
            for (ColumnReference ref : indexedColumns) {
                Cell cell = r.getColumnLatestCell(ref.getFamily(), ref.getQualifier());
                if (cell == null) continue;
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                ptr.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                this.valueMap.put(ref, ptr);
            }
        }

        @Override
        public RegionCoprocessorEnvironment getEnvironment() {
            return this.env;
        }

        @Override
        public long getCurrentTimestamp() {
            return this.currentTimestamp;
        }

        @Override
        public Map<String, byte[]> getUpdateAttributes() {
            return this.attributes;
        }

        @Override
        public byte[] getCurrentRowKey() {
            return this.mutation.getRow();
        }

        @Override
        public List<? extends IndexedColumnGroup> getIndexColumnHints() {
            return Collections.emptyList();
        }

        private void applyMutation() {
            for (Cell cell : this.pendingUpdates) {
                Object ref;
                if (cell.getTypeByte() == KeyValue.Type.Delete.getCode() || cell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode()) {
                    ref = new ColumnReference(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    this.valueMap.remove(ref);
                    continue;
                }
                if (cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode() || cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode()) {
                    for (ColumnReference ref2 : this.indexedColumns) {
                        if (!ref2.matchesFamily(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength())) continue;
                        this.valueMap.remove(ref2);
                    }
                    continue;
                }
                if (cell.getTypeByte() == KeyValue.Type.Put.getCode()) {
                    ref = new ColumnReference(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    if (!this.indexedColumns.contains(ref)) continue;
                    ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                    ptr.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                    this.valueMap.put((ColumnReference)ref, ptr);
                    continue;
                }
                throw new IllegalStateException("Unexpected mutation type for " + cell);
            }
        }

        @Override
        public Collection<KeyValue> getPendingUpdate() {
            return this.pendingUpdates;
        }

        @Override
        public Pair<ValueGetter, IndexUpdate> getIndexUpdateState(Collection<? extends ColumnReference> indexedColumns, boolean ignoreNewerMutations, boolean returnNullScannerIfRowNotFound, IndexMetaData indexMetaData) throws IOException {
            ColumnTracker tracker = new ColumnTracker(indexedColumns);
            ValueGetter getter = new ValueGetter(){

                @Override
                public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) throws IOException {
                    return (ImmutableBytesWritable)TxTableState.this.valueMap.get(ref);
                }

                @Override
                public byte[] getRowKey() {
                    return TxTableState.this.mutation.getRow();
                }
            };
            Pair pair = new Pair((Object)getter, (Object)new IndexUpdate(tracker));
            return pair;
        }
    }

    private static class BatchMutateContext {
        public Collection<Pair<Mutation, byte[]>> indexUpdates = Collections.emptyList();

        private BatchMutateContext() {
        }
    }
}

