/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ChunkedResultIterator
implements PeekingResultIterator {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedResultIterator.class);
    private final ParallelIteratorFactory delegateIteratorFactory;
    private ImmutableBytesWritable lastKey = new ImmutableBytesWritable();
    private final StatementContext context;
    private final TableRef tableRef;
    private final long chunkSize;
    private final MutationState mutationState;
    private Scan scan;
    private PeekingResultIterator resultIterator;
    private QueryPlan plan;

    private ChunkedResultIterator(ParallelIteratorFactory delegateIteratorFactory, MutationState mutationState, StatementContext context, TableRef tableRef, Scan scan, long chunkSize, ResultIterator scanner, QueryPlan plan) throws SQLException {
        this.delegateIteratorFactory = delegateIteratorFactory;
        this.context = context;
        this.tableRef = tableRef;
        this.scan = scan;
        this.chunkSize = chunkSize;
        this.mutationState = mutationState;
        this.plan = plan;
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("Get first chunked result iterator over " + tableRef.getTable().getPhysicalName().getString() + " with " + scan, ScanUtil.getCustomAnnotations(scan)));
        }
        SingleChunkResultIterator singleChunkResultIterator = new SingleChunkResultIterator(scanner, chunkSize);
        String tableName = tableRef.getTable().getPhysicalName().getString();
        this.resultIterator = delegateIteratorFactory.newIterator(context, singleChunkResultIterator, scan, tableName, plan);
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.getResultIterator().peek();
    }

    @Override
    public Tuple next() throws SQLException {
        return this.getResultIterator().next();
    }

    @Override
    public void explain(List<String> planSteps) {
        this.resultIterator.explain(planSteps);
    }

    @Override
    public void close() throws SQLException {
        this.resultIterator.close();
    }

    private PeekingResultIterator getResultIterator() throws SQLException {
        if (this.resultIterator.peek() == null && this.lastKey != null) {
            this.resultIterator.close();
            this.scan = ScanUtil.newScan(this.scan);
            if (ScanUtil.isLocalIndex(this.scan)) {
                this.scan.setAttribute("_ScanStartRowSuffix", ByteUtil.copyKeyBytesIfNecessary(this.lastKey));
            } else {
                this.scan.setStartRow(ByteUtil.copyKeyBytesIfNecessary(this.lastKey));
            }
            if (logger.isDebugEnabled()) {
                logger.debug(LogUtil.addCustomAnnotations("Get next chunked result iterator over " + this.tableRef.getTable().getPhysicalName().getString() + " with " + this.scan, ScanUtil.getCustomAnnotations(this.scan)));
            }
            String tableName = this.tableRef.getTable().getPhysicalName().getString();
            ReadMetricQueue readMetrics = this.context.getReadMetricsQueue();
            ScanMetricsHolder scanMetricsHolder = ScanMetricsHolder.getInstance(readMetrics, tableName, this.scan, this.context.getConnection().getLogLevel());
            long renewLeaseThreshold = this.context.getConnection().getQueryServices().getRenewLeaseThresholdMilliSeconds();
            SingleChunkResultIterator singleChunkResultIterator = new SingleChunkResultIterator(new TableResultIterator(this.mutationState, this.scan, scanMetricsHolder, renewLeaseThreshold, this.plan, DefaultParallelScanGrouper.getInstance()), this.chunkSize);
            this.resultIterator = this.delegateIteratorFactory.newIterator(this.context, singleChunkResultIterator, this.scan, tableName, this.plan);
        }
        return this.resultIterator;
    }

    private class SingleChunkResultIterator
    implements ResultIterator {
        private int rowCount = 0;
        private boolean chunkComplete;
        private final ResultIterator delegate;
        private final long chunkSize;

        private SingleChunkResultIterator(ResultIterator delegate, long chunkSize) {
            Preconditions.checkArgument((chunkSize > 0L ? 1 : 0) != 0);
            this.delegate = delegate;
            this.chunkSize = chunkSize;
        }

        @Override
        public Tuple next() throws SQLException {
            if (this.chunkComplete || ChunkedResultIterator.this.lastKey == null) {
                return null;
            }
            Tuple next = this.delegate.next();
            if (next != null) {
                if ((long)this.rowCount == this.chunkSize) {
                    next.getKey(ChunkedResultIterator.this.lastKey);
                } else if ((long)this.rowCount > this.chunkSize && this.rowKeyChanged(next)) {
                    this.chunkComplete = true;
                    return null;
                }
                ++this.rowCount;
            } else {
                ChunkedResultIterator.this.lastKey = null;
            }
            return next;
        }

        @Override
        public void explain(List<String> planSteps) {
            this.delegate.explain(planSteps);
        }

        @Override
        public void close() throws SQLException {
            this.delegate.close();
        }

        private boolean rowKeyChanged(Tuple newTuple) {
            byte[] currentKey = ChunkedResultIterator.this.lastKey.get();
            int offset = ChunkedResultIterator.this.lastKey.getOffset();
            int length = ChunkedResultIterator.this.lastKey.getLength();
            newTuple.getKey(ChunkedResultIterator.this.lastKey);
            return Bytes.compareTo((byte[])currentKey, (int)offset, (int)length, (byte[])ChunkedResultIterator.this.lastKey.get(), (int)ChunkedResultIterator.this.lastKey.getOffset(), (int)ChunkedResultIterator.this.lastKey.getLength()) != 0;
        }

        public String toString() {
            return "SingleChunkResultIterator [rowCount=" + this.rowCount + ", chunkComplete=" + this.chunkComplete + ", delegate=" + this.delegate + ", chunkSize=" + this.chunkSize + "]";
        }
    }

    @Deprecated
    public static class ChunkedResultIteratorFactory
    implements ParallelIteratorFactory {
        private final ParallelIteratorFactory delegateFactory;
        private final TableRef tableRef;
        private final MutationState mutationState;

        public ChunkedResultIteratorFactory(ParallelIteratorFactory delegateFactory, MutationState mutationState, TableRef tableRef) {
            this.delegateFactory = delegateFactory;
            this.tableRef = tableRef;
            this.mutationState = new MutationState(mutationState);
        }

        @Override
        public PeekingResultIterator newIterator(StatementContext context, ResultIterator scanner, Scan scan, String tableName, QueryPlan plan) throws SQLException {
            if (logger.isDebugEnabled()) {
                logger.debug(LogUtil.addCustomAnnotations("ChunkedResultIteratorFactory.newIterator over " + this.tableRef.getTable().getPhysicalName().getString() + " with " + scan, ScanUtil.getCustomAnnotations(scan)));
            }
            return new ChunkedResultIterator(this.delegateFactory, this.mutationState, context, this.tableRef, scan, this.mutationState.getConnection().getQueryServices().getProps().getLong("phoenix.query.scanResultChunkSize", 15000L), scanner, plan);
        }
    }
}

