/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.log.LogWriter;
import org.apache.phoenix.log.QueryLogInfo;
import org.apache.phoenix.log.RingBufferEvent;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.util.QueryUtil;

public class TableLogWriter
implements LogWriter {
    private static final Log LOG = LogFactory.getLog(LogWriter.class);
    private Connection connection;
    private boolean isClosed;
    private PreparedStatement upsertStatement;
    private Configuration config;
    private Map<MetricType, Integer> metricOrdinals = new HashMap<MetricType, Integer>();

    public TableLogWriter(Configuration configuration) {
        this.config = configuration;
    }

    private PreparedStatement buildUpsertStatement(Connection conn) throws SQLException {
        StringBuilder buf = new StringBuilder("UPSERT INTO SYSTEM.\"LOG\"(");
        int queryLogEntries = 0;
        for (QueryLogInfo queryLogInfo : QueryLogInfo.values()) {
            buf.append(queryLogInfo.columnName);
            buf.append(',');
            ++queryLogEntries;
        }
        for (Enum enum_ : MetricType.values()) {
            if (((MetricType)enum_).logLevel() == LogLevel.OFF) continue;
            this.metricOrdinals.put((MetricType)enum_, ++queryLogEntries);
            buf.append(((MetricType)enum_).columnName());
            buf.append(',');
        }
        buf.setLength(buf.length() - 1);
        buf.append(") VALUES (");
        for (int i = 0; i < QueryLogInfo.values().length; ++i) {
            buf.append("?,");
        }
        for (MetricType metricType : MetricType.values()) {
            if (metricType.logLevel() == LogLevel.OFF) continue;
            buf.append("?,");
        }
        buf.setLength(buf.length() - 1);
        buf.append(")");
        return conn.prepareStatement(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RingBufferEvent event) throws SQLException, IOException, ClassNotFoundException {
        if (this.isClosed()) {
            LOG.warn((Object)"Unable to commit query log as Log committer is already closed");
            return;
        }
        if (this.connection == null) {
            TableLogWriter tableLogWriter = this;
            synchronized (tableLogWriter) {
                if (this.connection == null) {
                    this.connection = QueryUtil.getConnectionForQueryLog(this.config);
                    this.upsertStatement = this.buildUpsertStatement(this.connection);
                }
            }
        }
        ImmutableMap<QueryLogInfo, Object> queryInfoMap = event.getQueryInfo();
        for (QueryLogInfo queryLogInfo : QueryLogInfo.values()) {
            if (queryInfoMap.containsKey((Object)queryLogInfo) && queryLogInfo.logLevel.ordinal() <= event.getConnectionLogLevel().ordinal()) {
                this.upsertStatement.setObject(queryLogInfo.ordinal() + 1, queryInfoMap.get((Object)queryLogInfo));
                continue;
            }
            this.upsertStatement.setObject(queryLogInfo.ordinal() + 1, null);
        }
        Map<MetricType, Long> overAllMetrics = event.getOverAllMetrics();
        Map<String, Map<MetricType, Long>> readMetrics = event.getReadMetrics();
        for (MetricType metric : MetricType.values()) {
            if (overAllMetrics != null && overAllMetrics.containsKey((Object)metric) && metric.isLoggingEnabled(event.getConnectionLogLevel())) {
                this.upsertStatement.setObject(this.metricOrdinals.get((Object)metric), overAllMetrics.get((Object)metric));
                continue;
            }
            if (metric.logLevel() == LogLevel.OFF) continue;
            this.upsertStatement.setObject(this.metricOrdinals.get((Object)metric), null);
        }
        if (readMetrics != null && !readMetrics.isEmpty()) {
            for (Map.Entry entry : readMetrics.entrySet()) {
                this.upsertStatement.setObject(QueryLogInfo.TABLE_NAME_I.ordinal() + 1, entry.getKey());
                for (MetricType metric : ((Map)entry.getValue()).keySet()) {
                    if (!metric.isLoggingEnabled(event.getConnectionLogLevel())) continue;
                    this.upsertStatement.setObject(this.metricOrdinals.get((Object)metric), ((Map)entry.getValue()).get((Object)metric));
                }
                this.upsertStatement.executeUpdate();
            }
        } else {
            this.upsertStatement.executeUpdate();
        }
        this.connection.commit();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.isClosed = true;
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

