/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mapreduce.KeyValueSerialization;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.bulkload.TableRowkeyPair;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRef;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRefFunctions;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiHfileOutputFormat
extends FileOutputFormat<TableRowkeyPair, Cell> {
    private static final Logger LOG = LoggerFactory.getLogger(MultiHfileOutputFormat.class);
    private static final String COMPRESSION_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.compression";
    private static final String BLOOM_TYPE_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.bloomtype";
    private static final String BLOCK_SIZE_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.blocksize";
    private static final String DATABLOCK_ENCODING_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.families.datablock.encoding";
    public static final String DATABLOCK_ENCODING_OVERRIDE_CONF_KEY = "hbase.mapreduce.hfileoutputformat.datablock.encoding";
    private static final String AT_DELIMITER = "@";

    public RecordWriter<TableRowkeyPair, Cell> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return MultiHfileOutputFormat.createRecordWriter(context);
    }

    static <V extends Cell> RecordWriter<TableRowkeyPair, V> createRecordWriter(final TaskAttemptContext context) throws IOException {
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)context);
        final Path outputdir = new FileOutputCommitter(outputPath, context).getWorkPath();
        final Configuration conf = context.getConfiguration();
        final FileSystem fs = outputdir.getFileSystem(conf);
        final long maxsize = conf.getLong("hbase.hregion.max.filesize", 0x280000000L);
        String defaultCompressionStr = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        final Compression.Algorithm defaultCompression = AbstractHFileWriter.compressionByName((String)defaultCompressionStr);
        final boolean compactionExclude = conf.getBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", false);
        return new RecordWriter<TableRowkeyPair, V>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private byte[] previousRow = HConstants.EMPTY_BYTE_ARRAY;
            private final byte[] now = Bytes.toBytes((long)EnvironmentEdgeManager.currentTimeMillis());
            private boolean rollRequested = false;

            public void write(TableRowkeyPair row, V cell) throws IOException {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                if (row == null && kv == null) {
                    this.rollWriters();
                    return;
                }
                String tableName = row.getTableName();
                byte[] rowKey = row.getRowkey().get();
                long length = kv.getLength();
                byte[] family = CellUtil.cloneFamily((Cell)kv);
                byte[] tableAndFamily = MultiHfileOutputFormat.join(tableName, Bytes.toString((byte[])family));
                WriterLength wl = this.writers.get(tableAndFamily);
                if (wl == null) {
                    Path tableOutputPath = CsvBulkImportUtil.getOutputPath(outputdir, tableName);
                    fs.mkdirs(new Path(tableOutputPath, Bytes.toString((byte[])family)));
                }
                if (wl != null && wl.written + length >= maxsize) {
                    this.rollRequested = true;
                }
                if (this.rollRequested && Bytes.compareTo((byte[])this.previousRow, (byte[])rowKey) != 0) {
                    this.rollWriters();
                }
                if (wl == null || wl.writer == null) {
                    wl = this.getNewWriter(tableName, family, conf);
                }
                kv.updateLatestStamp(this.now);
                wl.writer.append((Cell)kv);
                wl.written += length;
                this.previousRow = rowKey;
            }

            private void rollWriters() throws IOException {
                for (WriterLength wl : this.writers.values()) {
                    if (wl.writer != null) {
                        LOG.info("Writer=" + wl.writer.getPath() + (wl.written == 0L ? "" : ", wrote=" + wl.written));
                        this.close(wl.writer);
                    }
                    wl.writer = null;
                    wl.written = 0L;
                }
                this.rollRequested = false;
            }

            @SuppressWarnings(value={"BX_UNBOXING_IMMEDIATELY_REBOXED"}, justification="Not important")
            private WriterLength getNewWriter(String tableName, byte[] family, Configuration conf2) throws IOException {
                WriterLength wl = new WriterLength();
                Path tableOutputPath = CsvBulkImportUtil.getOutputPath(outputdir, tableName);
                Path familydir = new Path(tableOutputPath, Bytes.toString((byte[])family));
                Map<byte[], Compression.Algorithm> compressionMap = MultiHfileOutputFormat.createFamilyCompressionMap(conf2, tableName);
                Map<byte[], BloomType> bloomTypeMap = MultiHfileOutputFormat.createFamilyBloomTypeMap(conf2, tableName);
                Map<byte[], Integer> blockSizeMap = MultiHfileOutputFormat.createFamilyBlockSizeMap(conf2, tableName);
                String dataBlockEncodingStr = conf2.get(MultiHfileOutputFormat.DATABLOCK_ENCODING_OVERRIDE_CONF_KEY);
                Map<byte[], DataBlockEncoding> datablockEncodingMap = MultiHfileOutputFormat.createFamilyDataBlockEncodingMap(conf2, tableName);
                DataBlockEncoding overriddenEncoding = dataBlockEncodingStr != null ? DataBlockEncoding.valueOf((String)dataBlockEncodingStr) : null;
                Compression.Algorithm compression = compressionMap.get(family);
                compression = compression == null ? defaultCompression : compression;
                BloomType bloomType = bloomTypeMap.get(family);
                bloomType = bloomType == null ? BloomType.NONE : bloomType;
                Integer blockSize = blockSizeMap.get(family);
                blockSize = blockSize == null ? 65536 : blockSize;
                DataBlockEncoding encoding = overriddenEncoding;
                encoding = encoding == null ? datablockEncodingMap.get(family) : encoding;
                encoding = encoding == null ? DataBlockEncoding.NONE : encoding;
                Configuration tempConf = new Configuration(conf2);
                tempConf.setFloat("hfile.block.cache.size", 0.0f);
                HFileContextBuilder contextBuilder = new HFileContextBuilder().withCompression(compression).withChecksumType(HStore.getChecksumType((Configuration)conf2)).withBytesPerCheckSum(HStore.getBytesPerChecksum((Configuration)conf2)).withBlockSize(blockSize.intValue());
                contextBuilder.withDataBlockEncoding(encoding);
                HFileContext hFileContext = contextBuilder.build();
                wl.writer = new StoreFile.WriterBuilder(conf2, new CacheConfig(tempConf), fs).withOutputDir(familydir).withBloomType(bloomType).withComparator(KeyValue.COMPARATOR).withFileContext(hFileContext).build();
                byte[] tableAndFamily = MultiHfileOutputFormat.join(tableName, Bytes.toString((byte[])family));
                this.writers.put(tableAndFamily, wl);
                return wl;
            }

            private void close(StoreFile.Writer w) throws IOException {
                if (w != null) {
                    w.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)EnvironmentEdgeManager.currentTimeMillis()));
                    w.appendFileInfo(StoreFile.BULKLOAD_TASK_KEY, Bytes.toBytes((String)context.getTaskAttemptID().toString()));
                    w.appendFileInfo(StoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes((boolean)true));
                    w.appendFileInfo(StoreFile.EXCLUDE_FROM_MINOR_COMPACTION_KEY, Bytes.toBytes((boolean)compactionExclude));
                    w.appendTrackedTimestampsToMetadata();
                    w.close();
                }
            }

            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (WriterLength wl : this.writers.values()) {
                    this.close(wl.writer);
                }
            }
        };
    }

    private static byte[] join(String tableName, String family) {
        return Bytes.toBytes((String)(tableName + AT_DELIMITER + family));
    }

    @VisibleForTesting
    static Map<byte[], Compression.Algorithm> createFamilyCompressionMap(Configuration conf, String tableName) {
        TreeMap<byte[], Compression.Algorithm> compressionMap = new TreeMap<byte[], Compression.Algorithm>(Bytes.BYTES_COMPARATOR);
        Map<String, String> tableConfigs = MultiHfileOutputFormat.getTableConfigurations(conf, tableName);
        if (tableConfigs == null) {
            return compressionMap;
        }
        Map<byte[], String> stringMap = MultiHfileOutputFormat.createFamilyConfValueMap(tableConfigs, COMPRESSION_FAMILIES_CONF_KEY);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Compression.Algorithm algorithm = AbstractHFileWriter.compressionByName((String)e.getValue());
            compressionMap.put(e.getKey(), algorithm);
        }
        return compressionMap;
    }

    private static Map<String, String> getTableConfigurations(Configuration conf, String tableName) {
        String tableDefn = conf.get(tableName);
        if (StringUtils.isEmpty((String)tableDefn)) {
            return null;
        }
        TargetTableRef table = (TargetTableRef)TargetTableRefFunctions.FROM_JSON.apply((Object)tableDefn);
        Map<String, String> tableConfigs = table.getConfiguration();
        return tableConfigs;
    }

    @VisibleForTesting
    static Map<byte[], BloomType> createFamilyBloomTypeMap(Configuration conf, String tableName) {
        TreeMap<byte[], BloomType> bloomTypeMap = new TreeMap<byte[], BloomType>(Bytes.BYTES_COMPARATOR);
        Map<String, String> tableConfigs = MultiHfileOutputFormat.getTableConfigurations(conf, tableName);
        if (tableConfigs == null) {
            return bloomTypeMap;
        }
        Map<byte[], String> stringMap = MultiHfileOutputFormat.createFamilyConfValueMap(tableConfigs, BLOOM_TYPE_FAMILIES_CONF_KEY);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            BloomType bloomType = BloomType.valueOf((String)e.getValue());
            bloomTypeMap.put(e.getKey(), bloomType);
        }
        return bloomTypeMap;
    }

    @VisibleForTesting
    static Map<byte[], Integer> createFamilyBlockSizeMap(Configuration conf, String tableName) {
        TreeMap<byte[], Integer> blockSizeMap = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        Map<String, String> tableConfigs = MultiHfileOutputFormat.getTableConfigurations(conf, tableName);
        if (tableConfigs == null) {
            return blockSizeMap;
        }
        Map<byte[], String> stringMap = MultiHfileOutputFormat.createFamilyConfValueMap(tableConfigs, BLOCK_SIZE_FAMILIES_CONF_KEY);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Integer blockSize = Integer.parseInt(e.getValue());
            blockSizeMap.put(e.getKey(), blockSize);
        }
        return blockSizeMap;
    }

    @VisibleForTesting
    static Map<byte[], DataBlockEncoding> createFamilyDataBlockEncodingMap(Configuration conf, String tableName) {
        TreeMap<byte[], DataBlockEncoding> encoderMap = new TreeMap<byte[], DataBlockEncoding>(Bytes.BYTES_COMPARATOR);
        Map<String, String> tableConfigs = MultiHfileOutputFormat.getTableConfigurations(conf, tableName);
        if (tableConfigs == null) {
            return encoderMap;
        }
        Map<byte[], String> stringMap = MultiHfileOutputFormat.createFamilyConfValueMap(tableConfigs, DATABLOCK_ENCODING_FAMILIES_CONF_KEY);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            encoderMap.put(e.getKey(), DataBlockEncoding.valueOf((String)e.getValue()));
        }
        return encoderMap;
    }

    private static Map<byte[], String> createFamilyConfValueMap(Map<String, String> configs, String confName) {
        TreeMap<byte[], String> confValMap = new TreeMap<byte[], String>(Bytes.BYTES_COMPARATOR);
        String confVal = configs.get(confName);
        if (StringUtils.isEmpty((String)confVal)) {
            return confValMap;
        }
        for (String familyConf : confVal.split("&")) {
            String[] familySplit = familyConf.split("=");
            if (familySplit.length != 2) continue;
            try {
                confValMap.put(URLDecoder.decode(familySplit[0], "UTF-8").getBytes(), URLDecoder.decode(familySplit[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return confValMap;
    }

    static void configurePartitioner(Job job, Set<TableRowkeyPair> tablesStartKeys) throws IOException {
        Configuration conf = job.getConfiguration();
        Path partitionsPath = new Path(conf.get("hadoop.tmp.dir"), "partitions_" + UUID.randomUUID());
        FileSystem fs = partitionsPath.getFileSystem(conf);
        fs.makeQualified(partitionsPath);
        MultiHfileOutputFormat.writePartitions(conf, partitionsPath, tablesStartKeys);
        fs.deleteOnExit(partitionsPath);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)partitionsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, Set<TableRowkeyPair> tablesStartKeys) throws IOException {
        LOG.info("Writing partition information to " + partitionsPath);
        if (tablesStartKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<TableRowkeyPair> sorted = new TreeSet<TableRowkeyPair>(tablesStartKeys);
        TableRowkeyPair first = sorted.first();
        if (!first.getRowkey().equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.getRowkey().get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, TableRowkeyPair.class, NullWritable.class);){
            for (TableRowkeyPair startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    @VisibleForTesting
    static String configureCompression(HTableDescriptor tableDescriptor) throws UnsupportedEncodingException {
        StringBuilder compressionConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return compressionConfigValue.toString();
        }
        Collection families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                compressionConfigValue.append('&');
            }
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            compressionConfigValue.append('=');
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getCompression().getName(), "UTF-8"));
        }
        return compressionConfigValue.toString();
    }

    @VisibleForTesting
    static String configureBlockSize(HTableDescriptor tableDescriptor) throws UnsupportedEncodingException {
        StringBuilder blockSizeConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return blockSizeConfigValue.toString();
        }
        Collection families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                blockSizeConfigValue.append('&');
            }
            blockSizeConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            blockSizeConfigValue.append('=');
            blockSizeConfigValue.append(URLEncoder.encode(String.valueOf(familyDescriptor.getBlocksize()), "UTF-8"));
        }
        return blockSizeConfigValue.toString();
    }

    static String configureBloomType(HTableDescriptor tableDescriptor) throws UnsupportedEncodingException {
        StringBuilder bloomTypeConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return bloomTypeConfigValue.toString();
        }
        Collection families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                bloomTypeConfigValue.append('&');
            }
            bloomTypeConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            bloomTypeConfigValue.append('=');
            String bloomType = familyDescriptor.getBloomFilterType().toString();
            if (bloomType == null) {
                bloomType = HColumnDescriptor.DEFAULT_BLOOMFILTER;
            }
            bloomTypeConfigValue.append(URLEncoder.encode(bloomType, "UTF-8"));
        }
        return bloomTypeConfigValue.toString();
    }

    static String configureDataBlockEncoding(HTableDescriptor tableDescriptor) throws UnsupportedEncodingException {
        StringBuilder dataBlockEncodingConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return dataBlockEncodingConfigValue.toString();
        }
        Collection families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                dataBlockEncodingConfigValue.append('&');
            }
            dataBlockEncodingConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            dataBlockEncodingConfigValue.append('=');
            DataBlockEncoding encoding = familyDescriptor.getDataBlockEncoding();
            if (encoding == null) {
                encoding = DataBlockEncoding.NONE;
            }
            dataBlockEncodingConfigValue.append(URLEncoder.encode(encoding.toString(), "UTF-8"));
        }
        return dataBlockEncodingConfigValue.toString();
    }

    public static void configureIncrementalLoad(Job job, List<TargetTableRef> tablesToBeLoaded) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputFormatClass(MultiHfileOutputFormat.class);
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), KeyValueSerialization.class.getName()});
        TreeSet tablesStartKeys = Sets.newTreeSet();
        for (TargetTableRef table : tablesToBeLoaded) {
            String tableName = table.getPhysicalName();
            HTable htable = new HTable(conf, tableName);
            Throwable throwable = null;
            try {
                Set<TableRowkeyPair> startKeys = MultiHfileOutputFormat.getRegionStartKeys(tableName, htable.getRegionLocator());
                tablesStartKeys.addAll(startKeys);
                String compressionConfig = MultiHfileOutputFormat.configureCompression(htable.getTableDescriptor());
                String bloomTypeConfig = MultiHfileOutputFormat.configureBloomType(htable.getTableDescriptor());
                String blockSizeConfig = MultiHfileOutputFormat.configureBlockSize(htable.getTableDescriptor());
                String blockEncodingConfig = MultiHfileOutputFormat.configureDataBlockEncoding(htable.getTableDescriptor());
                HashMap tableConfigs = Maps.newHashMap();
                if (StringUtils.isNotBlank((String)compressionConfig)) {
                    tableConfigs.put(COMPRESSION_FAMILIES_CONF_KEY, compressionConfig);
                }
                if (StringUtils.isNotBlank((String)bloomTypeConfig)) {
                    tableConfigs.put(BLOOM_TYPE_FAMILIES_CONF_KEY, bloomTypeConfig);
                }
                if (StringUtils.isNotBlank((String)blockSizeConfig)) {
                    tableConfigs.put(BLOCK_SIZE_FAMILIES_CONF_KEY, blockSizeConfig);
                }
                if (StringUtils.isNotBlank((String)blockEncodingConfig)) {
                    tableConfigs.put(DATABLOCK_ENCODING_FAMILIES_CONF_KEY, blockEncodingConfig);
                }
                table.setConfiguration(tableConfigs);
                String tableDefns = (String)TargetTableRefFunctions.TO_JSON.apply((Object)table);
                conf.set(tableName, tableDefns);
                TargetTableRef tbl = (TargetTableRef)TargetTableRefFunctions.FROM_JSON.apply((Object)tableDefns);
                LOG.info(" the table logical name is " + tbl.getLogicalName());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (htable == null) continue;
                if (throwable != null) {
                    try {
                        htable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                htable.close();
            }
        }
        LOG.info("Configuring " + tablesStartKeys.size() + " reduce partitions to match current region count");
        job.setNumReduceTasks(tablesStartKeys.size());
        MultiHfileOutputFormat.configurePartitioner(job, tablesStartKeys);
        TableMapReduceUtil.addDependencyJars((Job)job);
        TableMapReduceUtil.initCredentials((Job)job);
    }

    private static Set<TableRowkeyPair> getRegionStartKeys(String tableName, RegionLocator table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        TreeSet<TableRowkeyPair> ret = new TreeSet<TableRowkeyPair>();
        for (byte[] byteKey : byteKeys) {
            ret.add(new TableRowkeyPair(tableName, new ImmutableBytesWritable(byteKey)));
        }
        return ret;
    }

    static class WriterLength {
        long written = 0L;
        StoreFile.Writer writer = null;

        WriterLength() {
        }
    }
}

