/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSizeCalculator;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.mapreduce.PhoenixRecordReader;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.KeyRange;

public class PhoenixInputFormat<T extends DBWritable>
extends InputFormat<NullWritable, T> {
    private static final Log LOG = LogFactory.getLog(PhoenixInputFormat.class);

    public RecordReader<NullWritable, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        QueryPlan queryPlan = this.getQueryPlan((JobContext)context, configuration);
        Class<?> inputClass = PhoenixConfigurationUtil.getInputClass(configuration);
        return new PhoenixRecordReader(inputClass, configuration, queryPlan);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        QueryPlan queryPlan = this.getQueryPlan(context, configuration);
        List<KeyRange> allSplits = queryPlan.getSplits();
        List<InputSplit> splits = this.generateSplits(queryPlan, allSplits, configuration);
        return splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InputSplit> generateSplits(QueryPlan qplan, List<KeyRange> splits, Configuration config) throws IOException {
        Preconditions.checkNotNull((Object)qplan);
        Preconditions.checkNotNull(splits);
        ArrayList psplits = Lists.newArrayListWithExpectedSize((int)splits.size());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)config);){
            RegionLocator regionLocator = connection.getRegionLocator(TableName.valueOf((String)qplan.getTableRef().getTable().getPhysicalName().toString()));
            RegionSizeCalculator sizeCalculator = new RegionSizeCalculator(regionLocator, connection.getAdmin());
            for (List<Scan> scans : qplan.getScans()) {
                HRegionLocation location = regionLocator.getRegionLocation(scans.get(0).getStartRow(), false);
                String regionLocation = location.getHostname();
                long regionSize = sizeCalculator.getRegionSize(location.getRegionInfo().getRegionName());
                boolean splitByStats = PhoenixConfigurationUtil.getSplitByStats(config);
                if (splitByStats) {
                    for (Scan aScan : scans) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Split for  scan : " + aScan + "with scanAttribute : " + aScan.getAttributesMap() + " [scanCache, cacheBlock, scanBatch] : [" + aScan.getCaching() + ", " + aScan.getCacheBlocks() + ", " + aScan.getBatch() + "] and  regionLocation : " + regionLocation));
                        }
                        psplits.add(new PhoenixInputSplit(Collections.singletonList(aScan), regionSize, regionLocation));
                    }
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Scan count[" + scans.size() + "] : " + Bytes.toStringBinary((byte[])scans.get(0).getStartRow()) + " ~ " + Bytes.toStringBinary((byte[])scans.get(scans.size() - 1).getStopRow())));
                    LOG.debug((Object)("First scan : " + scans.get(0) + "with scanAttribute : " + scans.get(0).getAttributesMap() + " [scanCache, cacheBlock, scanBatch] : [" + scans.get(0).getCaching() + ", " + scans.get(0).getCacheBlocks() + ", " + scans.get(0).getBatch() + "] and  regionLocation : " + regionLocation));
                    int limit = scans.size();
                    for (int i = 0; i < limit; ++i) {
                        LOG.debug((Object)("EXPECTED_UPPER_REGION_KEY[" + i + "] : " + Bytes.toStringBinary((byte[])scans.get(i).getAttribute("_ExpectedUpperRegionKey"))));
                    }
                }
                psplits.add(new PhoenixInputSplit(scans, regionSize, regionLocation));
            }
        }
        return psplits;
    }

    private QueryPlan getQueryPlan(JobContext context, Configuration configuration) throws IOException {
        Preconditions.checkNotNull((Object)context);
        try {
            String snapshotName;
            String txnScnValue = configuration.get("phoenix.mr.txscn.value");
            String currentScnValue = configuration.get("phoenix.mr.currentscn.value");
            Properties overridingProps = new Properties();
            if (txnScnValue == null && currentScnValue != null) {
                overridingProps.put("CurrentSCN", currentScnValue);
            }
            java.sql.Connection connection = ConnectionUtil.getInputConnection(configuration, overridingProps);
            String selectStatement = PhoenixConfigurationUtil.getSelectStatement(configuration);
            Preconditions.checkNotNull((Object)selectStatement);
            Statement statement = connection.createStatement();
            PhoenixStatement pstmt = statement.unwrap(PhoenixStatement.class);
            QueryPlan queryPlan = pstmt.optimizeQuery(selectStatement);
            Scan scan = queryPlan.getContext().getScan();
            if (txnScnValue != null) {
                scan.setAttribute("_TxScn", Bytes.toBytes((long)Long.valueOf(txnScnValue)));
            }
            if ((snapshotName = configuration.get("phoenix.mapreduce.snapshot.name")) != null) {
                PhoenixConfigurationUtil.setSnapshotNameKey(queryPlan.getContext().getConnection().getQueryServices().getConfiguration(), snapshotName);
            }
            queryPlan.iterator(MapReduceParallelScanGrouper.getInstance());
            return queryPlan;
        }
        catch (Exception exception) {
            LOG.error((Object)String.format("Failed to get the query plan with error [%s]", exception.getMessage()));
            throw new RuntimeException(exception);
        }
    }
}

