/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import io.netty.util.internal.ConcurrentSet;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.PhoenixRpcSchedulerFactory;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReaderGenerator;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.coprocessor.GetRegionObserver;
import org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.coprocessor.PhoenixTransactionalProcessor;
import org.apache.phoenix.coprocessor.ScanRegionObserver;
import org.apache.phoenix.coprocessor.SequenceRegionObserver;
import org.apache.phoenix.coprocessor.ServerCachingEndpointImpl;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.RetriableUpgradeException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.exception.UpgradeInProgressException;
import org.apache.phoenix.exception.UpgradeNotRequiredException;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.IndexRegionSplitPolicy;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.index.PhoenixIndexBuilder;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.index.PhoenixTransactionalIndexer;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.log.QueryLoggerDisruptor;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.ChildQueryServices;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.GuidePostsCache;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.EmptySequenceCacheException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.MetaDataSplitPolicy;
import org.apache.phoenix.schema.NewerSchemaAlreadyExistsException;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PMetaDataImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PSynchronizedMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.ConfigUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixContextExecutor;
import org.apache.phoenix.util.PhoenixStopWatch;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.apache.twill.zookeeper.ZKClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionQueryServicesImpl
extends DelegateQueryServices
implements ConnectionQueryServices {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionQueryServicesImpl.class);
    private static final int INITIAL_CHILD_SERVICES_CAPACITY = 100;
    private static final int DEFAULT_OUT_OF_ORDER_MUTATIONS_WAIT_TIME_MS = 1000;
    private static final int TTL_FOR_MUTEX = 900;
    protected final Configuration config;
    private final PhoenixEmbeddedDriver.ConnectionInfo connectionInfo;
    private final ReadOnlyProps props;
    private final String userName;
    private final User user;
    private final ConcurrentHashMap<ImmutableBytesWritable, ConnectionQueryServices> childServices;
    private final GuidePostsCache tableStatsCache;
    private volatile PMetaData latestMetaData;
    private final Object latestMetaDataLock = new Object();
    private int lowestClusterHBaseVersion = Integer.MAX_VALUE;
    private boolean hasIndexWALCodec = true;
    @GuardedBy(value="connectionCountLock")
    private int connectionCount = 0;
    private final Object connectionCountLock = new Object();
    private final boolean returnSequenceValues;
    private HConnection connection;
    private ZKClientService txZKClientService;
    private volatile boolean initialized;
    private volatile int nSequenceSaltBuckets;
    private volatile boolean closed;
    private volatile SQLException initializationException;
    private volatile ConcurrentMap<SequenceKey, Sequence> sequenceMap = Maps.newConcurrentMap();
    private KeyValueBuilder kvBuilder;
    private final int renewLeaseTaskFrequency;
    private final int renewLeasePoolSize;
    private final int renewLeaseThreshold;
    private final List<LinkedBlockingQueue<WeakReference<PhoenixConnection>>> connectionQueues;
    private ScheduledExecutorService renewLeaseExecutor;
    private static final ThreadFactory renewLeaseThreadFactory = new RenewLeaseThreadFactory();
    private final boolean renewLeaseEnabled;
    private final boolean isAutoUpgradeEnabled;
    private final AtomicBoolean upgradeRequired = new AtomicBoolean(false);
    private final int maxConnectionsAllowed;
    private final boolean shouldThrottleNumConnections;
    public static final byte[] UPGRADE_MUTEX = "UPGRADE_MUTEX".getBytes();
    public static final byte[] UPGRADE_MUTEX_LOCKED = "UPGRADE_MUTEX_LOCKED".getBytes();
    public static final byte[] UPGRADE_MUTEX_UNLOCKED = "UPGRADE_MUTEX_UNLOCKED".getBytes();
    public final ConcurrentSet<TableName> loadedTable = new ConcurrentSet();
    private final Map<ConnectionQueryServices.Feature, FeatureSupported> featureMap = ImmutableMap.of((Object)((Object)ConnectionQueryServices.Feature.LOCAL_INDEX), (Object)new FeatureSupported(){

        @Override
        public boolean isSupported(ConnectionQueryServices services) {
            int hbaseVersion = services.getLowestClusterHBaseVersion();
            return hbaseVersion < MetaDataProtocol.MIN_LOCAL_SI_VERSION_DISALLOW || hbaseVersion > MetaDataProtocol.MAX_LOCAL_SI_VERSION_DISALLOW;
        }
    }, (Object)((Object)ConnectionQueryServices.Feature.RENEW_LEASE), (Object)new FeatureSupported(){

        @Override
        public boolean isSupported(ConnectionQueryServices services) {
            int hbaseVersion = services.getLowestClusterHBaseVersion();
            return hbaseVersion >= MetaDataProtocol.MIN_RENEW_LEASE_VERSION;
        }
    });
    private QueryLoggerDisruptor queryDisruptor;
    private static final String TRUE_BYTES_AS_STRING = Bytes.toString((byte[])PDataType.TRUE_BYTES);

    private PMetaData newEmptyMetaData() {
        return new PSynchronizedMetaData(new PMetaDataImpl(100, this.getProps()));
    }

    public ConnectionQueryServicesImpl(QueryServices services, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo, Properties info) {
        super(services);
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        for (Map.Entry entry : services.getProps()) {
            config.set(entry.getKey(), entry.getValue());
        }
        if (info != null) {
            for (Object key : info.keySet()) {
                config.set((String)key, info.getProperty((String)key));
            }
        }
        for (Map.Entry entry : connectionInfo.asProps()) {
            config.set((String)entry.getKey(), (String)entry.getValue());
        }
        this.connectionInfo = connectionInfo;
        this.config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration(config);
        ConfigUtil.setReplicationConfigIfAbsent(this.config);
        this.props = new ReadOnlyProps(this.config.iterator());
        this.userName = connectionInfo.getPrincipal();
        this.user = connectionInfo.getUser();
        this.latestMetaData = this.newEmptyMetaData();
        this.childServices = new ConcurrentHashMap(100);
        String hbaseVersion = VersionInfo.getVersion();
        this.kvBuilder = KeyValueBuilder.get(hbaseVersion);
        this.returnSequenceValues = this.props.getBoolean("phoenix.sequence.returnValues", false);
        this.renewLeaseEnabled = config.getBoolean("phoenix.scanner.lease.renew.enabled", true);
        this.renewLeasePoolSize = config.getInt("phoenix.scanner.lease.pool.size", 10);
        this.renewLeaseThreshold = config.getInt("phoenix.scanner.lease.threshold", 45000);
        this.renewLeaseTaskFrequency = config.getInt("phoenix.scanner.lease.renew.interval", 30000);
        ArrayList list = Lists.newArrayListWithCapacity((int)this.renewLeasePoolSize);
        for (int i = 0; i < this.renewLeasePoolSize; ++i) {
            LinkedBlockingQueue queue = new LinkedBlockingQueue();
            list.add(queue);
        }
        this.connectionQueues = ImmutableList.copyOf((Collection)list);
        this.tableStatsCache = new GuidePostsCache(this, config);
        this.isAutoUpgradeEnabled = config.getBoolean("phoenix.autoupgrade.enabled", true);
        this.maxConnectionsAllowed = config.getInt("phoenix.client.connection.max.allowed.connections", 0);
        this.shouldThrottleNumConnections = this.maxConnectionsAllowed > 0;
        try {
            this.queryDisruptor = new QueryLoggerDisruptor(this.config);
        }
        catch (SQLException e) {
            logger.warn("Unable to initiate qeuery logging service !!");
            e.printStackTrace();
        }
    }

    private void initTxServiceClient() {
        this.txZKClientService = TransactionFactory.getTransactionFactory().getTransactionContext().setTransactionClient(this.config, this.props, this.connectionInfo);
    }

    private void openConnection() throws SQLException {
        try {
            boolean transactionsEnabled = this.props.getBoolean("phoenix.transactions.enabled", false);
            this.connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(this.config);
            GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.increment();
            logger.info("HConnection established. Stacktrace for informational purposes: " + this.connection);
            if (transactionsEnabled) {
                this.initTxServiceClient();
            }
        }
        catch (IOException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setRootCause(e).build().buildException();
        }
        if (this.connection.isClosed()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).build().buildException();
        }
    }

    @Override
    public HTableInterface getTable(byte[] tableName) throws SQLException {
        try {
            return HBaseFactoryProvider.getHTableFactory().getTable(tableName, this.connection, null);
        }
        catch (org.apache.hadoop.hbase.TableNotFoundException e) {
            throw new TableNotFoundException(SchemaUtil.getSchemaNameFromFullName(tableName), SchemaUtil.getTableNameFromFullName(tableName));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public HTableDescriptor getTableDescriptor(byte[] tableName) throws SQLException {
        HTableInterface htable = this.getTable(tableName);
        try {
            HTableDescriptor hTableDescriptor = htable.getTableDescriptor();
            return hTableDescriptor;
        }
        catch (IOException e) {
            if (e instanceof org.apache.hadoop.hbase.TableNotFoundException || e.getCause() instanceof org.apache.hadoop.hbase.TableNotFoundException) {
                byte[][] schemaAndTableName = new byte[2][];
                SchemaUtil.getVarChars(tableName, schemaAndTableName);
                throw new TableNotFoundException(Bytes.toString((byte[])schemaAndTableName[0]), Bytes.toString((byte[])schemaAndTableName[1]));
            }
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)htable);
        }
    }

    @Override
    public ReadOnlyProps getProps() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        ConnectionQueryServicesImpl connectionQueryServicesImpl = this;
        synchronized (connectionQueryServicesImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.decrement();
            try {
                if (this.queryDisruptor != null) {
                    this.queryDisruptor.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            SQLException sqlE = null;
            try {
                if (this.connection == null) return;
                this.returnAllSequences(this.sequenceMap);
            }
            catch (SQLException e) {
                sqlE = e;
            }
            finally {
                try {
                    block80: {
                        this.childServices.clear();
                        Object e = this.latestMetaDataLock;
                        synchronized (e) {
                            this.latestMetaData = null;
                            this.latestMetaDataLock.notifyAll();
                        }
                        try {
                            if (this.connection != null) {
                                this.connection.close();
                            }
                            GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.decrement();
                            if (this.renewLeaseExecutor == null) break block80;
                        }
                        catch (Throwable throwable) {
                            if (this.renewLeaseExecutor != null) {
                                this.renewLeaseExecutor.shutdownNow();
                            }
                            if (this.txZKClientService == null) throw throwable;
                            this.txZKClientService.stopAndWait();
                            throw throwable;
                        }
                        this.renewLeaseExecutor.shutdownNow();
                    }
                    if (this.txZKClientService != null) {
                        this.txZKClientService.stopAndWait();
                    }
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                finally {
                    try {
                        this.tableStatsCache.invalidateAll();
                        super.close();
                    }
                    catch (SQLException e) {
                        if (sqlE == null) {
                            sqlE = e;
                        }
                        sqlE.setNextException(e);
                    }
                    finally {
                        if (sqlE == null) return;
                        throw sqlE;
                    }
                }
            }
            return;
        }
    }

    protected ConnectionQueryServices newChildQueryService() {
        return new ChildQueryServices(this);
    }

    @Override
    public ConnectionQueryServices getChildQueryServices(ImmutableBytesWritable tenantId) {
        ConnectionQueryServices childQueryService = this.childServices.get(tenantId);
        if (childQueryService == null) {
            childQueryService = this.newChildQueryService();
            ConnectionQueryServices prevQueryService = this.childServices.putIfAbsent(tenantId, childQueryService);
            return prevQueryService == null ? childQueryService : prevQueryService;
        }
        return childQueryService;
    }

    @Override
    public void clearTableRegionCache(byte[] tableName) throws SQLException {
        TableName name = TableName.valueOf((byte[])tableName);
        this.loadedTable.remove((Object)name);
        this.connection.clearRegionCache(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HRegionLocation> getAllTableRegions(byte[] tableName) throws SQLException {
        int retryCount = 0;
        int maxRetryCount = 1;
        boolean reload = false;
        TableName name = TableName.valueOf((byte[])tableName);
        ClusterConnection clusterConn = (ClusterConnection)this.connection;
        while (true) {
            try {
                ArrayList<HRegionLocation> locations;
                if (this.loadedTable.contains((Object)name)) {
                    HRegionLocation regionLocation;
                    locations = new ArrayList<HRegionLocation>();
                    byte[] currentKey = HConstants.EMPTY_START_ROW;
                    do {
                        regionLocation = clusterConn.getRegionLocation(name, currentKey, reload);
                        locations.add(regionLocation);
                    } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW));
                } else {
                    ConcurrentSet<TableName> currentKey = this.loadedTable;
                    synchronized (currentKey) {
                        this.loadedTable.add((Object)name);
                        clusterConn.getConfiguration().setInt("hbase.meta.scanner.caching", 200);
                        RegionLocator regionLocator = clusterConn.getRegionLocator(name);
                        locations = regionLocator.getAllRegionLocations();
                    }
                    if (locations.size() > 0) {
                        this.asyncCacheMeta(name, clusterConn, locations);
                    } else {
                        throw new TableNotFoundException(name.getNameAsString());
                    }
                }
                return locations;
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                throw new TableNotFoundException(name.getNameAsString());
            }
            catch (IOException e) {
                if (retryCount++ < maxRetryCount) {
                    reload = true;
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).setRootCause(e).build().buildException();
            }
            break;
        }
    }

    private void asyncCacheMeta(final TableName name, final ClusterConnection clusterConn, final List<HRegionLocation> locations) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                clusterConn.clearRegionCache();
                for (HRegionLocation rl : locations) {
                    clusterConn.cacheLocation(name, new RegionLocations(new HRegionLocation[]{rl}));
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTable(PTable table, long resolvedTime) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            try {
                this.throwConnectionClosedIfNullMetaData();
                PTable existingTable = this.latestMetaData.getTableRef(new PTableKey(table.getTenantId(), table.getName().getString())).getTable();
                if (existingTable.getTimeStamp() >= table.getTimeStamp()) {
                    return;
                }
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            this.latestMetaData.addTable(table, resolvedTime);
            this.latestMetaDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResolvedTimestamp(PTable table, long resolvedTime) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData.updateResolvedTimestamp(table, resolvedTime);
            this.latestMetaDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PMetaData metaDataMutated(PName tenantId, String tableName, long tableSeqNum, Mutator mutator) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            PMetaData metaData = this.latestMetaData;
            long endTime = System.currentTimeMillis() + 1000L;
            try {
                while (true) {
                    long waitTime;
                    block11: {
                        try {
                            PTable table = metaData.getTableRef(new PTableKey(tenantId, tableName)).getTable();
                            if (table.getSequenceNumber() + 1L == tableSeqNum) {
                                mutator.mutate(metaData);
                                break;
                            }
                            if (table.getSequenceNumber() < tableSeqNum) break block11;
                            logger.warn("Attempt to cache older version of " + tableName + ": current= " + table.getSequenceNumber() + ", new=" + tableSeqNum);
                            break;
                        }
                        catch (TableNotFoundException tableNotFoundException) {
                            // empty catch block
                        }
                    }
                    if ((waitTime = endTime - System.currentTimeMillis()) <= 0L) {
                        logger.warn("Unable to update meta data repo within 1 seconds for " + tableName);
                        metaData.removeTable(tenantId, tableName, null, Long.MAX_VALUE);
                        break;
                    }
                    this.latestMetaDataLock.wait(waitTime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            this.latestMetaData = metaData;
            this.latestMetaDataLock.notifyAll();
            return metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData.removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
            this.latestMetaDataLock.notifyAll();
        }
    }

    @Override
    public void removeColumn(final PName tenantId, final String tableName, final List<PColumn> columnsToRemove, final long tableTimeStamp, final long tableSeqNum, final long resolvedTime) throws SQLException {
        this.metaDataMutated(tenantId, tableName, tableSeqNum, new Mutator(){

            @Override
            public void mutate(PMetaData metaData) throws SQLException {
                try {
                    metaData.removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum, resolvedTime);
                }
                catch (TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public PhoenixConnection connect(String url, Properties info) throws SQLException {
        this.checkClosed();
        PMetaData metadata = this.latestMetaData;
        this.throwConnectionClosedIfNullMetaData();
        metadata = metadata.clone();
        return new PhoenixConnection(this, url, info, metadata);
    }

    private HColumnDescriptor generateColumnFamilyDescriptor(Pair<byte[], Map<String, Object>> family, PTableType tableType) throws SQLException {
        HColumnDescriptor columnDesc = new HColumnDescriptor((byte[])family.getFirst());
        if (tableType != PTableType.VIEW) {
            columnDesc.setDataBlockEncoding(SchemaUtil.DEFAULT_DATA_BLOCK_ENCODING);
            if (tableType == PTableType.TABLE || tableType == PTableType.INDEX) {
                columnDesc.setBloomFilterType(BloomType.ROW);
            } else {
                columnDesc.setBloomFilterType(BloomType.NONE);
            }
            for (Map.Entry entry : ((Map)family.getSecond()).entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                ConnectionQueryServicesImpl.setHColumnDescriptorValue(columnDesc, key, value);
            }
        }
        return columnDesc;
    }

    private static void setHColumnDescriptorValue(HColumnDescriptor columnDesc, String key, Object value) {
        if ("VERSIONS".equals(key)) {
            columnDesc.setMaxVersions(ConnectionQueryServicesImpl.getMaxVersion(value));
        } else {
            columnDesc.setValue(key, value == null ? null : value.toString());
        }
    }

    private static int getMaxVersion(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String stringValue = value.toString();
        if (stringValue.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(stringValue);
    }

    private void modifyColumnFamilyDescriptor(HColumnDescriptor hcd, Map<String, Object> props) throws SQLException {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String propName = entry.getKey();
            Object value = entry.getValue();
            ConnectionQueryServicesImpl.setHColumnDescriptorValue(hcd, propName, value);
        }
    }

    private HTableDescriptor generateTableDescriptor(byte[] physicalTableName, HTableDescriptor existingDesc, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean isNamespaceMapped) throws SQLException {
        String defaultFamilyName = (String)tableProps.remove("DEFAULT_COLUMN_FAMILY");
        HTableDescriptor tableDescriptor = existingDesc != null ? new HTableDescriptor(existingDesc) : new HTableDescriptor(physicalTableName);
        for (Map.Entry<String, Object> entry : tableProps.entrySet()) {
            String key = entry.getKey();
            if (TableProperty.isPhoenixTableProperty(key)) continue;
            Object value = entry.getValue();
            tableDescriptor.setValue(key, value == null ? null : value.toString());
        }
        if (families.isEmpty()) {
            if (tableType != PTableType.VIEW) {
                byte[] defaultFamilyByes = defaultFamilyName == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : Bytes.toBytes((String)defaultFamilyName);
                HColumnDescriptor hColumnDescriptor = this.generateColumnFamilyDescriptor((Pair<byte[], Map<String, Object>>)new Pair((Object)defaultFamilyByes, Collections.emptyMap()), tableType);
                tableDescriptor.addFamily(hColumnDescriptor);
            }
        } else {
            for (Pair pair : families) {
                HColumnDescriptor columnDescriptor;
                byte[] familyByte = (byte[])pair.getFirst();
                if (tableDescriptor.getFamily(familyByte) == null) {
                    if (tableType == PTableType.VIEW) {
                        String fullTableName = Bytes.toString((byte[])physicalTableName);
                        throw new ReadOnlyTableException("The HBase column families for a read-only table must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName), Bytes.toString((byte[])familyByte));
                    }
                    columnDescriptor = this.generateColumnFamilyDescriptor((Pair<byte[], Map<String, Object>>)pair, tableType);
                    tableDescriptor.addFamily(columnDescriptor);
                    continue;
                }
                if (tableType == PTableType.VIEW) continue;
                columnDescriptor = tableDescriptor.getFamily(familyByte);
                if (columnDescriptor == null) {
                    throw new IllegalArgumentException("Unable to find column descriptor with family name " + Bytes.toString((byte[])((byte[])pair.getFirst())));
                }
                this.modifyColumnFamilyDescriptor(columnDescriptor, (Map)pair.getSecond());
            }
        }
        this.addCoprocessors(physicalTableName, tableDescriptor, tableType, tableProps);
        if (tableType == PTableType.SYSTEM) {
            tableDescriptor.setValue("PRIORITY", String.valueOf(PhoenixRpcSchedulerFactory.getMetadataPriority(this.config)));
        } else if (tableType == PTableType.INDEX && !this.isLocalIndexTable(tableDescriptor.getFamiliesKeys()) && !Boolean.TRUE.equals(tableProps.get("IMMUTABLE_ROWS"))) {
            tableDescriptor.setValue("PRIORITY", String.valueOf(PhoenixRpcSchedulerFactory.getIndexPriority(this.config)));
        }
        return tableDescriptor;
    }

    private boolean isLocalIndexTable(Collection<byte[]> families) {
        for (byte[] family : families) {
            if (!Bytes.toString((byte[])family).startsWith("L#")) continue;
            return true;
        }
        return false;
    }

    private void addCoprocessors(byte[] tableName, HTableDescriptor descriptor, PTableType tableType, Map<String, Object> tableProps) throws SQLException {
        int priority = this.props.getInt("phoenix.coprocessor.priority", 0x2FFFFFFE);
        try {
            boolean isTransactional;
            if (!descriptor.hasCoprocessor(GetRegionObserver.class.getName())) {
                descriptor.addCoprocessor(GetRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(ScanRegionObserver.class.getName())) {
                descriptor.addCoprocessor(ScanRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(UngroupedAggregateRegionObserver.class.getName())) {
                descriptor.addCoprocessor(UngroupedAggregateRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(GroupedAggregateRegionObserver.class.getName())) {
                descriptor.addCoprocessor(GroupedAggregateRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(ServerCachingEndpointImpl.class.getName())) {
                descriptor.addCoprocessor(ServerCachingEndpointImpl.class.getName(), null, priority, null);
            }
            boolean bl = isTransactional = Boolean.TRUE.equals(tableProps.get(TableProperty.TRANSACTIONAL.name())) || Boolean.TRUE.equals(tableProps.get("data.tx.read.pre.existing"));
            if (tableType != PTableType.INDEX && tableType != PTableType.VIEW && !SchemaUtil.isMetaTable(tableName) && !SchemaUtil.isStatsTable(tableName)) {
                if (isTransactional) {
                    if (!descriptor.hasCoprocessor(PhoenixTransactionalIndexer.class.getName())) {
                        descriptor.addCoprocessor(PhoenixTransactionalIndexer.class.getName(), null, priority, null);
                    }
                    if (descriptor.hasCoprocessor(Indexer.class.getName())) {
                        descriptor.removeCoprocessor(Indexer.class.getName());
                    }
                } else if (!descriptor.hasCoprocessor(Indexer.class.getName())) {
                    if (descriptor.hasCoprocessor(PhoenixTransactionalIndexer.class.getName())) {
                        descriptor.removeCoprocessor(PhoenixTransactionalIndexer.class.getName());
                    }
                    HashMap opts = Maps.newHashMapWithExpectedSize((int)1);
                    opts.put("org.apache.hadoop.hbase.index.codec.class", PhoenixIndexCodec.class.getName());
                    Indexer.enableIndexing(descriptor, PhoenixIndexBuilder.class, opts, priority);
                }
            }
            if (SchemaUtil.isStatsTable(tableName) && !descriptor.hasCoprocessor(MultiRowMutationEndpoint.class.getName())) {
                descriptor.addCoprocessor(MultiRowMutationEndpoint.class.getName(), null, priority, null);
            }
            Set familiesKeys = descriptor.getFamiliesKeys();
            for (byte[] family : familiesKeys) {
                if (!Bytes.toString((byte[])family).startsWith("L#") || descriptor.hasCoprocessor(IndexHalfStoreFileReaderGenerator.class.getName())) continue;
                descriptor.addCoprocessor(IndexHalfStoreFileReaderGenerator.class.getName(), null, priority, null);
                break;
            }
            if (SchemaUtil.isMetaTable(tableName) || SchemaUtil.isFunctionTable(tableName)) {
                if (!descriptor.hasCoprocessor(MetaDataEndpointImpl.class.getName())) {
                    descriptor.addCoprocessor(MetaDataEndpointImpl.class.getName(), null, priority, null);
                }
                if (SchemaUtil.isMetaTable(tableName) && !descriptor.hasCoprocessor(MetaDataRegionObserver.class.getName())) {
                    descriptor.addCoprocessor(MetaDataRegionObserver.class.getName(), null, priority + 1, null);
                }
            } else if (SchemaUtil.isSequenceTable(tableName) && !descriptor.hasCoprocessor(SequenceRegionObserver.class.getName())) {
                descriptor.addCoprocessor(SequenceRegionObserver.class.getName(), null, priority, null);
            }
            if (isTransactional) {
                if (!descriptor.hasCoprocessor(PhoenixTransactionalProcessor.class.getName())) {
                    descriptor.addCoprocessor(PhoenixTransactionalProcessor.class.getName(), null, priority - 10, null);
                }
            } else if (descriptor.hasCoprocessor(PhoenixTransactionalProcessor.class.getName())) {
                descriptor.removeCoprocessor(PhoenixTransactionalProcessor.class.getName());
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    private void pollForUpdatedTableDescriptor(final HBaseAdmin admin, final HTableDescriptor newTableDescriptor, final byte[] tableName) throws InterruptedException, TimeoutException {
        this.checkAndRetry(new RetriableOperation(){

            @Override
            public String getOperationName() {
                return "UpdateOrNewTableDescriptor";
            }

            @Override
            public boolean checkForCompletion() throws TimeoutException, IOException {
                HTableDescriptor tableDesc = admin.getTableDescriptor(tableName);
                return newTableDescriptor.equals((Object)tableDesc);
            }
        });
    }

    private void checkAndRetry(RetriableOperation op) throws InterruptedException, TimeoutException {
        int maxRetries = this.props.getInt("phoenix.schema.change.retries", 10);
        long sleepInterval = this.props.getLong("phoenix.schema.change.delay", 5000L);
        boolean success = false;
        int numTries = 1;
        PhoenixStopWatch watch = new PhoenixStopWatch();
        watch.start();
        do {
            block5: {
                try {
                    success = op.checkForCompletion();
                }
                catch (Exception ex) {
                    if (numTries != 1 && numTries != maxRetries) break block5;
                    watch.stop();
                    TimeoutException toThrow = new TimeoutException("Operation " + op.getOperationName() + " didn't complete because of exception. Time elapsed: " + watch.elapsedMillis());
                    toThrow.initCause(ex);
                    throw toThrow;
                }
            }
            Thread.sleep(sleepInterval);
        } while (++numTries < maxRetries && !success);
        watch.stop();
        if (!success) {
            throw new TimeoutException("Operation  " + op.getOperationName() + " didn't complete within " + watch.elapsedMillis() + " ms " + (numTries > 1 ? "after trying " + numTries + (numTries > 1 ? "times." : "time.") : ""));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Operation " + op.getOperationName() + " completed within " + watch.elapsedMillis() + "ms " + (numTries > 1 ? "after trying " + numTries + (numTries > 1 ? "times." : "time.") : ""));
        }
    }

    private boolean allowOnlineTableSchemaUpdate() {
        return this.props.getBoolean("hbase.online.schema.update.enable", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void ensureNamespaceCreated(String schemaName) throws SQLException {
        SQLException sqlE = null;
        try {
            Throwable throwable;
            HBaseAdmin admin;
            block22: {
                block23: {
                    admin = this.getAdmin();
                    throwable = null;
                    NamespaceDescriptor namespaceDescriptor = null;
                    try {
                        namespaceDescriptor = admin.getNamespaceDescriptor(schemaName);
                    }
                    catch (NamespaceNotFoundException namespaceNotFoundException) {
                        // empty catch block
                    }
                    if (namespaceDescriptor == null) {
                        namespaceDescriptor = NamespaceDescriptor.create((String)schemaName).build();
                        admin.createNamespace(namespaceDescriptor);
                    }
                    if (admin == null) break block22;
                    if (throwable == null) break block23;
                    try {
                        admin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block22;
                }
                admin.close();
            }
            return;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (admin != null) {
                            if (throwable != null) {
                                try {
                                    admin.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                admin.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                    if (sqlE != null) {
                        throw sqlE;
                    }
                }
            }
        }
        finally {
            if (sqlE != null) {
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HTableDescriptor ensureTableCreated(byte[] physicalTableName, PTableType tableType, Map<String, Object> props, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean modifyExistingMetaData, boolean isNamespaceMapped) throws SQLException {
        block69: {
            SQLException sqlE = null;
            HTableDescriptor existingDesc = null;
            boolean isMetaTable = SchemaUtil.isMetaTable(physicalTableName);
            boolean tableExist = true;
            try {
                HTableDescriptor hTableDescriptor;
                Throwable throwable;
                HBaseAdmin admin;
                block67: {
                    block68: {
                        HTableDescriptor newDesc;
                        block64: {
                            block65: {
                                block66: {
                                    block61: {
                                        HTableDescriptor e22222222;
                                        block62: {
                                            block63: {
                                                block58: {
                                                    HTableDescriptor e22222222;
                                                    block59: {
                                                        block60: {
                                                            block57: {
                                                                admin = this.getAdmin();
                                                                throwable = null;
                                                                String quorum = ZKConfig.getZKQuorumServersString((Configuration)this.config);
                                                                String znode = this.props.get("zookeeper.znode.parent");
                                                                logger.debug("Found quorum: " + quorum + ":" + znode);
                                                                try {
                                                                    existingDesc = admin.getTableDescriptor(physicalTableName);
                                                                }
                                                                catch (org.apache.hadoop.hbase.TableNotFoundException e3) {
                                                                    tableExist = false;
                                                                    if (tableType != PTableType.VIEW) break block57;
                                                                    String fullTableName = Bytes.toString((byte[])physicalTableName);
                                                                    throw new ReadOnlyTableException("An HBase table for a VIEW must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName));
                                                                }
                                                            }
                                                            newDesc = this.generateTableDescriptor(physicalTableName, existingDesc, tableType, props, families, splits, isNamespaceMapped);
                                                            if (tableExist) break block58;
                                                            if (newDesc.getValue(MetaDataUtil.IS_LOCAL_INDEX_TABLE_PROP_BYTES) != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(newDesc.getValue(MetaDataUtil.IS_LOCAL_INDEX_TABLE_PROP_BYTES)))) {
                                                                newDesc.setValue("SPLIT_POLICY", IndexRegionSplitPolicy.class.getName());
                                                            }
                                                            if (isMetaTable) {
                                                                newDesc.remove("SPLIT_POLICY");
                                                            }
                                                            try {
                                                                if (splits == null) {
                                                                    admin.createTable(newDesc);
                                                                } else {
                                                                    admin.createTable(newDesc, splits);
                                                                }
                                                            }
                                                            catch (TableExistsException e22222222) {
                                                                HTableDescriptor hTableDescriptor2 = null;
                                                                if (admin != null) {
                                                                    if (throwable != null) {
                                                                        try {
                                                                            admin.close();
                                                                        }
                                                                        catch (Throwable throwable2) {
                                                                            throwable.addSuppressed(throwable2);
                                                                        }
                                                                    } else {
                                                                        admin.close();
                                                                    }
                                                                }
                                                                if (sqlE != null) {
                                                                    throw sqlE;
                                                                }
                                                                return hTableDescriptor2;
                                                            }
                                                            if (isMetaTable) {
                                                                this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                                                newDesc.setValue("SPLIT_POLICY", MetaDataSplitPolicy.class.getName());
                                                                this.modifyTable(physicalTableName, newDesc, true);
                                                            }
                                                            e22222222 = null;
                                                            if (admin == null) break block59;
                                                            if (throwable == null) break block60;
                                                            try {
                                                                admin.close();
                                                            }
                                                            catch (Throwable throwable3) {
                                                                throwable.addSuppressed(throwable3);
                                                            }
                                                            break block59;
                                                        }
                                                        admin.close();
                                                    }
                                                    return e22222222;
                                                }
                                                if (isMetaTable) {
                                                    this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                                } else {
                                                    for (Pair<byte[], Map<String, Object>> family : families) {
                                                        if (newDesc.getValue("SPLIT_POLICY") != null && newDesc.getValue("SPLIT_POLICY").equals(IndexRegionSplitPolicy.class.getName()) || !Bytes.toString((byte[])((byte[])family.getFirst())).startsWith("L#")) continue;
                                                        newDesc.setValue("SPLIT_POLICY", IndexRegionSplitPolicy.class.getName());
                                                        break;
                                                    }
                                                }
                                                if (modifyExistingMetaData) break block61;
                                                e22222222 = existingDesc;
                                                if (admin == null) break block62;
                                                if (throwable == null) break block63;
                                                try {
                                                    admin.close();
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable.addSuppressed(throwable4);
                                                }
                                                break block62;
                                            }
                                            admin.close();
                                        }
                                        return e22222222;
                                    }
                                    boolean willBeTx = Boolean.TRUE.equals(props.get(TableProperty.TRANSACTIONAL.name()));
                                    if (willBeTx) {
                                        newDesc.setValue("data.tx.read.pre.existing", Boolean.TRUE.toString());
                                    } else {
                                        if (existingDesc.hasCoprocessor(PhoenixTransactionalProcessor.class.getName())) {
                                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MAY_NOT_SWITCH_TO_NON_TX).setSchemaName(SchemaUtil.getSchemaNameFromFullName(physicalTableName)).setTableName(SchemaUtil.getTableNameFromFullName(physicalTableName)).build().buildException();
                                        }
                                        newDesc.remove("data.tx.read.pre.existing");
                                    }
                                    if (!existingDesc.equals((Object)newDesc)) break block64;
                                    hTableDescriptor = null;
                                    if (admin == null) break block65;
                                    if (throwable == null) break block66;
                                    try {
                                        admin.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                    break block65;
                                }
                                admin.close();
                            }
                            return hTableDescriptor;
                        }
                        this.modifyTable(physicalTableName, newDesc, true);
                        hTableDescriptor = newDesc;
                        if (admin == null) break block67;
                        if (throwable == null) break block68;
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        break block67;
                    }
                    admin.close();
                }
                return hTableDescriptor;
                catch (Throwable throwable7) {
                    try {
                        try {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            if (admin != null) {
                                if (throwable != null) {
                                    try {
                                        admin.close();
                                    }
                                    catch (Throwable throwable9) {
                                        throwable.addSuppressed(throwable9);
                                    }
                                } else {
                                    admin.close();
                                }
                            }
                            throw throwable8;
                        }
                    }
                    catch (IOException e) {
                        sqlE = ServerUtil.parseServerException(e);
                        if (sqlE != null) {
                            throw sqlE;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                        return sqlE;
                    }
                    catch (TimeoutException e) {
                        sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setRootCause(e.getCause() != null ? e.getCause() : e).build().buildException();
                        return sqlE;
                    }
                }
            }
            finally {
                if (sqlE == null) break block69;
                throw sqlE;
            }
        }
        return null;
    }

    private void modifyTable(byte[] tableName, HTableDescriptor newDesc, boolean shouldPoll) throws IOException, InterruptedException, TimeoutException, SQLException {
        try (HBaseAdmin admin = this.getAdmin();){
            if (!this.allowOnlineTableSchemaUpdate()) {
                admin.disableTable(tableName);
                admin.modifyTable(tableName, newDesc);
                admin.enableTable(tableName);
            } else {
                admin.modifyTable(tableName, newDesc);
                if (shouldPoll) {
                    this.pollForUpdatedTableDescriptor(admin, newDesc, tableName);
                }
            }
        }
    }

    private static boolean hasIndexWALCodec(Long serverVersion) {
        if (serverVersion == null) {
            return true;
        }
        return MetaDataUtil.decodeHasIndexWALCodec(serverVersion);
    }

    private static boolean isCompatible(Long serverVersion) {
        if (serverVersion == null) {
            return false;
        }
        return MetaDataUtil.areClientAndServerCompatible(serverVersion);
    }

    private void checkClientServerCompatibility(byte[] metaTable) throws SQLException {
        StringBuilder buf = new StringBuilder("Newer Phoenix clients can't communicate with older Phoenix servers. The following servers require an updated phoenix-[version]-server.jar to be put in the classpath of HBase: ");
        boolean isIncompatible = false;
        int minHBaseVersion = Integer.MAX_VALUE;
        boolean isTableNamespaceMappingEnabled = false;
        HTableInterface ht = null;
        try {
            List<HRegionLocation> locations = this.getAllTableRegions(metaTable);
            HashSet serverMap = Sets.newHashSetWithExpectedSize((int)locations.size());
            TreeMap regionMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
            ArrayList regionKeys = Lists.newArrayListWithExpectedSize((int)locations.size());
            for (HRegionLocation entry : locations) {
                if (serverMap.contains(entry)) continue;
                regionKeys.add(entry.getRegionInfo().getStartKey());
                regionMap.put(entry.getRegionInfo().getRegionName(), entry);
                serverMap.add(entry);
            }
            ht = this.getTable(metaTable);
            Map results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, null, null, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, Long>(){

                public Long call(MetaDataProtos.MetaDataService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                    MetaDataProtos.GetVersionRequest.Builder builder = MetaDataProtos.GetVersionRequest.newBuilder();
                    builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                    instance.getVersion((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.GetVersionResponse>)rpcCallback);
                    if (controller.getFailedOn() != null) {
                        throw controller.getFailedOn();
                    }
                    return ((MetaDataProtos.GetVersionResponse)rpcCallback.get()).getVersion();
                }
            });
            for (Map.Entry result : results.entrySet()) {
                long version = (Long)result.getValue();
                isTableNamespaceMappingEnabled |= MetaDataUtil.decodeTableNamespaceMappingEnabled(version);
                if (!ConnectionQueryServicesImpl.isCompatible((Long)result.getValue())) {
                    isIncompatible = true;
                    HRegionLocation name = (HRegionLocation)regionMap.get(result.getKey());
                    buf.append(name);
                    buf.append(';');
                }
                this.hasIndexWALCodec &= ConnectionQueryServicesImpl.hasIndexWALCodec((Long)result.getValue());
                if (minHBaseVersion <= MetaDataUtil.decodeHBaseVersion((Long)result.getValue())) continue;
                minHBaseVersion = MetaDataUtil.decodeHBaseVersion((Long)result.getValue());
            }
            if (isTableNamespaceMappingEnabled != SchemaUtil.isNamespaceMappingEnabled(PTableType.TABLE, this.getProps())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES).setMessage("Ensure that config phoenix.schema.isNamespaceMappingEnabled is consitent on client and server.").build().buildException();
            }
            this.lowestClusterHBaseVersion = minHBaseVersion;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR).setRootCause(t).setMessage("Ensure that phoenix-[version]-server.jar is put on the classpath of HBase in every region server: " + t.getMessage()).build().buildException();
        }
        finally {
            if (ht != null) {
                try {
                    ht.close();
                }
                catch (IOException e) {
                    logger.warn("Could not close HTable", (Throwable)e);
                }
            }
        }
        if (isIncompatible) {
            buf.setLength(buf.length() - 1);
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.OUTDATED_JARS).setMessage(buf.toString()).build().buildException();
        }
    }

    private MetaDataProtocol.MetaDataMutationResult metaDataCoprocessorExec(byte[] tableKey, Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable) throws SQLException {
        return this.metaDataCoprocessorExec(tableKey, callable, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetaDataProtocol.MetaDataMutationResult metaDataCoprocessorExec(byte[] tableKey, Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable, byte[] tableName) throws SQLException {
        try {
            boolean retried = false;
            while (true) {
                if (retried) {
                    this.connection.relocateRegion(SchemaUtil.getPhysicalName(tableName, this.getProps()), tableKey);
                }
                HTableInterface ht = this.getTable(SchemaUtil.getPhysicalName(tableName, this.getProps()).getName());
                try {
                    Map results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, tableKey, tableKey, callable);
                    assert (results.size() == 1);
                    MetaDataProtos.MetaDataResponse result = (MetaDataProtos.MetaDataResponse)results.values().iterator().next();
                    if (result.getReturnCode() == MetaDataProtos.MutationCode.TABLE_NOT_IN_REGION || result.getReturnCode() == MetaDataProtos.MutationCode.FUNCTION_NOT_IN_REGION) {
                        if (retried) {
                            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                            return metaDataMutationResult;
                        }
                        retried = true;
                        continue;
                    }
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                    return metaDataMutationResult;
                }
                finally {
                    Closeables.closeQuietly((Closeable)ht);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    private void ensureViewIndexTableCreated(byte[] physicalTableName, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, long timestamp, boolean isNamespaceMapped) throws SQLException {
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        tableProps.put("IS_VIEW_INDEX_TABLE", TRUE_BYTES_AS_STRING);
        HTableDescriptor desc = this.ensureTableCreated(physicalIndexName, PTableType.TABLE, tableProps, families, splits, false, isNamespaceMapped);
        if (desc != null && !Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES)))) {
            String fullTableName = Bytes.toString((byte[])physicalIndexName);
            throw new TableAlreadyExistsException("Unable to create shared physical table for indexes on views.", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName));
        }
    }

    private boolean ensureViewIndexTableDropped(byte[] physicalTableName, long timestamp) throws SQLException {
        boolean wasDeleted;
        block17: {
            byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
            wasDeleted = false;
            try (HBaseAdmin admin = this.getAdmin();){
                try {
                    HTableDescriptor desc = admin.getTableDescriptor(physicalIndexName);
                    if (!Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES)))) break block17;
                    ReadOnlyProps props = this.getProps();
                    boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                    if (dropMetadata) {
                        admin.disableTable(physicalIndexName);
                        admin.deleteTable(physicalIndexName);
                        this.clearTableRegionCache(physicalIndexName);
                        wasDeleted = true;
                        break block17;
                    }
                    this.tableStatsCache.invalidateAll(desc);
                }
                catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }
        return wasDeleted;
    }

    private boolean ensureLocalIndexTableDropped(byte[] physicalTableName, long timestamp) throws SQLException {
        HTableDescriptor desc = null;
        boolean wasDeleted = false;
        try (HBaseAdmin admin = this.getAdmin();){
            try {
                desc = admin.getTableDescriptor(physicalTableName);
                for (byte[] fam : desc.getFamiliesKeys()) {
                    this.tableStatsCache.invalidate(new GuidePostsKey(physicalTableName, fam));
                }
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    ArrayList<String> columnFamiles = new ArrayList<String>();
                    for (HColumnDescriptor cf : desc.getColumnFamilies()) {
                        if (!cf.getNameAsString().startsWith("L#")) continue;
                        columnFamiles.add(cf.getNameAsString());
                    }
                    for (String cf : columnFamiles) {
                        admin.deleteColumn(physicalTableName, cf);
                    }
                    this.clearTableRegionCache(physicalTableName);
                    wasDeleted = true;
                }
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        return wasDeleted;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createTable(final List<Mutation> tableMetaData, byte[] physicalTableName, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean isNamespaceMapped, final boolean allocateIndexId) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        Put m = MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableName = physicalTableName != null ? physicalTableName : SchemaUtil.getPhysicalHBaseTableName(schemaBytes, tableBytes, isNamespaceMapped).getBytes();
        boolean localIndexTable = false;
        for (Pair<byte[], Map<String, Object>> family : families) {
            if (!Bytes.toString((byte[])((byte[])family.getFirst())).startsWith("L#")) continue;
            localIndexTable = true;
            break;
        }
        if (tableType == PTableType.VIEW && physicalTableName != null || tableType != PTableType.VIEW && (physicalTableName == null || localIndexTable)) {
            this.ensureTableCreated(tableName, tableType, tableProps, families, splits, true, isNamespaceMapped);
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (tableType == PTableType.INDEX) {
            if (physicalTableName != null && !localIndexTable && !MetaDataUtil.isMultiTenant((Mutation)m, this.kvBuilder, ptr)) {
                this.ensureViewIndexTableCreated(tenantIdBytes.length == 0 ? null : PNameFactory.newName(tenantIdBytes), physicalTableName, MetaDataUtil.getClientTimeStamp((Mutation)m), isNamespaceMapped);
            }
        } else if (tableType == PTableType.TABLE && MetaDataUtil.isMultiTenant((Mutation)m, this.kvBuilder, ptr)) {
            ptr.set(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
            MetaDataUtil.getMutationValue((Mutation)m, PhoenixDatabaseMetaData.DEFAULT_COLUMN_FAMILY_NAME_BYTES, this.kvBuilder, ptr);
            List<Object> familiesPlusDefault = null;
            for (Pair<byte[], Map<String, Object>> family : families) {
                byte[] cf = (byte[])family.getFirst();
                if (Bytes.compareTo((byte[])cf, (int)0, (int)cf.length, (byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength()) != 0) continue;
                familiesPlusDefault = families;
                break;
            }
            if (familiesPlusDefault == null) {
                byte[] defaultCF = ByteUtil.copyKeyBytesIfNecessary(ptr);
                familiesPlusDefault = Lists.newArrayList(families);
                familiesPlusDefault.add(new Pair((Object)defaultCF, Collections.emptyMap()));
            }
            this.ensureViewIndexTableCreated(tableName, tableProps, familiesPlusDefault, MetaDataUtil.isSalted((Mutation)m, this.kvBuilder, ptr) ? splits : (byte[][])null, MetaDataUtil.getClientTimeStamp((Mutation)m), isNamespaceMapped);
        }
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.CreateTableRequest.Builder builder = MetaDataProtos.CreateTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                if (allocateIndexId) {
                    builder.setAllocateIndexId(allocateIndexId);
                }
                MetaDataProtos.CreateTableRequest build = builder.build();
                instance.createTable((RpcController)controller, build, (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        return result;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getTable(PName tenantId, final byte[] schemaBytes, final byte[] tableBytes, final long tableTimestamp, final long clientTimestamp) throws SQLException {
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.GetTableRequest.Builder builder = MetaDataProtos.GetTableRequest.newBuilder();
                builder.setTenantId(ByteStringer.wrap((byte[])tenantIdBytes));
                builder.setSchemaName(ByteStringer.wrap((byte[])schemaBytes));
                builder.setTableName(ByteStringer.wrap((byte[])tableBytes));
                builder.setTableTimestamp(tableTimestamp);
                builder.setClientTimestamp(clientTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.getTable((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropTable(final List<Mutation> tableMetaData, final PTableType tableType, final boolean cascade) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.DropTableRequest.Builder builder = MetaDataProtos.DropTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setTableType(tableType.getSerializedValue());
                builder.setCascade(cascade);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.dropTable((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                PTable table = result.getTable();
                if (dropMetadata) {
                    this.flushParentPhysicalTable(table);
                    this.dropTables(result.getMutatedTableNames());
                } else {
                    this.invalidateTableStats(result.getMutatedTableNames());
                }
                if (tableType != PTableType.TABLE) break;
                long timestamp = MetaDataUtil.getClientTimeStamp(tableMetaData);
                byte[] physicalName = table.getPhysicalName().getBytes();
                this.ensureViewIndexTableDropped(physicalName, timestamp);
                this.ensureLocalIndexTableDropped(physicalName, timestamp);
                this.tableStatsCache.invalidateAll(table);
                break;
            }
        }
        return result;
    }

    private void flushParentPhysicalTable(PTable table) throws SQLException {
        byte[] parentPhysicalTableName = null;
        if (PTableType.VIEW == table.getType()) {
            if (!table.getIndexes().isEmpty()) {
                parentPhysicalTableName = table.getPhysicalName().getBytes();
            }
        } else if (PTableType.INDEX == table.getType()) {
            PTable parentTable = this.getTable(table.getTenantId(), table.getParentName().getString(), Long.MAX_VALUE);
            parentPhysicalTableName = parentTable.getPhysicalName().getBytes();
        }
        if (parentPhysicalTableName != null) {
            this.flushTable(parentPhysicalTableName);
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropFunction(final List<Mutation> functionData, final boolean ifExists) throws SQLException {
        byte[][] rowKeyMetadata = new byte[2][];
        byte[] key = functionData.get(0).getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] functionBytes = rowKeyMetadata[1];
        byte[] functionKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(functionKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.DropFunctionRequest.Builder builder = MetaDataProtos.DropFunctionRequest.newBuilder();
                for (Mutation m : functionData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setIfExists(ifExists);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.dropFunction((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
        return result;
    }

    private void invalidateTableStats(List<byte[]> tableNamesToDelete) {
        if (tableNamesToDelete != null) {
            for (byte[] tableName : tableNamesToDelete) {
                this.tableStatsCache.invalidateAll(tableName);
            }
        }
    }

    private void dropTable(byte[] tableNameToDelete) throws SQLException {
        this.dropTables(Collections.singletonList(tableNameToDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTables(List<byte[]> tableNamesToDelete) throws SQLException {
        block21: {
            SQLException sqlE = null;
            try (HBaseAdmin admin = this.getAdmin();){
                if (tableNamesToDelete != null) {
                    for (byte[] tableName : tableNamesToDelete) {
                        try {
                            HTableDescriptor htableDesc = this.getTableDescriptor(tableName);
                            admin.disableTable(tableName);
                            admin.deleteTable(tableName);
                            this.tableStatsCache.invalidateAll(htableDesc);
                            this.clearTableRegionCache(tableName);
                        }
                        catch (TableNotFoundException tableNotFoundException) {}
                    }
                }
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            finally {
                if (sqlE == null) break block21;
                throw sqlE;
            }
        }
    }

    private static Map<String, Object> createPropertiesMap(Map<ImmutableBytesWritable, ImmutableBytesWritable> htableProps) {
        HashMap props = Maps.newHashMapWithExpectedSize((int)htableProps.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : htableProps.entrySet()) {
            ImmutableBytesWritable key = entry.getKey();
            ImmutableBytesWritable value = entry.getValue();
            props.put(Bytes.toString((byte[])key.get(), (int)key.getOffset(), (int)key.getLength()), Bytes.toString((byte[])value.get(), (int)value.getOffset(), (int)value.getLength()));
        }
        return props;
    }

    private void ensureViewIndexTableCreated(PName tenantId, byte[] physicalIndexTableName, long timestamp, boolean isNamespaceMapped) throws SQLException {
        String name = Bytes.toString((byte[])SchemaUtil.getParentTableNameFromIndexTable(physicalIndexTableName, "_IDX_")).replace(":", ".");
        PTable table = this.getTable(tenantId, name, timestamp);
        this.ensureViewIndexTableCreated(table, timestamp, isNamespaceMapped);
    }

    private PTable getTable(PName tenantId, String fullTableName, long timestamp) throws SQLException {
        PTable table;
        block3: {
            try {
                PMetaData metadata = this.latestMetaData;
                this.throwConnectionClosedIfNullMetaData();
                table = metadata.getTableRef(new PTableKey(tenantId, fullTableName)).getTable();
                if (table.getTimeStamp() >= timestamp) {
                    throw new TableNotFoundException(table.getSchemaName().getString(), table.getTableName().getString());
                }
            }
            catch (TableNotFoundException e) {
                byte[] schemaName = Bytes.toBytes((String)SchemaUtil.getSchemaNameFromFullName(fullTableName));
                byte[] tableName = Bytes.toBytes((String)SchemaUtil.getTableNameFromFullName(fullTableName));
                MetaDataProtocol.MetaDataMutationResult result = this.getTable(tenantId, schemaName, tableName, Long.MAX_VALUE, timestamp);
                table = result.getTable();
                if (table != null) break block3;
                throw e;
            }
        }
        return table;
    }

    private void ensureViewIndexTableCreated(PTable table, long timestamp, boolean isNamespaceMapped) throws SQLException {
        Object familyName;
        byte[] physicalTableName = table.getPhysicalName().getBytes();
        HTableDescriptor htableDesc = this.getTableDescriptor(physicalTableName);
        Map<String, Object> tableProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getValues());
        ArrayList families = Lists.newArrayListWithExpectedSize((int)Math.max(1, table.getColumnFamilies().size() + 1));
        if (families.isEmpty()) {
            familyName = SchemaUtil.getEmptyColumnFamily(table);
            Map<String, Object> familyProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getFamily((byte[])familyName).getValues());
            families.add(new Pair(familyName, familyProps));
        } else {
            familyName = table.getColumnFamilies().iterator();
            while (familyName.hasNext()) {
                PColumnFamily family = (PColumnFamily)familyName.next();
                byte[] familyName2 = family.getName().getBytes();
                Map<String, Object> familyProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getFamily(familyName2).getValues());
                families.add(new Pair((Object)familyName2, familyProps));
            }
            families.add(new Pair((Object)table.getDefaultFamilyName().getBytes(), Collections.emptyMap()));
        }
        byte[][] splits = null;
        if (table.getBucketNum() != null) {
            splits = SaltingUtil.getSalteByteSplitPoints(table.getBucketNum());
        }
        tableProps.put("TRANSACTIONAL", table.isTransactional());
        tableProps.put("IMMUTABLE_ROWS", table.isImmutableRows());
        this.ensureViewIndexTableCreated(physicalTableName, tableProps, families, splits, timestamp, isNamespaceMapped);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult modifyColumn(final List<Mutation> tableMetaData, PTable table) throws SQLException {
        byte[][] rowKeyMetaData = new byte[3][];
        MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetaData, rowKeyMetaData);
        byte[] tenantIdBytes = rowKeyMetaData[0];
        byte[] schemaBytes = rowKeyMetaData[1];
        byte[] tableBytes = rowKeyMetaData[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        if (tableMetaData.isEmpty() || tableMetaData.size() == 1 && tableMetaData.get(0).isEmpty()) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NO_OP, EnvironmentEdgeManager.currentTimeMillis(), table);
        }
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.ModifyColumnRequest.Builder builder = MetaDataProtos.ModifyColumnRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.modifyColumn((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataProtocol.MetaDataMutationResult addColumn(final List<Mutation> tableMetaData, PTable table, Map<String, List<Pair<String, Object>>> stmtProperties, Set<String> colFamiliesForPColumnsToBeAdded, List<PColumn> columns) throws SQLException {
        ArrayList<Pair<byte[], Map<String, Object>>> families = new ArrayList<Pair<byte[], Map<String, Object>>>(stmtProperties.size());
        HashMap<String, Object> tableProps = new HashMap<String, Object>();
        HashSet tableDescriptors = Collections.emptySet();
        HashSet origTableDescriptors = Collections.emptySet();
        boolean nonTxToTx = false;
        Pair<HTableDescriptor, HTableDescriptor> tableDescriptorPair = this.separateAndValidateProperties(table, stmtProperties, colFamiliesForPColumnsToBeAdded, families, tableProps);
        HTableDescriptor tableDescriptor = (HTableDescriptor)tableDescriptorPair.getSecond();
        HTableDescriptor origTableDescriptor = (HTableDescriptor)tableDescriptorPair.getFirst();
        if (tableDescriptor != null) {
            tableDescriptors = Sets.newHashSetWithExpectedSize((int)(3 + table.getIndexes().size()));
            origTableDescriptors = Sets.newHashSetWithExpectedSize((int)(3 + table.getIndexes().size()));
            tableDescriptors.add(tableDescriptor);
            origTableDescriptors.add(origTableDescriptor);
            nonTxToTx = Boolean.TRUE.equals(tableProps.get("data.tx.read.pre.existing"));
            if (nonTxToTx) {
                this.updateDescriptorForTx(table, tableProps, tableDescriptor, Boolean.TRUE.toString(), tableDescriptors, origTableDescriptors);
            }
        }
        boolean success = false;
        boolean metaDataUpdated = !tableDescriptors.isEmpty();
        boolean pollingNeeded = tableProps.isEmpty() || !families.isEmpty() || !colFamiliesForPColumnsToBeAdded.isEmpty();
        MetaDataProtocol.MetaDataMutationResult result = null;
        try {
            boolean modifyHTable = true;
            if (table.getType() == PTableType.VIEW) {
                boolean canViewsAddNewCF = this.props.getBoolean("phoenix.view.allowNewColumnFamily", true);
                boolean bl = modifyHTable = canViewsAddNewCF && !this.existingColumnFamiliesForBaseTable(table.getPhysicalName()).containsAll(colFamiliesForPColumnsToBeAdded);
            }
            if (modifyHTable) {
                this.sendHBaseMetaData(tableDescriptors, pollingNeeded);
            }
            if (tableMetaData.isEmpty() || tableMetaData.size() == 1 && tableMetaData.get(0).isEmpty()) {
                MetaDataProtocol.MetaDataMutationResult canViewsAddNewCF = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NO_OP, EnvironmentEdgeManager.currentTimeMillis(), table);
                return canViewsAddNewCF;
            }
            byte[][] rowKeyMetaData = new byte[3][];
            PTableType tableType = table.getType();
            Mutation m = tableMetaData.get(0);
            byte[] rowKey = m.getRow();
            SchemaUtil.getVarChars(rowKey, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            byte[] schemaBytes = rowKeyMetaData[1];
            byte[] tableBytes = rowKeyMetaData[2];
            byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

                public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                    MetaDataProtos.AddColumnRequest.Builder builder = MetaDataProtos.AddColumnRequest.newBuilder();
                    for (Mutation m : tableMetaData) {
                        ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                        builder.addTableMetadataMutations(mp.toByteString());
                    }
                    builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                    instance.addColumn((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                    if (controller.getFailedOn() != null) {
                        throw controller.getFailedOn();
                    }
                    return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
                }
            });
            if (result.getMutationCode() == MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND || result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                success = true;
                if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.DISABLE_WAL_BYTES, this.kvBuilder, ptr) && Boolean.FALSE.equals(PBoolean.INSTANCE.toObject(ptr))) {
                    this.flushTable(table.getPhysicalName().getBytes());
                }
                if (tableType == PTableType.TABLE && MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES, this.kvBuilder, ptr)) {
                    long timestamp = MetaDataUtil.getClientTimeStamp(m);
                    if (Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr.get(), ptr.getOffset(), ptr.getLength()))) {
                        this.ensureViewIndexTableCreated(table, timestamp, table.isNamespaceMapped());
                    } else {
                        this.ensureViewIndexTableDropped(table.getPhysicalName().getBytes(), timestamp);
                    }
                }
            }
        }
        finally {
            if (!success && metaDataUpdated && nonTxToTx) {
                this.sendHBaseMetaData(origTableDescriptors, pollingNeeded);
            }
        }
        return result;
    }

    private void updateDescriptorForTx(PTable table, Map<String, Object> tableProps, HTableDescriptor tableDescriptor, String txValue, Set<HTableDescriptor> descriptorsToUpdate, Set<HTableDescriptor> origDescriptors) throws SQLException {
        byte[] physicalTableName = table.getPhysicalName().getBytes();
        try (HBaseAdmin admin = this.getAdmin();){
            HTableDescriptor indexDescriptor3;
            HashMap indexTableProps;
            this.setTransactional(tableDescriptor, table.getType(), txValue, tableProps);
            if (txValue == null) {
                indexTableProps = Collections.emptyMap();
            } else {
                indexTableProps = Maps.newHashMapWithExpectedSize((int)1);
                indexTableProps.put("data.tx.read.pre.existing", Boolean.valueOf(txValue));
            }
            for (PTable index : table.getIndexes()) {
                HTableDescriptor indexDescriptor2 = admin.getTableDescriptor(index.getPhysicalName().getBytes());
                origDescriptors.add(indexDescriptor2);
                indexDescriptor2 = new HTableDescriptor(indexDescriptor2);
                descriptorsToUpdate.add(indexDescriptor2);
                if (index.getColumnFamilies().isEmpty()) {
                    byte[] dataFamilyName = SchemaUtil.getEmptyColumnFamily(table);
                    byte[] indexFamilyName = SchemaUtil.getEmptyColumnFamily(index);
                    HColumnDescriptor indexColDescriptor = indexDescriptor2.getFamily(indexFamilyName);
                    HColumnDescriptor tableColDescriptor = tableDescriptor.getFamily(dataFamilyName);
                    indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
                    indexColDescriptor.setValue("dataset.table.ttl", tableColDescriptor.getValue("dataset.table.ttl"));
                } else {
                    for (PColumnFamily family : index.getColumnFamilies()) {
                        byte[] familyName = family.getName().getBytes();
                        indexDescriptor2.getFamily(familyName).setMaxVersions(tableDescriptor.getFamily(familyName).getMaxVersions());
                        HColumnDescriptor indexColDescriptor = indexDescriptor2.getFamily(familyName);
                        HColumnDescriptor tableColDescriptor = tableDescriptor.getFamily(familyName);
                        indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
                        indexColDescriptor.setValue("dataset.table.ttl", tableColDescriptor.getValue("dataset.table.ttl"));
                    }
                }
                this.setTransactional(indexDescriptor2, index.getType(), txValue, indexTableProps);
            }
            try {
                indexDescriptor3 = admin.getTableDescriptor(MetaDataUtil.getViewIndexPhysicalName(physicalTableName));
                origDescriptors.add(indexDescriptor3);
                indexDescriptor3 = new HTableDescriptor(indexDescriptor3);
                descriptorsToUpdate.add(indexDescriptor3);
                this.setSharedIndexMaxVersion(table, tableDescriptor, indexDescriptor3);
                this.setTransactional(indexDescriptor3, PTableType.INDEX, txValue, indexTableProps);
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException indexDescriptor3) {
                // empty catch block
            }
            try {
                indexDescriptor3 = admin.getTableDescriptor(MetaDataUtil.getLocalIndexPhysicalName(physicalTableName));
                origDescriptors.add(indexDescriptor3);
                indexDescriptor3 = new HTableDescriptor(indexDescriptor3);
                descriptorsToUpdate.add(indexDescriptor3);
                this.setSharedIndexMaxVersion(table, tableDescriptor, indexDescriptor3);
                this.setTransactional(indexDescriptor3, PTableType.INDEX, txValue, indexTableProps);
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    private void setSharedIndexMaxVersion(PTable table, HTableDescriptor tableDescriptor, HTableDescriptor indexDescriptor) {
        if (table.getColumnFamilies().isEmpty()) {
            byte[] familyName = SchemaUtil.getEmptyColumnFamily(table);
            HColumnDescriptor indexColDescriptor = indexDescriptor.getFamily(familyName);
            HColumnDescriptor tableColDescriptor = tableDescriptor.getFamily(familyName);
            indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
            indexColDescriptor.setValue("dataset.table.ttl", tableColDescriptor.getValue("dataset.table.ttl"));
        } else {
            for (PColumnFamily family : table.getColumnFamilies()) {
                byte[] familyName = family.getName().getBytes();
                HColumnDescriptor indexColDescriptor = indexDescriptor.getFamily(familyName);
                if (indexColDescriptor == null) continue;
                HColumnDescriptor tableColDescriptor = tableDescriptor.getFamily(familyName);
                indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
                indexColDescriptor.setValue("dataset.table.ttl", tableColDescriptor.getValue("dataset.table.ttl"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHBaseMetaData(Set<HTableDescriptor> tableDescriptors, boolean pollingNeeded) throws SQLException {
        SQLException sqlE = null;
        for (HTableDescriptor descriptor : tableDescriptors) {
            try {
                this.modifyTable(descriptor.getName(), descriptor, pollingNeeded);
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            catch (TimeoutException e) {
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setRootCause(e.getCause() != null ? e.getCause() : e).build().buildException();
            }
            finally {
                if (sqlE == null) continue;
                throw sqlE;
            }
        }
    }

    private void setTransactional(HTableDescriptor tableDescriptor, PTableType tableType, String txValue, Map<String, Object> tableProps) throws SQLException {
        if (txValue == null) {
            tableDescriptor.remove("data.tx.read.pre.existing");
        } else {
            tableDescriptor.setValue("data.tx.read.pre.existing", txValue);
        }
        this.addCoprocessors(tableDescriptor.getName(), tableDescriptor, tableType, tableProps);
    }

    /*
     * WARNING - void declaration
     */
    private Pair<HTableDescriptor, HTableDescriptor> separateAndValidateProperties(PTable table, Map<String, List<Pair<String, Object>>> properties, Set<String> colFamiliesForPColumnsToBeAdded, List<Pair<byte[], Map<String, Object>>> families, Map<String, Object> tableProps) throws SQLException {
        void var16_25;
        boolean isAddingPkColOnly;
        HashMap stmtFamiliesPropsMap = new HashMap(properties.size());
        Map<String, Object> commonFamilyProps = new HashMap();
        boolean addingColumns = colFamiliesForPColumnsToBeAdded != null && !colFamiliesForPColumnsToBeAdded.isEmpty();
        HashSet<String> existingColumnFamilies = this.existingColumnFamilies(table);
        HashMap<String, Map<String, Object>> allFamiliesProps = new HashMap<String, Map<String, Object>>(existingColumnFamilies.size());
        boolean isTransactional = table.isTransactional();
        boolean willBeTransactional = false;
        boolean isOrWillBeTransactional = isTransactional;
        Integer newTTL = null;
        for (String string : properties.keySet()) {
            List<Pair<String, Object>> propsList = properties.get(string);
            if (propsList == null || propsList.size() <= 0) continue;
            HashMap<String, Object> colFamilyPropsMap = new HashMap<String, Object>(propsList.size());
            for (Pair<String, Object> pair : propsList) {
                String string2 = (String)pair.getFirst();
                Object propValue = pair.getSecond();
                if ((MetaDataUtil.isHTableProperty(string2) || TableProperty.isPhoenixTableProperty(string2)) && addingColumns) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_TABLE_PROPERTY_ADD_COLUMN).setMessage("Property: " + string2).build().buildException();
                }
                if (MetaDataUtil.isHTableProperty(string2)) {
                    if (!string.equals("")) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY).setMessage("Column Family: " + string + ", Property: " + string2).build().buildException();
                    }
                    tableProps.put(string2, propValue);
                    continue;
                }
                if (TableProperty.isPhoenixTableProperty(string2)) {
                    TableProperty.valueOf(string2).validate(true, !string.equals(""), table.getType());
                    if (string2.equals("TTL")) {
                        newTTL = ((Number)pair.getSecond()).intValue();
                        commonFamilyProps.put(string2, pair.getSecond());
                        continue;
                    }
                    if (!string2.equals("TRANSACTIONAL") || !Boolean.TRUE.equals(propValue)) continue;
                    isOrWillBeTransactional = true;
                    willBeTransactional = true;
                    tableProps.put("data.tx.read.pre.existing", propValue);
                    continue;
                }
                if (MetaDataUtil.isHColumnProperty(string2)) {
                    if (string.equals("")) {
                        commonFamilyProps.put(string2, propValue);
                        continue;
                    }
                    colFamilyPropsMap.put(string2, propValue);
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_PROPERTY).setMessage("Column Family: " + string + ", Property: " + string2).build().buildException();
            }
            if (colFamilyPropsMap.isEmpty()) continue;
            stmtFamiliesPropsMap.put(string, colFamilyPropsMap);
        }
        commonFamilyProps = Collections.unmodifiableMap(commonFamilyProps);
        boolean bl = isAddingPkColOnly = colFamiliesForPColumnsToBeAdded.size() == 1 && colFamiliesForPColumnsToBeAdded.contains(null);
        if (!commonFamilyProps.isEmpty()) {
            HashMap<String, Object> m;
            if (!addingColumns) {
                for (String existingColFamily : existingColumnFamilies) {
                    m = new HashMap<String, Object>(commonFamilyProps.size());
                    m.putAll(commonFamilyProps);
                    allFamiliesProps.put(existingColFamily, m);
                }
            } else {
                for (String colFamily : colFamiliesForPColumnsToBeAdded) {
                    if (colFamily != null) {
                        m = new HashMap(commonFamilyProps.size());
                        m.putAll(commonFamilyProps);
                        allFamiliesProps.put(colFamily, m);
                        continue;
                    }
                    if (!isAddingPkColOnly) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SET_UNSUPPORTED_PROP_ON_ALTER_TABLE).build().buildException();
                }
            }
        }
        for (String f : stmtFamiliesPropsMap.keySet()) {
            if (!addingColumns && !existingColumnFamilies.contains(f)) {
                String schemaNameStr = table.getSchemaName() == null ? null : table.getSchemaName().getString();
                String tableNameStr = table.getTableName() == null ? null : table.getTableName().getString();
                throw new ColumnFamilyNotFoundException(schemaNameStr, tableNameStr, f);
            }
            if (addingColumns && !colFamiliesForPColumnsToBeAdded.contains(f)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_PROPERTY_FOR_COLUMN_NOT_ADDED).build().buildException();
            }
            Map commonProps = (Map)allFamiliesProps.get(f);
            Map stmtProps = (Map)stmtFamiliesPropsMap.get(f);
            if (commonProps != null) {
                if (stmtProps == null) continue;
                commonProps.putAll(stmtProps);
                continue;
            }
            if (stmtProps == null) continue;
            allFamiliesProps.put(f, stmtProps);
        }
        for (String cf : colFamiliesForPColumnsToBeAdded) {
            if (cf == null || allFamiliesProps.get(cf) != null) continue;
            allFamiliesProps.put(cf, new HashMap());
        }
        if (table.getColumnFamilies().isEmpty() && !addingColumns && !commonFamilyProps.isEmpty()) {
            allFamiliesProps.put(Bytes.toString((byte[])(table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : table.getDefaultFamilyName().getBytes())), commonFamilyProps);
        }
        if (!(table.getType() != PTableType.VIEW || stmtFamiliesPropsMap.isEmpty() && commonFamilyProps.isEmpty() && tableProps.isEmpty())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
        }
        Object var16_23 = null;
        HTableDescriptor origTableDescriptor = null;
        if (!allFamiliesProps.isEmpty() || !tableProps.isEmpty()) {
            int n;
            void var20_39;
            byte[] tableNameBytes = Bytes.toBytes((String)table.getPhysicalName().getString());
            HTableDescriptor existingTableDescriptor = origTableDescriptor = this.getTableDescriptor(tableNameBytes);
            HTableDescriptor hTableDescriptor = new HTableDescriptor(existingTableDescriptor);
            if (!tableProps.isEmpty()) {
                for (Map.Entry<String, Object> entry : tableProps.entrySet()) {
                    hTableDescriptor.setValue(entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null);
                }
            }
            if (addingColumns) {
                ConnectionQueryServicesImpl.setTTLForNewCFs(allFamiliesProps, table, hTableDescriptor, newTTL);
            }
            if (newTTL != null) {
                for (PColumnFamily pColumnFamily : table.getColumnFamilies()) {
                    if (allFamiliesProps.containsKey(pColumnFamily.getName().getString())) continue;
                    Iterator<PColumnFamily> familyProps = Maps.newHashMapWithExpectedSize((int)1);
                    familyProps.put("TTL", newTTL);
                    allFamiliesProps.put(pColumnFamily.getName().getString(), (Map<String, Object>)((Object)familyProps));
                }
            }
            Object var20_34 = null;
            if (isOrWillBeTransactional) {
                void var20_36;
                Map map = (Map)allFamiliesProps.get(SchemaUtil.getEmptyColumnFamilyAsString(table));
                if (map != null) {
                    Integer n2 = (Integer)map.get("VERSIONS");
                }
                if (var20_36 == null) {
                    if (isTransactional) {
                        Integer n3 = hTableDescriptor.getFamily(SchemaUtil.getEmptyColumnFamily(table)).getMaxVersions();
                    } else {
                        Integer n4 = this.getProps().getInt("phoenix.transactions.maxVersions", Integer.MAX_VALUE);
                    }
                }
                if (willBeTransactional) {
                    for (PColumnFamily pColumnFamily : table.getColumnFamilies()) {
                        if (allFamiliesProps.containsKey(pColumnFamily.getName().getString())) continue;
                        HashMap familyProps = Maps.newHashMapWithExpectedSize((int)1);
                        familyProps.put("VERSIONS", var20_39);
                        allFamiliesProps.put(pColumnFamily.getName().getString(), familyProps);
                    }
                }
            }
            if (isOrWillBeTransactional && (n = ConnectionQueryServicesImpl.getTTL(table, hTableDescriptor, newTTL)) != Integer.MAX_VALUE) {
                for (Map.Entry entry : allFamiliesProps.entrySet()) {
                    HashMap<String, Integer> props = (HashMap<String, Integer>)entry.getValue();
                    if (props == null) {
                        props = new HashMap<String, Integer>();
                    }
                    props.put("dataset.table.ttl", n);
                    if (willBeTransactional || Boolean.valueOf(hTableDescriptor.getValue("data.tx.read.pre.existing")).booleanValue()) continue;
                    props.remove("TTL");
                }
            }
            for (Map.Entry entry : allFamiliesProps.entrySet()) {
                byte[] cf;
                HColumnDescriptor colDescriptor;
                Map map = (Map)entry.getValue();
                if (isOrWillBeTransactional && !map.containsKey("VERSIONS")) {
                    map.put("VERSIONS", var20_39);
                }
                if ((colDescriptor = hTableDescriptor.getFamily(cf = Bytes.toBytes((String)((String)entry.getKey())))) == null) {
                    colDescriptor = this.generateColumnFamilyDescriptor((Pair<byte[], Map<String, Object>>)new Pair((Object)cf, (Object)map), table.getType());
                    hTableDescriptor.addFamily(colDescriptor);
                } else {
                    this.modifyColumnFamilyDescriptor(colDescriptor, map);
                }
                if (!isOrWillBeTransactional) continue;
                this.checkTransactionalVersionsValue(colDescriptor);
            }
        }
        return new Pair(origTableDescriptor, (Object)var16_25);
    }

    private void checkTransactionalVersionsValue(HColumnDescriptor colDescriptor) throws SQLException {
        int maxVersions = colDescriptor.getMaxVersions();
        if (maxVersions <= 1) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MAX_VERSIONS_MUST_BE_GREATER_THAN_ONE).setFamilyName(colDescriptor.getNameAsString()).build().buildException();
        }
    }

    private HashSet<String> existingColumnFamiliesForBaseTable(PName baseTableName) throws TableNotFoundException {
        this.throwConnectionClosedIfNullMetaData();
        PTable table = this.latestMetaData.getTableRef(new PTableKey(null, baseTableName.getString())).getTable();
        return this.existingColumnFamilies(table);
    }

    private HashSet<String> existingColumnFamilies(PTable table) {
        List<PColumnFamily> cfs = table.getColumnFamilies();
        HashSet<String> cfNames = new HashSet<String>(cfs.size());
        for (PColumnFamily cf : table.getColumnFamilies()) {
            cfNames.add(cf.getName().getString());
        }
        return cfNames;
    }

    private static int getTTL(PTable table, HTableDescriptor tableDesc, Integer newTTL) throws SQLException {
        int ttl = newTTL != null ? newTTL.intValue() : tableDesc.getFamily(SchemaUtil.getEmptyColumnFamily(table)).getTimeToLive();
        return ttl;
    }

    private static void setTTLForNewCFs(Map<String, Map<String, Object>> familyProps, PTable table, HTableDescriptor tableDesc, Integer newTTL) throws SQLException {
        if (!familyProps.isEmpty()) {
            int ttl = ConnectionQueryServicesImpl.getTTL(table, tableDesc, newTTL);
            for (Map.Entry<String, Map<String, Object>> entry : familyProps.entrySet()) {
                Map<String, Object> props = entry.getValue();
                if (props == null) {
                    props = new HashMap<String, Object>();
                }
                props.put("TTL", ttl);
            }
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropColumn(final List<Mutation> tableMetaData, PTableType tableType) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.DropColumnRequest.Builder builder = MetaDataProtos.DropColumnRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.dropColumn((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    this.dropTables(result.getMutatedTableNames());
                    break;
                }
                this.invalidateTableStats(result.getMutatedTableNames());
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection removeNotNullConstraint(PhoenixConnection oldMetaConnection, String schemaName, String tableName, long timestamp, String columnName) throws SQLException {
        PhoenixConnection metaConnection;
        block16: {
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            SQLException sqlE = null;
            try {
                String dml = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (" + "TENANT_ID" + "," + "TABLE_SCHEM" + "," + "TABLE_NAME" + "," + "COLUMN_NAME" + "," + "NULLABLE" + ") VALUES (null, ?, ?, ?, ?)";
                PreparedStatement stmt = metaConnection.prepareStatement(dml);
                stmt.setString(1, schemaName);
                stmt.setString(2, tableName);
                stmt.setString(3, columnName);
                stmt.setInt(4, 1);
                stmt.executeUpdate();
                metaConnection.commit();
            }
            catch (NewerTableAlreadyExistsException e) {
                logger.warn("Table already modified at this timestamp, so assuming column already nullable: " + columnName);
            }
            catch (SQLException e) {
                logger.warn("Add column failed due to:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block16;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection addColumn(PhoenixConnection oldMetaConnection, String tableName, long timestamp, String columns, boolean addIfNotExists) throws SQLException {
        PhoenixConnection metaConnection;
        block16: {
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            SQLException sqlE = null;
            try {
                metaConnection.createStatement().executeUpdate("ALTER TABLE " + tableName + " ADD " + (addIfNotExists ? " IF NOT EXISTS " : "") + columns);
            }
            catch (NewerTableAlreadyExistsException e) {
                logger.warn("Table already modified at this timestamp, so assuming add of these columns already done: " + columns);
            }
            catch (SQLException e) {
                logger.warn("Add column failed due to:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block16;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    private PhoenixConnection addColumnsIfNotExists(PhoenixConnection oldMetaConnection, String tableName, long timestamp, String columns) throws SQLException {
        return this.addColumn(oldMetaConnection, tableName, timestamp, columns, true);
    }

    @VisibleForTesting
    protected long getSystemTableVersion() {
        return 27L;
    }

    @VisibleForTesting
    protected void setUpgradeRequired() {
        this.upgradeRequired.set(true);
    }

    @VisibleForTesting
    protected boolean isInitialized() {
        return this.initialized;
    }

    @VisibleForTesting
    protected void setInitialized(boolean isInitialized) {
        this.initialized = isInitialized;
    }

    @VisibleForTesting
    protected String getSystemCatalogTableDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_TABLE_METADATA);
    }

    @VisibleForTesting
    protected String getFunctionTableDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_FUNCTION_METADATA);
    }

    @VisibleForTesting
    protected String getLogTableDDL() {
        return this.setSystemLogDDLProperties(QueryConstants.CREATE_LOG_METADATA);
    }

    private String setSystemLogDDLProperties(String ddl) {
        return String.format(ddl, this.props.getInt("phoenix.log.saltBuckets", 16));
    }

    private String setSystemDDLProperties(String ddl) {
        return String.format(ddl, this.props.getInt("phoenix.system.default.max.versions", 1), this.props.getBoolean("phoenix.system.default.keep.deleted.cells", false));
    }

    @Override
    public void init(final String url, final Properties props) throws SQLException {
        try {
            PhoenixContextExecutor.call(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Void call() throws Exception {
                    if (ConnectionQueryServicesImpl.this.isInitialized()) {
                        if (ConnectionQueryServicesImpl.this.initializationException == null) return null;
                        throw ConnectionQueryServicesImpl.this.initializationException;
                    }
                    ConnectionQueryServicesImpl connectionQueryServicesImpl = ConnectionQueryServicesImpl.this;
                    synchronized (connectionQueryServicesImpl) {
                        if (ConnectionQueryServicesImpl.this.isInitialized()) {
                            if (ConnectionQueryServicesImpl.this.initializationException == null) return null;
                            throw ConnectionQueryServicesImpl.this.initializationException;
                        }
                        ConnectionQueryServicesImpl.this.checkClosed();
                        boolean hConnectionEstablished = false;
                        boolean success = false;
                        try {
                            block110: {
                                GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.increment();
                                logger.info("An instance of ConnectionQueryServices was created.");
                                ConnectionQueryServicesImpl.this.openConnection();
                                hConnectionEstablished = true;
                                boolean isDoNotUpgradePropSet = UpgradeUtil.isNoUpgradeSet(props);
                                try (HBaseAdmin admin = ConnectionQueryServicesImpl.this.getAdmin();){
                                    boolean mappedSystemCatalogExists = admin.tableExists(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true));
                                    if (SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, ConnectionQueryServicesImpl.this.getProps())) {
                                        if (admin.tableExists(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES)) {
                                            ConnectionQueryServicesImpl.this.checkClientServerCompatibility(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
                                        }
                                        ConnectionQueryServicesImpl.this.ensureSystemTablesUpgraded(ConnectionQueryServicesImpl.this.getProps());
                                    } else if (mappedSystemCatalogExists) {
                                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES).setMessage("Cannot initiate connection as " + SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true) + " is found but client does not have " + "phoenix.schema.isNamespaceMappingEnabled" + " enabled").build().buildException();
                                    }
                                    ConnectionQueryServicesImpl.this.createSysMutexTable(admin);
                                }
                                Properties scnProps = PropertiesUtil.deepCopy(props);
                                scnProps.setProperty("CurrentSCN", Long.toString(ConnectionQueryServicesImpl.this.getSystemTableVersion()));
                                scnProps.remove("TenantId");
                                String globalUrl = JDBCUtil.removeProperty(url, "TenantId");
                                try (PhoenixConnection metaConnection = new PhoenixConnection(ConnectionQueryServicesImpl.this, globalUrl, scnProps, ConnectionQueryServicesImpl.this.newEmptyMetaData());){
                                    try {
                                        metaConnection.setRunningUpgrade(true);
                                        metaConnection.createStatement().executeUpdate(ConnectionQueryServicesImpl.this.getSystemCatalogTableDDL());
                                    }
                                    catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
                                    }
                                    catch (TableAlreadyExistsException e) {
                                        long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
                                        if (currentServerSideTableTimeStamp < 27L) {
                                            ConnectionQueryServicesImpl.this.setUpgradeRequired();
                                        }
                                    }
                                    catch (PhoenixIOException e) {
                                        if (!Iterables.isEmpty((Iterable)Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)e), AccessDeniedException.class))) {
                                            logger.warn("Could not check for Phoenix SYSTEM tables, assuming they exist and are properly configured");
                                            ConnectionQueryServicesImpl.this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, ConnectionQueryServicesImpl.this.getProps()).getName());
                                            success = true;
                                        } else {
                                            ConnectionQueryServicesImpl.this.initializationException = e;
                                        }
                                        Void void_ = null;
                                        if (metaConnection != null) {
                                            if (var8_16 != null) {
                                                try {
                                                    metaConnection.close();
                                                }
                                                catch (Throwable throwable) {
                                                    var8_16.addSuppressed(throwable);
                                                }
                                            } else {
                                                metaConnection.close();
                                            }
                                        }
                                        try {
                                            if (success) return void_;
                                            if (!hConnectionEstablished) return void_;
                                            ConnectionQueryServicesImpl.this.connection.close();
                                        }
                                        catch (IOException e2) {
                                            SQLException ex = new SQLException(e2);
                                            if (ConnectionQueryServicesImpl.this.initializationException != null) {
                                                ConnectionQueryServicesImpl.this.initializationException.setNextException(ex);
                                            } else {
                                                ConnectionQueryServicesImpl.this.initializationException = ex;
                                            }
                                        }
                                        finally {
                                            try {
                                                if (ConnectionQueryServicesImpl.this.initializationException != null) {
                                                    throw ConnectionQueryServicesImpl.this.initializationException;
                                                }
                                            }
                                            finally {
                                                ConnectionQueryServicesImpl.this.setInitialized(true);
                                            }
                                        }
                                        return void_;
                                    }
                                    if (!ConnectionQueryServicesImpl.this.upgradeRequired.get()) {
                                        ConnectionQueryServicesImpl.this.createOtherSystemTables(metaConnection);
                                        break block110;
                                    }
                                    if (ConnectionQueryServicesImpl.this.isAutoUpgradeEnabled && !isDoNotUpgradePropSet) {
                                        ConnectionQueryServicesImpl.this.upgradeSystemTables(url, props);
                                    }
                                }
                            }
                            ConnectionQueryServicesImpl.this.scheduleRenewLeaseTasks();
                            success = true;
                        }
                        catch (RetriableUpgradeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            if (e instanceof SQLException) {
                                ConnectionQueryServicesImpl.this.initializationException = (SQLException)e;
                            } else {
                                ConnectionQueryServicesImpl.this.initializationException = new SQLException(e);
                            }
                        }
                        finally {
                            try {
                                if (!success && hConnectionEstablished) {
                                    ConnectionQueryServicesImpl.this.connection.close();
                                }
                            }
                            catch (IOException e) {
                                SQLException ex = new SQLException(e);
                                if (ConnectionQueryServicesImpl.this.initializationException != null) {
                                    ConnectionQueryServicesImpl.this.initializationException.setNextException(ex);
                                } else {
                                    ConnectionQueryServicesImpl.this.initializationException = ex;
                                }
                            }
                            finally {
                                try {
                                    if (ConnectionQueryServicesImpl.this.initializationException != null) {
                                        throw ConnectionQueryServicesImpl.this.initializationException;
                                    }
                                }
                                finally {
                                    ConnectionQueryServicesImpl.this.setInitialized(true);
                                }
                            }
                        }
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, SQLException.class);
            Throwables.propagate((Throwable)e);
        }
    }

    private void createSysMutexTable(HBaseAdmin admin) throws IOException, SQLException {
        try {
            TableName mutexTableName = TableName.valueOf((byte[])PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME_BYTES);
            List<TableName> systemTables = this.getSystemTableNames(admin);
            if (systemTables.contains(mutexTableName)) {
                logger.debug("System mutex table already appears to exist, not creating it");
                return;
            }
            HTableDescriptor tableDesc = new HTableDescriptor(mutexTableName);
            HColumnDescriptor columnDesc = new HColumnDescriptor(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES);
            columnDesc.setTimeToLive(900);
            tableDesc.addFamily(columnDesc);
            admin.createTable(tableDesc);
            try (HTableInterface sysMutexTable = this.getTable(PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME_BYTES);){
                byte[] mutexRowKey = SchemaUtil.getTableKey(null, "SYSTEM", "CATALOG");
                Put put = new Put(mutexRowKey);
                put.add(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES, UPGRADE_MUTEX, UPGRADE_MUTEX_UNLOCKED);
                sysMutexTable.put(put);
            }
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
    }

    List<TableName> getSystemTableNames(HBaseAdmin admin) throws IOException {
        return Lists.newArrayList((Object[])admin.listTableNames("SYSTEM\\..*"));
    }

    private void createOtherSystemTables(PhoenixConnection metaConnection) throws SQLException {
        try {
            metaConnection.createStatement().execute(QueryConstants.CREATE_SEQUENCE_METADATA);
        }
        catch (TableAlreadyExistsException e) {
            this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
        }
        try {
            metaConnection.createStatement().execute(QueryConstants.CREATE_STATS_TABLE_METADATA);
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().execute(this.getFunctionTableDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().execute(this.getLogTableDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void upgradeSystemTables(String url, Properties props) throws SQLException {
        PhoenixConnection metaConnection = null;
        boolean success = false;
        String snapshotName = null;
        String sysCatalogTableName = null;
        SQLException toThrow = null;
        boolean acquiredMutexLock = false;
        byte[] mutexRowKey = SchemaUtil.getTableKey(null, "SYSTEM", "CATALOG");
        boolean snapshotCreated = false;
        try {
            block129: {
                long currentServerSideTableTimeStamp;
                block128: {
                    if (!this.isUpgradeRequired()) {
                        throw new UpgradeNotRequiredException();
                    }
                    Properties scnProps = PropertiesUtil.deepCopy(props);
                    scnProps.setProperty("CurrentSCN", Long.toString(27L));
                    scnProps.remove("TenantId");
                    String globalUrl = JDBCUtil.removeProperty(url, "TenantId");
                    metaConnection = new PhoenixConnection(this, globalUrl, scnProps, this.newEmptyMetaData());
                    metaConnection.setRunningUpgrade(true);
                    try {
                        metaConnection.createStatement().executeUpdate(this.getSystemCatalogTableDDL());
                    }
                    catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
                    }
                    catch (TableAlreadyExistsException e) {
                        long currentServerSideTableTimeStamp2 = e.getTable().getTimeStamp();
                        sysCatalogTableName = e.getTable().getPhysicalName().getString();
                        if (currentServerSideTableTimeStamp2 < 27L && (acquiredMutexLock = this.acquireUpgradeMutex(currentServerSideTableTimeStamp2, mutexRowKey))) {
                            snapshotName = UpgradeUtil.getSysCatalogSnapshotName(currentServerSideTableTimeStamp2);
                            this.createSnapshot(snapshotName, sysCatalogTableName);
                            snapshotCreated = true;
                        }
                        String columnsToAdd = "";
                        if (currentServerSideTableTimeStamp2 < 7L) {
                            columnsToAdd = this.addColumn(columnsToAdd, "STORE_NULLS " + PBoolean.INSTANCE.getSqlTypeName());
                            try (HBaseAdmin admin = this.getAdmin();){
                                HTableDescriptor[] localIndexTables;
                                for (HTableDescriptor table : localIndexTables = admin.listTables("_LOCAL_IDX_.*")) {
                                    if (table.getValue("PARENT_TABLE") != null || table.getValue("IS_LOCAL_INDEX_TABLE") == null) continue;
                                    table.setValue("PARENT_TABLE", MetaDataUtil.getLocalIndexUserTableName(table.getNameAsString()));
                                    admin.disableTable(table.getTableName());
                                    admin.modifyTable(table.getTableName(), table);
                                    admin.enableTable(table.getTableName());
                                }
                            }
                        }
                        if (currentServerSideTableTimeStamp2 < 3L) {
                            columnsToAdd = this.addColumn(columnsToAdd, "INDEX_TYPE " + PUnsignedTinyint.INSTANCE.getSqlTypeName() + ", " + "INDEX_DISABLE_TIMESTAMP" + " " + PLong.INSTANCE.getSqlTypeName());
                        }
                        if (!columnsToAdd.isEmpty()) {
                            PhoenixConnection newMetaConnection;
                            metaConnection = newMetaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 7L, columnsToAdd);
                        }
                        if (currentServerSideTableTimeStamp2 < 8L) {
                            columnsToAdd = "BASE_COLUMN_COUNT " + PInteger.INSTANCE.getSqlTypeName();
                            try {
                                metaConnection = this.addColumn(metaConnection, "SYSTEM.\"CATALOG\"", 8L, columnsToAdd, false);
                                UpgradeUtil.upgradeTo4_5_0(metaConnection);
                            }
                            catch (ColumnAlreadyExistsException ignored) {
                                logger.debug("No need to run 4.5 upgrade");
                            }
                            Properties p = PropertiesUtil.deepCopy(metaConnection.getClientInfo());
                            p.remove("CurrentSCN");
                            p.remove("TenantId");
                            try (PhoenixConnection conn = new PhoenixConnection(this, metaConnection.getURL(), p, metaConnection.getMetaDataCache());){
                                List<String> unsupportedTables;
                                List<String> tablesNeedingUpgrade = UpgradeUtil.getPhysicalTablesWithDescRowKey(conn);
                                if (!tablesNeedingUpgrade.isEmpty()) {
                                    logger.warn("The following tables require upgrade due to a bug causing the row key to be incorrect for descending columns and ascending BINARY columns (PHOENIX-2067 and PHOENIX-2120):\n" + Joiner.on((char)' ').join(tablesNeedingUpgrade) + "\nTo upgrade issue the \"bin/psql.py -u\" command.");
                                }
                                if (!(unsupportedTables = UpgradeUtil.getPhysicalTablesWithDescVarbinaryRowKey(conn)).isEmpty()) {
                                    logger.warn("The following tables use an unsupported VARBINARY DESC construct and need to be changed:\n" + Joiner.on((char)' ').join(unsupportedTables));
                                }
                            }
                        }
                        if (currentServerSideTableTimeStamp2 < 9L) {
                            columnsToAdd = "IS_ROW_TIMESTAMP " + PBoolean.INSTANCE.getSqlTypeName();
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 9L, columnsToAdd);
                        }
                        if (currentServerSideTableTimeStamp2 < 15L) {
                            metaConnection = this.dropStatsTable(metaConnection, 11L);
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 12L, "TRANSACTIONAL " + PBoolean.INSTANCE.getSqlTypeName());
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 13L, "UPDATE_CACHE_FREQUENCY " + PLong.INSTANCE.getSqlTypeName());
                            metaConnection = this.setImmutableTableIndexesImmutable(metaConnection, 14L);
                            metaConnection = this.updateSystemCatalogTimestamp(metaConnection, 15L);
                            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 15L);
                            this.clearCache();
                        }
                        if (currentServerSideTableTimeStamp2 < 18L) {
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 16L, "IS_NAMESPACE_MAPPED " + PBoolean.INSTANCE.getSqlTypeName());
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 17L, "AUTO_PARTITION_SEQ " + PVarchar.INSTANCE.getSqlTypeName());
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 18L, "APPEND_ONLY_SCHEMA " + PBoolean.INSTANCE.getSqlTypeName());
                            metaConnection = UpgradeUtil.disableViewIndexes(metaConnection);
                            if (this.getProps().getBoolean("phoenix.client.localIndexUpgrade", true)) {
                                metaConnection = UpgradeUtil.upgradeLocalIndexes(metaConnection);
                            }
                            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 18L);
                            this.clearCache();
                        }
                        if (currentServerSideTableTimeStamp2 < 20L) {
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 20L, "GUIDE_POSTS_WIDTH " + PLong.INSTANCE.getSqlTypeName());
                            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 20L);
                            this.clearCache();
                        }
                        if (currentServerSideTableTimeStamp2 < 25L) {
                            metaConnection = this.addColumnQualifierColumn(metaConnection, 22L);
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 23L, "IMMUTABLE_STORAGE_SCHEME " + PTinyint.INSTANCE.getSqlTypeName());
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 24L, "ENCODING_SCHEME " + PTinyint.INSTANCE.getSqlTypeName());
                            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 25L, "QUALIFIER_COUNTER " + PInteger.INSTANCE.getSqlTypeName());
                            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 25L);
                            this.clearCache();
                        }
                        if (currentServerSideTableTimeStamp2 >= 27L) break block128;
                        metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 27L, "USE_STATS_FOR_PARALLELIZATION " + PBoolean.INSTANCE.getSqlTypeName());
                        UpgradeUtil.addParentToChildLinks(metaConnection);
                    }
                }
                int nSaltBuckets = this.props.getInt("phoenix.sequence.saltBuckets", 0);
                try {
                    String createSequenceTable = Sequence.getCreateTableStatement(nSaltBuckets);
                    metaConnection.createStatement().executeUpdate(createSequenceTable);
                    this.nSequenceSaltBuckets = nSaltBuckets;
                }
                catch (NewerTableAlreadyExistsException e) {
                    this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
                }
                catch (TableAlreadyExistsException e) {
                    currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
                    if (currentServerSideTableTimeStamp < 3L) {
                        String columnsToAdd = "MIN_VALUE " + PLong.INSTANCE.getSqlTypeName() + ", " + "MAX_VALUE" + " " + PLong.INSTANCE.getSqlTypeName() + ", " + "CYCLE_FLAG" + " " + PBoolean.INSTANCE.getSqlTypeName() + ", " + "LIMIT_REACHED_FLAG" + " " + PBoolean.INSTANCE.getSqlTypeName();
                        this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 27L, columnsToAdd);
                    }
                    if (currentServerSideTableTimeStamp < 5L) {
                        if (UpgradeUtil.upgradeSequenceTable(metaConnection, nSaltBuckets, e.getTable())) {
                            metaConnection.removeTable(null, "SYSTEM", "SEQUENCE", 27L);
                            this.clearTableFromCache(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_SCHEMA_BYTES, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_TABLE_BYTES, 27L);
                            this.clearTableRegionCache(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES);
                        }
                        this.nSequenceSaltBuckets = nSaltBuckets;
                    }
                    this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
                }
                try {
                    metaConnection.createStatement().executeUpdate(QueryConstants.CREATE_STATS_TABLE_METADATA);
                }
                catch (NewerTableAlreadyExistsException e) {
                }
                catch (TableAlreadyExistsException e) {
                    currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
                    if (currentServerSideTableTimeStamp < 7L) {
                        metaConnection = this.addColumnsIfNotExists(metaConnection, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME, 27L, "GUIDE_POSTS_ROW_COUNT " + PLong.INSTANCE.getSqlTypeName());
                    }
                    if (currentServerSideTableTimeStamp >= 20L) break block129;
                    metaConnection = this.removeNotNullConstraint(metaConnection, "SYSTEM", "STATS", 20L, "COLUMN_FAMILY");
                    this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME, null, 20L);
                    this.clearCache();
                }
            }
            try {
                metaConnection.createStatement().executeUpdate(this.getFunctionTableDDL());
            }
            catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
            }
            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                // empty catch block
            }
            if (SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
                try {
                    metaConnection.createStatement().executeUpdate("CREATE SCHEMA IF NOT EXISTS SYSTEM");
                }
                catch (NewerSchemaAlreadyExistsException newerSchemaAlreadyExistsException) {
                    // empty catch block
                }
            }
            try {
                metaConnection.createStatement().executeUpdate(this.getLogTableDDL());
            }
            catch (NewerTableAlreadyExistsException newerTableAlreadyExistsException) {
            }
            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                // empty catch block
            }
            this.upgradeRequired.set(false);
            success = true;
            try {
                if (metaConnection == null) return;
                metaConnection.close();
                return;
            }
            catch (SQLException e) {
                if (toThrow != null) {
                    toThrow.setNextException(e);
                }
                toThrow = e;
            }
            finally {
                try {
                    if (snapshotCreated) {
                        this.restoreFromSnapshot(sysCatalogTableName, snapshotName, success);
                    }
                }
                catch (SQLException e) {
                    if (toThrow != null) {
                        toThrow.setNextException(e);
                    } else {
                        toThrow = e;
                    }
                }
                finally {
                    if (acquiredMutexLock) {
                        this.releaseUpgradeMutex(mutexRowKey);
                    }
                }
                if (toThrow == null) return;
                throw toThrow;
            }
        }
        catch (UpgradeInProgressException | UpgradeNotRequiredException e) {
            throw e;
            catch (Exception e2) {
                if (e2 instanceof SQLException) {
                    toThrow = (SQLException)e2;
                }
                toThrow = new SQLException(e2);
            }
        }
        finally {
            try {
                if (metaConnection != null) {
                    metaConnection.close();
                }
            }
            catch (SQLException e) {
                if (toThrow != null) {
                    toThrow.setNextException(e);
                }
                toThrow = e;
            }
            finally {
                try {
                    if (snapshotCreated) {
                        this.restoreFromSnapshot(sysCatalogTableName, snapshotName, success);
                    }
                }
                catch (SQLException e) {
                    if (toThrow != null) {
                        toThrow.setNextException(e);
                    } else {
                        toThrow = e;
                    }
                }
                finally {
                    if (acquiredMutexLock) {
                        this.releaseUpgradeMutex(mutexRowKey);
                    }
                }
                if (toThrow == null) return;
                throw toThrow;
            }
        }
    }

    private PhoenixConnection addColumnQualifierColumn(PhoenixConnection oldMetaConnection, Long timestamp) throws SQLException {
        Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
        props.setProperty("CurrentSCN", Long.toString(timestamp));
        PhoenixConnection metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
        PTable sysCatalogPTable = metaConnection.getTable(new PTableKey(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
        int numColumns = sysCatalogPTable.getColumns().size();
        try (PreparedStatement mutateTable = metaConnection.prepareStatement("UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT) VALUES (?, ?, ?, ?, ?, ?)");){
            mutateTable.setString(1, null);
            mutateTable.setString(2, "SYSTEM");
            mutateTable.setString(3, "CATALOG");
            mutateTable.setString(4, PTableType.SYSTEM.getSerializedValue());
            mutateTable.setLong(5, sysCatalogPTable.getSequenceNumber() + 1L);
            mutateTable.setInt(6, numColumns + 1);
            mutateTable.execute();
        }
        ArrayList<Mutation> tableMetadata = new ArrayList<Mutation>();
        tableMetadata.addAll((Collection)metaConnection.getMutationState().toMutations(metaConnection.getSCN()).next().getSecond());
        metaConnection.rollback();
        PColumnImpl column = new PColumnImpl(PNameFactory.newName("COLUMN_QUALIFIER"), PNameFactory.newName("DEFAULT_COLUMN_FAMILY"), PVarbinary.INSTANCE, null, null, true, numColumns, SortOrder.ASC, null, null, false, null, false, false, Bytes.toBytes((String)"COLUMN_QUALIFIER"));
        String upsertColumnMetadata = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF,IS_ROW_TIMESTAMP) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement colUpsert = metaConnection.prepareStatement(upsertColumnMetadata);){
            colUpsert.setString(1, null);
            colUpsert.setString(2, "SYSTEM");
            colUpsert.setString(3, "CATALOG");
            colUpsert.setString(4, "COLUMN_QUALIFIER");
            colUpsert.setString(5, "0");
            colUpsert.setInt(6, column.getDataType().getSqlType());
            colUpsert.setInt(7, 1);
            colUpsert.setNull(8, 4);
            colUpsert.setNull(9, 4);
            colUpsert.setInt(10, sysCatalogPTable.getBucketNum() != null ? numColumns : numColumns + 1);
            colUpsert.setInt(11, SortOrder.ASC.getSystemValue());
            colUpsert.setString(12, null);
            colUpsert.setNull(13, 4);
            colUpsert.setBytes(14, null);
            colUpsert.setBoolean(15, false);
            colUpsert.setString(16, sysCatalogPTable.getPKName() == null ? null : sysCatalogPTable.getPKName().getString());
            colUpsert.setNull(17, 5);
            colUpsert.setNull(18, 12);
            colUpsert.setBoolean(19, false);
            colUpsert.execute();
        }
        tableMetadata.addAll((Collection)metaConnection.getMutationState().toMutations(metaConnection.getSCN()).next().getSecond());
        metaConnection.rollback();
        metaConnection.getQueryServices().addColumn(tableMetadata, sysCatalogPTable, Collections.emptyMap(), Collections.emptySet(), Lists.newArrayList((Object[])new PColumn[]{column}));
        metaConnection.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, timestamp);
        this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, timestamp);
        this.clearCache();
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSnapshot(String snapshotName, String tableName) throws SQLException {
        HBaseAdmin admin = null;
        SQLException sqlE = null;
        try {
            admin = this.getAdmin();
            admin.snapshot(snapshotName, tableName);
            logger.info("Successfully created snapshot " + snapshotName + " for " + tableName);
            return;
        }
        catch (Exception e) {
            sqlE = new SQLException(e);
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (Exception e) {
                SQLException adminCloseEx = new SQLException(e);
                if (sqlE == null) {
                    sqlE = adminCloseEx;
                }
                sqlE.setNextException(adminCloseEx);
            }
            finally {
                if (sqlE == null) return;
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreFromSnapshot(String tableName, String snapshotName, boolean success) throws SQLException {
        boolean snapshotRestored = false;
        boolean tableDisabled = false;
        if (success) return;
        if (snapshotName == null) return;
        SQLException sqlE = null;
        HBaseAdmin admin = null;
        logger.warn("Starting restore of " + tableName + " using snapshot " + snapshotName + " because upgrade failed");
        admin = this.getAdmin();
        admin.disableTable(tableName);
        tableDisabled = true;
        admin.restoreSnapshot(snapshotName);
        snapshotRestored = true;
        logger.warn("Successfully restored " + tableName + " using snapshot " + snapshotName);
        if (admin == null) return;
        if (!tableDisabled) return;
        try {
            admin.enableTable(tableName);
            if (snapshotRestored) {
                logger.warn("Successfully restored and enabled " + tableName + " using snapshot " + snapshotName);
                return;
            }
            logger.warn("Successfully enabled " + tableName + " after restoring using snapshot " + snapshotName + " failed. ");
            return;
        }
        catch (Exception e1) {
            SQLException enableTableEx = new SQLException(e1);
            if (sqlE == null) {
                sqlE = enableTableEx;
            } else {
                sqlE.setNextException(enableTableEx);
            }
            logger.error("Failure in enabling " + tableName + (snapshotRestored ? " after successfully restoring using snapshot" + snapshotName : " after restoring using snapshot " + snapshotName + " failed. "));
        }
        finally {
            try {
                admin.close();
            }
            catch (Exception e2) {
                SQLException adminCloseEx = new SQLException(e2);
                if (sqlE == null) {
                    sqlE = adminCloseEx;
                }
                sqlE.setNextException(adminCloseEx);
            }
            finally {
                if (sqlE == null) return;
                throw sqlE;
            }
        }
        catch (Exception e) {
            try {
                sqlE = new SQLException(e);
                if (admin == null) return;
                if (!tableDisabled) return;
            }
            catch (Throwable throwable) {
                if (admin == null) throw throwable;
                if (!tableDisabled) throw throwable;
                try {
                    admin.enableTable(tableName);
                    if (snapshotRestored) {
                        logger.warn("Successfully restored and enabled " + tableName + " using snapshot " + snapshotName);
                        throw throwable;
                    }
                    logger.warn("Successfully enabled " + tableName + " after restoring using snapshot " + snapshotName + " failed. ");
                    throw throwable;
                }
                catch (Exception e1) {
                    SQLException enableTableEx = new SQLException(e1);
                    if (sqlE == null) {
                        sqlE = enableTableEx;
                    } else {
                        sqlE.setNextException(enableTableEx);
                    }
                    logger.error("Failure in enabling " + tableName + (snapshotRestored ? " after successfully restoring using snapshot" + snapshotName : " after restoring using snapshot " + snapshotName + " failed. "));
                }
                finally {
                    try {
                        admin.close();
                    }
                    catch (Exception e2) {
                        SQLException adminCloseEx = new SQLException(e2);
                        if (sqlE == null) {
                            sqlE = adminCloseEx;
                        }
                        sqlE.setNextException(adminCloseEx);
                    }
                    finally {
                        if (sqlE == null) throw throwable;
                        throw sqlE;
                    }
                }
            }
            try {
                admin.enableTable(tableName);
                if (snapshotRestored) {
                    logger.warn("Successfully restored and enabled " + tableName + " using snapshot " + snapshotName);
                }
                logger.warn("Successfully enabled " + tableName + " after restoring using snapshot " + snapshotName + " failed. ");
            }
            catch (Exception e1) {
                SQLException enableTableEx = new SQLException(e1);
                if (sqlE == null) {
                    sqlE = enableTableEx;
                } else {
                    sqlE.setNextException(enableTableEx);
                }
                logger.error("Failure in enabling " + tableName + (snapshotRestored ? " after successfully restoring using snapshot" + snapshotName : " after restoring using snapshot " + snapshotName + " failed. "));
            }
            finally {
                try {
                    admin.close();
                }
                catch (Exception e2) {
                    SQLException adminCloseEx = new SQLException(e2);
                    if (sqlE == null) {
                        sqlE = adminCloseEx;
                    }
                    sqlE.setNextException(adminCloseEx);
                }
                finally {
                    if (sqlE == null) return;
                    throw sqlE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureSystemTablesUpgraded(ReadOnlyProps props) throws SQLException, IOException, IllegalArgumentException, InterruptedException {
        if (!SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, props)) {
            return;
        }
        try (HTableInterface metatable = null;
             HBaseAdmin admin = this.getAdmin();){
            try {
                this.ensureNamespaceCreated("SYSTEM");
            }
            catch (PhoenixIOException phoenixIOException) {
                // empty catch block
            }
            List<TableName> tableNames = this.getSystemTableNames(admin);
            if (tableNames.size() == 0) {
                return;
            }
            if (tableNames.size() > 5) {
                logger.warn("Expected 5 system tables but found " + tableNames.size() + ":" + tableNames);
            }
            byte[] mappedSystemTable = SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, props).getName();
            metatable = this.getTable(mappedSystemTable);
            if (tableNames.contains(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME)) {
                if (!admin.tableExists(mappedSystemTable)) {
                    UpgradeUtil.mapTableToNamespace(admin, metatable, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, props, null, PTableType.SYSTEM, null);
                    this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 3L);
                }
                tableNames.remove(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME);
            }
            tableNames.remove(PhoenixDatabaseMetaData.SYSTEM_MUTEX_HBASE_TABLE_NAME);
            for (TableName table : tableNames) {
                UpgradeUtil.mapTableToNamespace(admin, metatable, table.getNameAsString(), props, null, PTableType.SYSTEM, null);
                this.removeTable(null, table.getNameAsString(), null, 3L);
            }
            if (!tableNames.isEmpty()) {
                this.clearCache();
            }
        }
    }

    @VisibleForTesting
    public boolean acquireUpgradeMutex(long currentServerSideTableTimestamp, byte[] rowToLock) throws IOException, SQLException {
        Preconditions.checkArgument((currentServerSideTableTimestamp < 27L ? 1 : 0) != 0);
        try (HTableInterface sysMutexTable = this.getTable(PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME_BYTES);){
            byte[] family = PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES;
            byte[] qualifier = UPGRADE_MUTEX;
            byte[] oldValue = UPGRADE_MUTEX_UNLOCKED;
            byte[] newValue = UPGRADE_MUTEX_LOCKED;
            Put put = new Put(rowToLock);
            put.addColumn(family, qualifier, newValue);
            boolean acquired = sysMutexTable.checkAndPut(rowToLock, family, qualifier, oldValue, put);
            if (!acquired && !(acquired = sysMutexTable.checkAndPut(rowToLock, family, qualifier, null, put))) {
                throw new UpgradeInProgressException(MetaDataProtocol.getVersion(currentServerSideTableTimestamp), MetaDataProtocol.getVersion(27L));
            }
            boolean bl = true;
            return bl;
        }
    }

    @VisibleForTesting
    public boolean releaseUpgradeMutex(byte[] mutexRowKey) {
        boolean released = false;
        try (HTableInterface sysMutexTable = this.getTable(PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME_BYTES);){
            byte[] family = PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES;
            byte[] qualifier = UPGRADE_MUTEX;
            byte[] expectedValue = UPGRADE_MUTEX_LOCKED;
            byte[] newValue = UPGRADE_MUTEX_UNLOCKED;
            Put put = new Put(mutexRowKey);
            put.addColumn(family, qualifier, newValue);
            released = sysMutexTable.checkAndPut(mutexRowKey, family, qualifier, expectedValue, put);
        }
        catch (Exception e) {
            logger.warn("Release of upgrade mutex failed", (Throwable)e);
        }
        return released;
    }

    private String addColumn(String columnsToAddSoFar, String columns) {
        if (columnsToAddSoFar == null || columnsToAddSoFar.isEmpty()) {
            return columns;
        }
        return columnsToAddSoFar + ", " + columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection setImmutableTableIndexesImmutable(PhoenixConnection oldMetaConnection, long timestamp) throws SQLException {
        PhoenixConnection metaConnection;
        block12: {
            SQLException sqlE = null;
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            boolean autoCommit = metaConnection.getAutoCommit();
            try {
                metaConnection.setAutoCommit(true);
                metaConnection.createStatement().execute("UPSERT INTO SYSTEM.CATALOG(TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, IMMUTABLE_ROWS)\nSELECT A.TENANT_ID, A.TABLE_SCHEM,B.COLUMN_FAMILY,null,null,true\nFROM SYSTEM.CATALOG A JOIN SYSTEM.CATALOG B ON (\n A.TENANT_ID = B.TENANT_ID AND \n A.TABLE_SCHEM = B.TABLE_SCHEM AND\n A.TABLE_NAME = B.TABLE_NAME AND\n A.COLUMN_NAME = B.COLUMN_NAME AND\n B.LINK_TYPE = 1\n)\nWHERE A.COLUMN_FAMILY IS NULL AND\n B.COLUMN_FAMILY IS NOT NULL AND\n A.IMMUTABLE_ROWS = TRUE");
            }
            catch (SQLException e) {
                logger.warn("exception during upgrading stats table:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    metaConnection.setAutoCommit(autoCommit);
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection updateSystemCatalogTimestamp(PhoenixConnection oldMetaConnection, long timestamp) throws SQLException {
        PhoenixConnection metaConnection;
        block12: {
            SQLException sqlE = null;
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            boolean autoCommit = metaConnection.getAutoCommit();
            try {
                metaConnection.setAutoCommit(true);
                metaConnection.createStatement().execute("UPSERT INTO SYSTEM.CATALOG(TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, DISABLE_WAL)\nVALUES (NULL, 'SYSTEM','CATALOG', NULL, NULL, FALSE)");
            }
            catch (SQLException e) {
                logger.warn("exception during upgrading stats table:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    metaConnection.setAutoCommit(autoCommit);
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection dropStatsTable(PhoenixConnection oldMetaConnection, long timestamp) throws SQLException, IOException {
        PhoenixConnection metaConnection;
        block12: {
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            SQLException sqlE = null;
            boolean wasCommit = metaConnection.getAutoCommit();
            try {
                metaConnection.setAutoCommit(true);
                metaConnection.createStatement().executeUpdate("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_NAME" + "='" + "STATS" + "' AND " + "TABLE_SCHEM" + "='" + "SYSTEM" + "'");
            }
            catch (SQLException e) {
                logger.warn("exception during upgrading stats table:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    metaConnection.setAutoCommit(wasCommit);
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    private void scheduleRenewLeaseTasks() {
        if (this.isRenewingLeasesEnabled()) {
            this.renewLeaseExecutor = Executors.newScheduledThreadPool(this.renewLeasePoolSize, renewLeaseThreadFactory);
            for (LinkedBlockingQueue<WeakReference<PhoenixConnection>> q : this.connectionQueues) {
                this.renewLeaseExecutor.scheduleAtFixedRate(new RenewLeaseTask(q), 0L, this.renewLeaseTaskFrequency, TimeUnit.MILLISECONDS);
            }
        }
    }

    private static int getSaltBuckets(TableAlreadyExistsException e) {
        PTable table = e.getTable();
        Integer sequenceSaltBuckets = table == null ? null : table.getBucketNum();
        return sequenceSaltBuckets == null ? 0 : sequenceSaltBuckets;
    }

    @Override
    public MutationState updateData(MutationPlan plan) throws SQLException {
        MutationState state2 = plan.execute();
        plan.getContext().getConnection().commit();
        return state2;
    }

    @Override
    public int getLowestClusterHBaseVersion() {
        return this.lowestClusterHBaseVersion;
    }

    @Override
    public boolean hasIndexWALCodec() {
        return this.hasIndexWALCodec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long clearCache() throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.latestMetaData = this.newEmptyMetaData();
        }
        this.tableStatsCache.invalidateAll();
        try (HTableInterface htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());){
            Map results = htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, Long>(){

                public Long call(MetaDataProtos.MetaDataService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                    MetaDataProtos.ClearCacheRequest.Builder builder = MetaDataProtos.ClearCacheRequest.newBuilder();
                    builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                    instance.clearCache((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.ClearCacheResponse>)rpcCallback);
                    if (controller.getFailedOn() != null) {
                        throw controller.getFailedOn();
                    }
                    return ((MetaDataProtos.ClearCacheResponse)rpcCallback.get()).getUnfreedBytes();
                }
            });
            long unfreedBytes = 0L;
            for (Map.Entry result : results.entrySet()) {
                if (result.getValue() == null) continue;
                unfreedBytes += ((Long)result.getValue()).longValue();
            }
            long l = unfreedBytes;
            return l;
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    private void flushTable(byte[] tableName) throws SQLException {
        HBaseAdmin admin = this.getAdmin();
        try {
            admin.flush(tableName);
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
        }
        finally {
            Closeables.closeQuietly((Closeable)admin);
        }
    }

    @Override
    public HBaseAdmin getAdmin() throws SQLException {
        try {
            return new HBaseAdmin((Connection)this.connection);
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult updateIndexState(final List<Mutation> tableMetaData, String parentTableName) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tableKey = SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, rowKeyMetadata[1], rowKeyMetadata[2]);
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.UpdateIndexStateRequest.Builder builder = MetaDataProtos.UpdateIndexStateRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.updateIndexState((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    /*
     * Loose catch block
     */
    @Override
    public long createSequence(String tenantId, String schemaName, String sequenceName, long startWith, long incrementBy, long cacheSize, long minValue, long maxValue, boolean cycle, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName, this.nSequenceSaltBuckets);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.createSequence(startWith, incrementBy, cacheSize, timestamp, minValue, maxValue, cycle);
            HTableInterface htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
            htable.setAutoFlush(true);
            try {
                Result result = htable.append(append);
                long l = sequence.createSequence(result, minValue, maxValue, cycle);
                return l;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            finally {
                Closeables.closeQuietly((Closeable)htable);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public long dropSequence(String tenantId, String schemaName, String sequenceName, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName, this.nSequenceSaltBuckets);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.dropSequence(timestamp);
            HTableInterface htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
            try {
                Result result = htable.append(append);
                long l = sequence.dropSequence(result);
                return l;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            finally {
                Closeables.closeQuietly((Closeable)htable);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public long currentSequenceValue(SequenceKey sequenceKey, long timestamp) throws SQLException {
        Sequence sequence = (Sequence)this.sequenceMap.get(sequenceKey);
        if (sequence == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        sequence.getLock().lock();
        try {
            long l = sequence.currentValue(timestamp);
            return l;
        }
        catch (EmptySequenceCacheException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public void validateSequences(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions, Sequence.ValueOp action) throws SQLException {
        this.incrementSequenceValues(sequenceAllocations, timestamp, values, exceptions, action);
    }

    @Override
    public void incrementSequences(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions) throws SQLException {
        this.incrementSequenceValues(sequenceAllocations, timestamp, values, exceptions, Sequence.ValueOp.INCREMENT_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSequenceValues(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions, Sequence.ValueOp op) throws SQLException {
        Sequence sequence4;
        ArrayList sequences = Lists.newArrayListWithExpectedSize((int)sequenceAllocations.size());
        for (SequenceAllocation sequenceAllocation : sequenceAllocations) {
            Sequence newSequences;
            SequenceKey key = sequenceAllocation.getSequenceKey();
            sequence4 = this.sequenceMap.putIfAbsent(key, newSequences = new Sequence(key));
            if (sequence4 == null) {
                sequence4 = newSequences;
            }
            sequences.add(sequence4);
        }
        try {
            Object[] resultObjects;
            ArrayList toIncrementList;
            ArrayList incrementBatch;
            block32: {
                for (Sequence sequence2 : sequences) {
                    sequence2.getLock().lock();
                }
                incrementBatch = Lists.newArrayListWithExpectedSize((int)sequences.size());
                toIncrementList = Lists.newArrayListWithExpectedSize((int)sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    sequence4 = (Sequence)sequences.get(i);
                    try {
                        values[i] = sequence4.incrementValue(timestamp, op, sequenceAllocations.get(i).getNumAllocations());
                        continue;
                    }
                    catch (EmptySequenceCacheException e) {
                        indexes[toIncrementList.size()] = i;
                        toIncrementList.add(sequence4);
                        Increment inc = sequence4.newIncrement(timestamp, op, sequenceAllocations.get(i).getNumAllocations());
                        incrementBatch.add(inc);
                        continue;
                    }
                    catch (SQLException e) {
                        exceptions[i] = e;
                    }
                }
                if (toIncrementList.isEmpty()) {
                    return;
                }
                HTableInterface hTable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
                resultObjects = null;
                SQLException sqlE = null;
                try {
                    resultObjects = hTable.batch((List)incrementBatch);
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block32;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence3 = (Sequence)toIncrementList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    long numToAllocate = Bytes.toLong((byte[])((Increment)incrementBatch.get(i)).getAttribute("NUM_TO_ALLOCATE"));
                    values[indexes[i]] = sequence3.incrementValue(result, op, numToAllocate);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence4 : sequences) {
                sequence4.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearTableFromCache(final byte[] tenantId, final byte[] schemaName, final byte[] tableName, final long clientTS) throws SQLException {
        try {
            SQLException sqlE = null;
            HTableInterface htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
            try {
                htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.ClearTableFromCacheResponse>(){

                    public MetaDataProtos.ClearTableFromCacheResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                        ServerRpcController controller = new ServerRpcController();
                        BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                        MetaDataProtos.ClearTableFromCacheRequest.Builder builder = MetaDataProtos.ClearTableFromCacheRequest.newBuilder();
                        builder.setTenantId(ByteStringer.wrap((byte[])tenantId));
                        builder.setTableName(ByteStringer.wrap((byte[])tableName));
                        builder.setSchemaName(ByteStringer.wrap((byte[])schemaName));
                        builder.setClientTimestamp(clientTS);
                        builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                        instance.clearTableFromCache((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.ClearTableFromCacheResponse>)rpcCallback);
                        if (controller.getFailedOn() != null) {
                            throw controller.getFailedOn();
                        }
                        return (MetaDataProtos.ClearTableFromCacheResponse)rpcCallback.get();
                    }
                });
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            catch (Throwable e) {
                sqlE = new SQLException(e);
            }
            finally {
                try {
                    htable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                finally {
                    if (sqlE == null) return;
                    throw sqlE;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(ServerUtil.parseServerException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnSequences(List<SequenceKey> keys, long timestamp, SQLException[] exceptions) throws SQLException {
        ArrayList sequences = Lists.newArrayListWithExpectedSize((int)keys.size());
        for (SequenceKey key : keys) {
            Sequence newSequences;
            Sequence sequence = this.sequenceMap.putIfAbsent(key, newSequences = new Sequence(key));
            if (sequence == null) {
                sequence = newSequences;
            }
            sequences.add(sequence);
        }
        try {
            Object[] resultObjects;
            ArrayList toReturnList;
            block31: {
                for (Sequence sequence : sequences) {
                    sequence.getLock().lock();
                }
                ArrayList mutations = Lists.newArrayListWithExpectedSize((int)sequences.size());
                toReturnList = Lists.newArrayListWithExpectedSize((int)sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    Sequence sequence = (Sequence)sequences.get(i);
                    try {
                        Append append = sequence.newReturn(timestamp);
                        toReturnList.add(sequence);
                        mutations.add(append);
                        continue;
                    }
                    catch (EmptySequenceCacheException append) {
                        // empty catch block
                    }
                }
                if (toReturnList.isEmpty()) {
                    return;
                }
                HTableInterface hTable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
                resultObjects = null;
                SQLException sqlE = null;
                try {
                    resultObjects = hTable.batch((List)mutations);
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block31;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence = (Sequence)toReturnList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    sequence.returnValue(result);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnAllSequences(ConcurrentMap<SequenceKey, Sequence> sequenceMap) throws SQLException {
        block18: {
            ArrayList mutations = Lists.newArrayListWithExpectedSize((int)sequenceMap.size());
            for (Sequence sequence : sequenceMap.values()) {
                mutations.addAll(sequence.newReturns());
            }
            if (mutations.isEmpty()) {
                return;
            }
            HTableInterface hTable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
            SQLException sqlE = null;
            try {
                hTable.batch((List)mutations);
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            finally {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                if (sqlE == null) break block18;
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(PhoenixConnection connection) throws SQLException {
        if (this.returnSequenceValues || this.shouldThrottleNumConnections) {
            Object object = this.connectionCountLock;
            synchronized (object) {
                if (this.shouldThrottleNumConnections && this.connectionCount + 1 > this.maxConnectionsAllowed) {
                    GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_THROTTLED_COUNTER.increment();
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NEW_CONNECTION_THROTTLED).build().buildException();
                }
                ++this.connectionCount;
            }
        }
        this.connectionQueues.get(this.getQueueIndex(connection)).add(new WeakReference<PhoenixConnection>(connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(PhoenixConnection connection) throws SQLException {
        if (this.returnSequenceValues) {
            ConcurrentMap<SequenceKey, Sequence> formerSequenceMap = null;
            Object object = this.connectionCountLock;
            synchronized (object) {
                if (--this.connectionCount <= 0 && !this.sequenceMap.isEmpty()) {
                    formerSequenceMap = this.sequenceMap;
                    this.sequenceMap = Maps.newConcurrentMap();
                }
                if (this.connectionCount < 0) {
                    this.connectionCount = 0;
                }
            }
            if (formerSequenceMap != null) {
                this.returnAllSequences(formerSequenceMap);
            }
        } else if (this.shouldThrottleNumConnections) {
            Object object = this.connectionCountLock;
            synchronized (object) {
                if (this.connectionCount > 0) {
                    --this.connectionCount;
                }
            }
        }
    }

    private int getQueueIndex(PhoenixConnection conn) {
        return ThreadLocalRandom.current().nextInt(this.renewLeasePoolSize);
    }

    @Override
    public KeyValueBuilder getKeyValueBuilder() {
        return this.kvBuilder;
    }

    @Override
    public boolean supportsFeature(ConnectionQueryServices.Feature feature) {
        FeatureSupported supported = this.featureMap.get((Object)feature);
        if (supported == null) {
            return false;
        }
        return supported.isSupported(this);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    private void checkClosed() {
        if (this.closed) {
            this.throwConnectionClosedException();
        }
    }

    private void throwConnectionClosedIfNullMetaData() {
        if (this.latestMetaData == null) {
            this.throwConnectionClosedException();
        }
    }

    private void throwConnectionClosedException() {
        throw new IllegalStateException("Connection to the cluster is closed");
    }

    @Override
    public GuidePostsInfo getTableStats(GuidePostsKey key) throws SQLException {
        try {
            return this.tableStatsCache.get(key);
        }
        catch (ExecutionException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @Override
    public int getSequenceSaltBuckets() {
        return this.nSequenceSaltBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFunction(PFunction function) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            try {
                this.throwConnectionClosedIfNullMetaData();
                PFunction existingFunction = this.latestMetaData.getFunction(new PTableKey(function.getTenantId(), function.getFunctionName()));
                if (existingFunction.getTimeStamp() >= function.getTimeStamp()) {
                    return;
                }
            }
            catch (FunctionNotFoundException functionNotFoundException) {
                // empty catch block
            }
            this.latestMetaData.addFunction(function);
            this.latestMetaDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFunction(PName tenantId, String function, long functionTimeStamp) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData.removeFunction(tenantId, function, functionTimeStamp);
            this.latestMetaDataLock.notifyAll();
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getFunctions(PName tenantId, final List<Pair<byte[], Long>> functions, final long clientTimestamp) throws SQLException {
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        return this.metaDataCoprocessorExec(tenantIdBytes, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.GetFunctionsRequest.Builder builder = MetaDataProtos.GetFunctionsRequest.newBuilder();
                builder.setTenantId(ByteStringer.wrap((byte[])tenantIdBytes));
                for (Pair function : functions) {
                    builder.addFunctionNames(ByteStringer.wrap((byte[])((byte[])function.getFirst())));
                    builder.addFunctionTimestamps((Long)function.getSecond());
                }
                builder.setClientTimestamp(clientTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.getFunctions((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getSchema(final String schemaName, final long clientTimestamp) throws SQLException {
        return this.metaDataCoprocessorExec(SchemaUtil.getSchemaKey(schemaName), new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.GetSchemaRequest.Builder builder = MetaDataProtos.GetSchemaRequest.newBuilder();
                builder.setSchemaName(schemaName);
                builder.setClientTimestamp(clientTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.getSchema((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createFunction(final List<Mutation> functionData, final PFunction function, final boolean temporary) throws SQLException {
        byte[][] rowKeyMetadata = new byte[2][];
        Put m = MetaDataUtil.getPutOnlyTableHeaderRow(functionData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] functionBytes = rowKeyMetadata[1];
        byte[] functionKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(functionKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.CreateFunctionRequest.Builder builder = MetaDataProtos.CreateFunctionRequest.newBuilder();
                for (Mutation m : functionData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setTemporary(temporary);
                builder.setReplace(function.isReplace());
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.createFunction((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
        return result;
    }

    @Override
    public long getRenewLeaseThresholdMilliSeconds() {
        return this.renewLeaseThreshold;
    }

    @Override
    public boolean isRenewingLeasesEnabled() {
        return this.supportsFeature(ConnectionQueryServices.Feature.RENEW_LEASE) && this.renewLeaseEnabled;
    }

    @Override
    public HRegionLocation getTableRegionLocation(byte[] tableName, byte[] row) throws SQLException {
        int retryCount = 0;
        int maxRetryCount = 1;
        boolean reload = false;
        while (true) {
            try {
                return this.connection.getRegionLocation(TableName.valueOf((byte[])tableName), row, reload);
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                String fullName = Bytes.toString((byte[])tableName);
                throw new TableNotFoundException(SchemaUtil.getSchemaNameFromFullName(fullName), SchemaUtil.getTableNameFromFullName(fullName));
            }
            catch (IOException e) {
                if (retryCount++ < maxRetryCount) {
                    reload = true;
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).setRootCause(e).build().buildException();
            }
            break;
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createSchema(final List<Mutation> schemaMutations, final String schemaName) throws SQLException {
        this.ensureNamespaceCreated(schemaName);
        Put m = MetaDataUtil.getPutOnlyTableHeaderRow(schemaMutations);
        byte[] key = m.getRow();
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(key, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.CreateSchemaRequest.Builder builder = MetaDataProtos.CreateSchemaRequest.newBuilder();
                for (Mutation m : schemaMutations) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setSchemaName(schemaName);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.createSchema((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        return result;
    }

    @Override
    public void addSchema(PSchema schema) throws SQLException {
        this.latestMetaData.addSchema(schema);
    }

    @Override
    public void removeSchema(PSchema schema, long schemaTimeStamp) {
        this.latestMetaData.removeSchema(schema, schemaTimeStamp);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropSchema(final List<Mutation> schemaMetaData, final String schemaName) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(SchemaUtil.getSchemaKey(schemaName), new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.DropSchemaRequest.Builder builder = MetaDataProtos.DropSchemaRequest.newBuilder();
                for (Mutation m : schemaMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addSchemaMetadataMutations(mp.toByteString());
                }
                builder.setSchemaName(schemaName);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 12, 0));
                instance.dropSchema((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case SCHEMA_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (!dropMetadata) break;
                this.ensureNamespaceDropped(schemaName, result.getMutationTime());
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNamespaceDropped(String schemaName, long mutationTime) throws SQLException {
        block20: {
            SQLException sqlE = null;
            try (HBaseAdmin admin = this.getAdmin();){
                String quorum = ZKConfig.getZKQuorumServersString((Configuration)this.config);
                String znode = this.props.get("zookeeper.znode.parent");
                logger.debug("Found quorum: " + quorum + ":" + znode);
                boolean nameSpaceExists = true;
                try {
                    admin.getNamespaceDescriptor(schemaName);
                }
                catch (NamespaceNotFoundException e) {
                    nameSpaceExists = false;
                }
                if (nameSpaceExists) {
                    admin.deleteNamespace(schemaName);
                }
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            finally {
                if (sqlE == null) break block20;
                throw sqlE;
            }
        }
    }

    public void addTableStats(GuidePostsKey key, GuidePostsInfo info) {
        this.tableStatsCache.put(Objects.requireNonNull(key), Objects.requireNonNull(info));
    }

    @Override
    public void invalidateStats(GuidePostsKey key) {
        this.tableStatsCache.invalidate(Objects.requireNonNull(key));
    }

    @Override
    public boolean isUpgradeRequired() {
        return this.upgradeRequired.get();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public QueryLoggerDisruptor getQueryDisruptor() {
        return this.queryDisruptor;
    }

    @VisibleForTesting
    static class RenewLeaseTask
    implements Runnable {
        private final LinkedBlockingQueue<WeakReference<PhoenixConnection>> connectionsQueue;
        private final Random random = new Random();
        private static final int MAX_WAIT_TIME = 1000;

        RenewLeaseTask(LinkedBlockingQueue<WeakReference<PhoenixConnection>> queue) {
            this.connectionsQueue = queue;
        }

        private void waitForRandomDuration() throws InterruptedException {
            new CountDownLatch(1).await(this.random.nextInt(1000), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            try {
                boolean wait = true;
                for (int numConnections = this.connectionsQueue.size(); numConnections > 0; --numConnections) {
                    WeakReference<PhoenixConnection> connRef;
                    if (wait) {
                        this.waitForRandomDuration();
                        wait = false;
                    }
                    if ((connRef = this.connectionsQueue.poll(1L, TimeUnit.MILLISECONDS)) == null) {
                        throw new InternalRenewLeaseTaskException("Connection ref found to be null. This is a bug. Some other thread removed items from the connection queue.");
                    }
                    PhoenixConnection conn = (PhoenixConnection)connRef.get();
                    if (conn == null || conn.isClosed()) continue;
                    LinkedBlockingQueue<WeakReference<TableResultIterator>> scannerQueue = conn.getScanners();
                    int renewed = 0;
                    long start = System.currentTimeMillis();
                    block10: for (int numScanners = scannerQueue.size(); numScanners > 0; --numScanners) {
                        WeakReference<TableResultIterator> ref = scannerQueue.poll(1L, TimeUnit.MILLISECONDS);
                        if (ref == null) {
                            throw new InternalRenewLeaseTaskException("TableResulIterator ref found to be null. This is a bug. Some other thread removed items from the scanner queue.");
                        }
                        TableResultIterator scanningItr = (TableResultIterator)ref.get();
                        if (scanningItr == null) continue;
                        TableResultIterator.RenewLeaseStatus status = scanningItr.renewLease();
                        switch (status) {
                            case RENEWED: {
                                ++renewed;
                                scannerQueue.offer(new WeakReference<TableResultIterator>(scanningItr));
                                logger.debug("Lease renewed for scanner: " + scanningItr);
                                continue block10;
                            }
                            case UNINITIALIZED: 
                            case THRESHOLD_NOT_REACHED: 
                            case LOCK_NOT_ACQUIRED: {
                                scannerQueue.offer(new WeakReference<TableResultIterator>(scanningItr));
                                continue block10;
                            }
                        }
                    }
                    if (renewed > 0) {
                        logger.info("Renewed leases for " + renewed + " scanner/s in " + (System.currentTimeMillis() - start) + " ms ");
                    }
                    this.connectionsQueue.offer(connRef);
                }
            }
            catch (InternalRenewLeaseTaskException e) {
                logger.error("Exception thrown when renewing lease. Draining the queue of scanners ", (Throwable)e);
                this.connectionsQueue.clear();
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Thread interrupted when renewing lease.", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Exception thrown when renewing lease ", (Throwable)e);
            }
            catch (Throwable e) {
                logger.error("Exception thrown when renewing lease. Draining the queue of scanners ", e);
                this.connectionsQueue.clear();
                throw new RuntimeException(e);
            }
        }

        private static class InternalRenewLeaseTaskException
        extends Exception {
            public InternalRenewLeaseTaskException(String msg) {
                super(msg);
            }
        }
    }

    private static class RenewLeaseThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final String NAME_PREFIX = "PHOENIX-SCANNER-RENEW-LEASE-thread-";

        private RenewLeaseThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, NAME_PREFIX + threadNumber.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }

    private static interface RetriableOperation {
        public boolean checkForCompletion() throws TimeoutException, IOException;

        public String getOperationName();
    }

    private static interface Mutator {
        public void mutate(PMetaData var1) throws SQLException;
    }

    private static interface FeatureSupported {
        public boolean isSupported(ConnectionQueryServices var1);
    }
}

