/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.schema.types.PVarchar;

public final class PIndexState
extends Enum<PIndexState> {
    public static final /* enum */ PIndexState BUILDING;
    public static final /* enum */ PIndexState USABLE;
    public static final /* enum */ PIndexState UNUSABLE;
    public static final /* enum */ PIndexState ACTIVE;
    public static final /* enum */ PIndexState INACTIVE;
    public static final /* enum */ PIndexState DISABLE;
    public static final /* enum */ PIndexState REBUILD;
    public static final /* enum */ PIndexState PENDING_ACTIVE;
    private final String serializedValue;
    private final byte[] serializedBytes;
    private final byte[] nameBytesValue;
    private static final PIndexState[] FROM_VALUE;
    private static final int FROM_VALUE_OFFSET;
    private static final /* synthetic */ PIndexState[] $VALUES;

    public static PIndexState[] values() {
        return (PIndexState[])$VALUES.clone();
    }

    public static PIndexState valueOf(String name) {
        return Enum.valueOf(PIndexState.class, name);
    }

    private PIndexState(String value) {
        this.serializedValue = value;
        this.serializedBytes = PVarchar.INSTANCE.toBytes(value);
        this.nameBytesValue = PVarchar.INSTANCE.toBytes(this.toString());
    }

    public String getSerializedValue() {
        return this.serializedValue;
    }

    public byte[] getSerializedBytes() {
        return this.serializedBytes;
    }

    public byte[] toBytes() {
        return this.nameBytesValue;
    }

    public static PIndexState fromSerializedValue(String serializedValue) {
        int i;
        if (serializedValue.length() == 1 && (i = serializedValue.charAt(0) - FROM_VALUE_OFFSET) >= 0 && i < FROM_VALUE.length && FROM_VALUE[i] != null) {
            return FROM_VALUE[i];
        }
        throw new IllegalArgumentException("Unable to PIndexState enum for serialized value of '" + serializedValue + "'");
    }

    public static PIndexState fromSerializedValue(byte serializedByte) {
        int i = serializedByte - FROM_VALUE_OFFSET;
        if (i >= 0 && i < FROM_VALUE.length && FROM_VALUE[i] != null) {
            return FROM_VALUE[i];
        }
        throw new IllegalArgumentException("Unable to PIndexState enum for serialized value of '" + (char)serializedByte + "'");
    }

    static {
        char c;
        BUILDING = new PIndexState("b");
        USABLE = new PIndexState("e");
        UNUSABLE = new PIndexState("d");
        ACTIVE = new PIndexState("a");
        INACTIVE = new PIndexState("i");
        DISABLE = new PIndexState("x");
        REBUILD = new PIndexState("r");
        PENDING_ACTIVE = new PIndexState("p");
        $VALUES = new PIndexState[]{BUILDING, USABLE, UNUSABLE, ACTIVE, INACTIVE, DISABLE, REBUILD, PENDING_ACTIVE};
        int minChar = Integer.MAX_VALUE;
        int n = Integer.MIN_VALUE;
        for (PIndexState state2 : PIndexState.values()) {
            char c2 = state2.getSerializedValue().charAt(0);
            if (c2 < minChar) {
                minChar = c2;
            }
            if (c2 <= c) continue;
            c = c2;
        }
        FROM_VALUE_OFFSET = minChar;
        FROM_VALUE = new PIndexState[c - minChar + true];
        PIndexState[] pIndexStateArray = PIndexState.values();
        int n2 = pIndexStateArray.length;
        for (int i = 0; i < n2; ++i) {
            PIndexState state2;
            PIndexState.FROM_VALUE[state2.getSerializedValue().charAt((int)0) - minChar] = state2 = pIndexStateArray[i];
        }
    }
}

