/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.TransactionCodec;
import org.apache.tephra.TransactionConflictException;
import org.apache.tephra.TransactionContext;
import org.apache.tephra.TransactionFailureException;
import org.apache.tephra.TransactionManager;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.TxConstants;
import org.apache.tephra.distributed.PooledClientProvider;
import org.apache.tephra.distributed.ThriftClientProvider;
import org.apache.tephra.distributed.TransactionService;
import org.apache.tephra.distributed.TransactionServiceClient;
import org.apache.tephra.hbase.coprocessor.TransactionProcessor;
import org.apache.tephra.inmemory.InMemoryTxSystemClient;
import org.apache.tephra.metrics.MetricsCollector;
import org.apache.tephra.metrics.TxMetricsCollector;
import org.apache.tephra.persist.HDFSTransactionStateStorage;
import org.apache.tephra.persist.TransactionStateStorage;
import org.apache.tephra.snapshot.SnapshotCodecProvider;
import org.apache.tephra.util.TxUtils;
import org.apache.tephra.visibility.FenceWait;
import org.apache.tephra.visibility.VisibilityFence;
import org.apache.tephra.zookeeper.TephraZKClientService;
import org.apache.twill.discovery.DiscoveryService;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.ZKDiscoveryService;
import org.apache.twill.internal.utils.Networks;
import org.apache.twill.zookeeper.RetryStrategies;
import org.apache.twill.zookeeper.RetryStrategy;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.twill.zookeeper.ZKClientServices;
import org.apache.twill.zookeeper.ZKClients;
import org.slf4j.Logger;

public class TephraTransactionContext
implements PhoenixTransactionContext {
    private static final TransactionCodec CODEC = new TransactionCodec();
    private static TransactionSystemClient txClient = null;
    private static ZKClientService zkClient = null;
    private static TransactionService txService = null;
    private static TransactionManager txManager = null;
    private final List<TransactionAware> txAwares;
    private final TransactionContext txContext;
    private Transaction tx;
    private TransactionSystemClient txServiceClient;
    private TransactionFailureException e;

    public TephraTransactionContext() {
        this.txServiceClient = null;
        this.txAwares = Lists.newArrayList();
        this.txContext = null;
    }

    public TephraTransactionContext(byte[] txnBytes) throws IOException {
        this();
        this.tx = txnBytes != null && txnBytes.length > 0 ? CODEC.decode(txnBytes) : null;
    }

    public TephraTransactionContext(PhoenixConnection connection) {
        this.txServiceClient = txClient;
        this.txAwares = Collections.emptyList();
        this.txContext = new TransactionContext(this.txServiceClient, new TransactionAware[0]);
    }

    public TephraTransactionContext(PhoenixTransactionContext ctx, PhoenixConnection connection, boolean subTask) {
        this.txServiceClient = txClient;
        assert (ctx instanceof TephraTransactionContext);
        TephraTransactionContext tephraTransactionContext = (TephraTransactionContext)ctx;
        if (subTask) {
            this.tx = tephraTransactionContext.getTransaction();
            this.txAwares = Lists.newArrayList();
            this.txContext = null;
        } else {
            this.txAwares = Collections.emptyList();
            this.txContext = tephraTransactionContext.getContext();
        }
        this.e = null;
    }

    @Override
    public void setInMemoryTransactionClient(Configuration config) {
        TransactionManager txnManager = new TransactionManager(config);
        txClient = this.txServiceClient = new InMemoryTxSystemClient(txnManager);
    }

    @Override
    public ZKClientService setTransactionClient(Configuration config, ReadOnlyProps props, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo) {
        String zkQuorumServersString = props.get("data.tx.zookeeper.quorum");
        if (zkQuorumServersString == null) {
            zkQuorumServersString = connectionInfo.getZookeeperQuorum() + ":" + connectionInfo.getPort();
        }
        int timeOut = props.getInt("zookeeper.session.timeout", 180000);
        ZKClientService txZKClientService = ZKClientServices.delegate((ZKClient)ZKClients.reWatchOnExpire((ZKClient)ZKClients.retryOnFailure((ZKClient)new TephraZKClientService(zkQuorumServersString, timeOut, null, (Multimap)ArrayListMultimap.create()), (RetryStrategy)RetryStrategies.exponentialDelay((long)500L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS))));
        txZKClientService.startAndWait();
        ZKDiscoveryService zkDiscoveryService = new ZKDiscoveryService((ZKClient)txZKClientService);
        PooledClientProvider pooledClientProvider = new PooledClientProvider(config, (DiscoveryServiceClient)zkDiscoveryService);
        txClient = this.txServiceClient = new TransactionServiceClient(config, (ThriftClientProvider)pooledClientProvider);
        return txZKClientService;
    }

    @Override
    public void begin() throws SQLException {
        if (this.txContext == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NULL_TRANSACTION_CONTEXT).build().buildException();
        }
        try {
            this.txContext.start();
        }
        catch (TransactionFailureException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.txContext == null || !this.isTransactionRunning()) {
            return;
        }
        try {
            this.txContext.finish();
        }
        catch (TransactionFailureException e) {
            this.e = e;
            if (e instanceof TransactionConflictException) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION).setMessage(e.getMessage()).setRootCause(e).build().buildException();
            }
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
    }

    @Override
    public void abort() throws SQLException {
        if (this.txContext == null || !this.isTransactionRunning()) {
            return;
        }
        try {
            if (this.e != null) {
                this.txContext.abort(this.e);
                this.e = null;
            } else {
                this.txContext.abort();
            }
        }
        catch (TransactionFailureException e) {
            this.e = null;
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
    }

    @Override
    public void checkpoint(boolean hasUncommittedData) throws SQLException {
        if (hasUncommittedData) {
            try {
                if (this.txContext == null) {
                    this.tx = this.txServiceClient.checkpoint(this.tx);
                } else {
                    assert (this.txContext != null);
                    this.txContext.checkpoint();
                    this.tx = this.txContext.getCurrentTransaction();
                }
            }
            catch (TransactionFailureException e) {
                throw new SQLException(e);
            }
        }
        if (this.txContext == null) {
            this.tx.setVisibility(Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT);
        } else {
            assert (this.txContext != null);
            this.txContext.getCurrentTransaction().setVisibility(Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT);
        }
    }

    @Override
    public void commitDDLFence(PTable dataTable, Logger logger) throws SQLException {
        byte[] key = dataTable.getName().getBytes();
        try {
            FenceWait fenceWait = VisibilityFence.prepareWait((byte[])key, (TransactionSystemClient)this.txServiceClient);
            fenceWait.await(10000L, TimeUnit.MILLISECONDS);
            if (logger.isInfoEnabled()) {
                logger.info("Added write fence at ~" + this.getCurrentTransaction().getReadPointer());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
        }
        catch (TimeoutException | TransactionFailureException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_UNABLE_TO_GET_WRITE_FENCE).setSchemaName(dataTable.getSchemaName().getString()).setTableName(dataTable.getTableName().getString()).build().buildException();
        }
    }

    public void markDMLFence(PTable table) {
        byte[] logicalKey = table.getName().getBytes();
        TransactionAware logicalTxAware = VisibilityFence.create((byte[])logicalKey);
        if (this.txContext == null) {
            this.txAwares.add(logicalTxAware);
        } else {
            this.txContext.addTransactionAware(logicalTxAware);
        }
        byte[] physicalKey = table.getPhysicalName().getBytes();
        if (Bytes.compareTo((byte[])physicalKey, (byte[])logicalKey) != 0) {
            TransactionAware physicalTxAware = VisibilityFence.create((byte[])physicalKey);
            if (this.txContext == null) {
                this.txAwares.add(physicalTxAware);
            } else {
                this.txContext.addTransactionAware(physicalTxAware);
            }
        }
    }

    @Override
    public void join(PhoenixTransactionContext ctx) {
        assert (ctx instanceof TephraTransactionContext);
        TephraTransactionContext tephraContext = (TephraTransactionContext)ctx;
        if (this.txContext != null) {
            for (TransactionAware txAware : tephraContext.getAwares()) {
                this.txContext.addTransactionAware(txAware);
            }
        } else {
            this.txAwares.addAll(tephraContext.getAwares());
        }
    }

    private Transaction getCurrentTransaction() {
        return this.tx != null ? this.tx : (this.txContext != null ? this.txContext.getCurrentTransaction() : null);
    }

    @Override
    public boolean isTransactionRunning() {
        return this.getCurrentTransaction() != null;
    }

    @Override
    public void reset() {
        this.tx = null;
        this.txAwares.clear();
        this.e = null;
    }

    @Override
    public long getTransactionId() {
        Transaction tx = this.getCurrentTransaction();
        return tx == null ? Long.MAX_VALUE : tx.getTransactionId();
    }

    @Override
    public long getReadPointer() {
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            return -1L;
        }
        return tx.getReadPointer();
    }

    @Override
    public long getWritePointer() {
        Transaction tx = this.getCurrentTransaction();
        return tx == null ? Long.MAX_VALUE : tx.getWritePointer();
    }

    @Override
    public void setVisibilityLevel(PhoenixTransactionContext.PhoenixVisibilityLevel visibilityLevel) {
        Transaction.VisibilityLevel tephraVisibilityLevel = null;
        switch (visibilityLevel) {
            case SNAPSHOT: {
                tephraVisibilityLevel = Transaction.VisibilityLevel.SNAPSHOT;
                break;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                tephraVisibilityLevel = Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
                break;
            }
            case SNAPSHOT_ALL: {
                tephraVisibilityLevel = Transaction.VisibilityLevel.SNAPSHOT_ALL;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Transaction tx = this.getCurrentTransaction();
        assert (tx != null);
        tx.setVisibility(tephraVisibilityLevel);
    }

    @Override
    public PhoenixTransactionContext.PhoenixVisibilityLevel getVisibilityLevel() {
        PhoenixTransactionContext.PhoenixVisibilityLevel phoenixVisibilityLevel;
        Transaction.VisibilityLevel visibilityLevel = null;
        Transaction tx = this.getCurrentTransaction();
        assert (tx != null);
        visibilityLevel = tx.getVisibilityLevel();
        switch (visibilityLevel) {
            case SNAPSHOT: {
                phoenixVisibilityLevel = PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT;
                break;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                phoenixVisibilityLevel = PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
                break;
            }
            case SNAPSHOT_ALL: {
                phoenixVisibilityLevel = PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_ALL;
            }
            default: {
                phoenixVisibilityLevel = null;
            }
        }
        return phoenixVisibilityLevel;
    }

    @Override
    public byte[] encodeTransaction() throws SQLException {
        Transaction tx = this.getCurrentTransaction();
        assert (tx != null);
        try {
            return CODEC.encode(tx);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public long getMaxTransactionsPerSecond() {
        return 1000000L;
    }

    @Override
    public boolean isPreExistingVersion(long version) {
        return TxUtils.isPreExistingVersion((long)version);
    }

    @Override
    public BaseRegionObserver getCoProcessor() {
        return new TransactionProcessor();
    }

    @Override
    public byte[] getFamilyDeleteMarker() {
        return TxConstants.FAMILY_DELETE_QUALIFIER;
    }

    @Override
    public void setTxnConfigs(Configuration config, String tmpFolder, int defaultTxnTimeoutSeconds) throws IOException {
        config.setBoolean("tx.persist", false);
        config.set("data.tx.client.retry.strategy", "n-times");
        config.setInt("data.tx.client.retry.attempts", 1);
        config.setInt("data.tx.bind.port", Networks.getRandomPort());
        config.set("data.tx.snapshot.dir", tmpFolder);
        config.setInt("data.tx.timeout", defaultTxnTimeoutSeconds);
        config.unset("data.tx.hdfs.user");
        config.setLong("data.tx.snapshot.interval", 5L);
    }

    @Override
    public void setupTxManager(Configuration config, String url) throws SQLException {
        if (txService != null) {
            return;
        }
        PhoenixEmbeddedDriver.ConnectionInfo connInfo = PhoenixEmbeddedDriver.ConnectionInfo.create(url);
        zkClient = ZKClientServices.delegate((ZKClient)ZKClients.reWatchOnExpire((ZKClient)ZKClients.retryOnFailure((ZKClient)ZKClientService.Builder.of((String)connInfo.getZookeeperConnectionString()).setSessionTimeout(config.getInt("zookeeper.session.timeout", 180000)).build(), (RetryStrategy)RetryStrategies.exponentialDelay((long)500L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS))));
        zkClient.startAndWait();
        ZKDiscoveryService discovery = new ZKDiscoveryService((ZKClient)zkClient);
        txManager = new TransactionManager(config, (TransactionStateStorage)new HDFSTransactionStateStorage(config, new SnapshotCodecProvider(config), (MetricsCollector)new TxMetricsCollector()), (MetricsCollector)new TxMetricsCollector());
        txService = new TransactionService(config, (ZKClient)zkClient, (DiscoveryService)discovery, Providers.of((Object)txManager));
        txService.startAndWait();
    }

    @Override
    public void tearDownTxManager() {
        try {
            if (txService != null) {
                txService.stopAndWait();
            }
        }
        finally {
            try {
                if (zkClient != null) {
                    zkClient.stopAndWait();
                }
            }
            finally {
                txService = null;
                zkClient = null;
                txManager = null;
            }
        }
    }

    Transaction getTransaction() {
        return this.getCurrentTransaction();
    }

    TransactionContext getContext() {
        return this.txContext;
    }

    List<TransactionAware> getAwares() {
        return this.txAwares;
    }

    void addTransactionAware(TransactionAware txAware) {
        if (this.txContext != null) {
            this.txContext.addTransactionAware(txAware);
        } else if (this.tx != null) {
            this.txAwares.add(txAware);
            assert (this.tx != null);
            txAware.startTx(this.tx);
        }
    }
}

