/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpgradeUtil;

public final class QueryUtil {
    private static final Log LOG = LogFactory.getLog(QueryUtil.class);
    public static final int COLUMN_FAMILY_POSITION = 25;
    public static final int COLUMN_NAME_POSITION = 4;
    public static final int DATA_TYPE_POSITION = 5;
    public static final int DATA_TYPE_NAME_POSITION = 6;
    private static final String SELECT = "SELECT";
    private static final String FROM = "FROM";
    private static final String WHERE = "WHERE";
    private static final String AND = "AND";
    private static final String[] CompareOpString = new String[CompareFilter.CompareOp.values().length];

    public static String toSQL(CompareFilter.CompareOp op) {
        return CompareOpString[op.ordinal()];
    }

    private QueryUtil() {
    }

    public static String constructUpsertStatement(String tableName, List<ColumnInfo> columnInfos) {
        if (columnInfos.isEmpty()) {
            throw new IllegalArgumentException("At least one column must be provided for upserts");
        }
        List columnNames = Lists.transform(columnInfos, (Function)new Function<ColumnInfo, String>(){

            public String apply(ColumnInfo columnInfo) {
                return columnInfo.getColumnName();
            }
        });
        return QueryUtil.constructUpsertStatement(tableName, columnNames, null);
    }

    public static String constructUpsertStatement(String tableName, List<String> columns, HintNode.Hint hint) {
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("At least one column must be provided for upserts");
        }
        String hintStr = "";
        if (hint != null) {
            HintNode node = new HintNode(hint.name());
            hintStr = node.toString();
        }
        ArrayList parameterList = Lists.newArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            parameterList.add("?");
        }
        return String.format("UPSERT %s INTO %s (%s) VALUES (%s)", hintStr, tableName, Joiner.on((String)", ").join(Iterables.transform(columns, (Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String columnName) {
                return SchemaUtil.getEscapedFullColumnName(columnName);
            }
        })), Joiner.on((String)", ").join((Iterable)parameterList));
    }

    public static String constructGenericUpsertStatement(String tableName, int numColumns) {
        if (numColumns == 0) {
            throw new IllegalArgumentException("At least one column must be provided for upserts");
        }
        ArrayList parameterList = Lists.newArrayListWithCapacity((int)numColumns);
        for (int i = 0; i < numColumns; ++i) {
            parameterList.add("?");
        }
        return String.format("UPSERT INTO %s VALUES (%s)", tableName, Joiner.on((String)", ").join((Iterable)parameterList));
    }

    public static String constructSelectStatement(String fullTableName, List<ColumnInfo> columnInfos, String conditions) {
        List columns = Lists.transform(columnInfos, (Function)new Function<ColumnInfo, String>(){

            public String apply(ColumnInfo input) {
                return input.getColumnName();
            }
        });
        return QueryUtil.constructSelectStatement(fullTableName, columns, conditions, null, false);
    }

    public static String constructSelectStatement(String fullTableName, List<String> columns, String conditions, HintNode.Hint hint, boolean escapeCols) {
        Preconditions.checkNotNull((Object)fullTableName, (Object)"Table name cannot be null");
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("At least one column must be provided");
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        String hintStr = "";
        if (hint != null) {
            HintNode node = new HintNode(hint.name());
            hintStr = node.toString();
        }
        query.append(hintStr);
        for (String col : columns) {
            if (col == null) continue;
            String fullColumnName = col;
            if (escapeCols) {
                fullColumnName = SchemaUtil.getEscapedFullColumnName(col);
            }
            query.append(fullColumnName);
            query.append(",");
        }
        query.setLength(query.length() - 1);
        query.append(" FROM ");
        query.append(fullTableName);
        if (conditions != null && conditions.length() > 0) {
            query.append(" WHERE (").append(conditions).append(")");
        }
        return query.toString();
    }

    public static String constructParameterizedInClause(int numWhereCols, int numBatches) {
        Preconditions.checkArgument((numWhereCols > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((numBatches > 0 ? 1 : 0) != 0);
        String batch = "(" + StringUtils.repeat((String)"?", (String)",", (int)numWhereCols) + ")";
        return "(" + StringUtils.repeat((String)batch, (String)",", (int)numBatches) + ")";
    }

    public static String getUrl(String zkQuorum) {
        return QueryUtil.getUrlInternal(zkQuorum, null, null, null);
    }

    public static String getUrl(String zkQuorum, int clientPort) {
        return QueryUtil.getUrlInternal(zkQuorum, clientPort, null, null);
    }

    public static String getUrl(String zkQuorum, String znodeParent) {
        return QueryUtil.getUrlInternal(zkQuorum, null, znodeParent, null);
    }

    public static String getUrl(String zkQuorum, int port, String znodeParent, String principal) {
        return QueryUtil.getUrlInternal(zkQuorum, port, znodeParent, principal);
    }

    public static String getUrl(String zkQuorum, int port, String znodeParent) {
        return QueryUtil.getUrlInternal(zkQuorum, port, znodeParent, null);
    }

    public static String getUrl(String zkQuorum, Integer port, String znodeParent) {
        return QueryUtil.getUrlInternal(zkQuorum, port, znodeParent, null);
    }

    public static String getUrl(String zkQuorum, Integer port, String znodeParent, String principal) {
        return QueryUtil.getUrlInternal(zkQuorum, port, znodeParent, principal);
    }

    private static String getUrlInternal(String zkQuorum, Integer port, String znodeParent, String principal) {
        return new PhoenixEmbeddedDriver.ConnectionInfo(zkQuorum, port, znodeParent, principal, null).toUrl() + ';';
    }

    public static String getExplainPlan(ResultSet rs) throws SQLException {
        StringBuilder buf = new StringBuilder();
        while (rs.next()) {
            buf.append(rs.getString(1));
            buf.append('\n');
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String getExplainPlan(ResultIterator iterator) throws SQLException {
        ArrayList steps = Lists.newArrayList();
        iterator.explain(steps);
        StringBuilder buf = new StringBuilder();
        for (String step : steps) {
            buf.append(step);
            buf.append('\n');
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static Connection getConnectionOnServer(Configuration conf) throws ClassNotFoundException, SQLException {
        return QueryUtil.getConnectionOnServer(new Properties(), conf);
    }

    public static Connection getConnectionOnServer(Properties props, Configuration conf) throws ClassNotFoundException, SQLException {
        UpgradeUtil.doNotUpgradeOnFirstConnection(props);
        return QueryUtil.getConnection(props, conf);
    }

    public static Connection getConnectionOnServerWithCustomUrl(Properties props, String principal) throws SQLException, ClassNotFoundException {
        UpgradeUtil.doNotUpgradeOnFirstConnection(props);
        String url = QueryUtil.getConnectionUrl(props, null, principal);
        LOG.info((Object)("Creating connection with the jdbc url: " + url));
        return DriverManager.getConnection(url, props);
    }

    public static Connection getConnection(Configuration conf) throws ClassNotFoundException, SQLException {
        return QueryUtil.getConnection(new Properties(), conf);
    }

    private static Connection getConnection(Properties props, Configuration conf) throws ClassNotFoundException, SQLException {
        String url = QueryUtil.getConnectionUrl(props, conf);
        LOG.info((Object)("Creating connection with the jdbc url: " + url));
        props = PropertiesUtil.combineProperties(props, conf);
        return DriverManager.getConnection(url, props);
    }

    public static String getConnectionUrl(Properties props, Configuration conf) throws ClassNotFoundException, SQLException {
        return QueryUtil.getConnectionUrl(props, conf, null);
    }

    public static String getConnectionUrl(Properties props, Configuration conf, String principal) throws ClassNotFoundException, SQLException {
        String znodeParent;
        int port = QueryUtil.getInt("hbase.zookeeper.property.clientPort", 2181, props, conf);
        String server = QueryUtil.getString("hbase.zookeeper.quorum", "localhost", props, conf);
        String url = QueryUtil.getUrl(server, port, znodeParent = QueryUtil.getString("zookeeper.znode.parent", "/hbase", props, conf), principal);
        if (url.endsWith(";")) {
            url = url.substring(0, url.length() - 1);
        }
        String defaultExtraArgs = conf != null ? conf.get("phoenix.jdbc.extra.arguments", "") : "";
        String extraArgs = props.getProperty("phoenix.jdbc.extra.arguments", defaultExtraArgs);
        url = extraArgs.length() > 0 ? url + ';' + extraArgs + ';' : url + ';';
        return url;
    }

    private static int getInt(String key, int defaultValue, Properties props, Configuration conf) {
        if (conf == null) {
            Preconditions.checkNotNull((Object)props);
            return Integer.parseInt(props.getProperty(key, String.valueOf(defaultValue)));
        }
        return conf.getInt(key, defaultValue);
    }

    private static String getString(String key, String defaultValue, Properties props, Configuration conf) {
        if (conf == null) {
            Preconditions.checkNotNull((Object)props);
            return props.getProperty(key, defaultValue);
        }
        return conf.get(key, defaultValue);
    }

    public static String getViewStatement(String schemaName, String tableName, String where) {
        return "SELECT * FROM " + (schemaName == null || schemaName.length() == 0 ? "" : "\"" + schemaName + "\".") + "\"" + tableName + "\" " + "WHERE " + where;
    }

    public static Integer getOffsetLimit(Integer limit, Integer offset) {
        if (limit == null) {
            return null;
        }
        if (offset == null) {
            return limit;
        }
        return limit + offset;
    }

    public static Integer getRemainingOffset(Tuple offsetTuple) {
        if (offsetTuple != null) {
            ImmutableBytesPtr rowKeyPtr = new ImmutableBytesPtr();
            offsetTuple.getKey(rowKeyPtr);
            if (QueryConstants.OFFSET_ROW_KEY_PTR.compareTo(rowKeyPtr) == 0) {
                Cell cell = offsetTuple.getValue(QueryConstants.OFFSET_FAMILY, QueryConstants.OFFSET_COLUMN);
                return PInteger.INSTANCE.toObject(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), PInteger.INSTANCE, SortOrder.ASC, null, null);
            }
        }
        return null;
    }

    public static String getViewPartitionClause(String partitionColumnName, long autoPartitionNum) {
        return partitionColumnName + " " + QueryUtil.toSQL(CompareFilter.CompareOp.EQUAL) + " " + autoPartitionNum;
    }

    public static Connection getConnectionForQueryLog(Configuration config) throws ClassNotFoundException, SQLException {
        return QueryUtil.getConnectionOnServer(config);
    }

    static {
        QueryUtil.CompareOpString[CompareFilter.CompareOp.EQUAL.ordinal()] = "=";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.NOT_EQUAL.ordinal()] = "!=";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.GREATER.ordinal()] = ">";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.LESS.ordinal()] = "<";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.GREATER_OR_EQUAL.ordinal()] = ">=";
        QueryUtil.CompareOpString[CompareFilter.CompareOp.LESS_OR_EQUAL.ordinal()] = "<=";
    }
}

