/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.openapi.antchain.util;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.ossutil.Client;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class AntchainUtils {
    private static final Pattern ENCODED_CHARACTERS_PATTERN;
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static String getTimestamp() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(new Date());
    }

    public static Boolean hasError(String res, String secret) throws Exception {
        JSONObject response = JSONObject.parseObject((String)res);
        if (response == null && response.get((Object)"response") == null) {
            return true;
        }
        Map map = (Map)response.get((Object)"response");
        if (map == null) {
            return true;
        }
        if (!"ok".equalsIgnoreCase(String.valueOf(map.get("result_code")))) {
            return false;
        }
        String content = AntchainUtils.extractStringToSign(res);
        String sign = AntchainUtils.sign(content, secret);
        if (!response.get((Object)"sign").equals(sign)) {
            return true;
        }
        return false;
    }

    private static String extractStringToSign(String responseString) {
        String responseNodeKey = "\"response\"";
        String signNodeKey = "\"sign\"";
        int indexOfResponseNode = responseString.indexOf(responseNodeKey);
        int indexOfSignNode = responseString.lastIndexOf(signNodeKey);
        if (indexOfResponseNode < 0) {
            return null;
        }
        if (indexOfSignNode < 0 || indexOfSignNode < indexOfResponseNode) {
            indexOfSignNode = responseString.lastIndexOf(125) - 1;
        }
        int startIndex = responseString.indexOf(123, indexOfResponseNode + responseNodeKey.length());
        int endIndex = responseString.lastIndexOf("}", indexOfSignNode);
        return responseString.substring(startIndex, endIndex + 1);
    }

    public static String getSignature(Map<String, String> signedParams, String secret) throws Exception {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, String> item : signedParams.entrySet()) {
            if (item.getValue() != null && item.getValue().startsWith("sign_type")) continue;
            keys.add(item.getKey());
        }
        Collections.sort(keys);
        String content = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if (i != 0) {
                content = content + "&";
            }
            content = content + AntchainUtils.urlEncode(key) + "=" + AntchainUtils.urlEncode(signedParams.get(key));
        }
        return AntchainUtils.sign(content, secret);
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
            StringBuffer buffer = new StringBuffer(encoded.length());
            while (matcher.find()) {
                String replacement = matcher.group(0);
                if ("+".equals(replacement)) {
                    replacement = "%20";
                } else if ("*".equals(replacement)) {
                    replacement = "%2A";
                } else if ("%7E".equals(replacement)) {
                    replacement = "~";
                }
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String sign(String content, String secret) throws Exception {
        return AntchainUtils.sign(content, "HmacSHA1", secret, DEFAULT_ENCODING);
    }

    private static String sign(String content, String algorithm, String secret, String charset) throws Exception {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(secret.getBytes(charset), algorithm));
        mac.update(content.getBytes(charset));
        byte[] signData = mac.doFinal();
        return Base64.getEncoder().encodeToString(signData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putObject(InputStream item, Map<String, String> headers, String urlPath) throws Exception {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlPath);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            conn.setRequestMethod("PUT");
            conn.setChunkedStreamingMode(0);
            conn.connect();
            OutputStream out = conn.getOutputStream();
            IOUtils.copy((InputStream)item, (OutputStream)out);
            out.flush();
            out.close();
            int statusCode = conn.getResponseCode();
            if (statusCode >= 400 && statusCode <= 600) {
                String line;
                String bodyStr = "";
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                while ((line = reader.readLine()) != null) {
                    bodyStr = bodyStr + line + "\n";
                }
                reader.close();
                Map respMap = Client.getErrMessage((String)bodyStr);
                if (respMap.get("Code") != null && String.valueOf(respMap.get("Code")) != "CallbackFailed") {
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", respMap.get("Code")), new TeaPair("message", respMap.get("Message")), new TeaPair("data", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("httpCode", (Object)statusCode), new TeaPair("requestId", respMap.get("RequestId")), new TeaPair("hostId", respMap.get("HostId"))}))}));
                }
            }
            conn.disconnect();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static Map<String, String> parseUploadHeaders(Object headers) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        if (headers == null) {
            return result;
        }
        if (List.class.isAssignableFrom(headers.getClass())) {
            ((List)headers).forEach(item -> {
                if (TeaModel.class.isAssignableFrom(item.getClass())) {
                    Map tmp = ((TeaModel)item).toMap();
                    result.put(tmp.get("name").toString(), tmp.get("value").toString());
                }
                if (List.class.isAssignableFrom(item.getClass())) {
                    try {
                        result.putAll(AntchainUtils.parseUploadHeaders(item));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return result;
    }

    public static String getNonce() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isSuccess(String resultCode, String successCode) {
        return resultCode.equalsIgnoreCase("ok") || resultCode.equalsIgnoreCase(successCode);
    }

    public static Date parseDate(String date) {
        return StringUtils.isEmpty((String)date) ? null : ISODateTimeFormat.dateTimeParser().parseDateTime(date).toDate();
    }

    public static String formatDate(Date date) {
        return date == null ? null : new DateTime((Object)date).toString();
    }

    public static Integer addInteger(Integer num, Integer num1) {
        return num + num1;
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

