/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client;

import com.apexsoft.client.GatewayClientV1Impl;
import com.apexsoft.client.GatewayClientV2Impl;
import com.apexsoft.client.GatewayClientV3Impl;
import com.apexsoft.client.GatewayClientV4Impl;
import com.apexsoft.client.Request;
import com.apexsoft.client.Response;
import com.apexsoft.client.Server;
import com.apexsoft.client.ServerStrategy;
import com.apexsoft.client.exception.GatewayException;
import java.io.File;

public interface GatewayClient {
    public void setStrategy(ServerStrategy ... var1);

    public void setAuth(String var1, String var2) throws GatewayException;

    public Server addHTTPServer(String var1, int var2) throws GatewayException;

    public Server addHTTPSServer(String var1, int var2, File var3, String var4) throws GatewayException;

    public void setTimeout(long var1, long var3, long var5);

    public Response service(Request var1) throws GatewayException;

    public Response upload(Request var1, File var2) throws GatewayException;

    public Response download(Request var1, File var2) throws GatewayException;

    public void ignoreCertVerify();

    public void setContextPath(String var1);

    public void checkSessionByValidateInError();

    public void destory();

    public static enum ProtocolVersion {
        ESB(1),
        LiveGateway(2),
        ApiGateway(3),
        LiveGatewayFuture(4);

        private Integer version;

        private ProtocolVersion(Integer version) {
            this.version = version;
        }

        public Integer value() {
            return this.version;
        }
    }

    public static class Instance {
        private static GatewayClient LiveGatewayFuture = new GatewayClientV4Impl();
        private static GatewayClient ESB = new GatewayClientV1Impl();
        private static GatewayClient ApiGateway = new GatewayClientV3Impl();
        private static GatewayClient LiveGateway = new GatewayClientV2Impl();

        public static GatewayClient singleton() {
            return ESB;
        }

        public static GatewayClient singleton(ProtocolVersion protocolVersion) {
            switch (protocolVersion) {
                case LiveGatewayFuture: {
                    return LiveGatewayFuture;
                }
                case LiveGateway: {
                    return LiveGateway;
                }
                case ApiGateway: {
                    return ApiGateway;
                }
                case ESB: {
                    return ESB;
                }
            }
            return LiveGateway;
        }
    }
}

