/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Set;

public class Head {
    private JsonObject data;
    private Gson gson = new GsonBuilder().registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

        public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == (double)src.longValue()) {
                return new JsonPrimitive((Number)src.longValue());
            }
            return new JsonPrimitive((Number)src);
        }
    }).create();

    public static Head create() {
        return new Head();
    }

    private Head() {
        this.data = new JsonObject();
    }

    public <T> Head put(String name, T value) {
        this.data.add(name, this.gson.toJsonTree(value));
        return this;
    }

    public <T> T get(String name, Class<T> clazz) {
        return (T)this.gson.fromJson(this.data.get(name), clazz);
    }

    public <T> T get(String name, Type type) {
        return (T)this.gson.fromJson(this.data.get(name), type);
    }

    public JsonElement get(String name) {
        return this.data.get(name);
    }

    public Set<String> getHeaderNames() {
        return this.data.keySet();
    }

    public JsonObject toJSON() {
        return this.data;
    }
}

