/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client;

import com.apexsoft.client.GatewayClient;
import com.apexsoft.client.GatewayClientV1Impl;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private static final Logger logger = LoggerFactory.getLogger(LogInterceptor.class);
    private GatewayClient client;

    public LogInterceptor(GatewayClient client) {
        this.client = client;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        int id = -1;
        if (logger.isDebugEnabled()) {
            id = ID_GENERATOR.incrementAndGet();
            String LOG_PREFIX = "[" + id + " request]";
            RequestBody requestBody = request.body();
            logger.debug("{}-->{}", (Object)LOG_PREFIX, (Object)request.toString());
            Headers headers = request.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                String name = headers.name(i);
                logger.debug("{}[HEAD]{}: {}", new Object[]{LOG_PREFIX, name, headers.value(i)});
            }
            MediaType contentType = requestBody.contentType();
            if ("multipart".equals(contentType.type())) {
                logger.debug("{}[BODY]{}-byte body omitted", (Object)LOG_PREFIX, (Object)requestBody.contentLength());
                MultipartBody multipartBody = (MultipartBody)requestBody;
                List parts = multipartBody.parts();
                for (MultipartBody.Part part : parts) {
                    if (part.body().contentType() != null) continue;
                    Buffer buffer = new Buffer();
                    part.body().writeTo((BufferedSink)buffer);
                    Charset charset = UTF8;
                    if (contentType != null) {
                        charset = contentType.charset(UTF8);
                    }
                    String bufferString = buffer.readString(charset);
                    if (this.client instanceof GatewayClientV1Impl && ((GatewayClientV1Impl)this.client).isURLEncode()) {
                        bufferString = "[URLEncode]" + URLDecoder.decode(bufferString, "UTF-8");
                    }
                    logger.debug("{}[BODY]{}", (Object)LOG_PREFIX, (Object)bufferString);
                }
            } else {
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                Charset charset = UTF8;
                if (contentType != null) {
                    charset = contentType.charset(UTF8);
                }
                String bufferString = buffer.readString(charset);
                if (this.client instanceof GatewayClientV1Impl && ((GatewayClientV1Impl)this.client).isURLEncode()) {
                    bufferString = "[URLEncode]" + URLDecoder.decode(bufferString, "UTF-8");
                }
                logger.debug("{}[BODY]{}", (Object)LOG_PREFIX, (Object)bufferString);
            }
        }
        Response response = chain.proceed(request);
        if (logger.isDebugEnabled()) {
            String LOG_PREFIX = "[" + id + " response]";
            long startNs = System.nanoTime();
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            ResponseBody responseBody = response.body();
            long contentLength = responseBody.contentLength();
            if (contentLength == -1L) {
                contentLength = responseBody.byteStream().available();
            }
            logger.debug(LOG_PREFIX + "<-- " + response.code() + ' ' + response.message() + " (" + tookMs + "ms" + ')');
            Headers headers = response.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                logger.debug("{}[HEAD]{}:{}", new Object[]{LOG_PREFIX, headers.name(i), headers.value(i)});
            }
            MediaType contentType = response.body().contentType();
            Charset charset = UTF8;
            if (contentType != null) {
                try {
                    charset = contentType.charset(UTF8);
                }
                catch (UnsupportedCharsetException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                if (response.header("Content-Disposition") != null) {
                    logger.debug("{}[BODY]{}-byte body omitted", (Object)LOG_PREFIX, (Object)contentLength);
                } else {
                    responseBody = response.peekBody(131072L);
                    String bufferString = responseBody.source().readString(charset);
                    if (this.client instanceof GatewayClientV1Impl && ((GatewayClientV1Impl)this.client).isURLEncode()) {
                        bufferString = "[URLEncode]" + URLDecoder.decode(bufferString, "UTF-8");
                    }
                    logger.debug("{}[BODY][SECTION-128KB]{}", (Object)LOG_PREFIX, (Object)bufferString);
                }
            } else {
                responseBody = response.peekBody(131072L);
                String bufferString = responseBody.source().readString(charset);
                if (this.client instanceof GatewayClientV1Impl && ((GatewayClientV1Impl)this.client).isURLEncode()) {
                    bufferString = "[URLEncode]" + URLDecoder.decode(bufferString, "UTF-8");
                }
                logger.debug("{}[BODY][SECTION-128KB]{}", (Object)LOG_PREFIX, (Object)bufferString);
            }
        }
        return response;
    }
}

