/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client;

import com.apexsoft.client.Constant;
import com.apexsoft.client.Head;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public class Request {
    @Expose
    private String serviceId;
    @Expose
    private String method;
    @Expose
    private String namespace;
    @Expose
    String sessionId;
    @Expose
    Integer version;
    private String mergeService;
    @Expose
    private JsonElement data;
    private Head head;
    private Gson gson = new GsonBuilder().registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

        public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == (double)src.longValue()) {
                return new JsonPrimitive((Number)src.longValue());
            }
            return new JsonPrimitive((Number)src);
        }
    }).excludeFieldsWithoutExposeAnnotation().create();

    public Request setService(String service) {
        if (service.contains(Constant.SPLIT_NAMESPACE)) {
            this.namespace = service.split(Constant.SPLIT_NAMESPACE)[0];
        }
        if (service.contains(Constant.SPLIT_METHOD)) {
            this.method = service.split(Constant.SPLIT_METHOD)[1];
        }
        this.mergeService = service;
        this.serviceId = service.replace(this.namespace + Constant.SPLIT_NAMESPACE, "").replace(Constant.SPLIT_METHOD + this.method, "");
        return this;
    }

    public Request setService(String namespace, String serviceId, String method) {
        this.namespace = namespace;
        this.serviceId = serviceId;
        this.method = method;
        this.mergeService = serviceId;
        if (namespace != null && !"".equals(namespace.trim())) {
            this.mergeService = namespace + Constant.SPLIT_NAMESPACE + this.mergeService;
        }
        if (method != null && !"".equals(method.trim())) {
            this.mergeService = this.mergeService + Constant.SPLIT_METHOD + method;
        }
        return this;
    }

    public String getNameSpaceAndServiceIdAndMethod() {
        return this.mergeService;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getMethod() {
        return this.method;
    }

    public Request() {
        this.data = new JsonObject();
        this.head = Head.create();
    }

    public Request(Map<String, Object> body) {
        this.data = this.gson.toJsonTree(body);
        this.head = Head.create();
    }

    public <T> Request put(String name, T value) {
        if (this.data.isJsonObject()) {
            this.data.getAsJsonObject().add(name, this.gson.toJsonTree(value));
            return this;
        }
        throw new RuntimeException("Response body is json");
    }

    public <T> T get(String name, Class<T> clazz) {
        if (this.data.isJsonObject()) {
            JsonElement element = this.data.getAsJsonObject().get(name);
            return (T)this.gson.fromJson(element, clazz);
        }
        throw new RuntimeException("Response body is json");
    }

    public JsonObject toJSON() {
        JsonObject temp = (JsonObject)this.gson.toJsonTree((Object)this);
        temp.add("head", (JsonElement)this.head.toJSON());
        return temp;
    }

    public Set<String> keySet() {
        if (this.data.isJsonObject()) {
            return this.data.getAsJsonObject().keySet();
        }
        throw new RuntimeException("Response body is json");
    }

    public Head getHead() {
        return this.head;
    }

    public void setHead(Head head) {
        this.head = head;
    }
}

