/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client;

import com.apexsoft.client.strategy.AvailableStrategy;
import com.apexsoft.client.strategy.MasterBackupStrategy;
import okhttp3.OkHttpClient;

public class Server
implements AvailableStrategy.AvailableServer,
MasterBackupStrategy.MasterBackupServer {
    private OkHttpClient client;
    private String server;
    private boolean enabled = true;
    private boolean master = true;
    private String sessionId = "";
    private long failDateTime = System.currentTimeMillis();
    private long recoveryPeroid = 30000L;
    private int failCount = 0;

    public OkHttpClient getClient() {
        return this.client;
    }

    public Server(OkHttpClient client, String server) {
        this.client = client;
        this.server = server;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getServer() {
        return this.server;
    }

    public Server setEnbaled(boolean enbaled) {
        this.enabled = enbaled;
        if (!enbaled) {
            this.failDateTime = System.currentTimeMillis();
            this.failCount = 0;
        } else {
            this.failDateTime = 0L;
            this.failCount = 0;
        }
        return this;
    }

    public Server markFail() {
        ++this.failCount;
        if (this.failCount >= 3) {
            this.failDateTime = System.currentTimeMillis();
            this.enabled = false;
            this.failCount = 0;
        }
        return this;
    }

    public Server setMaster(boolean master) {
        this.master = master;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean needCheck() {
        return this.failDateTime + this.recoveryPeroid < System.currentTimeMillis();
    }

    @Override
    public boolean isMaster() {
        return this.master;
    }

    public String toString() {
        return "Client{client=" + this.client + ", server='" + this.server + '\'' + ", enabled=" + this.enabled + ", master=" + this.master + ", sessionId='" + this.sessionId + '\'' + '}';
    }
}

