/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class GatewayTrustManager
implements X509TrustManager {
    private javax.security.cert.X509Certificate caCert;
    private static GatewayTrustManager INSTANCE = new GatewayTrustManager();

    public static GatewayTrustManager getInstance() {
        return INSTANCE;
    }

    private GatewayTrustManager() {
        String caCertStr = "-----BEGIN CERTIFICATE-----\nMIIDIDCCAggCCQD/pkrhQ3FV6jANBgkqhkiG9w0BAQsFADBSMQswCQYDVQQDDAJD\nQTENMAsGA1UECwwEQVBFWDENMAsGA1UECgwEQVBFWDELMAkGA1UEBwwCRloxCzAJ\nBgNVBAgMAkZKMQswCQYDVQQGEwJDTjAeFw0xOTA5MTIwMTU5MjlaFw0yOTA5MDkw\nMTU5MjlaMFIxCzAJBgNVBAMMAkNBMQ0wCwYDVQQLDARBUEVYMQ0wCwYDVQQKDARB\nUEVYMQswCQYDVQQHDAJGWjELMAkGA1UECAwCRkoxCzAJBgNVBAYTAkNOMIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3yeRDX7cm+J3kBu/zOneMPQaZJ8T\nz5ytZM1+2PtG+FPpYsPlAXPUTqMgxGMqXJ68cK5H/+J6dsWqYDTpzh6sjjc7FUe8\nb0HtVhyQt07gHS6ckPWvY1TWKaVVhspodULKR2VbC7O7sa95OR2g+8TIOBmAXV/A\nj5e3Bb5EiAHxwn/GsWzIg9ZoFZMl8/wYEHsULyP04DTi2uaE06t9fJzRffwIRXSi\nUPaTnwxdlBc8Bwb2RU4z+I0vZ9as7eGyMl286Lfp22CXj0w0K1G5B4YV7w60wvep\nrgn74fdeUAjHih7GqacF6PLjr6ckR3ZAwAvFU9UgcTOFXj9NJmC3G2o0awIDAQAB\nMA0GCSqGSIb3DQEBCwUAA4IBAQBOo+SdY81ERyHXRhrRrUQ6otR/qG/DFuNX7Xdh\nDkcFAYpQ+kq3J5tast5LvUyjNotx1QpNceEEVj2SSWh0dBTnPmh9uF6SEMZnovH3\npnWGsJzF/5l4Ind+CN7nXI3wW1CXxm1N0mfVigpyZBlSRBvKk0ja0lGaTEJa0Edc\nqKEziNIluO2/ZpOwDT27FUyMGgMeaxLXHcU7HyX6Hc+vU0Kd08RceVI9loOEAFZw\nRpIFyRFacAPGYPobIGOJDAWJLwm2D6JNytVObTc6CvRDKE6M3JIdCWOtg98t+ukY\nPqalpxBGDmfN1IubQHO0S//LJRaoDXMCSNG4T88mQvznFGZ/\n-----END CERTIFICATE-----\n";
        ByteArrayInputStream fs = null;
        try {
            fs = new ByteArrayInputStream(caCertStr.getBytes());
            this.caCert = javax.security.cert.X509Certificate.getInstance(fs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (x509Certificates == null || x509Certificates.length == 0) {
            throw new CertificateException("\u8bc1\u4e66\u4e0d\u5b58\u5728");
        }
        if (!x509Certificates[0].getIssuerDN().equals(this.caCert.getSubjectDN())) {
            throw new CertificateException("\u975eAPEX-CA\u9881\u53d1\u8bc1\u4e66");
        }
        try {
            x509Certificates[0].verify(this.caCert.getPublicKey());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException(e);
        }
        catch (InvalidKeyException e) {
            throw new CertificateException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CertificateException(e);
        }
        catch (SignatureException e) {
            throw new CertificateException(e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

