/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client;

import com.apexsoft.client.GatewayClient;
import com.apexsoft.client.Head;
import com.apexsoft.client.LogInterceptor;
import com.apexsoft.client.Request;
import com.apexsoft.client.Response;
import com.apexsoft.client.Server;
import com.apexsoft.client.ServerStrategy;
import com.apexsoft.client.exception.GatewayException;
import com.apexsoft.client.ssl.GatewayHostnameVerifier;
import com.apexsoft.client.ssl.GatewayKeyManager;
import com.apexsoft.client.ssl.GatewayTrustManager;
import com.apexsoft.client.ssl.TrustAnyHostnameVerifier;
import com.apexsoft.client.ssl.TrustAnyServerManager;
import com.apexsoft.client.strategy.AvailableStrategy;
import com.apexsoft.client.strategy.ComplexStrategy;
import com.apexsoft.client.strategy.RandomStrategy;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGatewayClient
implements GatewayClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractGatewayClient.class);
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    static final Charset UTF8 = Charset.forName("UTF-8");
    static final String MEDIA_TYPE_JSON = "application/json";
    static final String MEDIA_TYPE_PLAIN = "text/plain";
    static final String PATH_SERVICE = "/service";
    static final String PATH_UPLOAD = "/upload";
    static final String PATH_DOWNLOAD = "/download";
    static final String PATH_LOGIN = "/login";
    static final String PATH_VALIDATE = "/validate";
    static final String PATH_SPLIT = "/";
    static final String KEY_SERVICE_ID = "serviceId";
    static final String KEY_SESSION_ID = "sessionId";
    static final String KEY_BODY = "body";
    static final String KEY_HEAD = "head";
    static final String KEY_DATA = "data";
    static final String KEY_VERSION = "version";
    static final String KEY_NAMESPACE = "namespace";
    static final String KEY_METHOD = "method";
    String user;
    String password;
    ServerStrategy strategy = new RandomStrategy();
    boolean checkSessionByValidateInError = false;
    String contextPath = "";
    List<Server> servers = new ArrayList<Server>();
    private boolean trustAnyCert = false;
    private long connectTimeout = 2L;
    private long readTimeout = 10L;
    private long writeTimeout = 4L;
    private LogInterceptor logInterceptor = new LogInterceptor(this);
    private CheckServers guardThread = new CheckServers();

    @Override
    public void setStrategy(ServerStrategy ... strategy) {
        if (log.isDebugEnabled()) {
            for (ServerStrategy t : strategy) {
                log.debug("\u6dfb\u52a0\u7b56\u7565\u5668:{}", (Object)t.getClass().getName());
                if (!(t instanceof AvailableStrategy) || this.guardThread.isAlive()) continue;
                this.guardThread.setName(this.getClass().getSimpleName() + "-GuardThread");
                this.guardThread.start();
            }
        }
        this.strategy = new ComplexStrategy(strategy);
    }

    @Override
    public void setAuth(String user, String password) {
        this.user = user;
        this.password = password;
    }

    @Override
    public Server addHTTPServer(String ip, int port) throws GatewayException {
        return this.addServer(HTTP, ip, port, null, null);
    }

    @Override
    public Server addHTTPSServer(String ip, int port, File clientKey, String clientKeyPassword) throws GatewayException {
        FileInputStream fisClient = null;
        try {
            if (clientKey != null) {
                fisClient = new FileInputStream(clientKey);
                byte[] clientBytes = new byte[fisClient.available()];
                if (fisClient.read(clientBytes) == -1) {
                    throw new GatewayException("\u5ba2\u6237\u7aef\u8bc1\u4e66\u8bfb\u53d6\u5f02\u5e38");
                }
                Server server = this.addServer(HTTPS, ip, port, clientBytes, clientKeyPassword);
                return server;
            }
            Server clientBytes = this.addServer(HTTPS, ip, port, null, null);
            return clientBytes;
        }
        catch (IOException e) {
            throw new GatewayException(e.getMessage(), e);
        }
        finally {
            if (fisClient != null) {
                try {
                    fisClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Server addServer(String protocol, String ip, int port, byte[] clientKey, String clientKeyPassword) throws GatewayException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (this.connectTimeout > 0L) {
            builder.connectTimeout(this.connectTimeout, TimeUnit.SECONDS);
        }
        if (this.writeTimeout > 0L) {
            builder.connectTimeout(this.writeTimeout, TimeUnit.SECONDS);
        }
        if (this.readTimeout > 0L) {
            builder.connectTimeout(this.readTimeout, TimeUnit.SECONDS);
        }
        if (HTTPS.equals(protocol)) {
            try {
                X509TrustManager trustManager = this.trustAnyCert ? TrustAnyServerManager.getInstance() : GatewayTrustManager.getInstance();
                builder.sslSocketFactory(this.getSSLSocketFactory(clientKey, clientKeyPassword, trustManager), trustManager);
                builder.hostnameVerifier(this.trustAnyCert ? new TrustAnyHostnameVerifier() : new GatewayHostnameVerifier());
            }
            catch (NoSuchAlgorithmException e) {
                throw new GatewayException("SSL\u5f02\u5e38", e);
            }
            catch (KeyManagementException e) {
                throw new GatewayException("SSL\u5f02\u5e38", e);
            }
        }
        Server server = new Server(builder.addNetworkInterceptor((Interceptor)this.logInterceptor).build(), protocol + ip + ":" + port);
        this.servers.add(server);
        if (log.isDebugEnabled()) {
            log.debug("\u6dfb\u52a0\u670d\u52a1:{}", (Object)(protocol + ip + ":" + port));
        }
        return server;
    }

    private SSLSocketFactory getSSLSocketFactory(byte[] clientKey, String clientKeyPassword, X509TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trustManagers = new TrustManager[]{trustManager};
        KeyManager[] keyManagers = null;
        if (clientKey != null) {
            keyManagers = new KeyManager[]{new GatewayKeyManager(clientKey, clientKeyPassword)};
        }
        context.init(keyManagers, trustManagers, new SecureRandom());
        return context.getSocketFactory();
    }

    @Override
    public void setTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        this.connectTimeout = connectTimeout;
        this.writeTimeout = writeTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public void ignoreCertVerify() {
        if (this.servers.size() > 0) {
            throw new RuntimeException("trustAnyServer\u5fc5\u987b\u5728addHTTPServer|addHTTPSServer\u4e4b\u524d\u8c03\u7528");
        }
        this.trustAnyCert = true;
    }

    @Override
    public void setContextPath(String contextPath) {
        if (null == contextPath || "".equals(contextPath.trim())) {
            return;
        }
        if (!(contextPath = contextPath.trim()).startsWith(PATH_SPLIT)) {
            contextPath = PATH_SPLIT + contextPath;
        }
        if (contextPath.endsWith(PATH_SPLIT)) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        this.contextPath = contextPath;
    }

    @Override
    public void checkSessionByValidateInError() {
        this.checkSessionByValidateInError = true;
    }

    protected abstract Response handleService(Request var1, Server var2, boolean var3) throws GatewayException;

    protected abstract Response handleUpload(Request var1, String[] var2, File[] var3, Server var4, boolean var5) throws GatewayException;

    protected abstract Response handleDownload(Request var1, File var2, Server var3, boolean var4) throws GatewayException;

    protected abstract okhttp3.Response loginInner(Server var1) throws IOException, GatewayException;

    protected abstract boolean validate(Server var1) throws GatewayException;

    protected abstract okhttp3.Response validateInner(Server var1) throws IOException, GatewayException;

    protected abstract void login(Server var1) throws GatewayException;

    protected abstract String read(okhttp3.Response var1) throws IOException, GatewayException;

    @Override
    public void destory() {
        if (this.guardThread.isAlive()) {
            this.guardThread.interrupt();
            this.guardThread = new CheckServers();
            this.guardThread.setName(this.getClass().getSimpleName() + "-GuardThread");
        }
        this.servers = new ArrayList<Server>();
    }

    protected JsonObject protocolV4toV2(Request request) {
        JsonObject reqData = request.toJSON();
        reqData.remove(KEY_NAMESPACE);
        reqData.remove(KEY_METHOD);
        reqData.addProperty(KEY_SERVICE_ID, request.getNameSpaceAndServiceIdAndMethod());
        return reqData;
    }

    protected JsonObject protocolV4toV1(Request request) {
        JsonObject reqData = request.toJSON();
        Head head = request.getHead();
        JsonObject data = reqData.getAsJsonObject(KEY_DATA);
        reqData.remove(KEY_HEAD);
        Set<String> headKeys = head.getHeaderNames();
        for (String key : headKeys) {
            reqData.add(key, head.get(key));
        }
        reqData.remove(KEY_DATA);
        Set dataKeys = data.keySet();
        for (String key : dataKeys) {
            reqData.add(key, data.get(key));
        }
        reqData.remove(KEY_NAMESPACE);
        reqData.remove(KEY_METHOD);
        reqData.addProperty(KEY_SERVICE_ID, request.getNameSpaceAndServiceIdAndMethod());
        return reqData;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    public class CheckServers
    extends Thread {
        private long time;

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

