/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client;

import com.apexsoft.client.AbstractGatewayClient;
import com.apexsoft.client.GatewayClient;
import com.apexsoft.client.LoginResponse;
import com.apexsoft.client.Request;
import com.apexsoft.client.Response;
import com.apexsoft.client.Server;
import com.apexsoft.client.exception.GatewayException;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayClientV1Impl
extends AbstractGatewayClient {
    private static final Logger log = LoggerFactory.getLogger(GatewayClientV1Impl.class);
    private boolean urlencode = true;
    private static final String NOURLENCODER = "NOURLEncode";

    @Override
    public Response upload(Request data, File source) throws GatewayException {
        Server server = this.strategy.get(this.servers).get(0);
        if (log.isDebugEnabled()) {
            log.debug("\u76ee\u6807\u670d\u52a1:{}", (Object)server.toString());
        }
        return this.handleUpload(data, new String[]{"file"}, new File[]{source}, server, true);
    }

    @Override
    protected Response handleUpload(Request data, String[] fileField, File[] sources, Server server, boolean doLogin) throws GatewayException {
        try {
            Response resp;
            Request.Builder builder = this.build(data, server);
            builder.url(server.getServer() + this.contextPath + "/upload");
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
            bodyBuilder.setType(MultipartBody.FORM);
            JsonObject reqData = this.protocolV4toV1(data);
            for (File[] key : reqData.keySet()) {
                bodyBuilder.addFormDataPart((String)key, reqData.get((String)key).getAsString());
            }
            int index = 0;
            for (File source : sources) {
                String formField = fileField[index] == null ? "file" : fileField[index];
                bodyBuilder.addFormDataPart(formField, source.getName(), MultipartBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)source));
                ++index;
            }
            builder.post((RequestBody)bodyBuilder.build());
            okhttp3.Request request = builder.build();
            okhttp3.Response response = server.getClient().newCall(request).execute();
            if (response.code() == 200) {
                if (response.body() == null) {
                    throw new GatewayException("\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                }
                resp = new Response(this.read(response, this.urlencode));
                if (doLogin && resp.getCode() < 0 && this.checkSessionByValidateInError) {
                    if (!this.validate(server)) {
                        this.login(server);
                        return this.handleUpload(data, fileField, sources, server, false);
                    }
                } else if (doLogin && resp.getCode() == -10002) {
                    this.login(server);
                    return this.handleUpload(data, fileField, sources, server, false);
                }
            } else {
                if (response.code() >= 501 && response.code() <= 510) {
                    server.markFail();
                    log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
                }
                resp = new Response().setCode(-1).setNote("[code=" + response.code() + "]" + (response.body() == null ? "" : response.body().string()));
            }
            return resp;
        }
        catch (SocketException e) {
            server.markFail();
            log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
            throw new GatewayException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GatewayException(e.getMessage(), e);
        }
    }

    @Override
    public Response service(Request data) throws GatewayException {
        Server server = this.strategy.get(this.servers).get(0);
        if (log.isDebugEnabled()) {
            log.debug("\u76ee\u6807\u670d\u52a1:{}", (Object)server.toString());
        }
        return this.handleService(data, server, true);
    }

    @Override
    protected Response handleService(Request data, Server server, boolean doLogin) throws GatewayException {
        try {
            Response resp;
            Request.Builder builder = this.build(data, server);
            builder.url(server.getServer() + this.contextPath + "/service");
            this.buildRequest(builder, data);
            okhttp3.Request request = builder.build();
            okhttp3.Response response = server.getClient().newCall(request).execute();
            if (response.code() == 200) {
                if (response.body() == null) {
                    throw new GatewayException("\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                }
                resp = new Response(this.read(response, this.urlencode));
                if (doLogin && resp.getCode() < 0 && this.checkSessionByValidateInError) {
                    if (!this.validate(server)) {
                        this.login(server);
                        return this.handleService(data, server, false);
                    }
                } else if (doLogin && resp.getCode() == -10002) {
                    this.login(server);
                    return this.handleService(data, server, false);
                }
            } else {
                if (response.code() >= 501 && response.code() <= 510) {
                    server.markFail();
                    log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
                }
                resp = new Response().setCode(-1).setNote("[code=" + response.code() + "]" + (response.body() == null ? "" : response.body().string()));
            }
            return resp;
        }
        catch (SocketException e) {
            server.markFail();
            log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
            throw new GatewayException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GatewayException(e.getMessage(), e);
        }
    }

    @Override
    public Response download(Request data, File dest) throws GatewayException {
        Server server = this.strategy.get(this.servers).get(0);
        if (log.isDebugEnabled()) {
            log.debug("\u76ee\u6807\u670d\u52a1:{}", (Object)server.toString());
        }
        return this.handleDownload(data, dest, server, true);
    }

    public void setURLEncode(boolean urlencode) {
        this.urlencode = urlencode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response handleDownload(Request data, File dest, Server server, boolean doLogin) throws GatewayException {
        try {
            Response resp;
            Request.Builder builder = this.build(data, server);
            builder.url(server.getServer() + this.contextPath + "/download");
            this.buildRequest(builder, data);
            okhttp3.Request request = builder.build();
            okhttp3.Response response = server.getClient().newCall(request).execute();
            if (response.code() == 200) {
                if (response.header("Content-Disposition") == null) {
                    resp = new Response(this.read(response, this.urlencode));
                } else {
                    resp = new Response();
                    if (dest.getParentFile() != null && !dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                        throw new GatewayException("\u4e0b\u8f7d\u4e34\u65f6\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
                    }
                    if (!dest.exists() && !dest.createNewFile()) {
                        throw new GatewayException("\u4e0b\u8f7d\u4e34\u65f6\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
                    }
                    if (response.body() == null) {
                        throw new GatewayException("\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                    }
                    FileOutputStream fos = null;
                    InputStream is = null;
                    try {
                        int len;
                        fos = new FileOutputStream(dest);
                        is = response.body().byteStream();
                        byte[] bytes = new byte[8192];
                        while ((len = is.read(bytes)) != -1) {
                            fos.write(bytes, 0, len);
                        }
                    }
                    finally {
                        if (fos != null) {
                            fos.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                    }
                    resp.setCode(1);
                    resp.setNote("download success");
                }
                if (doLogin && resp.getCode() < 0 && this.checkSessionByValidateInError) {
                    if (!this.validate(server)) {
                        this.login(server);
                        return this.handleDownload(data, dest, server, false);
                    }
                } else if (doLogin && resp.getCode() == -10002) {
                    this.login(server);
                    return this.handleDownload(data, dest, server, false);
                }
            } else {
                if (response.code() >= 501 && response.code() <= 510) {
                    server.markFail();
                    log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
                }
                resp = new Response().setCode(-1).setNote("[code=" + response.code() + "]" + (response.body() == null ? "" : response.body().string()));
            }
            return resp;
        }
        catch (SocketException e) {
            server.markFail();
            log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
            throw new GatewayException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GatewayException(e.getMessage(), e);
        }
    }

    private void buildRequest(Request.Builder builder, Request request) throws GatewayException {
        JsonObject reqData = this.protocolV4toV1(request);
        if (this.urlencode) {
            try {
                builder.post(RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)URLEncoder.encode(reqData.toString(), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new GatewayException(e.getMessage(), e);
            }
        } else {
            builder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)reqData.toString()));
        }
    }

    private Request.Builder build(Request data, Server server) {
        Request.Builder builder = new Request.Builder();
        if (server.getSessionId() != null) {
            data.sessionId = server.getSessionId();
        }
        data.version = GatewayClient.ProtocolVersion.ESB.value();
        return builder;
    }

    @Override
    protected okhttp3.Response loginInner(Server server) throws IOException, GatewayException {
        Request.Builder builder = new Request.Builder();
        builder.url(server.getServer() + this.contextPath + "/login");
        Request req = new Request();
        req.put("loginId", this.user);
        req.put("loginPwd", this.password);
        builder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)req.toJSON().get("data").toString()));
        okhttp3.Request request = builder.build();
        return server.getClient().newCall(request).execute();
    }

    @Override
    protected boolean validate(Server server) throws GatewayException {
        try {
            okhttp3.Response response = this.validateInner(server);
            if (response.code() == 200) {
                if (response.body() == null) {
                    throw new GatewayException("\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                }
                Response resp = new Response(this.read(response, this.urlencode));
                return resp.getCode() >= 0;
            }
            if (response.code() >= 501 && response.code() <= 510) {
                server.markFail();
                log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
            }
            throw new GatewayException("response.error[" + response.code() + "]");
        }
        catch (SocketException e) {
            server.markFail();
            log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
            throw new GatewayException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GatewayException(e.getMessage(), e);
        }
    }

    @Override
    protected okhttp3.Response validateInner(Server server) throws IOException, GatewayException {
        Request.Builder builder = new Request.Builder();
        if (!this.urlencode) {
            builder.addHeader(NOURLENCODER, NOURLENCODER);
        }
        builder.url(server.getServer() + this.contextPath + "/validate");
        Request req = new Request();
        req.put("sessionId", server.getSessionId());
        builder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)req.toJSON().get("data").toString()));
        okhttp3.Request request = builder.build();
        return server.getClient().newCall(request).execute();
    }

    @Override
    protected void login(Server server) throws GatewayException {
        try {
            LoginResponse resp;
            okhttp3.Response response = this.loginInner(server);
            if (response.code() == 200) {
                if (response.body() == null) {
                    throw new GatewayException("\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                }
                resp = new LoginResponse(this.read(response, false));
                if (resp.getCode() == 0) {
                    resp.setCode(1);
                }
                if (resp.getCode() < 0) {
                    throw new GatewayException("LiveGateway-login\u5f02\u5e38[code=" + resp.getCode() + ",note=" + resp.getNote() + "]");
                }
            } else {
                if (response.code() >= 501 && response.code() <= 510) {
                    server.markFail();
                    log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
                }
                resp = (LoginResponse)new LoginResponse().setCode(-1).setNote("[code=" + response.code() + "]" + (response.body() == null ? "" : response.body().string()));
            }
            if (resp.getCode() > 0) {
                server.setSessionId(resp.getSessionId());
            }
        }
        catch (SocketException e) {
            server.markFail();
            log.debug("{}\u6807\u8bb0\u4e3a\u4e0d\u53ef\u7528", (Object)server);
            throw new GatewayException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GatewayException(e.getMessage(), e);
        }
    }

    private String read(okhttp3.Response response, boolean isURLEncode) throws IOException, GatewayException {
        if (response.body() == null) {
            throw new GatewayException("no response");
        }
        MediaType contentType = response.body().contentType();
        Charset charset = UTF8;
        if (contentType != null) {
            try {
                charset = contentType.charset(UTF8);
            }
            catch (UnsupportedCharsetException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        String responStr = response.body().source().readString(charset);
        if (isURLEncode) {
            return URLDecoder.decode(responStr, "UTF-8");
        }
        return responStr;
    }

    @Override
    protected String read(okhttp3.Response response) throws IOException, GatewayException {
        if (response.body() == null) {
            throw new GatewayException("no response");
        }
        MediaType contentType = response.body().contentType();
        Charset charset = UTF8;
        if (contentType != null) {
            try {
                charset = contentType.charset(UTF8);
            }
            catch (UnsupportedCharsetException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        String responStr = response.body().source().readString(charset);
        if (this.isURLEncode()) {
            return URLDecoder.decode(responStr, "UTF-8");
        }
        return responStr;
    }

    public boolean isURLEncode() {
        return this.urlencode;
    }
}

