/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client;

import com.apexsoft.client.Head;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class Response {
    private JsonElement data;
    private Head head;
    private Gson gson = new GsonBuilder().registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

        public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == (double)src.longValue()) {
                return new JsonPrimitive((Number)src.longValue());
            }
            return new JsonPrimitive((Number)src);
        }
    }).create();

    public Response(String text) {
        this.data = JsonParser.parseString((String)text);
    }

    public Response() {
        this.data = new JsonObject();
    }

    public int getCode() {
        if (this.data.isJsonObject()) {
            JsonElement codeEle = ((JsonObject)this.data).get("code");
            return codeEle == null ? 0 : codeEle.getAsInt();
        }
        return 0;
    }

    public String getNote() {
        if (this.data.isJsonObject()) {
            JsonElement noteEle = ((JsonObject)this.data).get("note");
            return noteEle == null ? null : noteEle.getAsString();
        }
        return null;
    }

    Response setCode(int code) {
        if (this.data.isJsonObject()) {
            this.data.getAsJsonObject().addProperty("code", (Number)code);
            return this;
        }
        throw new RuntimeException("Response body is not json");
    }

    Response setNote(String note) {
        if (this.data.isJsonObject()) {
            this.data.getAsJsonObject().addProperty("note", note);
            return this;
        }
        throw new RuntimeException("Response body is not json");
    }

    public String toJSONString() {
        return this.data.toString();
    }

    public <T> T toObject(Class clazz) {
        if (this.data.isJsonObject()) {
            return (T)this.gson.fromJson(this.data, clazz);
        }
        throw new RuntimeException("Response body is not json");
    }

    public <T> T toObject(Type type) {
        if (this.data.isJsonObject()) {
            return (T)this.gson.fromJson(this.data, type);
        }
        throw new RuntimeException("Response body is not json");
    }

    public <T> Response put(String name, T value) {
        if (this.data.isJsonObject()) {
            this.data.getAsJsonObject().add(name, this.gson.toJsonTree(value));
            return this;
        }
        throw new RuntimeException("Response body is not json");
    }

    public <T> T get(String name, Class<T> clazz) {
        if (this.data.isJsonObject()) {
            JsonElement element = this.data.getAsJsonObject().get(name);
            return (T)this.gson.fromJson(element, clazz);
        }
        throw new RuntimeException("Response body is not json");
    }

    public <T> T get(String name, Type type) {
        if (this.data.isJsonObject()) {
            JsonElement element = this.data.getAsJsonObject().get(name);
            return (T)this.gson.fromJson(element, type);
        }
        throw new RuntimeException("Response body is not json");
    }

    public Head getHead() {
        return this.head;
    }

    public void setHead(Head head) {
        this.head = head;
    }
}

