/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client.ssl;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class GatewayHostnameVerifier
implements HostnameVerifier {
    @Override
    public boolean verify(String s, SSLSession sslSession) {
        X509Certificate[] x509Certificates;
        try {
            x509Certificates = sslSession.getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            e.printStackTrace();
            return false;
        }
        if (x509Certificates == null || x509Certificates.length == 0) {
            return false;
        }
        String matchStr = "CN=" + s;
        for (X509Certificate certificate : x509Certificates) {
            if (certificate.getSubjectDN().getName().indexOf(matchStr) < 0) continue;
            return true;
        }
        return false;
    }
}

