/*
 * Decompiled with CFR 0.152.
 */
package com.apexsoft.client.ssl;

import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.X509KeyManager;

public class GatewayKeyManager
implements X509KeyManager {
    private String[] alias;
    private PrivateKey privateKey;
    private X509Certificate[] x509Certificates;

    public GatewayKeyManager(byte[] clientKey, String clientKeyPassword) {
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(new ByteArrayInputStream(clientKey), clientKeyPassword.toCharArray());
            Enumeration<String> aliases = ks.aliases();
            String keyAlias = null;
            this.alias = new String[ks.size()];
            int i = 0;
            if (aliases.hasMoreElements()) {
                keyAlias = aliases.nextElement();
                this.alias[i++] = keyAlias;
            }
            this.privateKey = (PrivateKey)ks.getKey(keyAlias, clientKeyPassword.toCharArray());
            this.x509Certificates = new X509Certificate[this.alias.length];
            for (int j = 0; j < this.alias.length; ++j) {
                this.x509Certificates[j] = (X509Certificate)ks.getCertificate(this.alias[j]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.alias;
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.alias[0];
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return new String[0];
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.x509Certificates;
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.privateKey;
    }
}

