/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common;

import com.citicbank.cbframework.common.exception.CBException;
import com.citicbank.cbframework.common.security.CBSM2;
import com.citicbank.cbframework.common.util.CBFileOperator;
import com.lsy.baselib.crypto.util.Base64;
import java.io.File;

public class MainTest {
    public static void main(String[] args) {
        File f = new File("ECiticData/RSACert/rsadouble2048cert_Encrypt.pfx");
        if (f.exists()) {
            System.out.println("file exist");
        } else {
            System.out.println("file not exist");
        }
        String message = "abcd1234";
        try {
            String sm2Crt = "MIIB5TCCAZCgAwIBAgIBADAMBggqgRzPVQGDdQUAMDIxDzANBgNVBAMMBlNFUlZFUjESMBAGA1UECwwJQ0lUSUNCQU5LMQswCQYDVQQGEwJDTjAgFw0xNTA3MTMwMTE5NTdaGA8yMTE1MDYxOTAxMTk1N1owMjEPMA0GA1UEAwwGU0VSVkVSMRIwEAYDVQQLDAlDSVRJQ0JBTksxCzAJBgNVBAYTAkNOMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEB6FYfrgGt1azWzdVqtV5lxHJahBgeg1Mrtc9cFQZrw0NM61scRO7AVX5py1RKq2xq/CYXGso7VaapilnNYI7gqOBkjCBjzBeBgNVHSMEVzBVgBQ2T3aRz8you6PBCaJJEFNrqgh0UaE6pDgwNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMoIBAjAOBgNVHQ8BAf8EBAMCBBAwHQYDVR0OBBYEFDZPdpHPzKi7o8EJokkQU2uqCHRRMAwGCCqBHM9VAYN1BQADQQBNejERG01bQ5Fjx3WXo+Aw2h/4viADfGBhUjkL6WFp/16aGKKD3kJW5ZQ/p7RfZt188LxnkLMseFrBKX7VSyUD";
            String sm2Pvk = "A1NNMuvzZwa+FXkCAvlph65lpZ0oZjJXO19WyP9UW/v+Keg/1ndgW6F4ma3Y4dmOwjE9/wa8DQJO5m5VUnYpz6N6JS6wlQ0h9juqA0/3p2iUNzzEXrmzrB4B9f+4eCUwhmqCtjwXSnX2n+d2RwfG9+Q7C/c=";
            String sm2PvkPwd = "ePLkm7SOCVw2OjX3";
            String key = new String(CBFileOperator.getFileContent("ECiticData/SM2Cert/server.key"));
            String pwd = new String(CBFileOperator.getFileContent("ECiticData/SM2Cert/server.pwd"));
            CBSM2.setCertificate(sm2Crt);
            CBSM2.setPrivateKey(sm2Pvk, sm2PvkPwd);
            byte[] encryptedData = CBSM2.encrypt(message.getBytes());
            System.out.println("2encryptedData length:" + encryptedData.length);
            System.out.println("2encryptedData:" + Base64.encode((byte[])encryptedData));
            byte[] decryptedData = CBSM2.decrypt(encryptedData);
            System.out.println("decryptedData length:" + decryptedData.length);
            System.out.println("decryptedData:" + new String(decryptedData));
            byte[] singedData = CBSM2.signature(message.getBytes());
            System.out.println("singedData length:" + singedData.length);
            System.out.println("singedData:" + new String(singedData));
            boolean isOk = CBSM2.verify(message.getBytes(), singedData);
            if (isOk) {
                System.out.println("SM2\u516c\u94a5\u9a8c\u7b7e\u901a\u8fc7");
            } else {
                System.out.println("SM2\u516c\u94a5\u9a8c\u7b7e\u5931\u8d25");
            }
        }
        catch (CBException e) {
            e.printStackTrace();
        }
    }
}

