/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.security;

import com.citicbank.cbframework.common.exception.CBException;
import com.citicbank.cbframework.common.util.CBBase64;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class CBRSA {
    public static final String RSA = "RSA/ECB/NoPadding";
    public static final String MD5withRSA = "MD5withRSA";
    public static final String SHA1withRSA = "SHA1withRSA";
    private static final String PROVIDER_NAME = "BC";

    public static KeyPair generateKeyPair(int keySize) throws CBException {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(RSA, PROVIDER_NAME);
            keyPairGen.initialize(keySize, new SecureRandom());
            return keyPairGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new CBException(e, "MPCM033");
        }
    }

    public static RSAPublicKey generateRSAPublicKey(byte[] modulus, byte[] publicExponent) throws CBException {
        try {
            KeyFactory keyFac = KeyFactory.getInstance(RSA, PROVIDER_NAME);
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(publicExponent));
            return (RSAPublicKey)keyFac.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            throw new CBException(e, "MPCM033");
        }
    }

    public static RSAPublicKey getRSAPublicKey(String urlB64Key) throws CBException {
        try {
            KeyFactory keyFac = KeyFactory.getInstance(RSA, PROVIDER_NAME);
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(CBBase64.decode(urlB64Key.getBytes()));
            return (RSAPublicKey)keyFac.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            throw new CBException(e, "MPCM033");
        }
    }

    public static RSAPublicKey getRSAPublicKey(RSAPrivateKey prk) throws CBException {
        return CBRSA.generateRSAPublicKey(prk.getModulus().toByteArray(), ((RSAPrivateCrtKey)prk).getPublicExponent().toByteArray());
    }

    public static RSAPrivateKey generateRSAPrivateKey(byte[] modulus, byte[] privateExponent) throws CBException {
        try {
            KeyFactory keyFac = KeyFactory.getInstance(RSA, PROVIDER_NAME);
            RSAPrivateKeySpec priKeySpec = new RSAPrivateKeySpec(new BigInteger(modulus), new BigInteger(privateExponent));
            return (RSAPrivateKey)keyFac.generatePrivate(priKeySpec);
        }
        catch (Exception e) {
            throw new CBException(e, "MPCM033");
        }
    }

    public static RSAPrivateKey getRSAPrivateKey(String strB64Key) throws CBException {
        try {
            KeyFactory keyFac = KeyFactory.getInstance(RSA, PROVIDER_NAME);
            PKCS8EncodedKeySpec priKeySpec = new PKCS8EncodedKeySpec(CBBase64.decode(strB64Key.getBytes()));
            return (RSAPrivateKey)keyFac.generatePrivate(priKeySpec);
        }
        catch (Exception e) {
            throw new CBException(e, "MPCM033");
        }
    }

    public static byte[] encrypt(RSAKey key, byte[] data) throws CBException {
        try {
            Cipher cipher = Cipher.getInstance(RSA, PROVIDER_NAME);
            cipher.init(1, (Key)((Object)key));
            int step = key.getModulus().bitLength() / 8;
            int n = data.length / step;
            if (n > 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int i = 0;
                while (i < n) {
                    baos.write(cipher.doFinal(data, i * step, step));
                    ++i;
                }
                n = data.length % step;
                if (n != 0) {
                    baos.write(cipher.doFinal(data, data.length - n, n));
                }
                return baos.toByteArray();
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CBException(e, "MPCM033");
        }
    }

    public static byte[] decrypt(RSAKey key, byte[] raw) throws CBException {
        try {
            Cipher cipher = Cipher.getInstance(RSA, PROVIDER_NAME);
            cipher.init(2, (Key)((Object)key));
            int step = key.getModulus().bitLength() / 8;
            int n = raw.length / step;
            if (n > 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int i = 0;
                while (i < n) {
                    baos.write(cipher.doFinal(raw, i * step, step));
                    ++i;
                }
                return baos.toByteArray();
            }
            return cipher.doFinal(raw);
        }
        catch (Exception e) {
            throw new CBException(e, "MPCM033");
        }
    }

    public static byte[] signature(String signtype, byte[] data, PrivateKey sk) throws CBException {
        try {
            Signature s = Signature.getInstance(signtype, PROVIDER_NAME);
            s.initSign(sk);
            s.update(data);
            return s.sign();
        }
        catch (Exception e) {
            throw new CBException(e, "MPCM033");
        }
    }

    public static byte[] signatureIs(String signtype, InputStream is, PrivateKey sk) throws CBException {
        try {
            int size;
            Signature s = Signature.getInstance(signtype, PROVIDER_NAME);
            s.initSign(sk);
            byte[] buf = new byte[1024];
            while ((size = is.read(buf)) != -1) {
                s.update(buf, 0, size);
            }
            return s.sign();
        }
        catch (Exception e) {
            throw new CBException(e, "MPCM033");
        }
    }

    public static boolean verify(String signtype, byte[] data, byte[] sign, PublicKey pk) {
        try {
            Signature v = Signature.getInstance(signtype, PROVIDER_NAME);
            v.initVerify(pk);
            v.update(data);
            return v.verify(sign);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean verifyIs(String signtype, InputStream is, byte[] sign, PublicKey pk) {
        try {
            int size;
            Signature v = Signature.getInstance(signtype, PROVIDER_NAME);
            v.initVerify(pk);
            byte[] buf = new byte[1024];
            while ((size = is.read(buf)) != -1) {
                v.update(buf, 0, size);
            }
            return v.verify(sign);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

