/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.security;

import com.citicbank.cbframework.common.exception.CBException;
import com.lsy.baselib.crypto.algorithm.SM2;
import com.lsy.baselib.crypto.exception.SM2Exception;
import java.security.KeyPair;

public class CBSM2 {
    static SM2 sm2 = null;

    static {
        sm2 = new SM2();
    }

    public static void setCertificate(String cert) {
        sm2.setCertificate(cert);
    }

    public static void setPrivateKey(String key, String pwd) {
        sm2.setPrivateKey(key, pwd);
    }

    public void generateKeyPair() {
        KeyPair kp = null;
        String hexPublickey = null;
        String hexPrivatekey = null;
        try {
            kp = SM2.generateKeyPair();
            hexPublickey = SM2.getPublicKey((KeyPair)kp);
            hexPrivatekey = SM2.getPrivateKey((KeyPair)kp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("SM2\u79c1\u94a5\uff08" + hexPrivatekey.length() + "\uff09\uff1a\uff08" + kp.getPrivate().getAlgorithm() + "\uff09:" + hexPrivatekey);
        System.out.println("SM2\u516c\u94a5\uff08" + hexPublickey.length() + "\uff09:\uff08" + kp.getPublic().getAlgorithm() + "\uff09:" + hexPublickey);
    }

    public static byte[] decrypt(byte[] raw) throws CBException {
        byte[] data = null;
        try {
            data = sm2.decrypt(raw);
        }
        catch (SM2Exception e) {
            e.printStackTrace();
            throw new CBException((Exception)((Object)e), "MPCM033");
        }
        return data;
    }

    public static byte[] encrypt(byte[] data) throws CBException {
        byte[] cipher = null;
        try {
            cipher = sm2.encrypt(data);
        }
        catch (SM2Exception e) {
            e.printStackTrace();
            throw new CBException((Exception)((Object)e), "MPCM033");
        }
        return cipher;
    }

    public static byte[] signature(byte[] data) throws CBException {
        byte[] singedData = null;
        try {
            singedData = sm2.sign(data);
        }
        catch (SM2Exception e) {
            throw new CBException((Exception)((Object)e), "MPCM033");
        }
        return singedData;
    }

    public static boolean verify(byte[] data, byte[] sign) throws CBException {
        boolean isOk = false;
        try {
            isOk = sm2.verify(data, sign);
        }
        catch (SM2Exception e) {
            throw new CBException((Exception)((Object)e), "MPCM033");
        }
        return isOk;
    }
}

