/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import com.citicbank.cbframework.common.exception.CBIOException;
import com.citicbank.cbframework.common.exception.CBInvalidParameterException;
import com.citicbank.cbframework.common.util.CBStreamOperator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CBFileOperator {
    public static byte[] getFileContent(String filePath) throws CBIOException, CBInvalidParameterException {
        if (filePath == null) {
            throw new CBInvalidParameterException("MPCM012");
        }
        InputStream is = CBFileOperator.getFileStream(filePath);
        return CBStreamOperator.getInputStreamBytes(is);
    }

    public static InputStream getFileStream(String filePath) throws CBIOException, CBInvalidParameterException {
        if (filePath == null) {
            throw new CBInvalidParameterException("MPCM013");
        }
        try {
            if (filePath.startsWith("file:///android_asset/")) {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/" + filePath.substring(22));
            }
            return new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new CBIOException(e, "MPCM024 " + filePath);
        }
    }

    public static void saveToFileByBytes(String filePath, byte[] data) throws CBIOException, CBInvalidParameterException {
        CBFileOperator.saveToFileByBytes(filePath, data, false);
    }

    public static void saveToFileByBytes(String filePath, byte[] data, boolean append) throws CBIOException, CBInvalidParameterException {
        if (filePath == null || data == null) {
            throw new CBInvalidParameterException("MPCM013");
        }
        CBFileOperator.saveToFileByStream(filePath, new ByteArrayInputStream(data), append);
    }

    public static void saveToFileByString(String filePath, String src) throws CBIOException, CBInvalidParameterException {
        CBFileOperator.saveToFileByString(filePath, src, false);
    }

    public static void saveToFileByString(String filePath, String data, boolean append) throws CBIOException, CBInvalidParameterException {
        if (filePath == null || data == null) {
            throw new CBInvalidParameterException("MPCM013");
        }
        CBFileOperator.saveToFileByStream(filePath, new ByteArrayInputStream(data.getBytes()), append);
    }

    public static void saveToFileByStream(String filePath, InputStream is) throws CBIOException, CBInvalidParameterException {
        CBFileOperator.saveToFileByStream(filePath, is, false);
    }

    public static void saveToFileByStream(String filePath, InputStream is, boolean append) throws CBIOException, CBInvalidParameterException {
        if (filePath == null || is == null) {
            throw new CBInvalidParameterException("MPCM014");
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(filePath);
                CBStreamOperator.copy(is, fos);
            }
            catch (FileNotFoundException e) {
                throw new CBIOException(e, "MPCM011 " + filePath);
            }
        }
        catch (Throwable throwable) {
            CBStreamOperator.close(fos);
            throw throwable;
        }
        CBStreamOperator.close(fos);
    }

    public static void unZip(String zipFilePath, String destPath) throws CBIOException, CBInvalidParameterException {
        if (zipFilePath == null || destPath == null) {
            throw new CBInvalidParameterException("MPCM015");
        }
        if (!destPath.endsWith("/")) {
            destPath = String.valueOf(destPath) + "/";
        }
        FileOutputStream fos = null;
        ZipInputStream zis = null;
        ZipEntry zipEntry = null;
        File file = null;
        int readedBytes = 0;
        byte[] buf = new byte[4096];
        try {
            try {
                zis = new ZipInputStream(new BufferedInputStream(CBFileOperator.getFileStream(zipFilePath)));
                while ((zipEntry = zis.getNextEntry()) != null) {
                    file = new File(String.valueOf(destPath) + zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        File parent = file.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        }
                        fos = new FileOutputStream(file);
                        while ((readedBytes = zis.read(buf)) > 0) {
                            fos.write(buf, 0, readedBytes);
                        }
                        fos.close();
                    }
                    zis.closeEntry();
                }
            }
            catch (IOException e) {
                throw new CBIOException(e, "MPCM015");
            }
        }
        catch (Throwable throwable) {
            CBStreamOperator.close(zis);
            throw throwable;
        }
        CBStreamOperator.close(zis);
    }

    public static void zip(String srcPath, String zipFilePath) throws CBIOException {
        CBFileOperator.zip(zipFilePath, new File(srcPath));
    }

    public static void zip(String zipFilePath, File srcFile) throws CBIOException {
        ZipOutputStream zos = null;
        try {
            try {
                zos = new ZipOutputStream(new FileOutputStream(zipFilePath));
                CBFileOperator.zip(zos, srcFile, "");
            }
            catch (IOException e) {
                throw new CBIOException(e, "MPCM016");
            }
        }
        catch (Throwable throwable) {
            CBStreamOperator.close(zos);
            throw throwable;
        }
        CBStreamOperator.close(zos);
    }

    private static void zip(ZipOutputStream zos, File srcFile, String baseDir) throws IOException {
        if (srcFile.isDirectory()) {
            File[] fileList = srcFile.listFiles();
            zos.putNextEntry(new ZipEntry(String.valueOf(baseDir) + "/"));
            baseDir = baseDir.length() == 0 ? "" : String.valueOf(baseDir) + "/";
            int i = 0;
            while (i < fileList.length) {
                CBFileOperator.zip(zos, fileList[i], String.valueOf(baseDir) + fileList[i].getName());
                ++i;
            }
        } else {
            int b;
            zos.putNextEntry(new ZipEntry(baseDir));
            FileInputStream in = new FileInputStream(srcFile);
            while ((b = in.read()) != -1) {
                zos.write(b);
            }
            in.close();
        }
    }

    public static boolean deleteFile(String fileName) {
        return CBFileOperator.deleteFile(new File(fileName));
    }

    public static boolean deleteFile(File file) {
        File[] subFiles;
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory() && (subFiles = file.listFiles()) != null) {
            File[] fileArray = subFiles;
            int n = subFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                if (!CBFileOperator.deleteFile(subFile)) {
                    return false;
                }
                ++n2;
            }
        }
        return file.delete();
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int len;
        FileInputStream input = new FileInputStream(sourceFile);
        BufferedInputStream inBuff = new BufferedInputStream(input);
        FileOutputStream output = new FileOutputStream(targetFile);
        BufferedOutputStream outBuff = new BufferedOutputStream(output);
        byte[] b = new byte[5120];
        while ((len = inBuff.read(b)) != -1) {
            outBuff.write(b, 0, len);
        }
        outBuff.flush();
        inBuff.close();
        outBuff.close();
        output.close();
        input.close();
    }

    public static void copyDirectiory(String sourceDir, String targetDir) throws IOException {
        CBFileOperator.copyDirectiory(sourceDir, targetDir, true);
    }

    public static void copyDirectiory(String sourceDir, String targetDir, boolean lazy) throws IOException {
        new File(targetDir).mkdirs();
        File[] file = new File(sourceDir).listFiles();
        int i = 0;
        while (i < file.length) {
            block5: {
                if (file[i].isFile()) {
                    File sourceFile = file[i];
                    File targetFile = new File(String.valueOf(new File(targetDir).getAbsolutePath()) + File.separator + file[i].getName());
                    try {
                        CBFileOperator.copyFile(sourceFile, targetFile);
                    }
                    catch (IOException e) {
                        if (!lazy) break block5;
                        throw e;
                    }
                }
            }
            if (file[i].isDirectory()) {
                String dir1 = String.valueOf(sourceDir) + File.separator + file[i].getName();
                String dir2 = String.valueOf(targetDir) + File.separator + file[i].getName();
                CBFileOperator.copyDirectiory(dir1, dir2, lazy);
            }
            ++i;
        }
    }
}

