/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import com.citicbank.cbframework.common.exception.CBException;
import com.citicbank.cbframework.common.exception.CBIOException;
import com.citicbank.cbframework.common.exception.CBInvalidParameterException;
import com.citicbank.cbframework.common.exception.CBInvalidTypeException;
import com.citicbank.cbframework.common.util.CBMD5;
import com.citicbank.cbframework.common.util.CBSHA1;
import com.citicbank.cbframework.common.util.CBSM3;
import java.io.InputStream;

public class CBHash {
    public static final int NONE = 0;
    public static final int MD5 = 1;
    public static final int SHA1 = 2;
    public static final int SM3 = 3;

    public static byte[] getHashByString(int type, String src) throws CBException {
        try {
            switch (type) {
                case 1: {
                    return CBMD5.getHashByString(src);
                }
                case 2: {
                    return CBSHA1.getHashByString(src);
                }
                case 3: {
                    return CBSM3.getHashByString(src);
                }
            }
            throw new CBInvalidTypeException("MPCM020");
        }
        catch (CBInvalidParameterException e) {
            throw new CBException(e, "MPCM016");
        }
    }

    public static byte[] getHashByInputStream(int type, InputStream src) throws CBException {
        try {
            switch (type) {
                case 1: {
                    return CBMD5.getHashByInputStream(src);
                }
                case 2: {
                    return CBSHA1.getHashByInputStream(src);
                }
                case 3: {
                    return CBSM3.getHashByInputStream(src);
                }
            }
            throw new CBInvalidTypeException("MPCM017");
        }
        catch (CBInvalidParameterException e) {
            throw new CBException(e, "MPCM018");
        }
        catch (CBIOException e) {
            throw new CBException(e, "MPCM019");
        }
    }

    public static byte[] getHashByBytes(int type, byte[] src) throws CBException {
        try {
            switch (type) {
                case 1: {
                    return CBMD5.getHashByBytes(src);
                }
                case 2: {
                    return CBSHA1.getHashByBytes(src);
                }
                case 3: {
                    return CBSM3.getHashByBytes(src);
                }
            }
            throw new CBInvalidTypeException("MPCM021");
        }
        catch (CBInvalidParameterException e) {
            throw new CBException(e, "MPCM022");
        }
    }
}

