/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import com.citicbank.cbframework.common.exception.CBInvalidParameterException;
import java.util.Locale;

public class CBHex {
    public static String encode(byte[] data) throws CBInvalidParameterException {
        if (data == null) {
            throw new CBInvalidParameterException("MPCM014");
        }
        StringBuilder sb = new StringBuilder();
        int n = 0;
        while (n < data.length) {
            String stmp = Integer.toHexString(data[n] & 0xFF);
            if (stmp.length() == 1) {
                sb.append("0");
            }
            sb.append(stmp);
            ++n;
        }
        return sb.toString().toUpperCase(Locale.CHINA);
    }

    public static byte[] decode(String data) throws CBInvalidParameterException {
        if (data == null) {
            throw new CBInvalidParameterException("MPCM015");
        }
        int n = data.length();
        if (n % 2 != 0) {
            data = "0" + data;
            ++n;
        }
        byte[] bytes = new byte[n /= 2];
        int i = 0;
        while (i < n) {
            bytes[i] = (byte)Integer.parseInt(data.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return bytes;
    }
}

