/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import java.util.ArrayList;

public class CBJSONTool {
    public static String formatJson(String json, String fillStringUnit) {
        String token;
        if (json == null || json.trim().length() == 0) {
            return null;
        }
        int fixedLenth = 0;
        ArrayList<String> tokenList = new ArrayList<String>();
        String jsonTemp = json;
        while (jsonTemp.length() > 0) {
            token = CBJSONTool.getToken(jsonTemp);
            jsonTemp = jsonTemp.substring(token.length());
            token = token.trim();
            tokenList.add(token);
        }
        int i = 0;
        while (i < tokenList.size()) {
            token = (String)tokenList.get(i);
            int length = token.getBytes().length;
            if (length > fixedLenth && i < tokenList.size() - 1 && ((String)tokenList.get(i + 1)).equals(":")) {
                fixedLenth = length;
            }
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        int count = 0;
        int i2 = 0;
        while (i2 < tokenList.size()) {
            String nextToken;
            String token2 = (String)tokenList.get(i2);
            if (token2.equals(",")) {
                buf.append(token2);
                CBJSONTool.doFill(buf, count, fillStringUnit);
            } else if (token2.equals(":")) {
                buf.append(" ").append(token2).append(" ");
            } else if (token2.equals("{")) {
                nextToken = (String)tokenList.get(i2 + 1);
                if (nextToken.equals("}")) {
                    ++i2;
                    buf.append("{ }");
                } else {
                    buf.append(token2);
                    CBJSONTool.doFill(buf, ++count, fillStringUnit);
                }
            } else if (token2.equals("}")) {
                CBJSONTool.doFill(buf, --count, fillStringUnit);
                buf.append(token2);
            } else if (token2.equals("[")) {
                nextToken = (String)tokenList.get(i2 + 1);
                if (nextToken.equals("]")) {
                    ++i2;
                    buf.append("[ ]");
                } else {
                    buf.append(token2);
                    CBJSONTool.doFill(buf, ++count, fillStringUnit);
                }
            } else if (token2.equals("]")) {
                CBJSONTool.doFill(buf, --count, fillStringUnit);
                buf.append(token2);
            } else {
                buf.append(token2);
            }
            ++i2;
        }
        return buf.toString();
    }

    private static String getToken(String json) {
        StringBuilder buf = new StringBuilder();
        boolean isInYinHao = false;
        while (json.length() > 0) {
            String token = json.substring(0, 1);
            json = json.substring(1);
            if (!isInYinHao && (token.equals(":") || token.equals("{") || token.equals("}") || token.equals("[") || token.equals("]") || token.equals(","))) {
                if (buf.toString().trim().length() != 0) break;
                buf.append(token);
                break;
            }
            if (token.equals("\\")) {
                buf.append(token);
                buf.append(json.substring(0, 1));
                json = json.substring(1);
                continue;
            }
            if (token.equals("\"")) {
                buf.append(token);
                if (isInYinHao) break;
                isInYinHao = true;
                continue;
            }
            buf.append(token);
        }
        return buf.toString();
    }

    private static void doFill(StringBuilder buf, int count, String fillStringUnit) {
        buf.append("\n");
        int i = 0;
        while (i < count) {
            buf.append(fillStringUnit);
            ++i;
        }
    }
}

