/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import com.citicbank.cbframework.common.util.CBStreamOperator;
import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class CBQRCodeEncoder {
    public static byte[] encoderQRCode(String content) {
        try {
            Qrcode qrcodeHandler = new Qrcode();
            qrcodeHandler.setQrcodeErrorCorrect('L');
            qrcodeHandler.setQrcodeEncodeMode('B');
            byte[] contentBytes = content.getBytes("UTF-8");
            boolean[][] codeOut = null;
            int ver = 1;
            int i = 5;
            while (i < 30) {
                qrcodeHandler.setQrcodeVersion(i);
                try {
                    codeOut = qrcodeHandler.calQrcode(contentBytes);
                    qrcodeHandler.calQrcode(contentBytes);
                    ver = i;
                    break;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            int size = 55 + ver * 12;
            BufferedImage bufImg = new BufferedImage(size, size, 1);
            Graphics2D gs = bufImg.createGraphics();
            gs.setBackground(Color.WHITE);
            gs.clearRect(0, 0, size, size);
            gs.setColor(Color.BLACK);
            int pixoff = 2;
            int i2 = 0;
            while (i2 < codeOut.length) {
                int j = 0;
                while (j < codeOut.length) {
                    if (codeOut[j][i2]) {
                        gs.fillRect(j * 3 + pixoff, i2 * 3 + pixoff, 3, 3);
                    }
                    ++j;
                }
                ++i2;
            }
            gs.dispose();
            bufImg.flush();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
            ImageIO.write((RenderedImage)bufImg, "png", ios);
            CBStreamOperator.close(baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

