/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import com.citicbank.cbframework.common.exception.CBIOException;
import com.citicbank.cbframework.common.exception.CBInvalidParameterException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CBSHA1 {
    private static final int READBUF_SIZE = 1024;
    private static MessageDigest messageDigest = null;

    static {
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static byte[] getHashByString(String data) throws CBInvalidParameterException {
        if (data == null) {
            throw new CBInvalidParameterException("MPCM010");
        }
        try {
            return CBSHA1.getHashByBytes(data.getBytes("UTF-8"));
        }
        catch (Exception e) {
            return "".getBytes();
        }
    }

    public static synchronized byte[] getHashByBytes(byte[] data) throws CBInvalidParameterException {
        if (data == null) {
            throw new CBInvalidParameterException("MPCM011");
        }
        try {
            messageDigest.reset();
            messageDigest.update(data);
            return messageDigest.digest();
        }
        catch (Exception e) {
            return "".getBytes();
        }
    }

    public static byte[] getHashByInputStream(InputStream is) throws CBInvalidParameterException, CBIOException {
        if (is == null) {
            throw new CBInvalidParameterException("MPCM012");
        }
        try {
            int size;
            byte[] buf = new byte[1024];
            messageDigest.reset();
            while ((size = is.read(buf)) != -1) {
                messageDigest.update(buf, 0, size);
            }
            return messageDigest.digest();
        }
        catch (IOException e) {
            throw new CBIOException("MPCM013");
        }
    }
}

