/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import com.citicbank.cbframework.common.exception.CBIOException;
import com.citicbank.cbframework.common.exception.CBInvalidParameterException;
import com.citicbank.cbframework.common.util.CBStreamOperator;
import com.lsy.baselib.crypto.algorithm.Digest;
import com.lsy.baselib.crypto.exception.DigestException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CBSM3 {
    private static final int READBUF_SIZE = 1024;

    public static byte[] getHashByString(String data) throws CBInvalidParameterException {
        if (data == null) {
            throw new CBInvalidParameterException("MPCM005");
        }
        try {
            return CBSM3.getHashByBytes(data.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized byte[] getHashByBytes(byte[] data) throws CBInvalidParameterException {
        if (data == null) {
            throw new CBInvalidParameterException("MPCM005");
        }
        try {
            return Digest.sm3((byte[])data);
        }
        catch (DigestException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getHashByInputStream(InputStream is) throws CBInvalidParameterException, CBIOException {
        if (is == null) {
            throw new CBInvalidParameterException("MPCM012");
        }
        StringBuffer buffer = new StringBuffer();
        BufferedReader bufReader = null;
        InputStreamReader inputReader = null;
        inputReader = new InputStreamReader(is);
        bufReader = new BufferedReader(inputReader);
        String line = "";
        try {
            try {
                while ((line = bufReader.readLine()) != null) {
                    buffer.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                CBStreamOperator.close(bufReader);
                CBStreamOperator.close(inputReader);
                return null;
            }
        }
        finally {
            CBStreamOperator.close(bufReader);
            CBStreamOperator.close(inputReader);
        }
        return CBSM3.getHashByString(buffer.toString());
    }
}

