/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import com.citicbank.cbframework.common.exception.CBIOException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CBStreamOperator {
    private static final int READBUF_SIZE = 1024;

    public static byte[] getInputStreamBytes(InputStream is) throws CBIOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CBStreamOperator.copy(is, baos);
        CBStreamOperator.close(baos);
        return baos.toByteArray();
    }

    public static void copy(InputStream is, OutputStream os) throws CBIOException {
        byte[] buf = new byte[1024];
        try {
            int size;
            while ((size = is.read(buf)) != -1) {
                os.write(buf, 0, size);
            }
        }
        catch (IOException e) {
            throw new CBIOException(e, "MPCM023");
        }
    }

    public static void close(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

