/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class CBXMLUtil {
    public static String formatXML(String xmlString) {
        try {
            SAXReader reader = new SAXReader();
            reader.setEncoding("UTF-8");
            return CBXMLUtil.formatXML((Node)reader.read((InputStream)new ByteArrayInputStream(xmlString.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u683c\u5f0f\u5316XML\u65f6\u51fa\u9519:" + xmlString;
        }
    }

    public static String formatXML(Node node) {
        StringBuilder localStringBuilder;
        block8: {
            if (node == null) {
                return "";
            }
            node.getDocument().setXMLEncoding("UTF-8");
            localStringBuilder = new StringBuilder();
            StringWriter localStringWriter = null;
            XMLWriter localXMLWriter = null;
            OutputFormat localOutputFormat = null;
            try {
                try {
                    localOutputFormat = OutputFormat.createPrettyPrint();
                    localXMLWriter = new XMLWriter(localOutputFormat);
                    localStringWriter = new StringWriter();
                    localXMLWriter.setWriter((Writer)localStringWriter);
                    localXMLWriter.write(node);
                    BufferedReader localBufferedReader = new BufferedReader(new StringReader(localStringWriter.toString()));
                    String str = localBufferedReader.readLine();
                    while (str != null) {
                        if (str.length() > 0) {
                            localStringBuilder.append(str).append("\n");
                        }
                        str = localBufferedReader.readLine();
                    }
                    localStringBuilder.setLength(localStringBuilder.length() - 1);
                }
                catch (Exception localException) {
                    localException.printStackTrace();
                    localStringWriter = null;
                    localXMLWriter = null;
                    localOutputFormat = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                localStringWriter = null;
                localXMLWriter = null;
                localOutputFormat = null;
                throw throwable;
            }
            localStringWriter = null;
            localXMLWriter = null;
            localOutputFormat = null;
        }
        return localStringBuilder.toString();
    }

    public static void removeElementChildren(Element element) {
        List list = element.selectNodes("*");
        for (Node el : list) {
            element.remove(el);
        }
    }

    public static void markMd5(Document doc) {
        try {
            Element root = doc.getRootElement();
            if (root != null) {
                root.addAttribute("md5", "");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(doc.asXML().getBytes("UTF-8"));
                baos.close();
                SAXReader reader = new SAXReader();
                String md5 = CBXMLUtil.getMd5(reader.read((InputStream)new ByteArrayInputStream(baos.toByteArray())).asXML().getBytes());
                root.addAttribute("md5", md5);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkMd5(Document doc) {
        try {
            Element root = doc.getRootElement();
            if (root != null) {
                String md5 = root.attributeValue("md5");
                root.addAttribute("md5", "");
                boolean ret = CBXMLUtil.getMd5(doc.asXML().getBytes("UTF-8")).equals(md5);
                root.addAttribute("md5", md5);
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String getMd5(byte[] data) {
        String s = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            int i = 0;
            while (i < 16) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
                ++i;
            }
            s = new String(str);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return s;
    }

    public static void swapElement(Element e1, Element e2) {
        if (e1 == null || e2 == null) {
            return;
        }
        Element t1 = e1.createCopy();
        Element t2 = e2.createCopy();
        e1.clearContent();
        e2.clearContent();
        e1.setAttributes(t2.attributes());
        e1.setText(t2.getText());
        e1.setContent(t2.content());
        e2.setAttributes(t1.attributes());
        e2.setText(t1.getText());
        e2.setContent(t1.content());
    }

    public static void clearAttribute(Element element) {
        while (element.attributeCount() > 0) {
            element.remove(element.attribute(0));
        }
    }
}

