/*
 * Decompiled with CFR 0.152.
 */
package com.citicbank.cbframework.common.util;

import com.citicbank.cbframework.common.util.CBStreamOperator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CBZipUtils {
    private static final String BASE_DIR = "";
    private static final String PATH = "/";
    private static final int BUFFER = 1024;
    private static final String EXT = ".zip";

    public static List<String> getArchiveFileList(String path) {
        ZipInputStream zis = null;
        ArrayList<String> archiveFileList = new ArrayList<String>();
        try {
            try {
                zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(path)));
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    archiveFileList.add(name);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                CBStreamOperator.close(zis);
                return null;
            }
        }
        catch (Throwable throwable) {
            CBStreamOperator.close(zis);
            throw throwable;
        }
        CBStreamOperator.close(zis);
        return archiveFileList;
    }

    public static void archive(List<String> srcFileList, String destPath) throws Exception {
        CBZipUtils.archive(srcFileList, new File(destPath));
    }

    public static void archive(List<String> srcFileList, File destFile) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destFile));
        for (String f : srcFileList) {
            String[] paths = f.split("\\|");
            f = paths.length > 1 ? String.valueOf(paths[1]) + paths[0] : paths[0];
            File file = new File(f);
            String baseDir = paths.length > 2 ? paths[2] : BASE_DIR;
            CBZipUtils.archiveFile(file, zos, baseDir);
        }
        zos.flush();
        zos.close();
    }

    public static void archive(String srcPath, String destPath) throws Exception {
        File srcFile = new File(srcPath);
        CBZipUtils.archive(srcFile, destPath);
    }

    public static void archive(File srcFile, File destFile) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destFile));
        CBZipUtils.archive(srcFile, zos, BASE_DIR);
        zos.flush();
        zos.close();
    }

    public static void archive(File srcFile) throws Exception {
        String name = srcFile.getName();
        String basePath = srcFile.getParent();
        String destPath = String.valueOf(basePath) + name + EXT;
        CBZipUtils.archive(srcFile, destPath);
    }

    public static void archive(File srcFile, String destPath) throws Exception {
        CBZipUtils.archive(srcFile, new File(destPath));
    }

    public static void archive(String srcPath) throws Exception {
        File srcFile = new File(srcPath);
        CBZipUtils.archive(srcFile);
    }

    private static void archive(File srcFile, ZipOutputStream zos, String basePath) throws Exception {
        if (srcFile.isDirectory()) {
            CBZipUtils.archiveDir(srcFile, zos, basePath);
        } else {
            CBZipUtils.archiveFile(srcFile, zos, basePath);
        }
    }

    private static void archiveDir(File dir, ZipOutputStream zos, String basePath) throws Exception {
        File[] files = dir.listFiles();
        if (files.length < 1) {
            ZipEntry entry = new ZipEntry(String.valueOf(basePath) + dir.getName() + PATH);
            zos.putNextEntry(entry);
            zos.closeEntry();
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            CBZipUtils.archive(file, zos, String.valueOf(basePath) + dir.getName() + PATH);
            ++n2;
        }
    }

    private static void archiveFile(File file, ZipOutputStream zos, String dir) throws Exception {
        int count;
        ZipEntry entry = new ZipEntry(String.valueOf(dir) + file.getName());
        entry.setSize(file.length());
        zos.putNextEntry(entry);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        byte[] data = new byte[1024];
        while ((count = bis.read(data, 0, 1024)) != -1) {
            zos.write(data, 0, count);
        }
        bis.close();
        zos.closeEntry();
    }

    public static void dearchive(File srcFile) throws Exception {
        String basePath = srcFile.getParent();
        CBZipUtils.dearchive(srcFile, basePath);
    }

    public static void dearchive(File srcFile, File destFile) throws Exception {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(srcFile));
        CBZipUtils.dearchive(destFile, zis);
        zis.close();
    }

    public static void dearchive(File srcFile, String destPath) throws Exception {
        CBZipUtils.dearchive(srcFile, new File(destPath));
    }

    private static void dearchive(File destFile, ZipInputStream zis) throws Exception {
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            String dir = String.valueOf(destFile.getPath()) + File.separator + entry.getName();
            File dirFile = new File(dir);
            CBZipUtils.fileProber(dirFile);
            if (entry.isDirectory()) {
                dirFile.mkdirs();
                continue;
            }
            CBZipUtils.dearchiveFile(dirFile, zis);
        }
    }

    public static void dearchive(String srcPath) throws Exception {
        File srcFile = new File(srcPath);
        CBZipUtils.dearchive(srcFile);
    }

    public static void dearchive(String srcPath, String destPath) throws Exception {
        File srcFile = new File(srcPath);
        CBZipUtils.dearchive(srcFile, destPath);
    }

    private static void dearchiveFile(File destFile, ZipInputStream zis) throws Exception {
        int count;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
        byte[] data = new byte[1024];
        while ((count = zis.read(data, 0, 1024)) != -1) {
            bos.write(data, 0, count);
        }
        bos.close();
    }

    private static void fileProber(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            CBZipUtils.fileProber(parentFile);
            parentFile.mkdir();
        }
    }

    public static byte[] dearchiveOneFileToBytes(File srcFile, String regex) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(srcFile));
        ZipEntry entry = null;
        ByteArrayOutputStream bosInfo = new ByteArrayOutputStream();
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            if (entry.getName().matches(regex)) {
                int count;
                byte[] data = new byte[1024];
                while ((count = zis.read(data, 0, 1024)) != -1) {
                    bosInfo.write(data, 0, count);
                }
                bosInfo.close();
                zis.close();
                return bosInfo.toByteArray();
            }
            byte[] data = new byte[1024];
            while (zis.read(data, 0, 1024) != -1) {
            }
        }
        zis.close();
        return null;
    }

    public static byte[] dearchiveOneFileToBytes(String srcPath, String regex) throws IOException {
        return CBZipUtils.dearchiveOneFileToBytes(new File(srcPath), regex);
    }
}

