/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jnr.constants.Constant;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Signal;
import jnr.constants.platform.Sysconf;
import jnr.ffi.LastError;
import jnr.ffi.Library;
import jnr.ffi.Memory;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.TypeAlias;
import jnr.ffi.byref.AbstractNumberReference;
import jnr.ffi.byref.IntByReference;
import jnr.ffi.byref.LongLongByReference;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.posix.BaseFileStat;
import jnr.posix.DefaultNativeGroup;
import jnr.posix.DefaultNativeTimeval;
import jnr.posix.FileStat;
import jnr.posix.Group;
import jnr.posix.JavaLibCHelper;
import jnr.posix.JavaTimes;
import jnr.posix.LibC;
import jnr.posix.LibCProvider;
import jnr.posix.NativePOSIX;
import jnr.posix.NativeTimes;
import jnr.posix.POSIX;
import jnr.posix.POSIXHandler;
import jnr.posix.Passwd;
import jnr.posix.SignalHandler;
import jnr.posix.SpawnFileAction;
import jnr.posix.Times;
import jnr.posix.Timeval;
import jnr.posix.UnixLibC;
import jnr.posix.util.Java5ProcessMaker;
import jnr.posix.util.MethodName;
import jnr.posix.util.ProcessMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseNativePOSIX
extends NativePOSIX
implements POSIX {
    private final LibC libc;
    protected final POSIXHandler handler;
    protected final JavaLibCHelper helper;
    protected final Map<Signal, SignalHandler> signalHandlers = new HashMap<Signal, SignalHandler>();
    public static final PointerConverter GROUP = new PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new DefaultNativeGroup((Pointer)arg) : null;
        }
    };
    public static final ToNativeConverter<FileStat, Pointer> FileStatConverter = new ToNativeConverter<FileStat, Pointer>(){

        @Override
        public Pointer toNative(FileStat value, ToNativeContext context) {
            if (value instanceof BaseFileStat) {
                return ((BaseFileStat)value).memory;
            }
            if (value instanceof Struct) {
                return Struct.getMemory((Struct)((Object)value));
            }
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("instance of " + value.getClass() + " is not a struct");
        }

        @Override
        public Class<Pointer> nativeType() {
            return Pointer.class;
        }
    };
    public static final ToNativeConverter<NativeTimes, Pointer> TimesConverter = new ToNativeConverter<NativeTimes, Pointer>(){

        @Override
        public Pointer toNative(NativeTimes value, ToNativeContext context) {
            return value.memory;
        }

        @Override
        public Class<Pointer> nativeType() {
            return Pointer.class;
        }
    };
    public static final ToNativeConverter<Constant, Integer> ConstantConverter = new ToNativeConverter<Constant, Integer>(){

        @Override
        public Integer toNative(Constant value, ToNativeContext context) {
            return value.intValue();
        }

        @Override
        public Class<Integer> nativeType() {
            return Integer.class;
        }
    };

    BaseNativePOSIX(LibCProvider libcProvider, POSIXHandler handler) {
        this.handler = handler;
        this.libc = libcProvider.getLibC();
        this.helper = new JavaLibCHelper(handler);
    }

    @Override
    public ProcessMaker newProcessMaker(String ... command) {
        return new Java5ProcessMaker(this.handler, command);
    }

    @Override
    public ProcessMaker newProcessMaker() {
        return new Java5ProcessMaker(this.handler);
    }

    @Override
    public final LibC libc() {
        return this.libc;
    }

    POSIXHandler handler() {
        return this.handler;
    }

    protected <T> T unimplementedNull() {
        this.handler().unimplementedError(MethodName.getCallerMethodName());
        return null;
    }

    protected int unimplementedInt() {
        this.handler().unimplementedError(MethodName.getCallerMethodName());
        return -1;
    }

    @Override
    public int chmod(String filename, int mode) {
        return this.libc().chmod(filename, mode);
    }

    @Override
    public int chown(String filename, int user, int group) {
        return this.libc().chown(filename, user, group);
    }

    @Override
    public int exec(String path, String ... args) {
        this.handler.unimplementedError("exec unimplemented");
        return -1;
    }

    @Override
    public int exec(String path, String[] args, String[] envp) {
        this.handler.unimplementedError("exec unimplemented");
        return -1;
    }

    @Override
    public int execv(String path, String[] args) {
        return this.libc().execv(path, args);
    }

    @Override
    public int execve(String path, String[] args, String[] env) {
        return this.libc().execve(path, args, env);
    }

    @Override
    public FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat stat = this.allocateStat();
        if (this.fstat(fileDescriptor, stat) < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "fstat", "" + this.helper.getfd(fileDescriptor));
        }
        return stat;
    }

    @Override
    public FileStat fstat(int fd) {
        FileStat stat = this.allocateStat();
        if (this.fstat(fd, stat) < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "fstat", "" + fd);
        }
        return stat;
    }

    @Override
    public int fstat(FileDescriptor fileDescriptor, FileStat stat) {
        int fd = this.helper.getfd(fileDescriptor);
        return this.libc().fstat(fd, stat);
    }

    @Override
    public int fstat(int fd, FileStat stat) {
        return this.libc().fstat(fd, stat);
    }

    @Override
    public String getenv(String envName) {
        return this.libc().getenv(envName);
    }

    @Override
    public int getegid() {
        return this.libc().getegid();
    }

    @Override
    public int geteuid() {
        return this.libc().geteuid();
    }

    @Override
    public int getgid() {
        return this.libc().getgid();
    }

    @Override
    public String getlogin() {
        return this.libc().getlogin();
    }

    @Override
    public int getpgid() {
        return this.libc().getpgid();
    }

    @Override
    public int getpgrp() {
        return this.libc().getpgrp();
    }

    @Override
    public int getpid() {
        return this.libc().getpid();
    }

    @Override
    public int getppid() {
        return this.libc().getppid();
    }

    @Override
    public Passwd getpwent() {
        return this.libc().getpwent();
    }

    @Override
    public Passwd getpwuid(int which) {
        return this.libc().getpwuid(which);
    }

    @Override
    public Passwd getpwnam(String which) {
        return this.libc().getpwnam(which);
    }

    @Override
    public Group getgrent() {
        return this.libc().getgrent();
    }

    @Override
    public Group getgrgid(int which) {
        return this.libc().getgrgid(which);
    }

    @Override
    public Group getgrnam(String which) {
        return this.libc().getgrnam(which);
    }

    @Override
    public int setpwent() {
        return this.libc().setpwent();
    }

    @Override
    public int endpwent() {
        return this.libc().endpwent();
    }

    @Override
    public int setgrent() {
        return this.libc().setgrent();
    }

    @Override
    public int endgrent() {
        return this.libc().endgrent();
    }

    @Override
    public int getuid() {
        return this.libc().getuid();
    }

    @Override
    public int setegid(int egid) {
        return this.libc().setegid(egid);
    }

    @Override
    public int seteuid(int euid) {
        return this.libc().seteuid(euid);
    }

    @Override
    public int setgid(int gid) {
        return this.libc().setgid(gid);
    }

    public int getfd(FileDescriptor descriptor) {
        return this.helper.getfd(descriptor);
    }

    @Override
    public int getpgid(int pid) {
        return this.libc().getpgid(pid);
    }

    @Override
    public int setpgid(int pid, int pgid) {
        return this.libc().setpgid(pid, pgid);
    }

    @Override
    public int setpgrp(int pid, int pgrp) {
        return this.libc().setpgrp(pid, pgrp);
    }

    @Override
    public int setsid() {
        return this.libc().setsid();
    }

    @Override
    public int setuid(int uid) {
        return this.libc().setuid(uid);
    }

    @Override
    public int kill(int pid, int signal) {
        return this.libc().kill(pid, signal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignalHandler signal(Signal sig, final SignalHandler handler) {
        Map<Signal, SignalHandler> map = this.signalHandlers;
        synchronized (map) {
            SignalHandler old = this.signalHandlers.get(sig);
            long result = this.libc().signal(sig.intValue(), new LibC.LibCSignalHandler(){

                public void signal(int sig) {
                    handler.handle(sig);
                }
            });
            if (result != -1L) {
                this.signalHandlers.put(sig, handler);
            }
            return old;
        }
    }

    @Override
    public int lchmod(String filename, int mode) {
        try {
            return this.libc().lchmod(filename, mode);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int lchown(String filename, int user, int group) {
        try {
            return this.libc().lchown(filename, user, group);
        }
        catch (UnsatisfiedLinkError ule) {
            return this.unimplementedInt();
        }
    }

    @Override
    public int link(String oldpath, String newpath) {
        return this.libc().link(oldpath, newpath);
    }

    @Override
    public FileStat lstat(String path) {
        FileStat stat = this.allocateStat();
        if (this.lstat(path, stat) < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "lstat", path);
        }
        return stat;
    }

    @Override
    public int lstat(String path, FileStat stat) {
        return this.libc().lstat(path, stat);
    }

    @Override
    public int mkdir(String path, int mode) {
        int res = this.libc().mkdir(path, mode);
        if (res < 0) {
            int errno = this.errno();
            this.handler.error(Errno.valueOf(errno), "mkdir", path);
        }
        return res;
    }

    @Override
    public int rmdir(String path) {
        int res = this.libc().rmdir(path);
        if (res < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "rmdir", path);
        }
        return res;
    }

    @Override
    public int setenv(String envName, String envValue, int overwrite) {
        return this.libc().setenv(envName, envValue, overwrite);
    }

    @Override
    public FileStat stat(String path) {
        FileStat stat = this.allocateStat();
        if (this.stat(path, stat) < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "stat", path);
        }
        return stat;
    }

    @Override
    public int stat(String path, FileStat stat) {
        return this.libc().stat(path, stat);
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        return this.libc().symlink(oldpath, newpath);
    }

    @Override
    public String readlink(String oldpath) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        int result = this.libc().readlink(oldpath, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    @Override
    public int unsetenv(String envName) {
        return this.libc().unsetenv(envName);
    }

    @Override
    public int umask(int mask) {
        return this.libc().umask(mask);
    }

    @Override
    public int utimes(String path, long[] atimeval, long[] mtimeval) {
        Timeval[] times = null;
        if (atimeval != null && mtimeval != null) {
            times = (Timeval[])Struct.arrayOf((Runtime)this.getRuntime(), DefaultNativeTimeval.class, (int)2);
            times[0].setTime(atimeval);
            times[1].setTime(mtimeval);
        }
        return this.libc().utimes(path, times);
    }

    @Override
    public int fork() {
        return this.libc().fork();
    }

    @Override
    public int waitpid(int pid, int[] status, int flags) {
        return this.libc().waitpid(pid, status, flags);
    }

    @Override
    public int wait(int[] status) {
        return this.libc().wait(status);
    }

    @Override
    public int getpriority(int which, int who) {
        return this.libc().getpriority(which, who);
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        return this.libc().setpriority(which, who, prio);
    }

    @Override
    public boolean isatty(FileDescriptor fd) {
        return this.libc().isatty(this.helper.getfd(fd)) != 0;
    }

    @Override
    public int errno() {
        return LastError.getLastError(this.getRuntime());
    }

    @Override
    public void errno(int value) {
        LastError.setLastError(this.getRuntime(), value);
    }

    @Override
    public int chdir(String path) {
        return this.libc().chdir(path);
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public long posix_spawnp(String path, Collection<? extends SpawnFileAction> fileActions, Collection<? extends CharSequence> argv, Collection<? extends CharSequence> envp) {
        CharSequence[] nativeArgv = new CharSequence[argv.size()];
        argv.toArray(nativeArgv);
        CharSequence[] nativeEnv = new CharSequence[envp.size()];
        envp.toArray(nativeEnv);
        return this.posix_spawnp(path, fileActions, nativeArgv, nativeEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long posix_spawnp(String path, Collection<? extends SpawnFileAction> fileActions, CharSequence[] argv, CharSequence[] envp) {
        AbstractNumberReference pid = Library.getRuntime(this.libc()).findType(TypeAlias.pid_t).size() == 4 ? new IntByReference(-1) : new LongLongByReference(-1L);
        Pointer nativeFileActions = this.nativeFileActions(fileActions);
        try {
            if (((UnixLibC)this.libc()).posix_spawnp(pid, path, nativeFileActions, null, argv, envp) < 0) {
                Errno e = Errno.valueOf(this.errno());
                this.handler.error(e, "posix_spawnp", e.description());
            }
        }
        finally {
            ((UnixLibC)this.libc()).posix_spawn_file_actions_destroy(nativeFileActions);
        }
        return pid.longValue();
    }

    @Override
    public int flock(int fd, int mode) {
        return this.libc().flock(fd, mode);
    }

    private Pointer nativeFileActions(Collection<? extends SpawnFileAction> fileActions) {
        Pointer nativeFileActions = Memory.allocateDirect(this.getRuntime(), 128);
        ((UnixLibC)this.libc()).posix_spawn_file_actions_init(nativeFileActions);
        for (SpawnFileAction spawnFileAction : fileActions) {
            spawnFileAction.act(this, nativeFileActions);
        }
        return nativeFileActions;
    }

    @Override
    public abstract FileStat allocateStat();

    @Override
    public long sysconf(Sysconf name) {
        switch (name) {
            case _SC_CLK_TCK: {
                return 1000L;
            }
        }
        this.errno(Errno.EOPNOTSUPP.intValue());
        return -1L;
    }

    @Override
    public Times times() {
        return new JavaTimes();
    }

    public static abstract class PointerConverter
    implements FromNativeConverter {
        public Class nativeType() {
            return Pointer.class;
        }
    }
}

