/*
 * Decompiled with CFR 0.152.
 */
package cmb.netpayment;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

class DER {
    static int INTEGER = 2;
    static int BIT_STRING = 3;
    static int OCTET_STRING = 4;
    static int SEQUENCE = 16;
    static int CONSTRUCTED = 32;
    static byte[] version;
    static byte[] rsaEncryptionAlgorithmIdentifier;

    static {
        byte[] byArray = new byte[3];
        byArray[0] = 2;
        byArray[1] = 1;
        version = byArray;
        byte[] byArray2 = new byte[15];
        byArray2[0] = 48;
        byArray2[1] = 13;
        byArray2[2] = 6;
        byArray2[3] = 9;
        byArray2[4] = 42;
        byArray2[5] = -122;
        byArray2[6] = 72;
        byArray2[7] = -122;
        byArray2[8] = -9;
        byArray2[9] = 13;
        byArray2[10] = 1;
        byArray2[11] = 1;
        byArray2[12] = 1;
        byArray2[13] = 5;
        rsaEncryptionAlgorithmIdentifier = byArray2;
    }

    DER() {
    }

    static BigInteger readDERint(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = DER.readTag(dataInputStream);
        int n2 = DER.readLen(dataInputStream);
        if (n != INTEGER) {
            throw new RuntimeException("Expecting tag[0x02] got " + Integer.toHexString(n));
        }
        if (n2 > 5096) {
            throw new RuntimeException("Length value seems a little big " + Integer.toHexString(n2));
        }
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        return new BigInteger(byArray);
    }

    static int readLen(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n > 127) {
            int n2 = 0;
            n ^= 0x80;
            int n3 = 0;
            while (n3 < n) {
                n2 = n2 * 256 + inputStream.read();
                ++n3;
            }
            n = n2;
        }
        return n;
    }

    static int readTag(InputStream inputStream) throws IOException {
        return inputStream.read();
    }

    static int writeDERint(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length + 1;
        outputStream.write(INTEGER);
        outputStream.write(byArray);
        return n += DER.writeDERlen(outputStream, byArray.length);
    }

    static int writeDERlen(OutputStream outputStream, int n) throws IOException {
        if (n > 127) {
            int n2 = 1;
            if (n >= 256) {
                n2 = 2;
            } else if (n >= 65536) {
                n2 = 3;
            } else if (n >= 0x1000000) {
                n2 = 4;
            }
            outputStream.write((byte)(n2 | 0x80));
            int n3 = (n2 - 1) * 8;
            while (n3 >= 0) {
                int n4 = n >> n3;
                outputStream.write((byte)n4);
                n3 -= 8;
            }
            return n2;
        }
        outputStream.write((byte)n);
        return 1;
    }
}

