/*
 * Decompiled with CFR 0.152.
 */
package cmb.netpayment;

import cmb.netpayment.DER;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

public class RSAPubKey
implements RSAPublicKey {
    public static final String ident = "$Id: RSAPubKey.java,v 1.9 1999/02/02 00:56:35 leachbj Exp $";
    protected BigInteger exponent;
    protected BigInteger modulus;

    public RSAPubKey() {
    }

    public RSAPubKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.exponent = bigInteger2;
    }

    public RSAPubKey(byte[] byArray) {
        this.x509Decode(byArray);
    }

    public RSAPubKey(byte[] byArray, String string) {
        if (string.equals("NETPAYMENT")) {
            this.x509Decode(byArray, string);
        } else {
            this.x509Decode(byArray);
        }
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        return this.x509Encode();
    }

    public String getFormat() {
        return "X.509";
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.exponent;
    }

    public String toString() {
        return String.valueOf(this.modulus.toString(16)) + "." + this.exponent.toString(16);
    }

    private void x509Decode(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DER.readTag(byteArrayInputStream);
            DER.readLen(byteArrayInputStream);
            byteArrayInputStream.skip(DER.rsaEncryptionAlgorithmIdentifier.length);
            DER.readTag(byteArrayInputStream);
            DER.readLen(byteArrayInputStream);
            byteArrayInputStream.skip(1L);
            DER.readTag(byteArrayInputStream);
            DER.readLen(byteArrayInputStream);
            this.modulus = DER.readDERint(byteArrayInputStream);
            this.exponent = DER.readDERint(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ExceptionInInitializerError(iOException);
        }
    }

    private void x509Decode(byte[] byArray, String string) {
        if (!string.equals("NETPAYMENT")) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DER.readTag(byteArrayInputStream);
            DER.readLen(byteArrayInputStream);
            this.modulus = DER.readDERint(byteArrayInputStream);
            this.exponent = DER.readDERint(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ExceptionInInitializerError(iOException);
        }
    }

    private byte[] x509Encode() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DER.writeDERint(byteArrayOutputStream, this.modulus);
            DER.writeDERint(byteArrayOutputStream, this.exponent);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(DER.SEQUENCE | DER.CONSTRUCTED);
            DER.writeDERlen(byteArrayOutputStream, byArray.length);
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(DER.BIT_STRING);
            DER.writeDERlen(byteArrayOutputStream, byArray2.length + 1);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(byArray2);
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(DER.SEQUENCE | DER.CONSTRUCTED);
            DER.writeDERlen(byteArrayOutputStream, DER.rsaEncryptionAlgorithmIdentifier.length + byArray3.length);
            byteArrayOutputStream.write(DER.rsaEncryptionAlgorithmIdentifier);
            byteArrayOutputStream.write(byArray3);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ExceptionInInitializerError(iOException);
        }
    }
}

