/*
 * Decompiled with CFR 0.152.
 */
package cmb.netpayment;

import cmb.netpayment.RSAPubKey;
import java.io.File;
import java.io.FileInputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

public class Security {
    private RSAPubKey m_RSAPubKey;

    public Security(String string) throws Exception {
        try {
            File file = new File(string);
            byte[] byArray = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(string);
            fileInputStream.read(byArray);
            fileInputStream.close();
            this.SetPublicKey(byArray);
        }
        catch (Throwable throwable) {
            throw new Exception("Load publickey files failed because: " + throwable.getMessage());
        }
    }

    public Security(byte[] byArray) throws Exception {
        try {
            this.SetPublicKey(byArray);
        }
        catch (Throwable throwable) {
            throw new Exception("Load publickey files failed because: " + throwable.getMessage());
        }
    }

    public boolean CheckSign(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(this.m_RSAPubKey);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("CheckSign: invalid Algorithm." + noSuchAlgorithmException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("CheckSign: invalid public key." + invalidKeyException.toString());
        }
        catch (SignatureException signatureException) {
            System.out.println("CheckSign: invalid sinature." + signatureException.toString());
        }
        catch (Exception exception) {
            System.out.println("CheckSign: " + exception.toString());
        }
        return bl;
    }

    private void SetPublicKey(byte[] byArray) throws Exception {
        this.m_RSAPubKey = new RSAPubKey(byArray, "NETPAYMENT");
    }

    public boolean checkInfoFromBank(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("GB2312");
        }
        catch (Exception exception) {
            return false;
        }
        return this.checkInfoFromBank(byArray);
    }

    public boolean checkInfoFromBank(byte[] byArray) {
        int n;
        int n2 = 38;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        int n3 = byArray.length;
        int n4 = -1;
        int n5 = n3 - 1;
        while (n5 >= 0) {
            n = byArray[n5];
            if (n == n2) {
                n4 = n5;
                break;
            }
            --n5;
        }
        if (n4 == -1) {
            return false;
        }
        String string = "&signature=";
        int n6 = string.length();
        byArray2 = new byte[n4];
        byArray3 = new byte[n3 - n4 - n6];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        System.arraycopy(byArray, n4 + n6, byArray3, 0, n3 - n4 - n6);
        int n7 = byArray3.length;
        n2 = 124;
        n4 = 0;
        byte[] byArray4 = new byte[1024];
        String string2 = "";
        n5 = 0;
        while (n5 < n7) {
            n = byArray3[n5];
            if (n == n2) {
                int n8 = Integer.parseInt(string2);
                byArray4[n4] = (byte)n8;
                ++n4;
                string2 = "";
            } else {
                char c = (char)n;
                string2 = String.valueOf(string2) + c;
            }
            ++n5;
        }
        byte[] byArray5 = new byte[n4];
        System.arraycopy(byArray4, 0, byArray5, 0, n4);
        return this.CheckSign(byArray2, byArray5);
    }
}

