/*
 * Decompiled with CFR 0.152.
 */
package com.cmbchina.ccd.cmblife.sdk;

import com.cmbchina.ccd.cmblife.sdk.CmblifeUtils;
import com.cmbchina.ccd.cmblife.sdk.cipher.SM2Utils;
import com.cmbchina.ccd.cmblife.sdk.cipher.SM4Utils;
import com.cmbchina.ccd.cmblife.sdk.encode.Base64;
import com.cmbchina.ccd.cmblife.sdk.global.AlgorithmEnum;
import com.cmbchina.ccd.cmblife.sdk.global.Constants;
import com.cmbchina.ccd.cmblife.sdk.global.JsonUtils;
import com.cmbchina.ccd.cmblife.sdk.global.StringUtils;
import com.cmbchina.ccd.cmblife.sdk.global.URLUtils;
import com.cmbchina.ccd.gct.opensdk.sm.SMCryptException;
import com.cmbchina.ccd.gct.opensdk.util.CommonUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class CmblifeUtilsV2 {
    public static String genProtocol(String funcName, Map<String, Object> paramsMap, String signKey, AlgorithmEnum algorithmEnum) throws GeneralSecurityException, SMCryptException {
        if (StringUtils.isBlank(signKey)) {
            throw new IllegalArgumentException("signKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(funcName)) {
            throw new IllegalArgumentException("funcName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == algorithmEnum) {
            algorithmEnum = AlgorithmEnum.ALGORITHM_SM3WITHSM2;
        }
        if (AlgorithmEnum.ALGORITHM_SHA256WithRSA.equals((Object)algorithmEnum)) {
            return CmblifeUtils.genProtocol(funcName, paramsMap, signKey, algorithmEnum.getName());
        }
        if (AlgorithmEnum.ALGORITHM_SM3WITHSM2.equals((Object)algorithmEnum)) {
            return CmblifeUtilsV2.genProtocol(funcName, paramsMap, signKey);
        }
        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5");
    }

    private static String genProtocol(String funcName, Map<String, Object> paramsMap, String signKey) throws SMCryptException {
        if (StringUtils.isBlank(signKey)) {
            throw new IllegalArgumentException("signKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(funcName)) {
            throw new IllegalArgumentException("funcName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.putAll(paramsMap);
        String unsignedProtocol = URLUtils.assembleProtocol(funcName, tempMap, false);
        String sign = CmblifeUtilsV2.sign(unsignedProtocol, signKey);
        tempMap.put("sign", sign);
        return URLUtils.assembleProtocol(funcName, tempMap, true);
    }

    public static String encrypt(String encryptBody, String encryptKey, AlgorithmEnum algorithmEnum) throws GeneralSecurityException, IOException, SMCryptException {
        if (StringUtils.isBlank(encryptBody)) {
            throw new IllegalArgumentException("\u62a5\u6587\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(encryptKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == algorithmEnum) {
            algorithmEnum = AlgorithmEnum.ALGORITHM_SM4_SM2;
        }
        if (AlgorithmEnum.ALGORITHM_AES_RSA.equals((Object)algorithmEnum)) {
            return CmblifeUtils.encrypt(encryptBody, encryptKey);
        }
        if (AlgorithmEnum.ALGORITHM_SM4_SM2.equals((Object)algorithmEnum)) {
            return CmblifeUtilsV2.encrypt(encryptBody, encryptKey);
        }
        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5");
    }

    private static String encrypt(String encryptBody, String encryptKey) throws IOException, SMCryptException {
        byte[] randomKey = SM4Utils.genSM4Key();
        byte[] randomIv = SM4Utils.genIv();
        byte[] encryptedBody = SM4Utils.encrypt(encryptBody.getBytes(Constants.DEFAULT_CHARSET_ENCODING), randomKey, randomIv);
        String keyAndIv = StringUtils.newStringUtf8(StringUtils.base64Encode(CmblifeUtilsV2.assemblingByteArray(randomKey, randomIv)));
        String encryptedKeyAndIv = SM2Utils.encrypt(keyAndIv, encryptKey);
        return encryptedKeyAndIv + "|" + new String(StringUtils.base64Encode(encryptedBody), Constants.DEFAULT_CHARSET_ENCODING);
    }

    public static String encryptPayExtra(String extra, String encryptKey) throws IOException, SMCryptException {
        byte[] key = CommonUtil.hexStringToByteArray((String)encryptKey);
        byte[] randomIv = SM4Utils.genIv();
        byte[] encryptedBody = SM4Utils.encrypt(extra.getBytes(Constants.DEFAULT_CHARSET_ENCODING), key, randomIv);
        byte[] ivAndEncryptedBody = CmblifeUtilsV2.assemblingByteArrayWithoutSplit(randomIv, encryptedBody);
        return new String(StringUtils.base64Encode(ivAndEncryptedBody), Constants.DEFAULT_CHARSET_ENCODING);
    }

    private static byte[] assemblingByteArrayWithoutSplit(byte[] iv, byte[] body) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(iv);
        os.write(body);
        return os.toByteArray();
    }

    private static byte[] assemblingByteArray(byte[] key, byte[] iv) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(key);
        os.write("|".getBytes());
        os.write(iv);
        return os.toByteArray();
    }

    public static String decrypt(String decryptBody, String decryptKey, AlgorithmEnum algorithmEnum) throws GeneralSecurityException, SMCryptException {
        if (StringUtils.isBlank(decryptBody)) {
            throw new IllegalArgumentException("\u62a5\u6587\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(decryptKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == algorithmEnum) {
            algorithmEnum = AlgorithmEnum.ALGORITHM_SM4_SM2;
        }
        if (AlgorithmEnum.ALGORITHM_AES_RSA.equals((Object)algorithmEnum)) {
            return CmblifeUtils.decrypt(decryptBody, decryptKey);
        }
        if (AlgorithmEnum.ALGORITHM_SM4_SM2.equals((Object)algorithmEnum)) {
            return CmblifeUtilsV2.decrypt(decryptBody, decryptKey);
        }
        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5");
    }

    private static String decrypt(String decryptBody, String decryptKey) throws SMCryptException {
        if (StringUtils.isBlank(decryptBody)) {
            throw new IllegalArgumentException("\u5bc6\u6587\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(decryptKey)) {
            throw new IllegalArgumentException("\u5bc6\u94a5\u4e3a\u7a7a");
        }
        String[] data = decryptBody.split("\\|");
        if (2 != data.length) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u62a5\u6587\u683c\u5f0f\u9519\u8bef");
        }
        String keyAndIvStr = data[0];
        String encryptedBody = data[1];
        String keyAndIv = SM2Utils.decrypt(keyAndIvStr, decryptKey);
        byte[] keyAndIvByteArray = StringUtils.base64Decode(keyAndIv);
        byte[] plainKey = new byte[16];
        byte[] splitAxis = new byte[1];
        byte[] plainIv = new byte[16];
        ByteArrayInputStream in = new ByteArrayInputStream(keyAndIvByteArray);
        in.read(plainKey, 0, 16);
        in.read(splitAxis, 0, 1);
        in.read(plainIv, 0, 16);
        byte[] decrypt = SM4Utils.decrypt(StringUtils.base64Decode(encryptedBody), plainKey, plainIv, null);
        return StringUtils.newStringUtf8(decrypt);
    }

    public static String sign(String signBody, String signKey, AlgorithmEnum algorithmEnum) throws GeneralSecurityException, SMCryptException {
        if (StringUtils.isBlank(signBody)) {
            throw new IllegalArgumentException("\u5f85\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(signKey)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == algorithmEnum) {
            algorithmEnum = AlgorithmEnum.ALGORITHM_SM3WITHSM2;
        }
        if (AlgorithmEnum.ALGORITHM_SHA256WithRSA.equals((Object)algorithmEnum)) {
            return CmblifeUtils.sign(signBody, signKey, algorithmEnum.getName());
        }
        if (AlgorithmEnum.ALGORITHM_SM3WITHSM2.equals((Object)algorithmEnum)) {
            return CmblifeUtilsV2.sign(signBody, signKey);
        }
        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5");
    }

    private static String sign(String signBody, String signKey) throws SMCryptException {
        return SM2Utils.sign(signBody, signKey);
    }

    public static boolean verify(String verifyBody, String sign, String verifyKey, AlgorithmEnum verifyAlgorithm) throws GeneralSecurityException, SMCryptException {
        if (StringUtils.isBlank(verifyBody)) {
            throw new IllegalArgumentException("\u9a8c\u7b7e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(sign)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank(verifyKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == verifyAlgorithm) {
            verifyAlgorithm = AlgorithmEnum.ALGORITHM_SM3WITHSM2;
        }
        if (AlgorithmEnum.ALGORITHM_SHA256WithRSA.equals((Object)verifyAlgorithm)) {
            return CmblifeUtils.verify(verifyBody, sign, verifyKey, verifyAlgorithm.getName());
        }
        if (AlgorithmEnum.ALGORITHM_SM3WITHSM2.equals((Object)verifyAlgorithm)) {
            return CmblifeUtilsV2.verify(verifyBody, sign, verifyKey);
        }
        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5");
    }

    private static boolean verify(String verifyBody, String sign, String verifyKey) throws SMCryptException {
        return SM2Utils.verify(verifyBody, verifyKey, sign);
    }

    public static String signForRequest(String funcName, Map<String, Object> params, String signKey, AlgorithmEnum signAlgorithm) throws GeneralSecurityException, SMCryptException {
        if (StringUtils.isNotBlank(funcName) && !funcName.contains(".json")) {
            funcName = funcName + ".json";
        }
        return CmblifeUtilsV2.sign(URLUtils.assembleUrl(funcName, params, false), signKey, signAlgorithm);
    }

    public static String signForResponse(Map<String, Object> params, String signKey, AlgorithmEnum signAlgorithm) throws GeneralSecurityException, SMCryptException {
        return CmblifeUtilsV2.sign(URLUtils.assembleUrl("", params, false), signKey, signAlgorithm);
    }

    public static boolean verifyForRequest(Map<String, Object> params, String verifyKey, AlgorithmEnum verifyAlgorithm) throws GeneralSecurityException, SMCryptException {
        HashMap<String, Object> verifySignParams = new HashMap<String, Object>(params);
        String sign = (String)verifySignParams.remove("sign");
        return CmblifeUtilsV2.verify(URLUtils.assembleUrl("", verifySignParams, false), sign, verifyKey, verifyAlgorithm);
    }

    public static boolean verifyForRequest(Map<String, Object> params, String verifyKey) throws GeneralSecurityException, SMCryptException {
        if (null == params || 0 == params.size()) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cmbKeyAlias = (String)params.get("cmbKeyAlias");
        if ("SM2_CMBLIFE".equals(cmbKeyAlias)) {
            return CmblifeUtilsV2.verifyForRequest(params, verifyKey, AlgorithmEnum.ALGORITHM_SM3WITHSM2);
        }
        return CmblifeUtils.verifyForRequest(params, verifyKey);
    }

    public static boolean verifyForResponse(String response, String verifyKey, AlgorithmEnum verifyAlgorithm) throws GeneralSecurityException, SMCryptException {
        Map<String, Object> verifySignParams = JsonUtils.jsonToMap(response);
        return CmblifeUtilsV2.verifyForResponse(verifySignParams, verifyKey, verifyAlgorithm);
    }

    public static boolean verifyForResponse(Map<String, Object> response, String verifyKey, AlgorithmEnum verifyAlgorithm) throws GeneralSecurityException, SMCryptException {
        String sign = (String)response.remove("sign");
        return CmblifeUtilsV2.verify(URLUtils.assembleUrl("", response, false), sign, verifyKey, verifyAlgorithm);
    }

    public static boolean verifyForResponse(String response, String verifyKey) throws GeneralSecurityException, SMCryptException {
        if (StringUtils.isBlank(response)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> verifySignParams = JsonUtils.jsonToMap(response);
        return CmblifeUtilsV2.verifyForResponse(verifySignParams, verifyKey);
    }

    private static boolean verifyForResponse(Map<String, Object> response, String verifyKey) throws GeneralSecurityException, SMCryptException {
        String cmbKeyAlias = (String)response.get("cmbKeyAlias");
        if ("SM2_CMBLIFE".equals(cmbKeyAlias)) {
            return CmblifeUtilsV2.verifyForResponse(response, verifyKey, AlgorithmEnum.ALGORITHM_SM3WITHSM2);
        }
        return CmblifeUtils.verifyForResponse(response, verifyKey, AlgorithmEnum.ALGORITHM_SHA256WithRSA.getName());
    }

    public static String genRequestBody(Map<String, Object> params) {
        return URLUtils.assembleUrl(null, params, true);
    }

    public static String genDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        return sdf.format(date);
    }

    public static String genRandom() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static Map<String, Object> jsonToMap(String json) {
        return JsonUtils.jsonToMap(json);
    }

    public static String mapToJson(Map<String, Object> params) {
        return JsonUtils.mapToJson(params);
    }

    @Deprecated
    public static String base64TransferHexStrForSM2Key(String base64Key) throws SMCryptException {
        byte[] keyBytes = Base64.decodeBase64(base64Key);
        return CommonUtil.byteArrayToHexString((byte[])keyBytes);
    }

    @Deprecated
    public static String hexStrTransferBase64ForSM2Key(String hexStrKey) throws SMCryptException {
        byte[] keyBytes = CommonUtil.hexStringToByteArray((String)hexStrKey);
        return Base64.encodeBase64String(keyBytes);
    }
}

